/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.elementmodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.elementmodel.Element;
import org.hl7.fhir.r4.elementmodel.Property;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.utils.ToolingExtensions;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public abstract class ParserBase {
    protected IWorkerContext context;
    protected ValidationPolicy policy;
    protected List<ValidationMessage> errors;
    protected ILinkResolver linkResolver;
    protected boolean showDecorations;

    public boolean isPrimitive(String code) {
        return Utilities.existsInList(code, "boolean", "integer", "string", "decimal", "uri", "base64Binary", "instant", "date", "dateTime", "time", "code", "oid", "id", "markdown", "unsignedInt", "positiveInt", "xhtml", "url", "canonical");
    }

    public ParserBase(IWorkerContext context) {
        this.context = context;
        this.policy = ValidationPolicy.NONE;
    }

    public void setupValidation(ValidationPolicy policy, List<ValidationMessage> errors) {
        this.policy = policy;
        this.errors = errors;
    }

    public abstract Element parse(InputStream var1) throws IOException, FHIRFormatError, DefinitionException, FHIRException;

    public abstract void compose(Element var1, OutputStream var2, IParser.OutputStyle var3, String var4) throws FHIRException, IOException;

    public void logError(int line, int col, String path, ValidationMessage.IssueType type, String message, ValidationMessage.IssueSeverity level) throws FHIRFormatError {
        if (this.policy == ValidationPolicy.EVERYTHING) {
            ValidationMessage msg = new ValidationMessage(ValidationMessage.Source.InstanceValidator, type, line, col, path, message, level);
            this.errors.add(msg);
        } else if (level == ValidationMessage.IssueSeverity.FATAL || level == ValidationMessage.IssueSeverity.ERROR && this.policy == ValidationPolicy.QUICK) {
            throw new FHIRFormatError(message + String.format(" at line %d col %d", line, col));
        }
    }

    protected StructureDefinition getDefinition(int line, int col, String ns, String name) throws FHIRFormatError {
        if (ns == null) {
            this.logError(line, col, name, ValidationMessage.IssueType.STRUCTURE, "This cannot be parsed as a FHIR object (no namespace)", ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        if (name == null) {
            this.logError(line, col, name, ValidationMessage.IssueType.STRUCTURE, "This cannot be parsed as a FHIR object (no name)", ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        for (StructureDefinition sd : this.context.allStructures()) {
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition/de-")) continue;
            if (name.equals(sd.getType()) && (ns == null || ns.equals("http://hl7.org/fhir")) && !ToolingExtensions.hasExtension(sd, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
                return sd;
            }
            String sns = ToolingExtensions.readStringExtension(sd, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace");
            if (!name.equals(sd.getType()) || ns == null || !ns.equals(sns)) continue;
            return sd;
        }
        this.logError(line, col, name, ValidationMessage.IssueType.STRUCTURE, "This does not appear to be a FHIR resource (unknown namespace/name '" + ns + "::" + name + "')", ValidationMessage.IssueSeverity.FATAL);
        return null;
    }

    protected StructureDefinition getDefinition(int line, int col, String name) throws FHIRFormatError {
        if (name == null) {
            this.logError(line, col, name, ValidationMessage.IssueType.STRUCTURE, "This cannot be parsed as a FHIR object (no name)", ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        for (StructureDefinition sd : this.context.getStructures()) {
            if (!sd.getUrl().equals("http://hl7.org/fhir/StructureDefinition/" + name)) continue;
            this.context.generateSnapshot(sd);
            return sd;
        }
        for (StructureDefinition sd : this.context.getStructures()) {
            if (!name.equals(sd.getType()) || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            this.context.generateSnapshot(sd);
            return sd;
        }
        this.logError(line, col, name, ValidationMessage.IssueType.STRUCTURE, "This does not appear to be a FHIR resource (unknown name '" + name + "')", ValidationMessage.IssueSeverity.FATAL);
        return null;
    }

    public ILinkResolver getLinkResolver() {
        return this.linkResolver;
    }

    public ParserBase setLinkResolver(ILinkResolver linkResolver) {
        this.linkResolver = linkResolver;
        return this;
    }

    public boolean isShowDecorations() {
        return this.showDecorations;
    }

    public void setShowDecorations(boolean showDecorations) {
        this.showDecorations = showDecorations;
    }

    public static enum ValidationPolicy {
        NONE,
        QUICK,
        EVERYTHING;

    }

    public static interface ILinkResolver {
        public String resolveType(String var1);

        public String resolveProperty(Property var1);

        public String resolvePage(String var1);
    }
}

