/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology;

import au.csiro.pathling.config.HttpClientCachingConfiguration;
import au.csiro.pathling.config.HttpClientCachingStorageType;
import au.csiro.pathling.config.HttpClientConfiguration;
import au.csiro.pathling.config.TerminologyConfiguration;
import au.csiro.pathling.encoders.FhirEncoders;
import au.csiro.pathling.fhir.TerminologyClient;
import au.csiro.pathling.terminology.DefaultTerminologyService;
import au.csiro.pathling.terminology.RequestRetryHandler;
import au.csiro.pathling.terminology.TerminologyService;
import au.csiro.pathling.terminology.TerminologyServiceFactory;
import au.csiro.pathling.terminology.caching.InMemoryCachingTerminologyService;
import au.csiro.pathling.terminology.caching.PersistentCachingTerminologyService;
import au.csiro.pathling.utilities.ObjectHolder;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import javax.annotation.Nonnull;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTerminologyServiceFactory
implements TerminologyServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultTerminologyServiceFactory.class);
    private static final long serialVersionUID = 2837933007972812597L;
    @Nonnull
    private static final ObjectHolder<DefaultTerminologyServiceFactory, TerminologyService> terminologyServiceHolder = ObjectHolder.singleton(DefaultTerminologyServiceFactory::createService);
    @Nonnull
    private final FhirVersionEnum fhirVersion;
    @Nonnull
    private final TerminologyConfiguration configuration;

    public static synchronized void reset() {
        log.info("Resetting terminology services");
        terminologyServiceHolder.reset();
    }

    public DefaultTerminologyServiceFactory(@Nonnull FhirVersionEnum fhirVersion, @Nonnull TerminologyConfiguration configuration) {
        this.fhirVersion = fhirVersion;
        this.configuration = configuration;
    }

    @Override
    @Nonnull
    public TerminologyService build() {
        return terminologyServiceHolder.getOrCreate(this);
    }

    @Nonnull
    private TerminologyService createService() {
        FhirContext fhirContext = FhirEncoders.contextFor(this.fhirVersion);
        CloseableHttpClient httpClient = DefaultTerminologyServiceFactory.buildHttpClient(this.configuration.getClient());
        TerminologyClient terminologyClient = TerminologyClient.build(fhirContext, this.configuration, httpClient);
        HttpClientCachingConfiguration cacheConfig = this.configuration.getCache();
        if (cacheConfig.isEnabled() && cacheConfig.getStorageType().equals((Object)HttpClientCachingStorageType.DISK)) {
            log.debug("Creating PersistentCachingTerminologyService with cache config: {}", (Object)cacheConfig);
            return new PersistentCachingTerminologyService(terminologyClient, httpClient, cacheConfig);
        }
        if (cacheConfig.isEnabled() && cacheConfig.getStorageType().equals((Object)HttpClientCachingStorageType.MEMORY)) {
            log.debug("Creating InMemoryCachingTerminologyService with cache config: {}", (Object)cacheConfig);
            return new InMemoryCachingTerminologyService(terminologyClient, httpClient, cacheConfig);
        }
        log.debug("Creating DefaultTerminologyService with no caching");
        return new DefaultTerminologyService(terminologyClient, httpClient);
    }

    private static CloseableHttpClient buildHttpClient(@Nonnull HttpClientConfiguration clientConfig) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(clientConfig.getMaxConnectionsTotal());
        connectionManager.setDefaultMaxPerRoute(clientConfig.getMaxConnectionsPerRoute());
        RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(clientConfig.getSocketTimeout()).build();
        HttpClientBuilder clientBuilder = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).setConnectionManager(connectionManager).setConnectionManagerShared(false);
        if (clientConfig.isRetryEnabled()) {
            clientBuilder.setRetryHandler(new RequestRetryHandler(clientConfig.getRetryCount()));
        }
        return clientBuilder.build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultTerminologyServiceFactory)) {
            return false;
        }
        DefaultTerminologyServiceFactory other = (DefaultTerminologyServiceFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FhirVersionEnum this$fhirVersion = this.getFhirVersion();
        FhirVersionEnum other$fhirVersion = other.getFhirVersion();
        if (this$fhirVersion == null ? other$fhirVersion != null : !((Object)((Object)this$fhirVersion)).equals((Object)other$fhirVersion)) {
            return false;
        }
        TerminologyConfiguration this$configuration = this.getConfiguration();
        TerminologyConfiguration other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultTerminologyServiceFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FhirVersionEnum $fhirVersion = this.getFhirVersion();
        result = result * 59 + ($fhirVersion == null ? 43 : ((Object)((Object)$fhirVersion)).hashCode());
        TerminologyConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        return result;
    }

    public String toString() {
        return "DefaultTerminologyServiceFactory(fhirVersion=" + this.getFhirVersion() + ", configuration=" + this.getConfiguration() + ")";
    }

    @Nonnull
    public FhirVersionEnum getFhirVersion() {
        return this.fhirVersion;
    }

    @Nonnull
    public TerminologyConfiguration getConfiguration() {
        return this.configuration;
    }
}

