/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.java.internal;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.java.StreamTableEnvironment;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.delegation.PlannerFactory;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.StreamTableDescriptor;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionParser;
import org.apache.flink.table.factories.ComponentFactoryService;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserFunctionsTypeHelper;
import org.apache.flink.table.operations.JavaDataStreamQueryOperation;
import org.apache.flink.table.operations.OutputConversionModifyOperation;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.typeutils.FieldInfoUtils;

@Internal
public final class StreamTableEnvironmentImpl
extends TableEnvironmentImpl
implements StreamTableEnvironment {
    private final StreamExecutionEnvironment executionEnvironment;

    public StreamTableEnvironmentImpl(CatalogManager catalogManager, FunctionCatalog functionCatalog, TableConfig tableConfig, StreamExecutionEnvironment executionEnvironment, Planner planner, Executor executor, boolean isStreamingMode) {
        super(catalogManager, tableConfig, executor, functionCatalog, planner, isStreamingMode);
        this.executionEnvironment = executionEnvironment;
    }

    public static StreamTableEnvironment create(StreamExecutionEnvironment executionEnvironment, EnvironmentSettings settings, TableConfig tableConfig) {
        if (!settings.isStreamingMode()) {
            throw new TableException("StreamTableEnvironment can not run in batch mode for now, please use TableEnvironment.");
        }
        CatalogManager catalogManager = new CatalogManager(settings.getBuiltInCatalogName(), new GenericInMemoryCatalog(settings.getBuiltInCatalogName(), settings.getBuiltInDatabaseName()));
        FunctionCatalog functionCatalog = new FunctionCatalog(catalogManager);
        Map<String, String> executorProperties = settings.toExecutorProperties();
        Executor executor = StreamTableEnvironmentImpl.lookupExecutor(executorProperties, executionEnvironment);
        Map<String, String> plannerProperties = settings.toPlannerProperties();
        Planner planner = ComponentFactoryService.find(PlannerFactory.class, plannerProperties).create(plannerProperties, executor, tableConfig, functionCatalog, catalogManager);
        return new StreamTableEnvironmentImpl(catalogManager, functionCatalog, tableConfig, executionEnvironment, planner, executor, settings.isStreamingMode());
    }

    private static Executor lookupExecutor(Map<String, String> executorProperties, StreamExecutionEnvironment executionEnvironment) {
        try {
            ExecutorFactory executorFactory = ComponentFactoryService.find(ExecutorFactory.class, executorProperties);
            Method createMethod = executorFactory.getClass().getMethod("create", Map.class, StreamExecutionEnvironment.class);
            return (Executor)createMethod.invoke((Object)executorFactory, executorProperties, executionEnvironment);
        }
        catch (Exception e) {
            throw new TableException("Could not instantiate the executor. Make sure a planner module is on the classpath", e);
        }
    }

    @Override
    public <T> void registerFunction(String name, TableFunction<T> tableFunction) {
        TypeInformation<T> typeInfo = UserFunctionsTypeHelper.getReturnTypeOfTableFunction(tableFunction);
        this.functionCatalog.registerTableFunction(name, tableFunction, typeInfo);
    }

    @Override
    public <T, ACC> void registerFunction(String name, AggregateFunction<T, ACC> aggregateFunction) {
        TypeInformation<T> typeInfo = UserFunctionsTypeHelper.getReturnTypeOfAggregateFunction(aggregateFunction);
        TypeInformation<ACC> accTypeInfo = UserFunctionsTypeHelper.getAccumulatorTypeOfAggregateFunction(aggregateFunction);
        this.functionCatalog.registerAggregateFunction(name, aggregateFunction, typeInfo, accTypeInfo);
    }

    @Override
    public <T, ACC> void registerFunction(String name, TableAggregateFunction<T, ACC> tableAggregateFunction) {
        TypeInformation<T> typeInfo = UserFunctionsTypeHelper.getReturnTypeOfAggregateFunction(tableAggregateFunction);
        TypeInformation<ACC> accTypeInfo = UserFunctionsTypeHelper.getAccumulatorTypeOfAggregateFunction(tableAggregateFunction);
        this.functionCatalog.registerAggregateFunction(name, tableAggregateFunction, typeInfo, accTypeInfo);
    }

    @Override
    public <T> Table fromDataStream(DataStream<T> dataStream) {
        JavaDataStreamQueryOperation<T> queryOperation = this.asQueryOperation(dataStream, Optional.empty());
        return this.createTable(queryOperation);
    }

    @Override
    public <T> Table fromDataStream(DataStream<T> dataStream, String fields) {
        List<Expression> expressions = ExpressionParser.parseExpressionList(fields);
        JavaDataStreamQueryOperation<T> queryOperation = this.asQueryOperation(dataStream, Optional.of(expressions));
        return this.createTable(queryOperation);
    }

    @Override
    public <T> void registerDataStream(String name, DataStream<T> dataStream) {
        this.registerTable(name, this.fromDataStream(dataStream));
    }

    @Override
    public <T> void registerDataStream(String name, DataStream<T> dataStream, String fields) {
        this.registerTable(name, this.fromDataStream(dataStream, fields));
    }

    @Override
    public <T> DataStream<T> toAppendStream(Table table, Class<T> clazz) {
        TypeInformation<T> typeInfo = this.extractTypeInformation(table, clazz);
        return this.toAppendStream(table, typeInfo);
    }

    @Override
    public <T> DataStream<T> toAppendStream(Table table, TypeInformation<T> typeInfo) {
        OutputConversionModifyOperation modifyOperation = new OutputConversionModifyOperation(table.getQueryOperation(), TypeConversions.fromLegacyInfoToDataType(typeInfo), OutputConversionModifyOperation.UpdateMode.APPEND);
        return this.toDataStream(table, modifyOperation);
    }

    @Override
    public <T> DataStream<T> toAppendStream(Table table, Class<T> clazz, StreamQueryConfig queryConfig) {
        this.tableConfig.setIdleStateRetentionTime(Time.milliseconds((long)queryConfig.getMinIdleStateRetentionTime()), Time.milliseconds((long)queryConfig.getMaxIdleStateRetentionTime()));
        return this.toAppendStream(table, clazz);
    }

    @Override
    public <T> DataStream<T> toAppendStream(Table table, TypeInformation<T> typeInfo, StreamQueryConfig queryConfig) {
        this.tableConfig.setIdleStateRetentionTime(Time.milliseconds((long)queryConfig.getMinIdleStateRetentionTime()), Time.milliseconds((long)queryConfig.getMaxIdleStateRetentionTime()));
        return this.toAppendStream(table, typeInfo);
    }

    @Override
    public <T> DataStream<Tuple2<Boolean, T>> toRetractStream(Table table, Class<T> clazz) {
        TypeInformation<T> typeInfo = this.extractTypeInformation(table, clazz);
        return this.toRetractStream(table, typeInfo);
    }

    @Override
    public <T> DataStream<Tuple2<Boolean, T>> toRetractStream(Table table, TypeInformation<T> typeInfo) {
        OutputConversionModifyOperation modifyOperation = new OutputConversionModifyOperation(table.getQueryOperation(), this.wrapWithChangeFlag(typeInfo), OutputConversionModifyOperation.UpdateMode.RETRACT);
        return this.toDataStream(table, modifyOperation);
    }

    @Override
    public <T> DataStream<Tuple2<Boolean, T>> toRetractStream(Table table, Class<T> clazz, StreamQueryConfig queryConfig) {
        this.tableConfig.setIdleStateRetentionTime(Time.milliseconds((long)queryConfig.getMinIdleStateRetentionTime()), Time.milliseconds((long)queryConfig.getMaxIdleStateRetentionTime()));
        return this.toRetractStream(table, clazz);
    }

    @Override
    public <T> DataStream<Tuple2<Boolean, T>> toRetractStream(Table table, TypeInformation<T> typeInfo, StreamQueryConfig queryConfig) {
        this.tableConfig.setIdleStateRetentionTime(Time.milliseconds((long)queryConfig.getMinIdleStateRetentionTime()), Time.milliseconds((long)queryConfig.getMaxIdleStateRetentionTime()));
        return this.toRetractStream(table, typeInfo);
    }

    @Override
    public StreamTableDescriptor connect(ConnectorDescriptor connectorDescriptor) {
        return (StreamTableDescriptor)super.connect(connectorDescriptor);
    }

    @Override
    public void sqlUpdate(String stmt, StreamQueryConfig config) {
        this.tableConfig.setIdleStateRetentionTime(Time.milliseconds((long)config.getMinIdleStateRetentionTime()), Time.milliseconds((long)config.getMaxIdleStateRetentionTime()));
        this.sqlUpdate(stmt);
    }

    @Override
    public void insertInto(Table table, StreamQueryConfig queryConfig, String sinkPath, String ... sinkPathContinued) {
        this.tableConfig.setIdleStateRetentionTime(Time.milliseconds((long)queryConfig.getMinIdleStateRetentionTime()), Time.milliseconds((long)queryConfig.getMaxIdleStateRetentionTime()));
        this.insertInto(table, sinkPath, sinkPathContinued);
    }

    @Internal
    public StreamExecutionEnvironment execEnv() {
        return this.executionEnvironment;
    }

    private <T> DataStream<T> toDataStream(Table table, OutputConversionModifyOperation modifyOperation) {
        List<Transformation<?>> transformations = this.planner.translate(Collections.singletonList(modifyOperation));
        Transformation<T> transformation = this.getTransformation(table, transformations);
        this.executionEnvironment.addOperator(transformation);
        return new DataStream(this.executionEnvironment, transformation);
    }

    @Override
    protected void validateTableSource(TableSource<?> tableSource) {
        super.validateTableSource(tableSource);
        this.validateTimeCharacteristic(TableSourceValidation.hasRowtimeAttribute(tableSource));
    }

    @Override
    protected boolean isEagerOperationTranslation() {
        return true;
    }

    private <T> TypeInformation<T> extractTypeInformation(Table table, Class<T> clazz) {
        try {
            return TypeExtractor.createTypeInfo(clazz);
        }
        catch (Exception ex) {
            throw new ValidationException(String.format("Could not convert query: %s to a DataStream of class %s", table.getQueryOperation().asSummaryString(), clazz.getSimpleName()), ex);
        }
    }

    private <T> Transformation<T> getTransformation(Table table, List<Transformation<?>> transformations) {
        if (transformations.size() != 1) {
            throw new TableException(String.format("Expected a single transformation for query: %s\n Got: %s", table.getQueryOperation().asSummaryString(), transformations));
        }
        return transformations.get(0);
    }

    private <T> DataType wrapWithChangeFlag(TypeInformation<T> outputType) {
        TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{Types.BOOLEAN(), outputType});
        return TypeConversions.fromLegacyInfoToDataType(tupleTypeInfo);
    }

    private <T> JavaDataStreamQueryOperation<T> asQueryOperation(DataStream<T> dataStream, Optional<List<Expression>> fields) {
        TypeInformation streamType = dataStream.getType();
        FieldInfoUtils.TypeInfoSchema typeInfoSchema = fields.map(f -> {
            FieldInfoUtils.TypeInfoSchema fieldsInfo = FieldInfoUtils.getFieldsInfo(streamType, f.toArray(new Expression[0]));
            this.validateTimeCharacteristic(fieldsInfo.isRowtimeDefined());
            return fieldsInfo;
        }).orElseGet(() -> FieldInfoUtils.getFieldsInfo(streamType));
        return new JavaDataStreamQueryOperation<T>(dataStream, typeInfoSchema.getIndices(), typeInfoSchema.toTableSchema());
    }

    private void validateTimeCharacteristic(boolean isRowtimeDefined) {
        if (isRowtimeDefined && this.executionEnvironment.getStreamTimeCharacteristic() != TimeCharacteristic.EventTime) {
            throw new ValidationException(String.format("A rowtime attribute requires an EventTime time characteristic in stream environment. But is: %s", this.executionEnvironment.getStreamTimeCharacteristic()));
        }
    }
}

