/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.security.plain;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import shaded.alink.kafka011.org.apache.kafka.common.security.JaasContext;
import shaded.alink.kafka011.org.apache.kafka.common.security.authenticator.SaslServerCallbackHandler;
import shaded.alink.kafka011.org.apache.kafka.common.security.plain.PlainLoginModule;

public class PlainSaslServer
implements SaslServer {
    public static final String PLAIN_MECHANISM = "PLAIN";
    private static final String JAAS_USER_PREFIX = "user_";
    private final JaasContext jaasContext;
    private boolean complete;
    private String authorizationId;

    public PlainSaslServer(JaasContext jaasContext) {
        this.jaasContext = jaasContext;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        String[] tokens;
        try {
            tokens = new String(response, "UTF-8").split("\u0000");
        }
        catch (UnsupportedEncodingException e) {
            throw new SaslException("UTF-8 encoding not supported", e);
        }
        if (tokens.length != 3) {
            throw new SaslException("Invalid SASL/PLAIN response: expected 3 tokens, got " + tokens.length);
        }
        String authorizationIdFromClient = tokens[0];
        String username = tokens[1];
        String password = tokens[2];
        if (username.isEmpty()) {
            throw new SaslException("Authentication failed: username not specified");
        }
        if (password.isEmpty()) {
            throw new SaslException("Authentication failed: password not specified");
        }
        String expectedPassword = this.jaasContext.configEntryOption(JAAS_USER_PREFIX + username, PlainLoginModule.class.getName());
        if (!password.equals(expectedPassword)) {
            throw new SaslException("Authentication failed: Invalid username or password");
        }
        if (!authorizationIdFromClient.isEmpty() && !authorizationIdFromClient.equals(username)) {
            throw new SaslException("Authentication failed: Client requested an authorization id that is different from username");
        }
        this.authorizationId = username;
        this.complete = true;
        return new byte[0];
    }

    @Override
    public String getAuthorizationID() {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return this.authorizationId;
    }

    @Override
    public String getMechanismName() {
        return PLAIN_MECHANISM;
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return Arrays.copyOfRange(incoming, offset, offset + len);
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return Arrays.copyOfRange(outgoing, offset, offset + len);
    }

    @Override
    public void dispose() throws SaslException {
    }

    public static class PlainSaslServerFactory
    implements SaslServerFactory {
        @Override
        public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            if (!PlainSaslServer.PLAIN_MECHANISM.equals(mechanism)) {
                throw new SaslException(String.format("Mechanism '%s' is not supported. Only PLAIN is supported.", mechanism));
            }
            if (!(cbh instanceof SaslServerCallbackHandler)) {
                throw new SaslException("CallbackHandler must be of type SaslServerCallbackHandler, but it is: " + cbh.getClass());
            }
            return new PlainSaslServer(((SaslServerCallbackHandler)cbh).jaasContext());
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            if (props == null) {
                return new String[]{PlainSaslServer.PLAIN_MECHANISM};
            }
            String noPlainText = (String)props.get("javax.security.sasl.policy.noplaintext");
            if ("true".equals(noPlainText)) {
                return new String[0];
            }
            return new String[]{PlainSaslServer.PLAIN_MECHANISM};
        }
    }
}

