/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.ProtoUtils;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka010.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka010.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.DescribeGroupsResponse;
import shaded.alink.kafka010.org.apache.kafka.common.utils.Utils;

public class DescribeGroupsRequest
extends AbstractRequest {
    private static final String GROUP_IDS_KEY_NAME = "group_ids";
    private final List<String> groupIds;

    private DescribeGroupsRequest(List<String> groupIds, short version) {
        super(new Struct(ProtoUtils.requestSchema(ApiKeys.DESCRIBE_GROUPS.id, version)), version);
        this.struct.set(GROUP_IDS_KEY_NAME, (Object)groupIds.toArray());
        this.groupIds = groupIds;
    }

    public DescribeGroupsRequest(Struct struct, short version) {
        super(struct, version);
        this.groupIds = new ArrayList<String>();
        for (Object groupId : struct.getArray(GROUP_IDS_KEY_NAME)) {
            this.groupIds.add((String)groupId);
        }
    }

    public List<String> groupIds() {
        return this.groupIds;
    }

    @Override
    public AbstractResponse getErrorResponse(Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return DescribeGroupsResponse.fromError(Errors.forException(e), this.groupIds);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.DESCRIBE_GROUPS.id)));
    }

    public static DescribeGroupsRequest parse(ByteBuffer buffer, int versionId) {
        return new DescribeGroupsRequest(ProtoUtils.parseRequest(ApiKeys.DESCRIBE_GROUPS.id, versionId, buffer), (short)versionId);
    }

    public static DescribeGroupsRequest parse(ByteBuffer buffer) {
        return DescribeGroupsRequest.parse(buffer, ProtoUtils.latestVersion(ApiKeys.DESCRIBE_GROUPS.id));
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeGroupsRequest> {
        private final List<String> groupIds;

        public Builder(List<String> groupIds) {
            super(ApiKeys.DESCRIBE_GROUPS);
            this.groupIds = groupIds;
        }

        @Override
        public DescribeGroupsRequest build() {
            short version = this.version();
            return new DescribeGroupsRequest(this.groupIds, version);
        }

        public String toString() {
            return "(type=DescribeGroupsRequest, groupIds=(" + Utils.join(this.groupIds, ",") + "))";
        }
    }
}

