/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiMessage;
import shaded.alink.kafka.org.apache.kafka.common.protocol.MessageUtil;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Readable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Writable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.ArrayOf;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Type;

public class SaslHandshakeResponseData
implements ApiMessage {
    private short errorCode;
    private List<String> mechanisms;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public SaslHandshakeResponseData(Readable readable, short version) {
        this.mechanisms = new ArrayList<String>();
        this.read(readable, version);
    }

    public SaslHandshakeResponseData(Struct struct, short version) {
        this.mechanisms = new ArrayList<String>();
        this.fromStruct(struct, version);
    }

    public SaslHandshakeResponseData() {
        this.errorCode = 0;
        this.mechanisms = new ArrayList<String>();
    }

    @Override
    public short apiKey() {
        return 17;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        this.errorCode = readable.readShort();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.mechanisms.clear();
        } else {
            this.mechanisms.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.mechanisms.add(readable.readNullableString());
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeShort(this.errorCode);
        writable.writeInt(this.mechanisms.size());
        for (String element : this.mechanisms) {
            writable.writeString(element);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.errorCode = struct.getShort("error_code");
        Object[] nestedObjects = struct.getArray("mechanisms");
        this.mechanisms = new ArrayList<String>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.mechanisms.add((String)nestedObject);
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("error_code", (Object)this.errorCode);
        String[] nestedObjects = new String[this.mechanisms.size()];
        int i = 0;
        for (String element : this.mechanisms) {
            nestedObjects[i++] = element;
        }
        struct.set("mechanisms", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 2;
        size += 4;
        for (String element : this.mechanisms) {
            size += 2;
            size += MessageUtil.serializedUtf8Length(element);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SaslHandshakeResponseData)) {
            return false;
        }
        SaslHandshakeResponseData other = (SaslHandshakeResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        return !(this.mechanisms == null ? other.mechanisms != null : !this.mechanisms.equals(other.mechanisms));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.mechanisms == null ? 0 : this.mechanisms.hashCode());
        return hashCode;
    }

    public String toString() {
        return "SaslHandshakeResponseData(errorCode=" + this.errorCode + ", mechanisms=" + MessageUtil.deepToString(this.mechanisms.iterator()) + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<String> mechanisms() {
        return this.mechanisms;
    }

    public SaslHandshakeResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public SaslHandshakeResponseData setMechanisms(List<String> v) {
        this.mechanisms = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("mechanisms", new ArrayOf(Type.STRING), "The mechanisms enabled in the server."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }
}

