/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.clients.producer.internals;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import shaded.alink.kafka.org.apache.kafka.common.MetricName;
import shaded.alink.kafka.org.apache.kafka.common.errors.TimeoutException;
import shaded.alink.kafka.org.apache.kafka.common.metrics.Metrics;
import shaded.alink.kafka.org.apache.kafka.common.metrics.Sensor;
import shaded.alink.kafka.org.apache.kafka.common.metrics.stats.Meter;
import shaded.alink.kafka.org.apache.kafka.common.utils.Time;

public class BufferPool {
    static final String WAIT_TIME_SENSOR_NAME = "bufferpool-wait-time";
    private final long totalMemory;
    private final int poolableSize;
    private final ReentrantLock lock;
    private final Deque<ByteBuffer> free;
    private final Deque<Condition> waiters;
    private long nonPooledAvailableMemory;
    private final Metrics metrics;
    private final Time time;
    private final Sensor waitTime;

    public BufferPool(long memory, int poolableSize, Metrics metrics, Time time, String metricGrpName) {
        this.poolableSize = poolableSize;
        this.lock = new ReentrantLock();
        this.free = new ArrayDeque<ByteBuffer>();
        this.waiters = new ArrayDeque<Condition>();
        this.totalMemory = memory;
        this.nonPooledAvailableMemory = memory;
        this.metrics = metrics;
        this.time = time;
        this.waitTime = this.metrics.sensor(WAIT_TIME_SENSOR_NAME);
        MetricName rateMetricName = metrics.metricName("bufferpool-wait-ratio", metricGrpName, "The fraction of time an appender waits for space allocation.");
        MetricName totalMetricName = metrics.metricName("bufferpool-wait-time-total", metricGrpName, "The total time an appender waits for space allocation.");
        this.waitTime.add(new Meter(TimeUnit.NANOSECONDS, rateMetricName, totalMetricName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer allocate(int size, long maxTimeToBlockMs) throws InterruptedException {
        ByteBuffer buffer;
        block25: {
            if ((long)size > this.totalMemory) {
                throw new IllegalArgumentException("Attempt to allocate " + size + " bytes, but there is a hard limit of " + this.totalMemory + " on memory allocations.");
            }
            buffer = null;
            this.lock.lock();
            try {
                if (size == this.poolableSize && !this.free.isEmpty()) {
                    ByteBuffer byteBuffer = this.free.pollFirst();
                    return byteBuffer;
                }
                int freeListSize = this.freeSize() * this.poolableSize;
                if (this.nonPooledAvailableMemory + (long)freeListSize >= (long)size) {
                    this.freeUp(size);
                    this.nonPooledAvailableMemory -= (long)size;
                    break block25;
                }
                int accumulated = 0;
                Condition moreMemory = this.lock.newCondition();
                try {
                    long remainingTimeToBlockNs = TimeUnit.MILLISECONDS.toNanos(maxTimeToBlockMs);
                    this.waiters.addLast(moreMemory);
                    while (accumulated < size) {
                        long timeNs;
                        boolean waitingTimeElapsed;
                        long startWaitNs = this.time.nanoseconds();
                        try {
                            waitingTimeElapsed = !moreMemory.await(remainingTimeToBlockNs, TimeUnit.NANOSECONDS);
                        }
                        finally {
                            long endWaitNs = this.time.nanoseconds();
                            timeNs = Math.max(0L, endWaitNs - startWaitNs);
                            this.recordWaitTime(timeNs);
                        }
                        if (waitingTimeElapsed) {
                            throw new TimeoutException("Failed to allocate memory within the configured max blocking time " + maxTimeToBlockMs + " ms.");
                        }
                        remainingTimeToBlockNs -= timeNs;
                        if (accumulated == 0 && size == this.poolableSize && !this.free.isEmpty()) {
                            buffer = this.free.pollFirst();
                            accumulated = size;
                            continue;
                        }
                        this.freeUp(size - accumulated);
                        int got = (int)Math.min((long)(size - accumulated), this.nonPooledAvailableMemory);
                        this.nonPooledAvailableMemory -= (long)got;
                        accumulated += got;
                    }
                    accumulated = 0;
                }
                finally {
                    this.nonPooledAvailableMemory += (long)accumulated;
                    this.waiters.remove(moreMemory);
                }
            }
            finally {
                try {
                    if (!(this.nonPooledAvailableMemory == 0L && this.free.isEmpty() || this.waiters.isEmpty())) {
                        this.waiters.peekFirst().signal();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        if (buffer == null) {
            return this.safeAllocateByteBuffer(size);
        }
        return buffer;
    }

    protected void recordWaitTime(long timeNs) {
        this.waitTime.record(timeNs, this.time.milliseconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer safeAllocateByteBuffer(int size) {
        boolean error = true;
        try {
            ByteBuffer buffer = this.allocateByteBuffer(size);
            error = false;
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
        finally {
            if (error) {
                this.lock.lock();
                try {
                    this.nonPooledAvailableMemory += (long)size;
                    if (!this.waiters.isEmpty()) {
                        this.waiters.peekFirst().signal();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }

    protected ByteBuffer allocateByteBuffer(int size) {
        return ByteBuffer.allocate(size);
    }

    private void freeUp(int size) {
        while (!this.free.isEmpty() && this.nonPooledAvailableMemory < (long)size) {
            this.nonPooledAvailableMemory += (long)this.free.pollLast().capacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocate(ByteBuffer buffer, int size) {
        this.lock.lock();
        try {
            if (size == this.poolableSize && size == buffer.capacity()) {
                buffer.clear();
                this.free.add(buffer);
            } else {
                this.nonPooledAvailableMemory += (long)size;
            }
            Condition moreMem = this.waiters.peekFirst();
            if (moreMem != null) {
                moreMem.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void deallocate(ByteBuffer buffer) {
        this.deallocate(buffer, buffer.capacity());
    }

    public long availableMemory() {
        this.lock.lock();
        try {
            long l = this.nonPooledAvailableMemory + (long)this.freeSize() * (long)this.poolableSize;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected int freeSize() {
        return this.free.size();
    }

    public long unallocatedMemory() {
        this.lock.lock();
        try {
            long l = this.nonPooledAvailableMemory;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int queued() {
        this.lock.lock();
        try {
            int n = this.waiters.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int poolableSize() {
        return this.poolableSize;
    }

    public long totalMemory() {
        return this.totalMemory;
    }

    Deque<Condition> waiters() {
        return this.waiters;
    }
}

