/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.hive;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.hive.FlinkHiveUDFException;
import org.apache.flink.table.functions.hive.HiveFunction;
import org.apache.flink.table.functions.hive.HiveFunctionWrapper;
import org.apache.flink.table.functions.hive.util.HiveFunctionUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.LegacyTypeInfoDataTypeConverter;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Internal
public abstract class HiveScalarFunction<UDFType>
extends ScalarFunction
implements HiveFunction {
    protected final HiveFunctionWrapper<UDFType> hiveFunctionWrapper;
    protected Object[] constantArguments;
    protected DataType[] argTypes;
    protected transient UDFType function;
    protected transient ObjectInspector returnInspector;
    private transient boolean isArgsSingleArray;

    HiveScalarFunction(HiveFunctionWrapper<UDFType> hiveFunctionWrapper) {
        this.hiveFunctionWrapper = hiveFunctionWrapper;
    }

    @Override
    public void setArgumentTypesAndConstants(Object[] constantArguments, DataType[] argTypes) {
        this.constantArguments = constantArguments;
        this.argTypes = argTypes;
    }

    public boolean isDeterministic() {
        try {
            UDFType udfType = this.hiveFunctionWrapper.getUDFClass().getAnnotation(UDFType.class);
            return udfType != null && udfType.deterministic() && !udfType.stateful();
        }
        catch (ClassNotFoundException e) {
            throw new FlinkHiveUDFException(e);
        }
    }

    public TypeInformation getResultType(Class[] signature) {
        return LegacyTypeInfoDataTypeConverter.toLegacyTypeInfo((DataType)this.getHiveResultType(this.constantArguments, this.argTypes));
    }

    public void open(FunctionContext context) {
        this.openInternal();
        this.isArgsSingleArray = HiveFunctionUtil.isSingleBoxedArray(this.argTypes);
    }

    protected abstract void openInternal();

    public Object eval(Object ... args) {
        if (this.isArgsSingleArray) {
            args = new Object[]{args};
        }
        return this.evalInternal(args);
    }

    protected abstract Object evalInternal(Object[] var1);
}

