/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.client;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.thrift.TException;

public class HiveShimV2
implements HiveShim {
    @Override
    public IMetaStoreClient getHiveMetastoreClient(HiveConf hiveConf) {
        try {
            Method method = RetryingMetaStoreClient.class.getMethod("getProxy", HiveConf.class, Boolean.TYPE);
            return (IMetaStoreClient)method.invoke(null, hiveConf, true);
        }
        catch (Exception ex) {
            throw new CatalogException("Failed to create Hive Metastore client", (Throwable)ex);
        }
    }

    @Override
    public List<String> getViews(IMetaStoreClient client, String databaseName) throws UnknownDBException, TException {
        try {
            Method method = client.getClass().getMethod("getTables", String.class, String.class, TableType.class);
            return (List)method.invoke((Object)client, databaseName, null, TableType.VIRTUAL_VIEW);
        }
        catch (InvocationTargetException ite) {
            Throwable targetEx = ite.getTargetException();
            if (targetEx instanceof TException) {
                throw (TException)targetEx;
            }
            throw new CatalogException(String.format("Failed to get views for %s", databaseName), targetEx);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new CatalogException(String.format("Failed to get views for %s", databaseName), (Throwable)e);
        }
    }

    @Override
    public Function getFunction(IMetaStoreClient client, String dbName, String functionName) throws NoSuchObjectException, TException {
        return client.getFunction(dbName, functionName);
    }

    @Override
    public boolean moveToTrash(FileSystem fs, Path path, Configuration conf, boolean purge) throws IOException {
        try {
            Method method = FileUtils.class.getDeclaredMethod("moveToTrash", FileSystem.class, Path.class, Configuration.class, Boolean.TYPE);
            return (Boolean)method.invoke(null, fs, path, conf, purge);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Failed to move " + path + " to trash", e);
        }
    }

    @Override
    public void alterTable(IMetaStoreClient client, String databaseName, String tableName, Table table) throws InvalidOperationException, MetaException, TException {
        client.alter_table(databaseName, tableName, table);
    }

    @Override
    public SimpleGenericUDAFParameterInfo createUDAFParameterInfo(ObjectInspector[] params, boolean isWindowing, boolean distinct, boolean allColumns) {
        try {
            Constructor constructor = SimpleGenericUDAFParameterInfo.class.getConstructor(ObjectInspector[].class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            return (SimpleGenericUDAFParameterInfo)constructor.newInstance(params, isWindowing, distinct, allColumns);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CatalogException("Failed to create SimpleGenericUDAFParameterInfo", (Throwable)e);
        }
    }
}

