/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.client;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.thrift.TException;

public class HiveShimV1
implements HiveShim {
    @Override
    public IMetaStoreClient getHiveMetastoreClient(HiveConf hiveConf) {
        try {
            Method method = RetryingMetaStoreClient.class.getMethod("getProxy", HiveConf.class);
            return (IMetaStoreClient)method.invoke(null, hiveConf);
        }
        catch (Exception ex) {
            throw new CatalogException("Failed to create Hive Metastore client", (Throwable)ex);
        }
    }

    @Override
    public List<String> getViews(IMetaStoreClient client, String databaseName) throws UnknownDBException, TException {
        List tableNames = client.getAllTables(databaseName);
        ArrayList<String> views = new ArrayList<String>();
        for (String name : tableNames) {
            Table table = client.getTable(databaseName, name);
            String viewDef = table.getViewOriginalText();
            if (viewDef == null || viewDef.isEmpty()) continue;
            views.add(table.getTableName());
        }
        return views;
    }

    @Override
    public Function getFunction(IMetaStoreClient client, String dbName, String functionName) throws NoSuchObjectException, TException {
        try {
            return client.getFunction(dbName, functionName);
        }
        catch (MetaException e) {
            if (e.getCause() instanceof NoSuchObjectException) {
                throw (NoSuchObjectException)e.getCause();
            }
            if (e.getMessage().startsWith(NoSuchObjectException.class.getSimpleName())) {
                throw new NoSuchObjectException(e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public boolean moveToTrash(FileSystem fs, Path path, Configuration conf, boolean purge) throws IOException {
        try {
            Method method = FileUtils.class.getDeclaredMethod("moveToTrash", FileSystem.class, Path.class, Configuration.class);
            return (Boolean)method.invoke(null, fs, path, conf);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Failed to move " + path + " to trash", e);
        }
    }

    @Override
    public void alterTable(IMetaStoreClient client, String databaseName, String tableName, Table table) throws InvalidOperationException, MetaException, TException {
        table.getParameters().put("DO_NOT_UPDATE_STATS", "true");
        client.alter_table(databaseName, tableName, table);
    }

    @Override
    public SimpleGenericUDAFParameterInfo createUDAFParameterInfo(ObjectInspector[] params, boolean isWindowing, boolean distinct, boolean allColumns) {
        try {
            Constructor constructor = SimpleGenericUDAFParameterInfo.class.getConstructor(ObjectInspector[].class, Boolean.TYPE, Boolean.TYPE);
            return (SimpleGenericUDAFParameterInfo)constructor.newInstance(params, distinct, allColumns);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CatalogException("Failed to create SimpleGenericUDAFParameterInfo", (Throwable)e);
        }
    }
}

