/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.client.HiveShimV1;
import org.apache.flink.table.catalog.hive.client.HiveShimV2;
import org.apache.hive.common.util.HiveVersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveShimLoader {
    public static final String HIVE_V1_VERSION_NAME = "1.2.1";
    public static final String HIVE_V2_VERSION_NAME = "2.3.4";
    private static final Map<String, HiveShim> hiveShims = new ConcurrentHashMap<String, HiveShim>(2);
    private static final Logger LOG = LoggerFactory.getLogger(HiveShimLoader.class);

    private HiveShimLoader() {
    }

    public static HiveShim loadHiveShim(String version) {
        return hiveShims.computeIfAbsent(version, v -> {
            if (v.startsWith(HIVE_V1_VERSION_NAME)) {
                return new HiveShimV1();
            }
            if (v.startsWith(HIVE_V2_VERSION_NAME)) {
                return new HiveShimV2();
            }
            throw new CatalogException("Unsupported Hive version " + v);
        });
    }

    public static String getHiveVersion() {
        return HiveVersionInfo.getVersion();
    }
}

