/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive;

import java.net.MalformedURLException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.hadoop.mapred.utils.HadoopUtils;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connectors.hive.HiveTableFactory;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.CatalogViewImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.exceptions.TablePartitionedException;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientFactory;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientWrapper;
import org.apache.flink.table.catalog.hive.util.HiveStatsUtil;
import org.apache.flink.table.catalog.hive.util.HiveTableUtil;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.ql.io.StorageFormatDescriptor;
import org.apache.hadoop.hive.ql.io.StorageFormatFactory;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCatalog
extends AbstractCatalog {
    public static final String DEFAULT_DB = "default";
    private static final Logger LOG = LoggerFactory.getLogger(HiveCatalog.class);
    private static final StorageFormatFactory storageFormatFactory = new StorageFormatFactory();
    private static final String DEFAULT_HIVE_TABLE_STORAGE_FORMAT = "TextFile";
    private static final String FLINK_FUNCTION_PREFIX = "flink:";
    private final HiveConf hiveConf;
    private final String hiveVersion;
    private HiveMetastoreClientWrapper client;

    public HiveCatalog(String catalogName, @Nullable String defaultDatabase, @Nullable String hiveConfDir, String hiveVersion) {
        this(catalogName, defaultDatabase == null ? DEFAULT_DB : defaultDatabase, HiveCatalog.createHiveConf(hiveConfDir), hiveVersion);
    }

    @VisibleForTesting
    protected HiveCatalog(String catalogName, String defaultDatabase, @Nullable HiveConf hiveConf, String hiveVersion) {
        super(catalogName, defaultDatabase == null ? DEFAULT_DB : defaultDatabase);
        this.hiveConf = hiveConf == null ? HiveCatalog.createHiveConf(null) : hiveConf;
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)hiveVersion) ? 1 : 0) != 0, (Object)"hiveVersion cannot be null or empty");
        this.hiveVersion = hiveVersion;
        this.hiveConf.set("hive-version", hiveVersion);
        LOG.info("Created HiveCatalog '{}'", (Object)catalogName);
    }

    private static HiveConf createHiveConf(@Nullable String hiveConfDir) {
        LOG.info("Setting hive conf dir as {}", (Object)hiveConfDir);
        try {
            HiveConf.setHiveSiteLocation(hiveConfDir == null ? null : Paths.get(hiveConfDir, "hive-site.xml").toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new CatalogException(String.format("Failed to get hive-site.xml from %s", hiveConfDir), (Throwable)e);
        }
        return new HiveConf(HadoopUtils.getHadoopConfiguration(new Configuration()), HiveConf.class);
    }

    @VisibleForTesting
    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    @VisibleForTesting
    public String getHiveVersion() {
        return this.hiveVersion;
    }

    public void open() throws CatalogException {
        if (this.client == null) {
            this.client = HiveMetastoreClientFactory.create(this.hiveConf, this.hiveVersion);
            LOG.info("Connected to Hive metastore");
        }
        if (!this.databaseExists(this.getDefaultDatabase())) {
            throw new CatalogException(String.format("Configured default database %s doesn't exist in catalog %s.", this.getDefaultDatabase(), this.getName()));
        }
    }

    public void close() throws CatalogException {
        if (this.client != null) {
            this.client.close();
            this.client = null;
            LOG.info("Close connection to Hive metastore");
        }
    }

    public Optional<TableFactory> getTableFactory() {
        return Optional.of(new HiveTableFactory(this.hiveConf));
    }

    public CatalogDatabase getDatabase(String databaseName) throws DatabaseNotExistException, CatalogException {
        Database hiveDatabase = this.getHiveDatabase(databaseName);
        Map properties = hiveDatabase.getParameters();
        properties.put("database.location_uri", hiveDatabase.getLocationUri());
        return new CatalogDatabaseImpl(properties, hiveDatabase.getDescription());
    }

    public void createDatabase(String databaseName, CatalogDatabase database, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"databaseName cannot be null or empty");
        Preconditions.checkNotNull((Object)database, (String)"database cannot be null");
        Database hiveDatabase = HiveCatalog.instantiateHiveDatabase(databaseName, database);
        try {
            this.client.createDatabase(hiveDatabase);
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new DatabaseAlreadyExistException(this.getName(), hiveDatabase.getName());
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to create database %s", hiveDatabase.getName()), (Throwable)e);
        }
    }

    private static Database instantiateHiveDatabase(String databaseName, CatalogDatabase database) {
        Map properties = database.getProperties();
        String dbLocationUri = (String)properties.remove("database.location_uri");
        return new Database(databaseName, database.getComment(), dbLocationUri, properties);
    }

    public void alterDatabase(String databaseName, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"databaseName cannot be null or empty");
        Preconditions.checkNotNull((Object)newDatabase, (String)"newDatabase cannot be null");
        if (!this.databaseExists(databaseName)) {
            if (!ignoreIfNotExists) {
                throw new DatabaseNotExistException(this.getName(), databaseName);
            }
            return;
        }
        Database newHiveDatabase = HiveCatalog.instantiateHiveDatabase(databaseName, newDatabase);
        try {
            this.client.alterDatabase(databaseName, newHiveDatabase);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to alter database %s", databaseName), (Throwable)e);
        }
    }

    public List<String> listDatabases() throws CatalogException {
        try {
            return this.client.getAllDatabases();
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to list all databases in %s", this.getName()), (Throwable)e);
        }
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        try {
            return this.client.getDatabase(databaseName) != null;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to determine whether database %s exists or not", databaseName), (Throwable)e);
        }
    }

    public void dropDatabase(String name, boolean ignoreIfNotExists) throws DatabaseNotExistException, DatabaseNotEmptyException, CatalogException {
        try {
            this.client.dropDatabase(name, true, ignoreIfNotExists);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreIfNotExists) {
                throw new DatabaseNotExistException(this.getName(), name);
            }
        }
        catch (InvalidOperationException e) {
            throw new DatabaseNotEmptyException(this.getName(), name);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to drop database %s", name), (Throwable)e);
        }
    }

    private Database getHiveDatabase(String databaseName) throws DatabaseNotExistException {
        try {
            return this.client.getDatabase(databaseName);
        }
        catch (NoSuchObjectException e) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to get database %s from %s", databaseName, this.getName()), (Throwable)e);
        }
    }

    public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"tablePath cannot be null");
        org.apache.hadoop.hive.metastore.api.Table hiveTable = this.getHiveTable(tablePath);
        return HiveCatalog.instantiateCatalogTable(hiveTable, this.hiveConf);
    }

    public void createTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"tablePath cannot be null");
        Preconditions.checkNotNull((Object)table, (String)"table cannot be null");
        if (!this.databaseExists(tablePath.getDatabaseName())) {
            throw new DatabaseNotExistException(this.getName(), tablePath.getDatabaseName());
        }
        org.apache.hadoop.hive.metastore.api.Table hiveTable = HiveCatalog.instantiateHiveTable(tablePath, table);
        try {
            this.client.createTable(hiveTable);
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new TableAlreadyExistException(this.getName(), tablePath);
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to create table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws TableNotExistException, TableAlreadyExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"tablePath cannot be null");
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)newTableName) ? 1 : 0) != 0, (Object)"newTableName cannot be null or empty");
        try {
            if (this.tableExists(tablePath)) {
                ObjectPath newPath = new ObjectPath(tablePath.getDatabaseName(), newTableName);
                if (this.tableExists(newPath)) {
                    throw new TableAlreadyExistException(this.getName(), newPath);
                }
                org.apache.hadoop.hive.metastore.api.Table table = this.getHiveTable(tablePath);
                table.setTableName(newTableName);
                this.client.alter_table(tablePath.getDatabaseName(), tablePath.getObjectName(), table);
            } else if (!ignoreIfNotExists) {
                throw new TableNotExistException(this.getName(), tablePath);
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to rename table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newCatalogTable, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        org.apache.hadoop.hive.metastore.api.Table hiveTable;
        Preconditions.checkNotNull((Object)tablePath, (String)"tablePath cannot be null");
        Preconditions.checkNotNull((Object)newCatalogTable, (String)"newCatalogTable cannot be null");
        try {
            hiveTable = this.getHiveTable(tablePath);
        }
        catch (TableNotExistException e) {
            if (!ignoreIfNotExists) {
                throw e;
            }
            return;
        }
        CatalogBaseTable existingTable = HiveCatalog.instantiateCatalogTable(hiveTable, this.hiveConf);
        if (existingTable.getClass() != newCatalogTable.getClass()) {
            throw new CatalogException(String.format("Table types don't match. Existing table is '%s' and new table is '%s'.", existingTable.getClass().getName(), newCatalogTable.getClass().getName()));
        }
        org.apache.hadoop.hive.metastore.api.Table newTable = HiveCatalog.instantiateHiveTable(tablePath, newCatalogTable);
        if (!newTable.getSd().isSetLocation()) {
            newTable.getSd().setLocation(hiveTable.getSd().getLocation());
        }
        try {
            this.client.alter_table(tablePath.getDatabaseName(), tablePath.getObjectName(), newTable);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to rename table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"tablePath cannot be null");
        try {
            this.client.dropTable(tablePath.getDatabaseName(), tablePath.getObjectName(), true, ignoreIfNotExists);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreIfNotExists) {
                throw new TableNotExistException(this.getName(), tablePath);
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to drop table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"databaseName cannot be null or empty");
        try {
            return this.client.getAllTables(databaseName);
        }
        catch (UnknownDBException e) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to list tables in database %s", databaseName), (Throwable)e);
        }
    }

    public List<String> listViews(String databaseName) throws DatabaseNotExistException, CatalogException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"databaseName cannot be null or empty");
        try {
            return this.client.getViews(databaseName);
        }
        catch (UnknownDBException e) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to list views in database %s", databaseName), (Throwable)e);
        }
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"tablePath cannot be null");
        try {
            return this.client.tableExists(tablePath.getDatabaseName(), tablePath.getObjectName());
        }
        catch (UnknownDBException e) {
            return false;
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to check whether table %s exists or not.", tablePath.getFullName()), (Throwable)e);
        }
    }

    @VisibleForTesting
    public org.apache.hadoop.hive.metastore.api.Table getHiveTable(ObjectPath tablePath) throws TableNotExistException {
        try {
            return this.client.getTable(tablePath.getDatabaseName(), tablePath.getObjectName());
        }
        catch (NoSuchObjectException e) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to get table %s from Hive metastore", tablePath.getFullName()), (Throwable)e);
        }
    }

    private static CatalogBaseTable instantiateCatalogTable(org.apache.hadoop.hive.metastore.api.Table hiveTable, HiveConf hiveConf) {
        List fields;
        boolean isView = TableType.valueOf((String)hiveTable.getTableType()) == TableType.VIRTUAL_VIEW;
        Map<String, String> properties = hiveTable.getParameters();
        boolean isGeneric = Boolean.valueOf((String)properties.get("is_generic"));
        if (isGeneric) {
            properties = HiveCatalog.retrieveFlinkProperties(properties);
        }
        String comment = properties.remove("comment");
        if (Table.hasMetastoreBasedSchema((HiveConf)hiveConf, (String)hiveTable.getSd().getSerdeInfo().getSerializationLib())) {
            fields = hiveTable.getSd().getCols();
        } else {
            try {
                fields = MetaStoreUtils.getFieldsFromDeserializer((String)hiveTable.getTableName(), (Deserializer)MetaStoreUtils.getDeserializer((org.apache.hadoop.conf.Configuration)hiveConf, (org.apache.hadoop.hive.metastore.api.Table)hiveTable, (boolean)true));
            }
            catch (MetaException | SerDeException e) {
                throw new CatalogException("Failed to get Hive table schema from deserializer", e);
            }
        }
        TableSchema tableSchema = HiveTableUtil.createTableSchema(fields, hiveTable.getPartitionKeys());
        List<Object> partitionKeys = new ArrayList();
        if (!hiveTable.getPartitionKeys().isEmpty()) {
            partitionKeys = HiveCatalog.getFieldNames(hiveTable.getPartitionKeys());
        }
        if (isView) {
            return new CatalogViewImpl(hiveTable.getViewOriginalText(), hiveTable.getViewExpandedText(), tableSchema, properties, comment);
        }
        return new CatalogTableImpl(tableSchema, partitionKeys, properties, comment);
    }

    private static org.apache.hadoop.hive.metastore.api.Table instantiateHiveTable(ObjectPath tablePath, CatalogBaseTable table) {
        org.apache.hadoop.hive.metastore.api.Table hiveTable = Table.getEmptyTable((String)tablePath.getDatabaseName(), (String)tablePath.getObjectName());
        hiveTable.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        Map<String, String> properties = new HashMap<String, String>(table.getProperties());
        properties.put("comment", table.getComment());
        boolean isGeneric = Boolean.valueOf((String)properties.get("is_generic"));
        if (isGeneric) {
            properties = HiveCatalog.maskFlinkProperties(properties);
        }
        hiveTable.setParameters(properties);
        StorageDescriptor sd = hiveTable.getSd();
        HiveCatalog.setStorageFormat(sd, properties);
        List<FieldSchema> allColumns = HiveTableUtil.createHiveColumns(table.getSchema());
        if (table instanceof CatalogTableImpl) {
            CatalogTableImpl catalogTable = (CatalogTableImpl)table;
            if (catalogTable.isPartitioned()) {
                int partitionKeySize = catalogTable.getPartitionKeys().size();
                List<FieldSchema> regularColumns = allColumns.subList(0, allColumns.size() - partitionKeySize);
                List<FieldSchema> partitionColumns = allColumns.subList(allColumns.size() - partitionKeySize, allColumns.size());
                sd.setCols(regularColumns);
                hiveTable.setPartitionKeys(partitionColumns);
            } else {
                sd.setCols(allColumns);
                hiveTable.setPartitionKeys(new ArrayList());
            }
        } else if (table instanceof CatalogViewImpl) {
            CatalogViewImpl view = (CatalogViewImpl)table;
            sd.setCols(allColumns);
            hiveTable.setPartitionKeys(new ArrayList());
            hiveTable.setViewOriginalText(view.getOriginalQuery());
            hiveTable.setViewExpandedText(view.getExpandedQuery());
            hiveTable.setTableType(TableType.VIRTUAL_VIEW.name());
        } else {
            throw new CatalogException("HiveCatalog only supports CatalogTableImpl and CatalogViewImpl");
        }
        return hiveTable;
    }

    private static void setStorageFormat(StorageDescriptor sd, Map<String, String> properties) {
        String storageFormatName = DEFAULT_HIVE_TABLE_STORAGE_FORMAT;
        StorageFormatDescriptor storageFormatDescriptor = storageFormatFactory.get(storageFormatName);
        Preconditions.checkArgument((storageFormatDescriptor != null ? 1 : 0) != 0, (Object)("Unknown storage format " + storageFormatName));
        sd.setInputFormat(storageFormatDescriptor.getInputFormat());
        sd.setOutputFormat(storageFormatDescriptor.getOutputFormat());
        String serdeLib = storageFormatDescriptor.getSerde();
        sd.getSerdeInfo().setSerializationLib(serdeLib != null ? serdeLib : LazySimpleSerDe.class.getName());
    }

    private static Map<String, String> retrieveFlinkProperties(Map<String, String> hiveTableParams) {
        return hiveTableParams.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("flink.") || ((String)e.getKey()).equals("is_generic")).collect(Collectors.toMap(e -> ((String)e.getKey()).replace("flink.", ""), e -> (String)e.getValue()));
    }

    private static Map<String, String> maskFlinkProperties(Map<String, String> properties) {
        return properties.entrySet().stream().filter(e -> e.getKey() != null && e.getValue() != null).map(e -> new Tuple2((Object)(((String)e.getKey()).equals("is_generic") ? (String)e.getKey() : "flink." + (String)e.getKey()), e.getValue())).collect(Collectors.toMap(t -> (String)t.f0, t -> (String)t.f1));
    }

    public boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        Preconditions.checkNotNull((Object)partitionSpec, (String)"CatalogPartitionSpec cannot be null");
        try {
            return this.getHivePartition(tablePath, partitionSpec) != null;
        }
        catch (PartitionSpecInvalidException | TableNotExistException | NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to get partition %s of table %s", partitionSpec, tablePath), (Throwable)e);
        }
    }

    public void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, PartitionAlreadyExistsException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        Preconditions.checkNotNull((Object)partitionSpec, (String)"CatalogPartitionSpec cannot be null");
        Preconditions.checkNotNull((Object)partition, (String)"Partition cannot be null");
        boolean isGeneric = Boolean.valueOf((String)partition.getProperties().get("is_generic"));
        if (isGeneric) {
            throw new CatalogException("Currently only supports non-generic CatalogPartition");
        }
        org.apache.hadoop.hive.metastore.api.Table hiveTable = this.getHiveTable(tablePath);
        HiveCatalog.ensureTableAndPartitionMatch(hiveTable, partition);
        this.ensurePartitionedTable(tablePath, hiveTable);
        try {
            this.client.add_partition(this.instantiateHivePartition(hiveTable, partitionSpec, partition));
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new PartitionAlreadyExistsException(this.getName(), tablePath, partitionSpec);
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to create partition %s of table %s", partitionSpec, tablePath));
        }
    }

    public void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        Preconditions.checkNotNull((Object)partitionSpec, (String)"CatalogPartitionSpec cannot be null");
        try {
            org.apache.hadoop.hive.metastore.api.Table hiveTable = this.getHiveTable(tablePath);
            this.client.dropPartition(tablePath.getDatabaseName(), tablePath.getObjectName(), this.getOrderedFullPartitionValues(partitionSpec, HiveCatalog.getFieldNames(hiveTable.getPartitionKeys()), tablePath), true);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreIfNotExists) {
                throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec, (Throwable)e);
            }
        }
        catch (PartitionSpecInvalidException | TableNotExistException | MetaException e) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec, e);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to drop partition %s of table %s", partitionSpec, tablePath));
        }
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        org.apache.hadoop.hive.metastore.api.Table hiveTable = this.getHiveTable(tablePath);
        this.ensurePartitionedTable(tablePath, hiveTable);
        try {
            return this.client.listPartitionNames(tablePath.getDatabaseName(), tablePath.getObjectName(), (short)-1).stream().map(HiveCatalog::createPartitionSpec).collect(Collectors.toList());
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to list partitions of table %s", tablePath), (Throwable)e);
        }
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        Preconditions.checkNotNull((Object)partitionSpec, (String)"CatalogPartitionSpec cannot be null");
        org.apache.hadoop.hive.metastore.api.Table hiveTable = this.getHiveTable(tablePath);
        this.ensurePartitionedTable(tablePath, hiveTable);
        try {
            List partialVals = MetaStoreUtils.getPvals((List)hiveTable.getPartitionKeys(), (Map)partitionSpec.getPartitionSpec());
            return this.client.listPartitionNames(tablePath.getDatabaseName(), tablePath.getObjectName(), partialVals, (short)-1).stream().map(HiveCatalog::createPartitionSpec).collect(Collectors.toList());
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to list partitions of table %s", tablePath), (Throwable)e);
        }
    }

    public CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        Preconditions.checkNotNull((Object)partitionSpec, (String)"CatalogPartitionSpec cannot be null");
        try {
            Partition hivePartition = this.getHivePartition(tablePath, partitionSpec);
            Map properties = hivePartition.getParameters();
            properties.put("partition.location", hivePartition.getSd().getLocation());
            String comment = (String)properties.remove("comment");
            return new CatalogPartitionImpl(properties, comment);
        }
        catch (PartitionSpecInvalidException | TableNotExistException | MetaException | NoSuchObjectException e) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec, e);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to get partition %s of table %s", partitionSpec, tablePath), (Throwable)e);
        }
    }

    public void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (String)"Table path cannot be null");
        Preconditions.checkNotNull((Object)partitionSpec, (String)"CatalogPartitionSpec cannot be null");
        Preconditions.checkNotNull((Object)newPartition, (String)"New partition cannot be null");
        boolean isGeneric = Boolean.valueOf((String)newPartition.getProperties().get("is_generic"));
        if (isGeneric) {
            throw new CatalogException("Currently only supports non-generic CatalogPartition");
        }
        try {
            org.apache.hadoop.hive.metastore.api.Table hiveTable = this.getHiveTable(tablePath);
            HiveCatalog.ensureTableAndPartitionMatch(hiveTable, newPartition);
            Partition oldHivePartition = this.getHivePartition(hiveTable, partitionSpec);
            if (oldHivePartition == null) {
                if (ignoreIfNotExists) {
                    return;
                }
                throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
            }
            Partition newHivePartition = this.instantiateHivePartition(hiveTable, partitionSpec, newPartition);
            if (newHivePartition.getSd().getLocation() == null) {
                newHivePartition.getSd().setLocation(oldHivePartition.getSd().getLocation());
            }
            this.client.alter_partition(tablePath.getDatabaseName(), tablePath.getObjectName(), newHivePartition);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreIfNotExists) {
                throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec, (Throwable)e);
            }
        }
        catch (PartitionSpecInvalidException | TableNotExistException | InvalidOperationException | MetaException e) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec, e);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to alter existing partition with new partition %s of table %s", partitionSpec, tablePath), (Throwable)e);
        }
    }

    private static void ensureTableAndPartitionMatch(org.apache.hadoop.hive.metastore.api.Table hiveTable, CatalogPartition catalogPartition) {
        boolean partitionIsGeneric;
        boolean tableIsGeneric = Boolean.valueOf((String)hiveTable.getParameters().get("is_generic"));
        if (tableIsGeneric != (partitionIsGeneric = Boolean.valueOf((String)catalogPartition.getProperties().get("is_generic")).booleanValue())) {
            throw new CatalogException(String.format("Cannot handle %s partition for %s table", catalogPartition.getClass().getName(), tableIsGeneric ? "generic" : "non-generic"));
        }
    }

    private Partition instantiateHivePartition(org.apache.hadoop.hive.metastore.api.Table hiveTable, CatalogPartitionSpec partitionSpec, CatalogPartition catalogPartition) throws PartitionSpecInvalidException {
        List<String> partCols = HiveCatalog.getFieldNames(hiveTable.getPartitionKeys());
        List<String> partValues = this.getOrderedFullPartitionValues(partitionSpec, partCols, new ObjectPath(hiveTable.getDbName(), hiveTable.getTableName()));
        for (int i = 0; i < partCols.size(); ++i) {
            if (!StringUtils.isNullOrWhitespaceOnly((String)partValues.get(i))) continue;
            throw new PartitionSpecInvalidException(this.getName(), partCols, new ObjectPath(hiveTable.getDbName(), hiveTable.getTableName()), partitionSpec);
        }
        StorageDescriptor sd = hiveTable.getSd().deepCopy();
        sd.setLocation((String)catalogPartition.getProperties().remove("partition.location"));
        HashMap<String, String> properties = new HashMap<String, String>(catalogPartition.getProperties());
        properties.put("comment", catalogPartition.getComment());
        return HiveTableUtil.createHivePartition(hiveTable.getDbName(), hiveTable.getTableName(), partValues, sd, properties);
    }

    private void ensurePartitionedTable(ObjectPath tablePath, org.apache.hadoop.hive.metastore.api.Table hiveTable) throws TableNotPartitionedException {
        if (!this.isTablePartitioned(hiveTable)) {
            throw new TableNotPartitionedException(this.getName(), tablePath);
        }
    }

    public static List<String> getFieldNames(List<FieldSchema> fieldSchemas) {
        ArrayList<String> names = new ArrayList<String>(fieldSchemas.size());
        for (FieldSchema fs : fieldSchemas) {
            names.add(fs.getName());
        }
        return names;
    }

    private static CatalogPartitionSpec createPartitionSpec(String hivePartitionName) {
        String[] partKeyVals = hivePartitionName.split("/");
        HashMap<String, String> spec = new HashMap<String, String>(partKeyVals.length);
        for (String keyVal : partKeyVals) {
            String[] kv = keyVal.split("=");
            spec.put(kv[0], kv[1]);
        }
        return new CatalogPartitionSpec(spec);
    }

    private List<String> getOrderedFullPartitionValues(CatalogPartitionSpec partitionSpec, List<String> partitionKeys, ObjectPath tablePath) throws PartitionSpecInvalidException {
        Map spec = partitionSpec.getPartitionSpec();
        if (spec.size() != partitionKeys.size()) {
            throw new PartitionSpecInvalidException(this.getName(), partitionKeys, tablePath, partitionSpec);
        }
        ArrayList<String> values = new ArrayList<String>(spec.size());
        for (String key : partitionKeys) {
            if (!spec.containsKey(key)) {
                throw new PartitionSpecInvalidException(this.getName(), partitionKeys, tablePath, partitionSpec);
            }
            values.add((String)spec.get(key));
        }
        return values;
    }

    private Partition getHivePartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException, PartitionSpecInvalidException, TException {
        return this.getHivePartition(this.getHiveTable(tablePath), partitionSpec);
    }

    private Partition getHivePartition(org.apache.hadoop.hive.metastore.api.Table hiveTable, CatalogPartitionSpec partitionSpec) throws PartitionSpecInvalidException, TException {
        return this.client.getPartition(hiveTable.getDbName(), hiveTable.getTableName(), this.getOrderedFullPartitionValues(partitionSpec, HiveCatalog.getFieldNames(hiveTable.getPartitionKeys()), new ObjectPath(hiveTable.getDbName(), hiveTable.getTableName())));
    }

    public void createFunction(ObjectPath functionPath, CatalogFunction function, boolean ignoreIfExists) throws FunctionAlreadyExistException, DatabaseNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)functionPath, (String)"functionPath cannot be null");
        Preconditions.checkNotNull((Object)function, (String)"function cannot be null");
        if (!(function instanceof CatalogFunctionImpl)) {
            throw new CatalogException(String.format("Unsupported catalog function type %s", function.getClass().getName()));
        }
        Function hiveFunction = HiveCatalog.instantiateHiveFunction(functionPath, function);
        try {
            this.client.createFunction(hiveFunction);
        }
        catch (NoSuchObjectException e) {
            throw new DatabaseNotExistException(this.getName(), functionPath.getDatabaseName(), (Throwable)e);
        }
        catch (AlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new FunctionAlreadyExistException(this.getName(), functionPath, (Throwable)e);
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to create function %s", functionPath.getFullName()), (Throwable)e);
        }
    }

    public void alterFunction(ObjectPath functionPath, CatalogFunction newFunction, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)functionPath, (String)"functionPath cannot be null");
        Preconditions.checkNotNull((Object)newFunction, (String)"newFunction cannot be null");
        try {
            CatalogFunction existingFunction = this.getFunction(functionPath);
            boolean existingType = Boolean.valueOf((String)existingFunction.getProperties().get("is_generic"));
            boolean newType = Boolean.valueOf((String)newFunction.getProperties().get("is_generic"));
            if (existingType != newType) {
                throw new CatalogException(String.format("Function types don't match. Existing function %s generic, and new function %s generic.", existingType ? "is" : "isn't", newType ? "is" : "isn't"));
            }
            if (!(newFunction instanceof CatalogFunctionImpl)) {
                throw new CatalogException(String.format("Unsupported catalog function type %s", newFunction.getClass().getName()));
            }
            Function hiveFunction = HiveCatalog.instantiateHiveFunction(functionPath, newFunction);
            this.client.alterFunction(functionPath.getDatabaseName(), functionPath.getObjectName(), hiveFunction);
        }
        catch (FunctionNotExistException e) {
            if (!ignoreIfNotExists) {
                throw e;
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to alter function %s", functionPath.getFullName()), (Throwable)e);
        }
    }

    public void dropFunction(ObjectPath functionPath, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)functionPath, (String)"functionPath cannot be null");
        try {
            this.client.dropFunction(functionPath.getDatabaseName(), functionPath.getObjectName());
        }
        catch (NoSuchObjectException e) {
            if (!ignoreIfNotExists) {
                throw new FunctionNotExistException(this.getName(), functionPath, (Throwable)e);
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to drop function %s", functionPath.getFullName()), (Throwable)e);
        }
    }

    public List<String> listFunctions(String databaseName) throws DatabaseNotExistException, CatalogException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"databaseName cannot be null or empty");
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        try {
            return this.client.getFunctions(databaseName, ".*");
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to list functions in database %s", databaseName), (Throwable)e);
        }
    }

    public CatalogFunction getFunction(ObjectPath functionPath) throws FunctionNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)functionPath, (String)"functionPath cannot be null or empty");
        try {
            Function function = this.client.getFunction(functionPath.getDatabaseName(), functionPath.getObjectName());
            if (function.getClassName().startsWith(FLINK_FUNCTION_PREFIX)) {
                return new CatalogFunctionImpl(function.getClassName().substring(FLINK_FUNCTION_PREFIX.length()), (Map)new HashMap<String, String>(){
                    {
                        this.put("is_generic", String.valueOf(true));
                    }
                });
            }
            return new CatalogFunctionImpl(function.getClassName(), (Map)new HashMap<String, String>(){
                {
                    this.put("is_generic", String.valueOf(false));
                }
            });
        }
        catch (NoSuchObjectException e) {
            throw new FunctionNotExistException(this.getName(), functionPath, (Throwable)e);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to get function %s", functionPath.getFullName()), (Throwable)e);
        }
    }

    public boolean functionExists(ObjectPath functionPath) throws CatalogException {
        Preconditions.checkNotNull((Object)functionPath, (String)"functionPath cannot be null or empty");
        try {
            return this.client.getFunction(functionPath.getDatabaseName(), functionPath.getObjectName()) != null;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to check whether function %s exists or not", functionPath.getFullName()), (Throwable)e);
        }
    }

    private static Function instantiateHiveFunction(ObjectPath functionPath, CatalogFunction function) {
        boolean isGeneric = Boolean.valueOf((String)function.getProperties().get("is_generic"));
        String functionClassName = isGeneric ? FLINK_FUNCTION_PREFIX + function.getClassName() : function.getClassName();
        return new Function(HiveStringUtils.normalizeIdentifier((String)functionPath.getObjectName()), functionPath.getDatabaseName(), functionClassName, null, PrincipalType.GROUP, (int)(System.currentTimeMillis() / 1000L), FunctionType.JAVA, new ArrayList());
    }

    private boolean isTablePartitioned(org.apache.hadoop.hive.metastore.api.Table hiveTable) {
        return hiveTable.getPartitionKeysSize() != 0;
    }

    public void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        try {
            org.apache.hadoop.hive.metastore.api.Table hiveTable = this.getHiveTable(tablePath);
            if (HiveCatalog.compareAndUpdateStatisticsProperties(tableStatistics, hiveTable.getParameters())) {
                this.client.alter_table(tablePath.getDatabaseName(), tablePath.getObjectName(), hiveTable);
            }
        }
        catch (TableNotExistException e) {
            if (!ignoreIfNotExists) {
                throw e;
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to alter table stats of table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException, TablePartitionedException {
        try {
            org.apache.hadoop.hive.metastore.api.Table hiveTable = this.getHiveTable(tablePath);
            if (this.isTablePartitioned(hiveTable)) {
                throw new TablePartitionedException(this.getName(), tablePath);
            }
            this.client.updateTableColumnStatistics(HiveStatsUtil.createTableColumnStats(hiveTable, columnStatistics.getColumnStatisticsData()));
        }
        catch (TableNotExistException e) {
            if (!ignoreIfNotExists) {
                throw e;
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to alter table column stats of table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    private static boolean compareAndUpdateStatisticsProperties(CatalogTableStatistics statistics, Map<String, String> parameters) {
        boolean needUpdateStatistics;
        String oldRowCount = parameters.getOrDefault("numRows", "0");
        String oldTotalSize = parameters.getOrDefault("totalSize", "0");
        String oldNumFiles = parameters.getOrDefault("numFiles", "0");
        String oldRawDataSize = parameters.getOrDefault("rawDataSize", "0");
        boolean bl = needUpdateStatistics = statistics.getRowCount() != Long.parseLong(oldRowCount) || statistics.getTotalSize() != Long.parseLong(oldTotalSize) || statistics.getFileCount() != Integer.parseInt(oldNumFiles) || statistics.getRawDataSize() != Long.parseLong(oldRawDataSize);
        if (needUpdateStatistics) {
            parameters.put("numRows", String.valueOf(statistics.getRowCount()));
            parameters.put("totalSize", String.valueOf(statistics.getTotalSize()));
            parameters.put("numFiles", String.valueOf(statistics.getFileCount()));
            parameters.put("rawDataSize", String.valueOf(statistics.getRawDataSize()));
        }
        return needUpdateStatistics;
    }

    private static CatalogTableStatistics createCatalogTableStatistics(Map<String, String> parameters) {
        long rowRount = Long.parseLong(parameters.getOrDefault("numRows", "0"));
        long totalSize = Long.parseLong(parameters.getOrDefault("totalSize", "0"));
        int numFiles = Integer.parseInt(parameters.getOrDefault("numFiles", "0"));
        long rawDataSize = Long.parseLong(parameters.getOrDefault("rawDataSize", "0"));
        return new CatalogTableStatistics(rowRount, numFiles, totalSize, rawDataSize);
    }

    public void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        try {
            Partition hivePartition = this.getHivePartition(tablePath, partitionSpec);
            if (HiveCatalog.compareAndUpdateStatisticsProperties(partitionStatistics, hivePartition.getParameters())) {
                this.client.alter_partition(tablePath.getDatabaseName(), tablePath.getObjectName(), hivePartition);
            }
        }
        catch (PartitionSpecInvalidException | TableNotExistException e) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec, e);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to alter table stats of table %s 's partition %s", tablePath.getFullName(), String.valueOf(partitionSpec)), (Throwable)e);
        }
    }

    public void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        try {
            Partition hivePartition = this.getHivePartition(tablePath, partitionSpec);
            org.apache.hadoop.hive.metastore.api.Table hiveTable = this.getHiveTable(tablePath);
            String partName = this.getPartitionName(tablePath, partitionSpec, hiveTable);
            this.client.updatePartitionColumnStatistics(HiveStatsUtil.createPartitionColumnStats(hivePartition, partName, columnStatistics.getColumnStatisticsData()));
        }
        catch (PartitionSpecInvalidException | TableNotExistException e) {
            if (!ignoreIfNotExists) {
                throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec, e);
            }
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to alter table column stats of table %s 's partition %s", tablePath.getFullName(), String.valueOf(partitionSpec)), (Throwable)e);
        }
    }

    private String getPartitionName(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, org.apache.hadoop.hive.metastore.api.Table hiveTable) throws PartitionSpecInvalidException {
        List<String> partitionCols = HiveCatalog.getFieldNames(hiveTable.getPartitionKeys());
        List<String> partitionVals = this.getOrderedFullPartitionValues(partitionSpec, partitionCols, tablePath);
        ArrayList<String> partKVs = new ArrayList<String>();
        for (int i = 0; i < partitionCols.size(); ++i) {
            partKVs.add(partitionCols.get(i) + "=" + partitionVals.get(i));
        }
        return String.join((CharSequence)"/", partKVs);
    }

    public CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        org.apache.hadoop.hive.metastore.api.Table hiveTable = this.getHiveTable(tablePath);
        if (!this.isTablePartitioned(hiveTable)) {
            return HiveCatalog.createCatalogTableStatistics(hiveTable.getParameters());
        }
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        org.apache.hadoop.hive.metastore.api.Table hiveTable = this.getHiveTable(tablePath);
        try {
            if (!this.isTablePartitioned(hiveTable)) {
                List<ColumnStatisticsObj> columnStatisticsObjs = this.client.getTableColumnStatistics(hiveTable.getDbName(), hiveTable.getTableName(), HiveCatalog.getFieldNames(hiveTable.getSd().getCols()));
                return new CatalogColumnStatistics(HiveStatsUtil.createCatalogColumnStats(columnStatisticsObjs));
            }
            return CatalogColumnStatistics.UNKNOWN;
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to get table column stats of table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        try {
            Partition partition = this.getHivePartition(tablePath, partitionSpec);
            return HiveCatalog.createCatalogTableStatistics(partition.getParameters());
        }
        catch (PartitionSpecInvalidException | TableNotExistException e) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec, e);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to get partition stats of table %s 's partition %s", tablePath.getFullName(), String.valueOf(partitionSpec)), (Throwable)e);
        }
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        try {
            Partition partition = this.getHivePartition(tablePath, partitionSpec);
            org.apache.hadoop.hive.metastore.api.Table hiveTable = this.getHiveTable(tablePath);
            String partName = this.getPartitionName(tablePath, partitionSpec, hiveTable);
            ArrayList<String> partNames = new ArrayList<String>();
            partNames.add(partName);
            Map<String, List<ColumnStatisticsObj>> partitionColumnStatistics = this.client.getPartitionColumnStatistics(partition.getDbName(), partition.getTableName(), partNames, HiveCatalog.getFieldNames(partition.getSd().getCols()));
            List<ColumnStatisticsObj> columnStatisticsObjs = partitionColumnStatistics.get(partName);
            if (columnStatisticsObjs != null && !columnStatisticsObjs.isEmpty()) {
                return new CatalogColumnStatistics(HiveStatsUtil.createCatalogColumnStats(columnStatisticsObjs));
            }
            return CatalogColumnStatistics.UNKNOWN;
        }
        catch (PartitionSpecInvalidException | TableNotExistException e) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
        catch (TException e) {
            throw new CatalogException(String.format("Failed to get table stats of table %s 's partition %s", tablePath.getFullName(), String.valueOf(partitionSpec)), (Throwable)e);
        }
    }
}

