/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.operator.stream.source;

import com.alibaba.alink.common.MLEnvironmentFactory;
import com.alibaba.alink.common.utils.DataStreamConversionUtil;
import com.alibaba.alink.operator.common.io.kafka.BaseKafkaSourceBuilder;
import com.alibaba.alink.operator.common.io.kafka.KafkaMessageDeserialization;
import com.alibaba.alink.operator.common.io.kafka.KafkaUtils;
import com.alibaba.alink.operator.stream.source.BaseSourceStreamOp;
import com.alibaba.alink.params.io.KafkaSourceParams;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.ml.api.misc.param.Params;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public abstract class BaseKafkaSourceStreamOp<T extends BaseKafkaSourceStreamOp<T>>
extends BaseSourceStreamOp<T> {
    public BaseKafkaSourceStreamOp(String nameSrcSnk, Params params) {
        super(nameSrcSnk, params);
    }

    protected abstract BaseKafkaSourceBuilder getKafkaSourceBuilder();

    protected Table initializeDataSource() {
        String topic = (String)this.getParams().get(KafkaSourceParams.TOPIC);
        String topicPattern = (String)this.getParams().get(KafkaSourceParams.TOPIC_PATTERN);
        KafkaSourceParams.StartupMode startupMode = (KafkaSourceParams.StartupMode)this.getParams().get(KafkaSourceParams.STARTUP_MODE);
        String properties = (String)this.getParams().get(KafkaSourceParams.PROPERTIES);
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)topicPattern) || !StringUtils.isNullOrWhitespaceOnly((String)topic) ? 1 : 0) != 0);
        Properties props = new Properties();
        props.setProperty("group.id", (String)this.getParams().get(KafkaSourceParams.GROUP_ID));
        props.setProperty("bootstrap.servers", (String)this.getParams().get(KafkaSourceParams.BOOTSTRAP_SERVERS));
        if (!StringUtils.isNullOrWhitespaceOnly((String)properties)) {
            String[] kvPairs;
            for (String kvPair : kvPairs = properties.split(",")) {
                int pos = kvPair.indexOf(61);
                Preconditions.checkArgument((pos >= 0 ? 1 : 0) != 0, (Object)"Invalid properties format, should be \"k1=v1,k2=v2,...\"");
                String key = kvPair.substring(0, pos);
                String value = kvPair.substring(pos + 1);
                props.setProperty(key, value);
            }
        }
        BaseKafkaSourceBuilder builder = this.getKafkaSourceBuilder();
        if (!StringUtils.isNullOrWhitespaceOnly((String)topicPattern)) {
            builder.setTopicPattern(topicPattern);
        } else {
            List<String> topics = Arrays.asList(topic.split(","));
            builder.setTopic(topics);
        }
        builder.setProperties(props);
        builder.setStartupMode(startupMode);
        if (startupMode.equals(KafkaSourceParams.StartupMode.TIMESTAMP)) {
            String timeStr = (String)this.getParams().get(KafkaSourceParams.START_TIME);
            builder.setStartTimeMs(KafkaUtils.parseDateStringToMs(timeStr));
        }
        StreamExecutionEnvironment env = MLEnvironmentFactory.get((Long)this.getMLEnvironmentId()).getStreamExecutionEnvironment();
        SingleOutputStreamOperator data = env.addSource(builder.build()).name("kafka");
        return DataStreamConversionUtil.toTable((Long)this.getMLEnvironmentId(), (DataStream)data, (String[])KafkaMessageDeserialization.KAFKA_SRC_FIELD_NAMES, (TypeInformation[])KafkaMessageDeserialization.KAFKA_SRC_FIELD_TYPES);
    }
}

