/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.python;

import com.alibaba.alink.executor.datasource.DataSourceFactory;
import com.alibaba.alink.executor.datasource.TableDataT;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import py4j.GatewayServer;

public class AlinkDBMain {
    public boolean validate(String type, String config) throws Exception {
        return DataSourceFactory.MakeDataSource(type, config).check();
    }

    public List<String> listTables(String type, String config, String prefix, int cnt) throws Exception {
        return DataSourceFactory.MakeDataSource(type, config).listTables(prefix, cnt);
    }

    public TableDataT getTableData(String type, String config, String tableName, int cnt) throws Exception {
        return DataSourceFactory.MakeDataSource(type, config).getTableData(tableName, cnt);
    }

    public boolean execute(String type, String config, String sql) throws Exception {
        return true;
    }

    public boolean hasTable(String type, String config, String tableName) throws Exception {
        return DataSourceFactory.MakeDataSource(type, config).getDB().hasTable(tableName);
    }

    public String[] getColNames(String type, String config, String tableName) throws Exception {
        return DataSourceFactory.MakeDataSource(type, config).getDB().getColNames(tableName);
    }

    public String[] getColTypes(String type, String config, String tableName) throws Exception {
        TypeInformation[] t = DataSourceFactory.MakeDataSource(type, config).getDB().getTableSchema(tableName).getFieldTypes();
        String[] ret = new String[t.length];
        for (int i = 0; i < t.length; ++i) {
            ret[i] = t[i].toString().toUpperCase();
        }
        return ret;
    }

    public String submitJob(String configJson, String planJson, Integer cores, Integer memory, String extra) throws IOException {
        throw new RuntimeException("not support");
    }

    public String getStatus(String configJson, String jobId) throws IOException {
        throw new RuntimeException("not support");
    }

    public void killJob(String configJson, String jobId) throws IOException {
        throw new RuntimeException("not support");
    }

    public LogResultT getLog(String configJson, String jobId, Integer offset, Integer limit) throws IOException {
        throw new RuntimeException("not support");
    }

    public static void main(String[] args) {
        Options opt = AlinkDBMain.createOptions();
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(opt, args);
            if (cmd.hasOption('h')) {
                AlinkDBMain.printUsage(opt);
                return;
            }
        }
        catch (ParseException exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
            AlinkDBMain.printHelp(opt);
            return;
        }
        int port = cmd.hasOption("port") ? Integer.parseInt(cmd.getOptionValue("port")) : 25333;
        AlinkDBMain app = new AlinkDBMain();
        GatewayServer server = new GatewayServer(app, port);
        server.start();
    }

    private static Options createOptions() {
        Options opt = new Options();
        opt.addOption(Option.builder((String)"P").hasArg().required(false).longOpt("port").desc("the listen port, default 25333").build());
        opt.addOption(Option.builder((String)"h").required(false).hasArg(false).longOpt("help").build());
        return opt;
    }

    private static void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String syntax = "Main";
        PrintStream out = System.out;
        out.println("\n=====");
        out.println("USAGE");
        out.println("=====");
        PrintWriter pw = new PrintWriter(out);
        formatter.printUsage(pw, 80, "Main", options);
        pw.flush();
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String syntax = "Main";
        String usageHeader = "Example of AlinkLocalGateway";
        String usageFooter = "See http://alink.alibaba-inc.com for further details.";
        PrintStream out = System.out;
        out.println("");
        out.println("========================================== ");
        out.println("HELP");
        out.println("===========================================");
        formatter.printHelp("Main", "Example of AlinkLocalGateway", options, "See http://alink.alibaba-inc.com for further details.");
    }

    public static class LogResultT {
        public Integer offset;
        public List<String> data;
    }
}

