/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.common.sql.builtin.string;

import com.alibaba.alink.common.utils.AlinkSerializable;
import org.apache.flink.table.functions.AggregateFunction;

public class ConcatAgg
extends AggregateFunction<String, WeightedAvgAccum> {
    public WeightedAvgAccum createAccumulator() {
        return new WeightedAvgAccum();
    }

    public String getValue(WeightedAvgAccum acc) {
        if (acc.count == 0) {
            return null;
        }
        return acc.concat;
    }

    public void accumulate(WeightedAvgAccum acc, String iValue, String linedelimiter) {
        if (acc.count == 0) {
            acc.concat = iValue;
            WeightedAvgAccum weightedAvgAccum = acc;
            weightedAvgAccum.count = weightedAvgAccum.count + 1;
            acc.linedelimiter = linedelimiter;
        } else {
            acc.concat = acc.concat + linedelimiter + iValue;
            WeightedAvgAccum weightedAvgAccum = acc;
            weightedAvgAccum.count = weightedAvgAccum.count + 1;
            acc.linedelimiter = linedelimiter;
        }
    }

    public void retract(WeightedAvgAccum acc, String iValue, String linedelimiter) {
        if (acc.count == 1) {
            acc.concat = "";
            acc.count = 0;
        } else {
            acc.concat = acc.concat.replaceFirst(linedelimiter + iValue, "");
            WeightedAvgAccum weightedAvgAccum = acc;
            weightedAvgAccum.count = weightedAvgAccum.count - 1;
        }
    }

    public void merge(WeightedAvgAccum acc, Iterable<WeightedAvgAccum> it) {
        for (WeightedAvgAccum a : it) {
            if (acc.count == 0) {
                acc.concat = a.concat;
                acc.count = acc.count + a.count;
                continue;
            }
            acc.concat = acc.concat + a.linedelimiter + a.concat;
            acc.count = acc.count + a.count;
        }
    }

    public void resetAccumulator(WeightedAvgAccum acc) {
        acc.concat = "";
        acc.count = 0;
        acc.linedelimiter = null;
    }

    public static class WeightedAvgAccum
    implements AlinkSerializable {
        private String concat = "";
        private int count = 0;
        private String linedelimiter = null;
    }
}

