/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeVisitor;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class FieldsDataType
extends DataType {
    private final Map<String, DataType> fieldDataTypes;

    public FieldsDataType(LogicalType logicalType, @Nullable Class<?> conversionClass, Map<String, DataType> fieldDataTypes) {
        super(logicalType, conversionClass);
        this.fieldDataTypes = Collections.unmodifiableMap(new HashMap((Map)Preconditions.checkNotNull(fieldDataTypes, (String)"Field data types must not be null.")));
    }

    public FieldsDataType(LogicalType logicalType, Map<String, DataType> fieldDataTypes) {
        this(logicalType, null, fieldDataTypes);
    }

    public Map<String, DataType> getFieldDataTypes() {
        return this.fieldDataTypes;
    }

    @Override
    public DataType notNull() {
        return new FieldsDataType(this.logicalType.copy(false), this.conversionClass, this.fieldDataTypes);
    }

    @Override
    public DataType nullable() {
        return new FieldsDataType(this.logicalType.copy(true), this.conversionClass, this.fieldDataTypes);
    }

    @Override
    public DataType bridgedTo(Class<?> newConversionClass) {
        return new FieldsDataType(this.logicalType, (Class)Preconditions.checkNotNull(newConversionClass, (String)"New conversion class must not be null."), this.fieldDataTypes);
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FieldsDataType that = (FieldsDataType)o;
        return this.fieldDataTypes.equals(that.fieldDataTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fieldDataTypes);
    }
}

