/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.DataSink;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.sinks.BatchTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.utils.TableConnectorUtils;
import org.apache.flink.types.Row;

public class CsvTableSink
implements BatchTableSink<Row>,
AppendStreamTableSink<Row> {
    private String path;
    private String fieldDelim;
    private int numFiles = -1;
    private FileSystem.WriteMode writeMode;
    private String[] fieldNames;
    private TypeInformation<?>[] fieldTypes;

    public CsvTableSink(String path, String fieldDelim, int numFiles, FileSystem.WriteMode writeMode) {
        this.path = path;
        this.fieldDelim = fieldDelim;
        this.numFiles = numFiles;
        this.writeMode = writeMode;
    }

    public CsvTableSink(String path) {
        this(path, ",");
    }

    public CsvTableSink(String path, String fieldDelim) {
        this(path, fieldDelim, -1, null);
    }

    @Override
    public void emitDataSet(DataSet<Row> dataSet) {
        MapOperator csvRows = dataSet.map((MapFunction)new CsvFormatter(this.fieldDelim == null ? "," : this.fieldDelim));
        DataSink sink = this.writeMode != null ? csvRows.writeAsText(this.path, this.writeMode) : csvRows.writeAsText(this.path);
        if (this.numFiles > 0) {
            csvRows.setParallelism(this.numFiles);
            sink.setParallelism(this.numFiles);
        }
        sink.name(TableConnectorUtils.generateRuntimeName(CsvTableSink.class, this.fieldNames));
    }

    @Override
    public DataStreamSink<?> consumeDataStream(DataStream<Row> dataStream) {
        SingleOutputStreamOperator csvRows = dataStream.map((MapFunction)new CsvFormatter(this.fieldDelim == null ? "," : this.fieldDelim));
        DataStreamSink sink = this.writeMode != null ? csvRows.writeAsText(this.path, this.writeMode) : csvRows.writeAsText(this.path);
        if (this.numFiles > 0) {
            csvRows.setParallelism(this.numFiles);
            sink.setParallelism(this.numFiles);
        } else {
            csvRows.setParallelism(dataStream.getParallelism());
            sink.setParallelism(dataStream.getParallelism());
        }
        sink.name(TableConnectorUtils.generateRuntimeName(CsvTableSink.class, this.fieldNames));
        return sink;
    }

    @Override
    public void emitDataStream(DataStream<Row> dataStream) {
        this.consumeDataStream(dataStream);
    }

    @Override
    public TableSink<Row> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        CsvTableSink configuredSink = new CsvTableSink(this.path, this.fieldDelim, this.numFiles, this.writeMode);
        configuredSink.fieldNames = fieldNames;
        configuredSink.fieldTypes = fieldTypes;
        return configuredSink;
    }

    @Override
    public TypeInformation<Row> getOutputType() {
        return new RowTypeInfo(this.getFieldTypes(), this.getFieldNames());
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public TypeInformation<?>[] getFieldTypes() {
        return this.fieldTypes;
    }

    public static class CsvFormatter
    implements MapFunction<Row, String> {
        private static final long serialVersionUID = 1L;
        private final String fieldDelim;

        CsvFormatter(String fieldDelim) {
            this.fieldDelim = fieldDelim;
        }

        public String map(Row row) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < row.getArity(); ++i) {
                Object o;
                if (builder.length() != 0) {
                    builder.append(this.fieldDelim);
                }
                if ((o = row.getField(i)) == null) continue;
                builder.append(o);
            }
            return builder.toString();
        }
    }
}

