/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.runtime.util.SegmentsUtil;
import org.apache.flink.util.InstantiationUtil;

@Internal
public final class BinaryGenericSerializer<T>
extends TypeSerializer<BinaryGeneric<T>> {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<T> serializer;

    public BinaryGenericSerializer(TypeSerializer<T> serializer) {
        this.serializer = serializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public BinaryGeneric<T> createInstance() {
        return new BinaryGeneric<Object>(this.serializer.createInstance(), this.serializer);
    }

    public BinaryGeneric<T> copy(BinaryGeneric<T> from) {
        return from.copy();
    }

    public BinaryGeneric<T> copy(BinaryGeneric<T> from, BinaryGeneric<T> reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(BinaryGeneric<T> record, DataOutputView target) throws IOException {
        target.writeInt(record.getSizeInBytes());
        SegmentsUtil.copyToView(record.getSegments(), record.getOffset(), record.getSizeInBytes(), target);
    }

    public BinaryGeneric<T> deserialize(DataInputView source) throws IOException {
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        return new BinaryGeneric<T>(new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes)}, 0, bytes.length, this.serializer);
    }

    public BinaryGeneric<T> deserialize(BinaryGeneric<T> record, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    public BinaryGenericSerializer<T> duplicate() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BinaryGenericSerializer that = (BinaryGenericSerializer)((Object)o);
        return this.serializer.equals(that.serializer);
    }

    public int hashCode() {
        return this.serializer.hashCode();
    }

    public TypeSerializerSnapshot<BinaryGeneric<T>> snapshotConfiguration() {
        return new BinaryGenericSerializerSnapshot<T>(this.serializer);
    }

    public static final class BinaryGenericSerializerSnapshot<T>
    implements TypeSerializerSnapshot<BinaryGeneric<T>> {
        private static final int CURRENT_VERSION = 3;
        private TypeSerializer<T> previousSerializer;

        public BinaryGenericSerializerSnapshot() {
        }

        BinaryGenericSerializerSnapshot(TypeSerializer<T> serializer) {
            this.previousSerializer = serializer;
        }

        public int getCurrentVersion() {
            return 3;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            InstantiationUtil.serializeObject((OutputStream)new DataOutputViewStream(out), this.previousSerializer);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            try {
                this.previousSerializer = (TypeSerializer)InstantiationUtil.deserializeObject((InputStream)new DataInputViewStream(in), (ClassLoader)userCodeClassLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        public TypeSerializer<BinaryGeneric<T>> restoreSerializer() {
            return new BinaryGenericSerializer<T>(this.previousSerializer);
        }

        public TypeSerializerSchemaCompatibility<BinaryGeneric<T>> resolveSchemaCompatibility(TypeSerializer<BinaryGeneric<T>> newSerializer) {
            if (!(newSerializer instanceof BinaryGenericSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            BinaryGenericSerializer newBinaryGenericSerializer = (BinaryGenericSerializer)newSerializer;
            if (!this.previousSerializer.equals((Object)newBinaryGenericSerializer.serializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

