/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.types;

import java.util.List;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;

public class PlannerTypeUtils {
    public static int getArity(LogicalType t) {
        if (t instanceof RowType) {
            return ((RowType)t).getFieldCount();
        }
        return 1;
    }

    public static RowType toRowType(LogicalType t) {
        if (t instanceof RowType) {
            return (RowType)t;
        }
        return RowType.of(t);
    }

    public static boolean isPrimitive(LogicalType type) {
        return PlannerTypeUtils.isPrimitive(type.getTypeRoot());
    }

    public static boolean isPrimitive(LogicalTypeRoot root) {
        switch (root) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isInteroperable(LogicalType t1, LogicalType t2) {
        if (t1.getTypeRoot().getFamilies().contains((Object)LogicalTypeFamily.CHARACTER_STRING) && t2.getTypeRoot().getFamilies().contains((Object)LogicalTypeFamily.CHARACTER_STRING)) {
            return true;
        }
        if (t1.getTypeRoot().getFamilies().contains((Object)LogicalTypeFamily.BINARY_STRING) && t2.getTypeRoot().getFamilies().contains((Object)LogicalTypeFamily.BINARY_STRING)) {
            return true;
        }
        if (t1.getTypeRoot() != t2.getTypeRoot()) {
            return false;
        }
        switch (t1.getTypeRoot()) {
            case ARRAY: 
            case MAP: 
            case MULTISET: 
            case ROW: {
                List<LogicalType> children1 = t1.getChildren();
                List<LogicalType> children2 = t2.getChildren();
                if (children1.size() != children2.size()) {
                    return false;
                }
                for (int i = 0; i < children1.size(); ++i) {
                    if (PlannerTypeUtils.isInteroperable(children1.get(i), children2.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return t1.copy(true).equals(t2.copy(true));
    }

    public static boolean isAssignable(LogicalType t1, LogicalType t2) {
        if (t1.getTypeRoot().getFamilies().contains((Object)LogicalTypeFamily.CHARACTER_STRING) && t2.getTypeRoot().getFamilies().contains((Object)LogicalTypeFamily.CHARACTER_STRING)) {
            return true;
        }
        if (t1.getTypeRoot().getFamilies().contains((Object)LogicalTypeFamily.BINARY_STRING) && t2.getTypeRoot().getFamilies().contains((Object)LogicalTypeFamily.BINARY_STRING)) {
            return true;
        }
        if (t1.getTypeRoot() != t2.getTypeRoot()) {
            return false;
        }
        switch (t1.getTypeRoot()) {
            case DECIMAL: {
                return true;
            }
        }
        if (t1.getChildren().isEmpty()) {
            return t1.copy(true).equals(t2.copy(true));
        }
        List<LogicalType> children1 = t1.getChildren();
        List<LogicalType> children2 = t2.getChildren();
        if (children1.size() != children2.size()) {
            return false;
        }
        for (int i = 0; i < children1.size(); ++i) {
            if (PlannerTypeUtils.isAssignable(children1.get(i), children2.get(i))) continue;
            return false;
        }
        return true;
    }
}

