/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.util.BaseRowUtil;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.typeutils.BaseRowSerializer;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.runtime.util.StreamRecordCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamSortOperator
extends TableStreamOperator<BaseRow>
implements OneInputStreamOperator<BaseRow, BaseRow> {
    private static final long serialVersionUID = 9042068324817807379L;
    private static final Logger LOG = LoggerFactory.getLogger(StreamSortOperator.class);
    private final BaseRowTypeInfo inputRowType;
    private GeneratedRecordComparator gComparator;
    private transient RecordComparator comparator;
    private transient BaseRowSerializer baseRowSerializer;
    private transient StreamRecordCollector<BaseRow> collector;
    private transient ListState<Tuple2<BaseRow, Long>> bufferState;
    private transient HashMap<BaseRow, Long> inputBuffer;

    public StreamSortOperator(BaseRowTypeInfo inputRowType, GeneratedRecordComparator gComparator) {
        this.inputRowType = inputRowType;
        this.gComparator = gComparator;
    }

    public void open() throws Exception {
        super.open();
        LOG.info("Opening StreamSortOperator");
        ExecutionConfig executionConfig = this.getExecutionConfig();
        this.baseRowSerializer = this.inputRowType.createSerializer(executionConfig);
        this.comparator = (RecordComparator)this.gComparator.newInstance(this.getContainingTask().getUserCodeClassLoader());
        this.gComparator = null;
        this.collector = new StreamRecordCollector(this.output);
        this.inputBuffer = new HashMap();
        if (this.bufferState != null) {
            ((Iterable)this.bufferState.get()).forEach(input -> this.inputBuffer.put((BaseRow)input.f0, (Long)input.f1));
        }
    }

    public void processElement(StreamRecord<BaseRow> element) throws Exception {
        BaseRow originalInput = (BaseRow)element.getValue();
        BinaryRow input = this.baseRowSerializer.toBinaryRow(originalInput).copy();
        BaseRowUtil.setAccumulate(input);
        long count = this.inputBuffer.getOrDefault(input, 0L);
        if (BaseRowUtil.isAccumulateMsg(originalInput)) {
            this.inputBuffer.put(input, count + 1L);
        } else {
            if (count == 0L) {
                throw new RuntimeException("BaseRow not exist!");
            }
            if (count == 1L) {
                this.inputBuffer.remove(input);
            } else {
                this.inputBuffer.put(input, count - 1L);
            }
        }
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        TupleTypeInfo tupleType = new TupleTypeInfo(new TypeInformation[]{this.inputRowType, Types.LONG});
        this.bufferState = context.getOperatorStateStore().getListState(new ListStateDescriptor("localBufferState", (TypeInformation)tupleType));
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        this.bufferState.clear();
        ArrayList dataToFlush = new ArrayList(this.inputBuffer.size());
        this.inputBuffer.forEach((key, value) -> dataToFlush.add(Tuple2.of((Object)key, (Object)value)));
        this.bufferState.addAll(dataToFlush);
    }

    @Override
    public void close() throws Exception {
        LOG.info("Closing StreamSortOperator");
        if (!this.inputBuffer.isEmpty()) {
            ArrayList<BaseRow> rowsSet = new ArrayList<BaseRow>();
            rowsSet.addAll(this.inputBuffer.keySet());
            rowsSet.sort(this.comparator);
            rowsSet.forEach(row -> {
                long count = this.inputBuffer.get(row);
                int i = 1;
                while ((long)i <= count) {
                    this.collector.collect((BaseRow)row);
                    ++i;
                }
            });
        }
        super.close();
    }
}

