/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.disk.iomanager.AbstractChannelReaderInputView;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.compression.BlockCompressionFactory;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.sort.AbstractBinaryExternalMerger;
import org.apache.flink.table.runtime.operators.sort.ChannelReaderKVInputViewIterator;
import org.apache.flink.table.runtime.operators.sort.SpillChannelManager;
import org.apache.flink.table.runtime.typeutils.BinaryRowSerializer;
import org.apache.flink.util.MutableObjectIterator;

public class BinaryKVExternalMerger
extends AbstractBinaryExternalMerger<Tuple2<BinaryRow, BinaryRow>> {
    private final BinaryRowSerializer keySerializer;
    private final BinaryRowSerializer valueSerializer;
    private final RecordComparator comparator;

    public BinaryKVExternalMerger(IOManager ioManager, int pageSize, int maxFanIn, SpillChannelManager channelManager, BinaryRowSerializer keySerializer, BinaryRowSerializer valueSerializer, RecordComparator comparator, boolean compressionEnable, BlockCompressionFactory compressionCodecFactory, int compressionBlockSize) {
        super(ioManager, pageSize, maxFanIn, channelManager, compressionEnable, compressionCodecFactory, compressionBlockSize);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.comparator = comparator;
    }

    @Override
    protected List<Tuple2<BinaryRow, BinaryRow>> mergeReusedEntries(int size) {
        ArrayList<Tuple2<BinaryRow, BinaryRow>> reused = new ArrayList<Tuple2<BinaryRow, BinaryRow>>(size);
        for (int i = 0; i < size; ++i) {
            reused.add((Tuple2<BinaryRow, BinaryRow>)new Tuple2((Object)this.keySerializer.createInstance(), (Object)this.valueSerializer.createInstance()));
        }
        return reused;
    }

    @Override
    protected MutableObjectIterator<Tuple2<BinaryRow, BinaryRow>> channelReaderInputViewIterator(AbstractChannelReaderInputView inView) {
        return new ChannelReaderKVInputViewIterator<BinaryRow, BinaryRow>(inView, null, this.keySerializer.duplicate(), this.valueSerializer.duplicate());
    }

    @Override
    protected Comparator<Tuple2<BinaryRow, BinaryRow>> mergeComparator() {
        return (o1, o2) -> this.comparator.compare((BaseRow)o1.f0, (BaseRow)o2.f0);
    }

    @Override
    protected void writeMergingOutput(MutableObjectIterator<Tuple2<BinaryRow, BinaryRow>> mergeIterator, AbstractPagedOutputView output) throws IOException {
        Tuple2 kv = new Tuple2((Object)this.keySerializer.createInstance(), (Object)this.valueSerializer.createInstance());
        while ((kv = (Tuple2)mergeIterator.next((Object)kv)) != null) {
            this.keySerializer.serialize((BinaryRow)kv.f0, (DataOutputView)output);
            this.valueSerializer.serialize((BinaryRow)kv.f1, (DataOutputView)output);
        }
    }
}

