/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import java.io.Serializable;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.AlgorithmOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.InputSelectable;
import org.apache.flink.streaming.api.operators.InputSelection;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.runtime.hashtable.BinaryHashTable;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.operators.join.HashJoinType;
import org.apache.flink.table.runtime.typeutils.AbstractRowSerializer;
import org.apache.flink.table.runtime.util.RowIterator;
import org.apache.flink.table.runtime.util.StreamRecordCollector;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HashJoinOperator
extends TableStreamOperator<BaseRow>
implements TwoInputStreamOperator<BaseRow, BaseRow, BaseRow>,
BoundedMultiInput,
InputSelectable {
    private static final Logger LOG = LoggerFactory.getLogger(HashJoinOperator.class);
    private final HashJoinParameter parameter;
    private final boolean reverseJoinFunction;
    private final HashJoinType type;
    private transient BinaryHashTable table;
    transient Collector<BaseRow> collector;
    transient BaseRow buildSideNullRow;
    private transient BaseRow probeSideNullRow;
    private transient JoinedRow joinedRow;
    private transient boolean buildEnd;
    private transient JoinCondition condition;

    HashJoinOperator(HashJoinParameter parameter) {
        this.parameter = parameter;
        this.type = parameter.type;
        this.reverseJoinFunction = parameter.reverseJoinFunction;
    }

    public void open() throws Exception {
        super.open();
        ClassLoader cl = this.getContainingTask().getUserCodeClassLoader();
        AbstractRowSerializer buildSerializer = (AbstractRowSerializer)this.getOperatorConfig().getTypeSerializerIn1(this.getUserCodeClassloader());
        AbstractRowSerializer probeSerializer = (AbstractRowSerializer)this.getOperatorConfig().getTypeSerializerIn2(this.getUserCodeClassloader());
        boolean hashJoinUseBitMaps = this.getContainingTask().getEnvironment().getTaskConfiguration().getBoolean(AlgorithmOptions.HASH_JOIN_BLOOM_FILTERS);
        int parallel = this.getRuntimeContext().getNumberOfParallelSubtasks();
        this.condition = (JoinCondition)this.parameter.condFuncCode.newInstance(cl);
        this.condition.setRuntimeContext((RuntimeContext)this.getRuntimeContext());
        this.condition.open(new Configuration());
        this.table = new BinaryHashTable(this.getContainingTask().getJobConfiguration(), this.getContainingTask(), buildSerializer, probeSerializer, (Projection)this.parameter.buildProjectionCode.newInstance(cl), (Projection)this.parameter.probeProjectionCode.newInstance(cl), this.getContainingTask().getEnvironment().getMemoryManager(), this.parameter.reservedMemorySize, this.parameter.maxMemorySize, this.parameter.perRequestMemorySize, this.getContainingTask().getEnvironment().getIOManager(), this.parameter.buildRowSize, this.parameter.buildRowCount / (long)parallel, hashJoinUseBitMaps, this.type, this.condition, this.reverseJoinFunction, this.parameter.filterNullKeys, this.parameter.tryDistinctBuildRow);
        this.collector = new StreamRecordCollector<BaseRow>(this.output);
        this.buildSideNullRow = new GenericRow(buildSerializer.getArity());
        this.probeSideNullRow = new GenericRow(probeSerializer.getArity());
        this.joinedRow = new JoinedRow();
        this.buildEnd = false;
        this.getMetricGroup().gauge("memoryUsedSizeInBytes", this.table::getUsedMemoryInBytes);
        this.getMetricGroup().gauge("numSpillFiles", this.table::getNumSpillFiles);
        this.getMetricGroup().gauge("spillInBytes", this.table::getSpillInBytes);
        this.parameter.condFuncCode = null;
        this.parameter.buildProjectionCode = null;
        this.parameter.probeProjectionCode = null;
    }

    public void processElement1(StreamRecord<BaseRow> element) throws Exception {
        Preconditions.checkState((!this.buildEnd ? 1 : 0) != 0, (Object)"Should not build ended.");
        this.table.putBuildRow((BaseRow)element.getValue());
    }

    public void processElement2(StreamRecord<BaseRow> element) throws Exception {
        Preconditions.checkState((boolean)this.buildEnd, (Object)"Should build ended.");
        if (this.table.tryProbe((BaseRow)element.getValue())) {
            this.joinWithNextKey();
        }
    }

    public InputSelection nextSelection() {
        return this.buildEnd ? InputSelection.SECOND : InputSelection.FIRST;
    }

    public void endInput(int inputId) throws Exception {
        switch (inputId) {
            case 1: {
                Preconditions.checkState((!this.buildEnd ? 1 : 0) != 0, (Object)"Should not build ended.");
                LOG.info("Finish build phase.");
                this.buildEnd = true;
                this.table.endBuild();
                break;
            }
            case 2: {
                Preconditions.checkState((boolean)this.buildEnd, (Object)"Should build ended.");
                LOG.info("Finish probe phase.");
                while (this.table.nextMatching()) {
                    this.joinWithNextKey();
                }
                LOG.info("Finish rebuild phase.");
            }
        }
    }

    private void joinWithNextKey() throws Exception {
        this.join(this.table.getBuildSideIterator(), this.table.getCurrentProbeRow());
    }

    public abstract void join(RowIterator<BinaryRow> var1, BaseRow var2) throws Exception;

    void innerJoin(RowIterator<BinaryRow> buildIter, BaseRow probeRow) throws Exception {
        this.collect(buildIter.getRow(), probeRow);
        while (buildIter.advanceNext()) {
            this.collect(buildIter.getRow(), probeRow);
        }
    }

    void buildOuterJoin(RowIterator<BinaryRow> buildIter) throws Exception {
        this.collect(buildIter.getRow(), this.probeSideNullRow);
        while (buildIter.advanceNext()) {
            this.collect(buildIter.getRow(), this.probeSideNullRow);
        }
    }

    void collect(BaseRow row1, BaseRow row2) throws Exception {
        if (this.reverseJoinFunction) {
            this.collector.collect((Object)this.joinedRow.replace(row2, row1));
        } else {
            this.collector.collect((Object)this.joinedRow.replace(row1, row2));
        }
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.table != null) {
            this.table.close();
            this.table.free();
            this.table = null;
        }
        this.condition.close();
    }

    public static HashJoinOperator newHashJoinOperator(long minMemorySize, long maxMemorySize, long eachRequestMemorySize, HashJoinType type, GeneratedJoinCondition condFuncCode, boolean reverseJoinFunction, boolean[] filterNullKeys, GeneratedProjection buildProjectionCode, GeneratedProjection probeProjectionCode, boolean tryDistinctBuildRow, int buildRowSize, long buildRowCount, long probeRowCount, RowType keyType) {
        HashJoinParameter parameter = new HashJoinParameter(minMemorySize, maxMemorySize, eachRequestMemorySize, type, condFuncCode, reverseJoinFunction, filterNullKeys, buildProjectionCode, probeProjectionCode, tryDistinctBuildRow, buildRowSize, buildRowCount, probeRowCount, keyType);
        switch (type) {
            case INNER: {
                return new InnerHashJoinOperator(parameter);
            }
            case BUILD_OUTER: {
                return new BuildOuterHashJoinOperator(parameter);
            }
            case PROBE_OUTER: {
                return new ProbeOuterHashJoinOperator(parameter);
            }
            case FULL_OUTER: {
                return new FullOuterHashJoinOperator(parameter);
            }
            case SEMI: {
                return new SemiHashJoinOperator(parameter);
            }
            case ANTI: {
                return new AntiHashJoinOperator(parameter);
            }
            case BUILD_LEFT_SEMI: 
            case BUILD_LEFT_ANTI: {
                return new BuildLeftSemiOrAntiHashJoinOperator(parameter);
            }
        }
        throw new IllegalArgumentException("invalid: " + (Object)((Object)type));
    }

    private static class BuildLeftSemiOrAntiHashJoinOperator
    extends HashJoinOperator {
        BuildLeftSemiOrAntiHashJoinOperator(HashJoinParameter parameter) {
            super(parameter);
        }

        @Override
        public void join(RowIterator<BinaryRow> buildIter, BaseRow probeRow) throws Exception {
            block4: {
                if (!buildIter.advanceNext()) break block4;
                if (probeRow != null) {
                    while (buildIter.advanceNext()) {
                    }
                } else {
                    this.collector.collect((Object)buildIter.getRow());
                    while (buildIter.advanceNext()) {
                        this.collector.collect((Object)buildIter.getRow());
                    }
                }
            }
        }
    }

    private static class AntiHashJoinOperator
    extends HashJoinOperator {
        AntiHashJoinOperator(HashJoinParameter parameter) {
            super(parameter);
        }

        @Override
        public void join(RowIterator<BinaryRow> buildIter, BaseRow probeRow) throws Exception {
            Preconditions.checkNotNull((Object)probeRow);
            if (!buildIter.advanceNext()) {
                this.collector.collect((Object)probeRow);
            }
        }
    }

    private static class SemiHashJoinOperator
    extends HashJoinOperator {
        SemiHashJoinOperator(HashJoinParameter parameter) {
            super(parameter);
        }

        @Override
        public void join(RowIterator<BinaryRow> buildIter, BaseRow probeRow) throws Exception {
            Preconditions.checkNotNull((Object)probeRow);
            if (buildIter.advanceNext()) {
                this.collector.collect((Object)probeRow);
            }
        }
    }

    private static class FullOuterHashJoinOperator
    extends HashJoinOperator {
        FullOuterHashJoinOperator(HashJoinParameter parameter) {
            super(parameter);
        }

        @Override
        public void join(RowIterator<BinaryRow> buildIter, BaseRow probeRow) throws Exception {
            if (buildIter.advanceNext()) {
                if (probeRow != null) {
                    this.innerJoin(buildIter, probeRow);
                } else {
                    this.buildOuterJoin(buildIter);
                }
            } else if (probeRow != null) {
                this.collect(this.buildSideNullRow, probeRow);
            }
        }
    }

    private static class ProbeOuterHashJoinOperator
    extends HashJoinOperator {
        ProbeOuterHashJoinOperator(HashJoinParameter parameter) {
            super(parameter);
        }

        @Override
        public void join(RowIterator<BinaryRow> buildIter, BaseRow probeRow) throws Exception {
            if (buildIter.advanceNext()) {
                if (probeRow != null) {
                    this.innerJoin(buildIter, probeRow);
                }
            } else if (probeRow != null) {
                this.collect(this.buildSideNullRow, probeRow);
            }
        }
    }

    private static class BuildOuterHashJoinOperator
    extends HashJoinOperator {
        BuildOuterHashJoinOperator(HashJoinParameter parameter) {
            super(parameter);
        }

        @Override
        public void join(RowIterator<BinaryRow> buildIter, BaseRow probeRow) throws Exception {
            if (buildIter.advanceNext()) {
                if (probeRow != null) {
                    this.innerJoin(buildIter, probeRow);
                } else {
                    this.buildOuterJoin(buildIter);
                }
            }
        }
    }

    private static class InnerHashJoinOperator
    extends HashJoinOperator {
        InnerHashJoinOperator(HashJoinParameter parameter) {
            super(parameter);
        }

        @Override
        public void join(RowIterator<BinaryRow> buildIter, BaseRow probeRow) throws Exception {
            if (buildIter.advanceNext() && probeRow != null) {
                this.innerJoin(buildIter, probeRow);
            }
        }
    }

    static class HashJoinParameter
    implements Serializable {
        long reservedMemorySize;
        long maxMemorySize;
        long perRequestMemorySize;
        HashJoinType type;
        GeneratedJoinCondition condFuncCode;
        boolean reverseJoinFunction;
        boolean[] filterNullKeys;
        GeneratedProjection buildProjectionCode;
        GeneratedProjection probeProjectionCode;
        boolean tryDistinctBuildRow;
        int buildRowSize;
        long buildRowCount;
        long probeRowCount;
        RowType keyType;

        HashJoinParameter(long reservedMemorySize, long maxMemorySize, long perRequestMemorySize, HashJoinType type, GeneratedJoinCondition condFuncCode, boolean reverseJoinFunction, boolean[] filterNullKeys, GeneratedProjection buildProjectionCode, GeneratedProjection probeProjectionCode, boolean tryDistinctBuildRow, int buildRowSize, long buildRowCount, long probeRowCount, RowType keyType) {
            this.reservedMemorySize = reservedMemorySize;
            this.maxMemorySize = maxMemorySize;
            this.perRequestMemorySize = perRequestMemorySize;
            this.type = type;
            this.condFuncCode = condFuncCode;
            this.reverseJoinFunction = reverseJoinFunction;
            this.filterNullKeys = filterNullKeys;
            this.buildProjectionCode = buildProjectionCode;
            this.probeProjectionCode = probeProjectionCode;
            this.tryDistinctBuildRow = tryDistinctBuildRow;
            this.buildRowSize = buildRowSize;
            this.buildRowCount = buildRowCount;
            this.probeRowCount = probeRowCount;
            this.keyType = keyType;
        }
    }
}

