/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;
import org.apache.flink.sql.parser.ddl.SqlDropTable;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.sql.parser.dml.RichSqlInsert;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.operations.ddl.DropTableOperation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.operations.SqlConversionException;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;

public class SqlToOperationConverter {
    private FlinkPlannerImpl flinkPlanner;

    private SqlToOperationConverter(FlinkPlannerImpl flinkPlanner) {
        this.flinkPlanner = flinkPlanner;
    }

    public static Operation convert(FlinkPlannerImpl flinkPlanner, SqlNode sqlNode) {
        SqlNode validated = flinkPlanner.validate(sqlNode);
        SqlToOperationConverter converter = new SqlToOperationConverter(flinkPlanner);
        if (validated instanceof SqlCreateTable) {
            return converter.convertCreateTable((SqlCreateTable)validated);
        }
        if (validated instanceof SqlDropTable) {
            return converter.convertDropTable((SqlDropTable)validated);
        }
        if (validated instanceof RichSqlInsert) {
            return converter.convertSqlInsert((RichSqlInsert)validated);
        }
        if (validated.getKind().belongsTo(SqlKind.QUERY)) {
            return converter.convertSqlQuery(validated);
        }
        throw new TableException("Unsupported node type " + validated.getClass().getSimpleName());
    }

    private Operation convertCreateTable(SqlCreateTable sqlCreateTable) {
        if (sqlCreateTable.getPrimaryKeyList() != null && sqlCreateTable.getPrimaryKeyList().size() > 0 || sqlCreateTable.getUniqueKeysList() != null && sqlCreateTable.getUniqueKeysList().size() > 0) {
            throw new SqlConversionException("Primary key and unique key are not supported yet.");
        }
        SqlNodeList propertyList = sqlCreateTable.getPropertyList();
        HashMap<String, String> properties = new HashMap<String, String>();
        if (propertyList != null) {
            propertyList.getList().forEach(p -> properties.put(((SqlTableOption)p).getKeyString().toLowerCase(), ((SqlTableOption)p).getValueString()));
        }
        TableSchema tableSchema = this.createTableSchema(sqlCreateTable, new FlinkTypeFactory(new FlinkTypeSystem()));
        String tableComment = "";
        if (sqlCreateTable.getComment() != null) {
            tableComment = sqlCreateTable.getComment().getNlsString().getValue();
        }
        List<String> partitionKeys = new ArrayList<String>();
        SqlNodeList partitionKey = sqlCreateTable.getPartitionKeyList();
        if (partitionKey != null) {
            partitionKeys = partitionKey.getList().stream().map(p -> ((SqlIdentifier)p).getSimple()).collect(Collectors.toList());
        }
        CatalogTableImpl catalogTable = new CatalogTableImpl(tableSchema, partitionKeys, properties, tableComment);
        return new CreateTableOperation(sqlCreateTable.fullTableName(), catalogTable, sqlCreateTable.isIfNotExists());
    }

    private Operation convertDropTable(SqlDropTable sqlDropTable) {
        return new DropTableOperation(sqlDropTable.fullTableName(), sqlDropTable.getIfExists());
    }

    private Operation convertSqlInsert(RichSqlInsert insert) {
        ImmutableList<String> targetTablePath = ((SqlIdentifier)insert.getTargetTable()).names;
        return new CatalogSinkModifyOperation(targetTablePath, (PlannerQueryOperation)SqlToOperationConverter.convert(this.flinkPlanner, insert.getSource()), insert.getStaticPartitionKVs());
    }

    private Operation convertSqlQuery(SqlNode node) {
        return this.toQueryOperation(this.flinkPlanner, node);
    }

    private TableSchema createTableSchema(SqlCreateTable sqlCreateTable, FlinkTypeFactory factory) {
        SqlNodeList columnList = sqlCreateTable.getColumnList();
        TableSchema physicalSchema = null;
        TableSchema.Builder builder = new TableSchema.Builder();
        List physicalColumns = columnList.getList().stream().filter(n -> n instanceof SqlTableColumn).collect(Collectors.toList());
        for (SqlNode node : physicalColumns) {
            SqlTableColumn column = (SqlTableColumn)node;
            RelDataType relType = column.getType().deriveType(factory, column.getType().getNullable());
            builder.field(column.getName().getSimple(), LogicalTypeDataTypeConverter.fromLogicalTypeToDataType(FlinkTypeFactory.toLogicalType(relType)));
            physicalSchema = builder.build();
        }
        assert (physicalSchema != null);
        if (sqlCreateTable.containsComputedColumn()) {
            throw new SqlConversionException("Computed columns for DDL is not supported yet!");
        }
        return physicalSchema;
    }

    private PlannerQueryOperation toQueryOperation(FlinkPlannerImpl planner, SqlNode validated) {
        RelRoot relational = planner.rel(validated);
        return new PlannerQueryOperation(relational.project());
    }
}

