/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.utils.ApiExpressionUtils;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.planner.functions.aggfunctions.DeclarativeAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;

public abstract class MaxAggFunction
extends DeclarativeAggregateFunction {
    private UnresolvedReferenceExpression max = ApiExpressionUtils.unresolvedRef("max");

    @Override
    public int operandCount() {
        return 1;
    }

    @Override
    public UnresolvedReferenceExpression[] aggBufferAttributes() {
        return new UnresolvedReferenceExpression[]{this.max};
    }

    @Override
    public DataType[] getAggBufferTypes() {
        return new DataType[]{this.getResultType()};
    }

    @Override
    public Expression[] initialValuesExpressions() {
        return new Expression[]{ExpressionBuilder.nullOf(this.getResultType())};
    }

    @Override
    public Expression[] accumulateExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.operand(0)), this.max, ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.max), this.operand(0), ExpressionBuilder.ifThenElse(ExpressionBuilder.greaterThan(this.operand(0), this.max), this.operand(0), this.max)))};
    }

    @Override
    public Expression[] retractExpressions() {
        return new Expression[0];
    }

    @Override
    public Expression[] mergeExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.mergeOperand(this.max)), this.max, ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.max), this.mergeOperand(this.max), ExpressionBuilder.ifThenElse(ExpressionBuilder.greaterThan(this.mergeOperand(this.max), this.max), this.mergeOperand(this.max), this.max)))};
    }

    @Override
    public Expression getValueExpression() {
        return this.max;
    }

    public static class TimestampMaxAggFunction
    extends MaxAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.TIMESTAMP(3);
        }
    }

    public static class TimeMaxAggFunction
    extends MaxAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.TIME(0);
        }
    }

    public static class DateMaxAggFunction
    extends MaxAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.DATE();
        }
    }

    public static class StringMaxAggFunction
    extends MaxAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.STRING();
        }
    }

    public static class BooleanMaxAggFunction
    extends MaxAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.BOOLEAN();
        }
    }

    public static class DecimalMaxAggFunction
    extends MaxAggFunction {
        private DecimalType decimalType;

        public DecimalMaxAggFunction(DecimalType decimalType) {
            this.decimalType = decimalType;
        }

        @Override
        public DataType getResultType() {
            return DataTypes.DECIMAL(this.decimalType.getPrecision(), this.decimalType.getScale());
        }
    }

    public static class DoubleMaxAggFunction
    extends MaxAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.DOUBLE();
        }
    }

    public static class FloatMaxAggFunction
    extends MaxAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.FLOAT();
        }
    }

    public static class LongMaxAggFunction
    extends MaxAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.BIGINT();
        }
    }

    public static class ShortMaxAggFunction
    extends MaxAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.SMALLINT();
        }
    }

    public static class ByteMaxAggFunction
    extends MaxAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.TINYINT();
        }
    }

    public static class IntMaxAggFunction
    extends MaxAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.INT();
        }
    }
}

