/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.BooleanSerializer;
import org.apache.flink.api.common.typeutils.base.ByteSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.FloatSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.common.typeutils.base.ShortSerializer;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataview.MapViewSerializer;
import org.apache.flink.table.dataview.MapViewTypeInfo;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.runtime.typeutils.BinaryStringSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryStringTypeInfo;
import org.apache.flink.table.runtime.typeutils.DecimalSerializer;
import org.apache.flink.table.runtime.typeutils.DecimalTypeInfo;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TypeInformationAnyType;

public abstract class LastValueWithRetractAggFunction<T>
extends AggregateFunction<T, GenericRow> {
    @Override
    public GenericRow createAccumulator() {
        GenericRow acc = new GenericRow(4);
        acc.setField(0, null);
        acc.setField(1, null);
        acc.setField(2, new BinaryGeneric(new MapView(this.getResultType(), (TypeInformation<?>)new ListTypeInfo(Types.LONG)), this.getValueToOrderMapViewSerializer()));
        acc.setField(3, new BinaryGeneric(new MapView((TypeInformation<?>)Types.LONG, (TypeInformation<?>)new ListTypeInfo(this.getResultType())), this.getOrderToValueMapViewSerializer()));
        return acc;
    }

    public void accumulate(GenericRow acc, Object value) throws Exception {
        if (value != null) {
            Object v = value;
            Long order = System.currentTimeMillis();
            MapView<T, List<Long>> valueToOrderMapView = this.getValueToOrderMapViewFromAcc(acc);
            List<Long> orderList = valueToOrderMapView.get(v);
            if (orderList == null) {
                orderList = new ArrayList<Long>();
            }
            orderList.add(order);
            valueToOrderMapView.put(v, orderList);
            this.accumulate(acc, value, order);
        }
    }

    public void accumulate(GenericRow acc, Object value, Long order) throws Exception {
        if (value != null) {
            MapView<Long, List<T>> orderToValueMapView;
            List<T> valueList;
            Object v = value;
            Long prevOrder = (Long)acc.getField(1);
            if (prevOrder == null || prevOrder <= order) {
                acc.setField(0, v);
                acc.setLong(1, order);
            }
            if ((valueList = (orderToValueMapView = this.getOrderToValueMapViewFromAcc(acc)).get(order)) == null) {
                valueList = new ArrayList<T>();
            }
            valueList.add(v);
            orderToValueMapView.put(order, valueList);
        }
    }

    public void retract(GenericRow acc, Object value) throws Exception {
        if (value != null) {
            Object v = value;
            MapView<T, List<Long>> valueToOrderMapView = this.getValueToOrderMapViewFromAcc(acc);
            List<Long> orderList = valueToOrderMapView.get(v);
            if (orderList != null && orderList.size() > 0) {
                Long order = orderList.get(0);
                orderList.remove(0);
                if (orderList.isEmpty()) {
                    valueToOrderMapView.remove(v);
                } else {
                    valueToOrderMapView.put(v, orderList);
                }
                this.retract(acc, value, order);
            }
        }
    }

    public void retract(GenericRow acc, Object value, Long order) throws Exception {
        if (value != null) {
            Object v = value;
            MapView<Long, List<T>> orderToValueMapView = this.getOrderToValueMapViewFromAcc(acc);
            List<T> valueList = orderToValueMapView.get(order);
            if (valueList == null) {
                return;
            }
            int index = valueList.indexOf(v);
            if (index >= 0) {
                valueList.remove(index);
                if (valueList.isEmpty()) {
                    orderToValueMapView.remove(order);
                } else {
                    orderToValueMapView.put(order, valueList);
                }
            }
            if (v.equals(acc.getField(0))) {
                Long startKey = (Long)acc.getField(1);
                Iterator<Long> iter = orderToValueMapView.keys().iterator();
                Long nextKey = Long.MIN_VALUE;
                while (iter.hasNext()) {
                    Long key = iter.next();
                    if (key > startKey || key <= nextKey) continue;
                    nextKey = key;
                }
                if (nextKey != Long.MIN_VALUE) {
                    List<T> values = orderToValueMapView.get(nextKey);
                    acc.setField(0, values.get(values.size() - 1));
                    acc.setField(1, nextKey);
                } else {
                    acc.setField(0, null);
                    acc.setField(1, null);
                }
            }
        }
    }

    public void resetAccumulator(GenericRow acc) {
        acc.setField(0, null);
        acc.setField(1, null);
        MapView<T, List<Long>> valueToOrderMapView = this.getValueToOrderMapViewFromAcc(acc);
        valueToOrderMapView.clear();
        MapView<Long, List<T>> orderToValueMapView = this.getOrderToValueMapViewFromAcc(acc);
        orderToValueMapView.clear();
    }

    @Override
    public T getValue(GenericRow acc) {
        return (T)acc.getField(0);
    }

    protected abstract TypeSerializer<T> createValueSerializer();

    @Override
    public TypeInformation<GenericRow> getAccumulatorType() {
        LogicalType[] fieldTypes = new LogicalType[]{TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType(this.getResultType()), new BigIntType(), new TypeInformationAnyType(new MapViewTypeInfo(this.getResultType(), new ListTypeInfo(Types.LONG), false, false)), new TypeInformationAnyType(new MapViewTypeInfo(Types.LONG, new ListTypeInfo(this.getResultType()), false, false))};
        String[] fieldNames = new String[]{"lastValue", "lastOrder", "valueToOrderMapView", "orderToValueMapView"};
        return new BaseRowTypeInfo(fieldTypes, fieldNames);
    }

    private MapView<T, List<Long>> getValueToOrderMapViewFromAcc(GenericRow acc) {
        BinaryGeneric binaryGeneric = (BinaryGeneric)acc.getField(2);
        return (MapView)BinaryGeneric.getJavaObjectFromBinaryGeneric(binaryGeneric, this.getValueToOrderMapViewSerializer());
    }

    private MapView<Long, List<T>> getOrderToValueMapViewFromAcc(GenericRow acc) {
        BinaryGeneric binaryGeneric = (BinaryGeneric)acc.getField(3);
        return (MapView)BinaryGeneric.getJavaObjectFromBinaryGeneric(binaryGeneric, this.getOrderToValueMapViewSerializer());
    }

    private MapViewSerializer<T, List<Long>> getValueToOrderMapViewSerializer() {
        return new MapViewSerializer(new MapSerializer(this.createValueSerializer(), (TypeSerializer)new ListSerializer((TypeSerializer)LongSerializer.INSTANCE)));
    }

    private MapViewSerializer<Long, List<T>> getOrderToValueMapViewSerializer() {
        return new MapViewSerializer<Long, List<T>>(new MapSerializer((TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)new ListSerializer(this.createValueSerializer())));
    }

    public static class StringLastValueWithRetractAggFunction
    extends LastValueWithRetractAggFunction<BinaryString> {
        @Override
        public TypeInformation<BinaryString> getResultType() {
            return BinaryStringTypeInfo.INSTANCE;
        }

        public void accumulate(GenericRow acc, BinaryString value) throws Exception {
            if (value != null) {
                super.accumulate(acc, value.copy());
            }
        }

        public void accumulate(GenericRow acc, BinaryString value, Long order) throws Exception {
            if (value != null) {
                super.accumulate(acc, value.copy(), order);
            }
        }

        @Override
        protected TypeSerializer<BinaryString> createValueSerializer() {
            return BinaryStringSerializer.INSTANCE;
        }
    }

    public static class DecimalLastValueWithRetractAggFunction
    extends LastValueWithRetractAggFunction<Decimal> {
        private DecimalTypeInfo decimalTypeInfo;

        public DecimalLastValueWithRetractAggFunction(DecimalTypeInfo decimalTypeInfo) {
            this.decimalTypeInfo = decimalTypeInfo;
        }

        public void accumulate(GenericRow acc, Decimal value) throws Exception {
            super.accumulate(acc, value);
        }

        public void accumulate(GenericRow acc, Decimal value, Long order) throws Exception {
            super.accumulate(acc, value, order);
        }

        @Override
        public TypeInformation<Decimal> getResultType() {
            return this.decimalTypeInfo;
        }

        @Override
        protected TypeSerializer<Decimal> createValueSerializer() {
            return new DecimalSerializer(this.decimalTypeInfo.precision(), this.decimalTypeInfo.scale());
        }
    }

    public static class BooleanLastValueWithRetractAggFunction
    extends LastValueWithRetractAggFunction<Boolean> {
        @Override
        public TypeInformation<Boolean> getResultType() {
            return Types.BOOLEAN;
        }

        @Override
        protected TypeSerializer<Boolean> createValueSerializer() {
            return BooleanSerializer.INSTANCE;
        }
    }

    public static class DoubleLastValueWithRetractAggFunction
    extends LastValueWithRetractAggFunction<Double> {
        @Override
        public TypeInformation<Double> getResultType() {
            return Types.DOUBLE;
        }

        @Override
        protected TypeSerializer<Double> createValueSerializer() {
            return DoubleSerializer.INSTANCE;
        }
    }

    public static class FloatLastValueWithRetractAggFunction
    extends LastValueWithRetractAggFunction<Float> {
        @Override
        public TypeInformation<Float> getResultType() {
            return Types.FLOAT;
        }

        @Override
        protected TypeSerializer<Float> createValueSerializer() {
            return FloatSerializer.INSTANCE;
        }
    }

    public static class LongLastValueWithRetractAggFunction
    extends LastValueWithRetractAggFunction<Long> {
        @Override
        public TypeInformation<Long> getResultType() {
            return Types.LONG;
        }

        @Override
        protected TypeSerializer<Long> createValueSerializer() {
            return LongSerializer.INSTANCE;
        }
    }

    public static class IntLastValueWithRetractAggFunction
    extends LastValueWithRetractAggFunction<Integer> {
        @Override
        public TypeInformation<Integer> getResultType() {
            return Types.INT;
        }

        @Override
        protected TypeSerializer<Integer> createValueSerializer() {
            return IntSerializer.INSTANCE;
        }
    }

    public static class ShortLastValueWithRetractAggFunction
    extends LastValueWithRetractAggFunction<Short> {
        @Override
        public TypeInformation<Short> getResultType() {
            return Types.SHORT;
        }

        @Override
        protected TypeSerializer<Short> createValueSerializer() {
            return ShortSerializer.INSTANCE;
        }
    }

    public static class ByteLastValueWithRetractAggFunction
    extends LastValueWithRetractAggFunction<Byte> {
        @Override
        public TypeInformation<Byte> getResultType() {
            return Types.BYTE;
        }

        @Override
        protected TypeSerializer<Byte> createValueSerializer() {
            return ByteSerializer.INSTANCE;
        }
    }
}

