/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InputDependencyConstraint;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.runtime.jobgraph.ScheduleMode;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.transformations.ShuffleMode;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.delegation.ExecutorBase;
import org.apache.flink.table.planner.plan.nodes.resource.NodeResourceUtil;

@Internal
public class BatchExecutor
extends ExecutorBase {
    @VisibleForTesting
    public BatchExecutor(StreamExecutionEnvironment executionEnvironment) {
        super(executionEnvironment);
    }

    @Override
    public JobExecutionResult execute(String jobName) throws Exception {
        StreamExecutionEnvironment execEnv = this.getExecutionEnvironment();
        StreamGraph streamGraph = this.generateStreamGraph(jobName);
        return execEnv.execute(streamGraph);
    }

    private void setBatchProperties(StreamExecutionEnvironment execEnv) {
        ExecutionConfig executionConfig = execEnv.getConfig();
        executionConfig.enableObjectReuse();
        executionConfig.setLatencyTrackingInterval(-1L);
        execEnv.setStreamTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        execEnv.setBufferTimeout(-1L);
        if (this.isShuffleModeAllBatch()) {
            executionConfig.setDefaultInputDependencyConstraint(InputDependencyConstraint.ALL);
        }
    }

    @Override
    public StreamGraph generateStreamGraph(List<Transformation<?>> transformations, String jobName) {
        StreamExecutionEnvironment execEnv = this.getExecutionEnvironment();
        this.setBatchProperties(execEnv);
        transformations.forEach(arg_0 -> ((StreamExecutionEnvironment)execEnv).addOperator(arg_0));
        StreamGraph streamGraph = execEnv.getStreamGraph(this.getNonEmptyJobName(jobName));
        ResourceSpec managedResourceSpec = NodeResourceUtil.fromManagedMem(0);
        streamGraph.getStreamNodes().forEach(sn -> {
            if (sn.getMinResources().equals((Object)ResourceSpec.DEFAULT)) {
                sn.setResources(managedResourceSpec, managedResourceSpec);
            }
        });
        streamGraph.setChaining(true);
        streamGraph.setScheduleMode(ScheduleMode.LAZY_FROM_SOURCES_WITH_BATCH_SLOT_REQUEST);
        streamGraph.setStateBackend(null);
        if (streamGraph.getCheckpointConfig().isCheckpointingEnabled()) {
            throw new IllegalArgumentException("Checkpoint is not supported for batch jobs.");
        }
        if (this.isShuffleModeAllBatch()) {
            streamGraph.setBlockingConnectionsBetweenChains(true);
        }
        return streamGraph;
    }

    private boolean isShuffleModeAllBatch() {
        String value = this.tableConfig.getConfiguration().getString(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE);
        if (value.equalsIgnoreCase(ShuffleMode.BATCH.toString())) {
            return true;
        }
        if (!value.equalsIgnoreCase(ShuffleMode.PIPELINED.toString())) {
            throw new IllegalArgumentException(ExecutionConfigOptions.TABLE_EXEC_SHUFFLE_MODE.key() + " can only be set to " + ShuffleMode.BATCH.toString() + " or " + ShuffleMode.PIPELINED.toString());
        }
        return false;
    }
}

