/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.QueryOperationCatalogView;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.schema.FlinkTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;

@Internal
public class QueryOperationCatalogViewTable
extends FlinkTable
implements TranslatableTable {
    private final QueryOperationCatalogView catalogView;
    private final RelProtoDataType rowType;
    private final FlinkStatistic statistic;

    public static QueryOperationCatalogViewTable createCalciteTable(QueryOperationCatalogView catalogView) {
        return new QueryOperationCatalogViewTable(catalogView, typeFactory -> {
            TableSchema tableSchema = catalogView.getSchema();
            List<String> fieldNames = Arrays.asList(tableSchema.getFieldNames());
            List fieldTypes = Arrays.stream(tableSchema.getFieldDataTypes()).map(LogicalTypeDataTypeConverter::fromDataTypeToLogicalType).collect(Collectors.toList());
            return ((FlinkTypeFactory)typeFactory).buildRelNodeRowType(JavaScalaConversionUtil.toScala(fieldNames), JavaScalaConversionUtil.toScala(fieldTypes));
        }, FlinkStatistic.UNKNOWN());
    }

    private QueryOperationCatalogViewTable(QueryOperationCatalogView catalogView, RelProtoDataType rowType, FlinkStatistic statistic2) {
        this.catalogView = catalogView;
        this.rowType = rowType;
        this.statistic = statistic2;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        FlinkRelBuilder relBuilder = FlinkRelBuilder.of(context.getCluster(), relOptTable);
        RelNode relNode = relBuilder.queryOperation(this.catalogView.getQueryOperation()).build();
        return RelOptUtil.createCastRel(relNode, (RelDataType)this.rowType.apply(relBuilder.getTypeFactory()), false);
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.rowType.apply(typeFactory);
    }

    public QueryOperationCatalogView getCatalogView() {
        return this.catalogView;
    }

    @Override
    public FlinkStatistic getStatistic() {
        return this.statistic;
    }

    @Override
    public FlinkTable copy(FlinkStatistic statistic2) {
        return new QueryOperationCatalogViewTable(this.catalogView, this.rowType, statistic2);
    }
}

