/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.List;
import java.util.Optional;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.utils.HiveAggSqlFunction;
import org.apache.flink.table.planner.functions.utils.HiveFunctionUtils;
import org.apache.flink.table.planner.functions.utils.HiveScalarSqlFunction;
import org.apache.flink.table.planner.functions.utils.HiveTableSqlFunction;
import org.apache.flink.table.planner.functions.utils.TableSqlFunction;
import org.apache.flink.table.planner.functions.utils.UserDefinedFunctionUtils;
import org.apache.flink.table.planner.plan.schema.DeferredTypeFlinkTableFunction;
import org.apache.flink.table.planner.plan.schema.FlinkTableFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;

@Internal
public class FunctionCatalogOperatorTable
implements SqlOperatorTable {
    private final FunctionCatalog functionCatalog;
    private final FlinkTypeFactory typeFactory;

    public FunctionCatalogOperatorTable(FunctionCatalog functionCatalog, FlinkTypeFactory typeFactory) {
        this.functionCatalog = functionCatalog;
        this.typeFactory = typeFactory;
    }

    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList, SqlNameMatcher nameMatcher) {
        if (!opName.isSimple()) {
            return;
        }
        if (this.isNotUserFunction(category)) {
            return;
        }
        String name = opName.getSimple();
        Optional<FunctionLookup.Result> candidateFunction = this.functionCatalog.lookupFunction(name);
        candidateFunction.flatMap(lookupResult -> this.convertToSqlFunction(category, name, lookupResult.getFunctionDefinition())).ifPresent(operatorList::add);
    }

    private boolean isNotUserFunction(SqlFunctionCategory category) {
        return category != null && !category.isUserDefinedNotSpecificFunction();
    }

    private Optional<SqlFunction> convertToSqlFunction(SqlFunctionCategory category, String name, FunctionDefinition functionDefinition) {
        if (functionDefinition instanceof AggregateFunctionDefinition) {
            AggregateFunctionDefinition def = (AggregateFunctionDefinition)functionDefinition;
            if (HiveFunctionUtils.isHiveFunc(def.getAggregateFunction())) {
                return Optional.of(new HiveAggSqlFunction(name, name, def.getAggregateFunction(), this.typeFactory));
            }
            return this.convertAggregateFunction(name, (AggregateFunctionDefinition)functionDefinition);
        }
        if (functionDefinition instanceof ScalarFunctionDefinition) {
            ScalarFunctionDefinition def = (ScalarFunctionDefinition)functionDefinition;
            if (HiveFunctionUtils.isHiveFunc(def.getScalarFunction())) {
                return Optional.of(new HiveScalarSqlFunction(name, name, def.getScalarFunction(), this.typeFactory));
            }
            return this.convertScalarFunction(name, def);
        }
        if (functionDefinition instanceof TableFunctionDefinition && category != null && category.isTableFunction()) {
            TableFunctionDefinition def = (TableFunctionDefinition)functionDefinition;
            if (HiveFunctionUtils.isHiveFunc(def.getTableFunction())) {
                DataType returnType = TypeConversions.fromLegacyInfoToDataType(new GenericTypeInfo(Row.class));
                return Optional.of(new HiveTableSqlFunction(name, name, def.getTableFunction(), returnType, this.typeFactory, (FlinkTableFunction)new DeferredTypeFlinkTableFunction(def.getTableFunction(), returnType), HiveTableSqlFunction.operandTypeChecker(name, def.getTableFunction())));
            }
            return this.convertTableFunction(name, (TableFunctionDefinition)functionDefinition);
        }
        return Optional.empty();
    }

    private Optional<SqlFunction> convertAggregateFunction(String name, AggregateFunctionDefinition functionDefinition) {
        SqlFunction aggregateFunction = UserDefinedFunctionUtils.createAggregateSqlFunction(name, name, functionDefinition.getAggregateFunction(), TypeConversions.fromLegacyInfoToDataType(functionDefinition.getResultTypeInfo()), TypeConversions.fromLegacyInfoToDataType(functionDefinition.getAccumulatorTypeInfo()), this.typeFactory);
        return Optional.of(aggregateFunction);
    }

    private Optional<SqlFunction> convertScalarFunction(String name, ScalarFunctionDefinition functionDefinition) {
        SqlFunction scalarFunction = UserDefinedFunctionUtils.createScalarSqlFunction(name, name, functionDefinition.getScalarFunction(), this.typeFactory);
        return Optional.of(scalarFunction);
    }

    private Optional<SqlFunction> convertTableFunction(String name, TableFunctionDefinition functionDefinition) {
        TableSqlFunction tableFunction = UserDefinedFunctionUtils.createTableSqlFunction(name, name, functionDefinition.getTableFunction(), TypeConversions.fromLegacyInfoToDataType(functionDefinition.getResultType()), this.typeFactory);
        return Optional.of(tableFunction);
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        throw new UnsupportedOperationException("This should never be called");
    }
}

