/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils.factories;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.expressions.utils.ResolvedExpressionDefaultVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.SortQueryOperation;

@Internal
public class SortOperationFactory {
    private final boolean isStreamingMode;

    public SortOperationFactory(boolean isStreamingMode) {
        this.isStreamingMode = isStreamingMode;
    }

    public QueryOperation createSort(List<ResolvedExpression> orders, QueryOperation child, ExpressionResolver.PostResolverFactory postResolverFactory) {
        this.failIfStreaming();
        OrderWrapper orderWrapper = new OrderWrapper(postResolverFactory);
        List<ResolvedExpression> convertedOrders = orders.stream().map(f -> f.accept(orderWrapper)).collect(Collectors.toList());
        return new SortQueryOperation(convertedOrders, child);
    }

    public QueryOperation createLimitWithOffset(int offset, QueryOperation child) {
        SortQueryOperation previousSort = this.validateAndGetChildSort(child);
        if (offset < 0) {
            throw new ValidationException("Offset should be greater or equal 0");
        }
        if (previousSort.getOffset() != -1) {
            throw new ValidationException("OFFSET already defined");
        }
        return new SortQueryOperation(previousSort.getOrder(), previousSort.getChild(), offset, -1);
    }

    public QueryOperation createLimitWithFetch(int fetch, QueryOperation child) {
        SortQueryOperation previousSort = this.validateAndGetChildSort(child);
        if (fetch < 0) {
            throw new ValidationException("Fetch should be greater or equal 0");
        }
        int offset = Math.max(previousSort.getOffset(), 0);
        return new SortQueryOperation(previousSort.getOrder(), previousSort.getChild(), offset, fetch);
    }

    private SortQueryOperation validateAndGetChildSort(QueryOperation child) {
        this.failIfStreaming();
        if (!(child instanceof SortQueryOperation)) {
            throw new ValidationException("A limit operation must be preceded by a sort operation.");
        }
        SortQueryOperation previousSort = (SortQueryOperation)child;
        if (previousSort.getFetch() != -1) {
            throw new ValidationException("FETCH is already defined.");
        }
        return previousSort;
    }

    private void failIfStreaming() {
        if (this.isStreamingMode) {
            throw new ValidationException("A limit operation on unbounded tables is currently not supported.");
        }
    }

    private class OrderWrapper
    extends ResolvedExpressionDefaultVisitor<ResolvedExpression> {
        private ExpressionResolver.PostResolverFactory postResolverFactory;

        OrderWrapper(ExpressionResolver.PostResolverFactory postResolverFactory) {
            this.postResolverFactory = postResolverFactory;
        }

        @Override
        public ResolvedExpression visit(CallExpression call) {
            if (BuiltInFunctionDefinitions.ORDERING.contains(call.getFunctionDefinition())) {
                return call;
            }
            return this.defaultMethod(call);
        }

        @Override
        protected ResolvedExpression defaultMethod(ResolvedExpression expression2) {
            return this.postResolverFactory.wrappingCall(BuiltInFunctionDefinitions.ORDER_ASC, expression2);
        }
    }
}

