/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.api.GroupWindow;
import org.apache.flink.table.api.OverWindow;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionUtils;
import org.apache.flink.table.expressions.LocalReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.expressions.resolver.LookupCallResolver;
import org.apache.flink.table.expressions.resolver.lookups.TableReferenceLookup;
import org.apache.flink.table.expressions.utils.ApiExpressionDefaultVisitor;
import org.apache.flink.table.expressions.utils.ApiExpressionUtils;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.operations.DistinctQueryOperation;
import org.apache.flink.table.operations.FilterQueryOperation;
import org.apache.flink.table.operations.JoinQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.SetQueryOperation;
import org.apache.flink.table.operations.WindowAggregateQueryOperation;
import org.apache.flink.table.operations.utils.factories.AggregateOperationFactory;
import org.apache.flink.table.operations.utils.factories.AliasOperationUtils;
import org.apache.flink.table.operations.utils.factories.CalculatedTableFactory;
import org.apache.flink.table.operations.utils.factories.ColumnOperationUtils;
import org.apache.flink.table.operations.utils.factories.JoinOperationFactory;
import org.apache.flink.table.operations.utils.factories.ProjectionOperationFactory;
import org.apache.flink.table.operations.utils.factories.SetOperationFactory;
import org.apache.flink.table.operations.utils.factories.SortOperationFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.typeutils.FieldInfoUtils;
import org.apache.flink.util.Preconditions;

@Internal
public final class OperationTreeBuilder {
    private final FunctionLookup functionCatalog;
    private final TableReferenceLookup tableReferenceLookup;
    private final LookupCallResolver lookupResolver;
    private final ProjectionOperationFactory projectionOperationFactory;
    private final SortOperationFactory sortOperationFactory;
    private final CalculatedTableFactory calculatedTableFactory;
    private final SetOperationFactory setOperationFactory;
    private final AggregateOperationFactory aggregateOperationFactory;
    private final JoinOperationFactory joinOperationFactory;

    private OperationTreeBuilder(FunctionLookup functionLookup, TableReferenceLookup tableReferenceLookup, ProjectionOperationFactory projectionOperationFactory, SortOperationFactory sortOperationFactory, CalculatedTableFactory calculatedTableFactory, SetOperationFactory setOperationFactory, AggregateOperationFactory aggregateOperationFactory, JoinOperationFactory joinOperationFactory) {
        this.functionCatalog = functionLookup;
        this.tableReferenceLookup = tableReferenceLookup;
        this.projectionOperationFactory = projectionOperationFactory;
        this.sortOperationFactory = sortOperationFactory;
        this.calculatedTableFactory = calculatedTableFactory;
        this.setOperationFactory = setOperationFactory;
        this.aggregateOperationFactory = aggregateOperationFactory;
        this.joinOperationFactory = joinOperationFactory;
        this.lookupResolver = new LookupCallResolver(functionLookup);
    }

    public static OperationTreeBuilder create(FunctionLookup functionCatalog, TableReferenceLookup tableReferenceLookup, boolean isStreamingMode) {
        return new OperationTreeBuilder(functionCatalog, tableReferenceLookup, new ProjectionOperationFactory(), new SortOperationFactory(isStreamingMode), new CalculatedTableFactory(), new SetOperationFactory(isStreamingMode), new AggregateOperationFactory(isStreamingMode), new JoinOperationFactory());
    }

    public QueryOperation project(List<Expression> projectList, QueryOperation child) {
        return this.project(projectList, child, false);
    }

    public QueryOperation project(List<Expression> projectList, QueryOperation child, boolean explicitAlias) {
        projectList.forEach(p -> p.accept(new NoAggregateChecker("Aggregate functions are not supported in the select right after the aggregate or flatAggregate operation.")));
        projectList.forEach(p -> p.accept(new NoWindowPropertyChecker("Window properties can only be used on windowed tables.")));
        return this.projectInternal(projectList, child, explicitAlias, Collections.emptyList());
    }

    public QueryOperation project(List<Expression> projectList, QueryOperation child, List<OverWindow> overWindows) {
        Preconditions.checkArgument((!overWindows.isEmpty() ? 1 : 0) != 0);
        projectList.forEach(p -> p.accept(new NoWindowPropertyChecker("Window start and end properties are not available for Over windows.")));
        return this.projectInternal(projectList, child, true, overWindows);
    }

    private QueryOperation projectInternal(List<Expression> projectList, QueryOperation child, boolean explicitAlias, List<OverWindow> overWindows) {
        ExpressionResolver resolver = ExpressionResolver.resolverFor(this.tableReferenceLookup, this.functionCatalog, child).withOverWindows(overWindows).build();
        List<ResolvedExpression> projections = resolver.resolve(projectList);
        return this.projectionOperationFactory.create(projections, child, explicitAlias, resolver.postResolverFactory());
    }

    public QueryOperation addColumns(boolean replaceIfExist, List<Expression> fieldLists, QueryOperation child) {
        List<Expression> newColumns;
        if (replaceIfExist) {
            String[] fieldNames = child.getTableSchema().getFieldNames();
            newColumns = ColumnOperationUtils.addOrReplaceColumns(Arrays.asList(fieldNames), fieldLists);
        } else {
            newColumns = new ArrayList<Expression>(fieldLists);
            newColumns.add(0, new UnresolvedReferenceExpression("*"));
        }
        return this.project(newColumns, child, false);
    }

    public QueryOperation renameColumns(List<Expression> aliases, QueryOperation child) {
        ExpressionResolver resolver = this.getResolver(child);
        String[] inputFieldNames = child.getTableSchema().getFieldNames();
        List<Expression> validateAliases = ColumnOperationUtils.renameColumns(Arrays.asList(inputFieldNames), resolver.resolveExpanding(aliases));
        return this.project(validateAliases, child, false);
    }

    public QueryOperation dropColumns(List<Expression> fieldLists, QueryOperation child) {
        ExpressionResolver resolver = this.getResolver(child);
        String[] inputFieldNames = child.getTableSchema().getFieldNames();
        List<Expression> finalFields = ColumnOperationUtils.dropFields(Arrays.asList(inputFieldNames), resolver.resolveExpanding(fieldLists));
        return this.project(finalFields, child, false);
    }

    public QueryOperation aggregate(List<Expression> groupingExpressions, List<Expression> aggregates2, QueryOperation child) {
        ExpressionResolver resolver = this.getResolver(child);
        List<ResolvedExpression> resolvedGroupings = resolver.resolve(groupingExpressions);
        List<ResolvedExpression> resolvedAggregates = resolver.resolve(aggregates2);
        return this.aggregateOperationFactory.createAggregate(resolvedGroupings, resolvedAggregates, child);
    }

    public QueryOperation windowAggregate(List<Expression> groupingExpressions, GroupWindow window, List<Expression> windowProperties, List<Expression> aggregates2, QueryOperation child) {
        ExpressionResolver resolver = this.getResolver(child);
        WindowAggregateQueryOperation.ResolvedGroupWindow resolvedWindow = this.aggregateOperationFactory.createResolvedWindow(window, resolver);
        ExpressionResolver resolverWithWindowReferences = ExpressionResolver.resolverFor(this.tableReferenceLookup, this.functionCatalog, child).withLocalReferences(new LocalReferenceExpression(resolvedWindow.getAlias(), resolvedWindow.getTimeAttribute().getOutputDataType())).build();
        List<ResolvedExpression> convertedGroupings = resolverWithWindowReferences.resolve(groupingExpressions);
        List<ResolvedExpression> convertedAggregates = resolverWithWindowReferences.resolve(aggregates2);
        List<ResolvedExpression> convertedProperties = resolverWithWindowReferences.resolve(windowProperties);
        return this.aggregateOperationFactory.createWindowAggregate(convertedGroupings, convertedAggregates, convertedProperties, resolvedWindow, child);
    }

    public QueryOperation windowAggregate(List<Expression> groupingExpressions, GroupWindow window, List<Expression> windowProperties, Expression aggregateFunction, QueryOperation child) {
        ExpressionResolver resolver = this.getResolver(child);
        Expression resolvedAggregate = aggregateFunction.accept(this.lookupResolver);
        AggregateWithAlias aggregateWithAlias = resolvedAggregate.accept(new ExtractAliasAndAggregate(true, resolver));
        ArrayList<Expression> groupsAndAggregate = new ArrayList<Expression>(groupingExpressions);
        groupsAndAggregate.add(aggregateWithAlias.aggregate);
        List<Expression> namedGroupsAndAggregate = this.addAliasToTheCallInAggregate(Arrays.asList(child.getTableSchema().getFieldNames()), groupsAndAggregate);
        List<Expression> newGroupingExpressions = namedGroupsAndAggregate.subList(0, groupingExpressions.size());
        Expression aggregateRenamed = namedGroupsAndAggregate.get(groupingExpressions.size());
        WindowAggregateQueryOperation.ResolvedGroupWindow resolvedWindow = this.aggregateOperationFactory.createResolvedWindow(window, resolver);
        ExpressionResolver resolverWithWindowReferences = ExpressionResolver.resolverFor(this.tableReferenceLookup, this.functionCatalog, child).withLocalReferences(new LocalReferenceExpression(resolvedWindow.getAlias(), resolvedWindow.getTimeAttribute().getOutputDataType())).build();
        List<ResolvedExpression> convertedGroupings = resolverWithWindowReferences.resolve(newGroupingExpressions);
        List<ResolvedExpression> convertedAggregates = resolverWithWindowReferences.resolve(Collections.singletonList(aggregateRenamed));
        List<ResolvedExpression> convertedProperties = resolverWithWindowReferences.resolve(windowProperties);
        QueryOperation aggregateOperation = this.aggregateOperationFactory.createWindowAggregate(convertedGroupings, Collections.singletonList(convertedAggregates.get(0)), convertedProperties, resolvedWindow, child);
        String[] aggNames = aggregateOperation.getTableSchema().getFieldNames();
        List flattenedExpressions = Arrays.stream(aggNames).map(ApiExpressionUtils::unresolvedRef).collect(Collectors.toCollection(ArrayList::new));
        flattenedExpressions.set(groupingExpressions.size(), ApiExpressionUtils.unresolvedCall(BuiltInFunctionDefinitions.FLATTEN, ApiExpressionUtils.unresolvedRef(aggNames[groupingExpressions.size()])));
        QueryOperation flattenedProjection = this.project(flattenedExpressions, aggregateOperation);
        return this.aliasBackwardFields(flattenedProjection, aggregateWithAlias.aliases, groupingExpressions.size());
    }

    public QueryOperation join(QueryOperation left, QueryOperation right, JoinQueryOperation.JoinType joinType, Optional<Expression> condition, boolean correlated) {
        ExpressionResolver resolver = ExpressionResolver.resolverFor(this.tableReferenceLookup, this.functionCatalog, left, right).build();
        Optional<ResolvedExpression> resolvedCondition = condition.map(expr -> this.resolveSingleExpression((Expression)expr, resolver));
        return this.joinOperationFactory.create(left, right, joinType, resolvedCondition.orElse(ApiExpressionUtils.valueLiteral(true)), correlated);
    }

    public QueryOperation joinLateral(QueryOperation left, Expression tableFunction, JoinQueryOperation.JoinType joinType, Optional<Expression> condition) {
        ExpressionResolver resolver = this.getResolver(left);
        ResolvedExpression resolvedFunction = this.resolveSingleExpression(tableFunction, resolver);
        QueryOperation temporalTable = this.calculatedTableFactory.create(resolvedFunction, left.getTableSchema().getFieldNames());
        return this.join(left, temporalTable, joinType, condition, true);
    }

    public Expression resolveExpression(Expression expression2, QueryOperation ... tableOperation) {
        ExpressionResolver resolver = ExpressionResolver.resolverFor(this.tableReferenceLookup, this.functionCatalog, tableOperation).build();
        return this.resolveSingleExpression(expression2, resolver);
    }

    private ResolvedExpression resolveSingleExpression(Expression expression2, ExpressionResolver resolver) {
        List<ResolvedExpression> resolvedExpression = resolver.resolve(Collections.singletonList(expression2));
        if (resolvedExpression.size() != 1) {
            throw new ValidationException("Expected single expression");
        }
        return resolvedExpression.get(0);
    }

    public QueryOperation sort(List<Expression> fields2, QueryOperation child) {
        ExpressionResolver resolver = this.getResolver(child);
        List<ResolvedExpression> resolvedFields = resolver.resolve(fields2);
        return this.sortOperationFactory.createSort(resolvedFields, child, resolver.postResolverFactory());
    }

    public QueryOperation limitWithOffset(int offset, QueryOperation child) {
        return this.sortOperationFactory.createLimitWithOffset(offset, child);
    }

    public QueryOperation limitWithFetch(int fetch, QueryOperation child) {
        return this.sortOperationFactory.createLimitWithFetch(fetch, child);
    }

    public QueryOperation alias(List<Expression> fields2, QueryOperation child) {
        List<Expression> newFields = AliasOperationUtils.createAliasList(fields2, child);
        return this.project(newFields, child, true);
    }

    public QueryOperation filter(Expression condition, QueryOperation child) {
        ExpressionResolver resolver = this.getResolver(child);
        ResolvedExpression resolvedExpression = this.resolveSingleExpression(condition, resolver);
        DataType conditionType = resolvedExpression.getOutputDataType();
        if (!LogicalTypeChecks.hasRoot(conditionType.getLogicalType(), LogicalTypeRoot.BOOLEAN)) {
            throw new ValidationException("Filter operator requires a boolean expression as input, but $condition is of type " + conditionType);
        }
        return new FilterQueryOperation(resolvedExpression, child);
    }

    public QueryOperation distinct(QueryOperation child) {
        return new DistinctQueryOperation(child);
    }

    public QueryOperation minus(QueryOperation left, QueryOperation right, boolean all) {
        return this.setOperationFactory.create(SetQueryOperation.SetQueryOperationType.MINUS, left, right, all);
    }

    public QueryOperation intersect(QueryOperation left, QueryOperation right, boolean all) {
        return this.setOperationFactory.create(SetQueryOperation.SetQueryOperationType.INTERSECT, left, right, all);
    }

    public QueryOperation union(QueryOperation left, QueryOperation right, boolean all) {
        return this.setOperationFactory.create(SetQueryOperation.SetQueryOperationType.UNION, left, right, all);
    }

    public QueryOperation map(Expression mapFunction, QueryOperation child) {
        Expression resolvedMapFunction = mapFunction.accept(this.lookupResolver);
        if (!ApiExpressionUtils.isFunctionOfKind(resolvedMapFunction, FunctionKind.SCALAR)) {
            throw new ValidationException("Only a scalar function can be used in the map operator.");
        }
        UnresolvedCallExpression expandedFields = ApiExpressionUtils.unresolvedCall(BuiltInFunctionDefinitions.FLATTEN, resolvedMapFunction);
        return this.project(Collections.singletonList(expandedFields), child, false);
    }

    public QueryOperation flatMap(Expression tableFunction, QueryOperation child) {
        Expression resolvedTableFunction = tableFunction.accept(this.lookupResolver);
        if (!ApiExpressionUtils.isFunctionOfKind(resolvedTableFunction, FunctionKind.TABLE)) {
            throw new ValidationException("Only a table function can be used in the flatMap operator.");
        }
        TypeInformation<?> resultType2 = ((TableFunctionDefinition)((UnresolvedCallExpression)resolvedTableFunction).getFunctionDefinition()).getResultType();
        List<String> originFieldNames = Arrays.asList(FieldInfoUtils.getFieldNames(resultType2));
        List<String> childFields = Arrays.asList(child.getTableSchema().getFieldNames());
        HashSet<String> usedFieldNames = new HashSet<String>(childFields);
        ArrayList<Expression> args = new ArrayList<Expression>();
        for (String originFieldName : originFieldNames) {
            String resultName = this.getUniqueName(originFieldName, usedFieldNames);
            usedFieldNames.add(resultName);
            args.add(ApiExpressionUtils.valueLiteral(resultName));
        }
        args.add(0, resolvedTableFunction);
        UnresolvedCallExpression renamedTableFunction = ApiExpressionUtils.unresolvedCall(BuiltInFunctionDefinitions.AS, args.toArray(new Expression[0]));
        QueryOperation joinNode = this.joinLateral(child, renamedTableFunction, JoinQueryOperation.JoinType.INNER, Optional.empty());
        QueryOperation rightNode = this.dropColumns(childFields.stream().map(UnresolvedReferenceExpression::new).collect(Collectors.toList()), joinNode);
        return this.alias(originFieldNames.stream().map(UnresolvedReferenceExpression::new).collect(Collectors.toList()), rightNode);
    }

    public QueryOperation aggregate(List<Expression> groupingExpressions, Expression aggregate, QueryOperation child) {
        Expression resolvedAggregate = aggregate.accept(this.lookupResolver);
        AggregateWithAlias aggregateWithAlias = resolvedAggregate.accept(new ExtractAliasAndAggregate(true, this.getResolver(child)));
        ArrayList<Expression> groupsAndAggregate = new ArrayList<Expression>(groupingExpressions);
        groupsAndAggregate.add(aggregateWithAlias.aggregate);
        List<Expression> namedGroupsAndAggregate = this.addAliasToTheCallInAggregate(Arrays.asList(child.getTableSchema().getFieldNames()), groupsAndAggregate);
        List<Expression> newGroupingExpressions = namedGroupsAndAggregate.subList(0, groupingExpressions.size());
        Expression aggregateRenamed = namedGroupsAndAggregate.get(groupingExpressions.size());
        QueryOperation aggregateOperation = this.aggregate(newGroupingExpressions, Collections.singletonList(aggregateRenamed), child);
        String[] aggNames = aggregateOperation.getTableSchema().getFieldNames();
        List flattenedExpressions = Arrays.asList(aggNames).subList(0, groupingExpressions.size()).stream().map(ApiExpressionUtils::unresolvedRef).collect(Collectors.toCollection(ArrayList::new));
        flattenedExpressions.add(ApiExpressionUtils.unresolvedCall(BuiltInFunctionDefinitions.FLATTEN, ApiExpressionUtils.unresolvedRef(aggNames[aggNames.length - 1])));
        QueryOperation flattenedProjection = this.project(flattenedExpressions, aggregateOperation);
        return this.aliasBackwardFields(flattenedProjection, aggregateWithAlias.aliases, groupingExpressions.size());
    }

    public QueryOperation tableAggregate(List<Expression> groupingExpressions, Expression tableAggFunction, QueryOperation child) {
        List<Expression> newGroupingExpressions = this.addAliasToTheCallInAggregate(Arrays.asList(child.getTableSchema().getFieldNames()), groupingExpressions);
        ExpressionResolver resolver = this.getResolver(child);
        List<ResolvedExpression> resolvedGroupings = resolver.resolve(newGroupingExpressions);
        Tuple2<ResolvedExpression, List<String>> resolvedFunctionAndAlias = this.aggregateOperationFactory.extractTableAggFunctionAndAliases(this.resolveSingleExpression(tableAggFunction, resolver));
        QueryOperation tableAggOperation = this.aggregateOperationFactory.createAggregate(resolvedGroupings, Collections.singletonList(resolvedFunctionAndAlias.f0), child);
        return this.aliasBackwardFields(tableAggOperation, (List)resolvedFunctionAndAlias.f1, groupingExpressions.size());
    }

    public QueryOperation windowTableAggregate(List<Expression> groupingExpressions, GroupWindow window, List<Expression> windowProperties, Expression tableAggFunction, QueryOperation child) {
        List<Expression> newGroupingExpressions = this.addAliasToTheCallInAggregate(Arrays.asList(child.getTableSchema().getFieldNames()), groupingExpressions);
        ExpressionResolver resolver = this.getResolver(child);
        WindowAggregateQueryOperation.ResolvedGroupWindow resolvedWindow = this.aggregateOperationFactory.createResolvedWindow(window, resolver);
        ExpressionResolver resolverWithWindowReferences = ExpressionResolver.resolverFor(this.tableReferenceLookup, this.functionCatalog, child).withLocalReferences(new LocalReferenceExpression(resolvedWindow.getAlias(), resolvedWindow.getTimeAttribute().getOutputDataType())).build();
        List<ResolvedExpression> convertedGroupings = resolverWithWindowReferences.resolve(newGroupingExpressions);
        List<ResolvedExpression> convertedAggregates = resolverWithWindowReferences.resolve(Collections.singletonList(tableAggFunction));
        List<ResolvedExpression> convertedProperties = resolverWithWindowReferences.resolve(windowProperties);
        Tuple2<ResolvedExpression, List<String>> resolvedFunctionAndAlias = this.aggregateOperationFactory.extractTableAggFunctionAndAliases(convertedAggregates.get(0));
        QueryOperation tableAggOperation = this.aggregateOperationFactory.createWindowAggregate(convertedGroupings, Collections.singletonList(resolvedFunctionAndAlias.f0), convertedProperties, resolvedWindow, child);
        return this.aliasBackwardFields(tableAggOperation, (List)resolvedFunctionAndAlias.f1, groupingExpressions.size());
    }

    private QueryOperation aliasBackwardFields(QueryOperation inputOperation, List<String> alias2, int aliasStartIndex) {
        if (!alias2.isEmpty()) {
            String[] namesBeforeAlias = inputOperation.getTableSchema().getFieldNames();
            ArrayList<String> namesAfterAlias = new ArrayList<String>(Arrays.asList(namesBeforeAlias));
            for (int i = 0; i < alias2.size(); ++i) {
                int withOffset = aliasStartIndex + i;
                namesAfterAlias.remove(withOffset);
                namesAfterAlias.add(withOffset, alias2.get(i));
            }
            return this.alias(namesAfterAlias.stream().map(UnresolvedReferenceExpression::new).collect(Collectors.toList()), inputOperation);
        }
        return inputOperation;
    }

    private List<Expression> addAliasToTheCallInAggregate(List<String> inputFieldNames, List<Expression> expressions) {
        int attrNameCntr = 0;
        HashSet<String> usedFieldNames = new HashSet<String>(inputFieldNames);
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (Expression groupingExpression : expressions) {
            if (groupingExpression instanceof UnresolvedCallExpression && !ApiExpressionUtils.isFunction(groupingExpression, BuiltInFunctionDefinitions.AS)) {
                String tempName = this.getUniqueName("TMP_" + attrNameCntr, usedFieldNames);
                ++attrNameCntr;
                usedFieldNames.add(tempName);
                result.add(ApiExpressionUtils.unresolvedCall(BuiltInFunctionDefinitions.AS, groupingExpression, ApiExpressionUtils.valueLiteral(tempName)));
                continue;
            }
            result.add(groupingExpression);
        }
        return result;
    }

    private String getUniqueName(String inputName, Collection<String> usedFieldNames) {
        int i = 0;
        String resultName = inputName;
        while (usedFieldNames.contains(resultName)) {
            resultName = resultName + "_" + i;
            ++i;
        }
        return resultName;
    }

    private ExpressionResolver getResolver(QueryOperation child) {
        return ExpressionResolver.resolverFor(this.tableReferenceLookup, this.functionCatalog, child).build();
    }

    private static class NoAggregateChecker
    extends ApiExpressionDefaultVisitor<Void> {
        private final String exceptionMessage;

        private NoAggregateChecker(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
        }

        @Override
        public Void visit(UnresolvedCallExpression call) {
            if (ApiExpressionUtils.isFunctionOfKind(call, FunctionKind.AGGREGATE)) {
                throw new ValidationException(this.exceptionMessage);
            }
            call.getChildren().forEach(expr -> expr.accept(this));
            return null;
        }

        @Override
        protected Void defaultMethod(Expression expression2) {
            return null;
        }
    }

    private static class NoWindowPropertyChecker
    extends ApiExpressionDefaultVisitor<Void> {
        private final String exceptionMessage;

        private NoWindowPropertyChecker(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
        }

        @Override
        public Void visit(UnresolvedCallExpression call) {
            FunctionDefinition functionDefinition = call.getFunctionDefinition();
            if (BuiltInFunctionDefinitions.WINDOW_PROPERTIES.contains(functionDefinition)) {
                throw new ValidationException(this.exceptionMessage);
            }
            call.getChildren().forEach(expr -> expr.accept(this));
            return null;
        }

        @Override
        protected Void defaultMethod(Expression expression2) {
            return null;
        }
    }

    private static class ExtractAliasAndAggregate
    extends ApiExpressionDefaultVisitor<AggregateWithAlias> {
        private boolean isRowbasedAggregate = false;
        private ExpressionResolver resolver = null;

        public ExtractAliasAndAggregate(boolean isRowbasedAggregate, ExpressionResolver resolver) {
            this.isRowbasedAggregate = isRowbasedAggregate;
            this.resolver = resolver;
        }

        @Override
        public AggregateWithAlias visit(UnresolvedCallExpression unresolvedCall) {
            if (ApiExpressionUtils.isFunction(unresolvedCall, BuiltInFunctionDefinitions.AS)) {
                Expression expression2 = unresolvedCall.getChildren().get(0);
                if (expression2 instanceof UnresolvedCallExpression) {
                    List<String> aliases = this.extractAliases(unresolvedCall);
                    return this.getAggregate((UnresolvedCallExpression)expression2, aliases).orElseGet(() -> this.defaultMethod(unresolvedCall));
                }
                return this.defaultMethod(unresolvedCall);
            }
            return this.getAggregate(unresolvedCall, Collections.emptyList()).orElseGet(() -> this.defaultMethod(unresolvedCall));
        }

        private List<String> extractAliases(UnresolvedCallExpression unresolvedCall) {
            return unresolvedCall.getChildren().subList(1, unresolvedCall.getChildren().size()).stream().map(ex -> ExpressionUtils.extractValue(ex, String.class).orElseThrow(() -> new TableException("Expected string literal as alias."))).collect(Collectors.toList());
        }

        private Optional<AggregateWithAlias> getAggregate(UnresolvedCallExpression unresolvedCall, List<String> aliases) {
            FunctionDefinition functionDefinition = unresolvedCall.getFunctionDefinition();
            if (ApiExpressionUtils.isFunctionOfKind(unresolvedCall, FunctionKind.AGGREGATE)) {
                List<Object> fieldNames;
                if (aliases.isEmpty()) {
                    if (functionDefinition instanceof AggregateFunctionDefinition) {
                        TypeInformation<?> resultTypeInfo = ((AggregateFunctionDefinition)functionDefinition).getResultTypeInfo();
                        fieldNames = Arrays.asList(FieldInfoUtils.getFieldNames(resultTypeInfo));
                    } else {
                        fieldNames = Collections.emptyList();
                    }
                } else {
                    ResolvedExpression resolvedExpression = this.resolver.resolve(Collections.singletonList(unresolvedCall)).get(0);
                    this.validateAlias(aliases, resolvedExpression, this.isRowbasedAggregate);
                    fieldNames = aliases;
                }
                return Optional.of(new AggregateWithAlias(unresolvedCall, fieldNames));
            }
            return Optional.empty();
        }

        @Override
        protected AggregateWithAlias defaultMethod(Expression expression2) {
            throw new ValidationException("Aggregate function expected. Got: " + expression2);
        }

        private void validateAlias(List<String> aliases, ResolvedExpression resolvedExpression, Boolean isRowbasedAggregate) {
            int length = TypeConversions.fromDataTypeToLegacyInfo(resolvedExpression.getOutputDataType()).getArity();
            int callArity = isRowbasedAggregate != false ? length : 1;
            int aliasesSize = aliases.size();
            if (0 < aliasesSize && aliasesSize != callArity) {
                throw new ValidationException(String.format("List of column aliases must have same degree as table; the returned table of function '%s' has %d columns, whereas alias list has %d columns", resolvedExpression, callArity, aliasesSize));
            }
        }
    }

    private static class AggregateWithAlias {
        private final UnresolvedCallExpression aggregate;
        private final List<String> aliases;

        private AggregateWithAlias(UnresolvedCallExpression aggregate, List<String> aliases) {
            this.aggregate = aggregate;
            this.aliases = aliases;
        }
    }
}

