/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat.vector.heap;

import java.util.Arrays;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.vector.AbstractColumnVector;
import org.apache.flink.table.dataformat.vector.heap.HeapBooleanVector;
import org.apache.flink.table.dataformat.vector.heap.HeapByteVector;
import org.apache.flink.table.dataformat.vector.heap.HeapBytesVector;
import org.apache.flink.table.dataformat.vector.heap.HeapDoubleVector;
import org.apache.flink.table.dataformat.vector.heap.HeapFloatVector;
import org.apache.flink.table.dataformat.vector.heap.HeapIntVector;
import org.apache.flink.table.dataformat.vector.heap.HeapLongVector;
import org.apache.flink.table.dataformat.vector.heap.HeapShortVector;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;

public abstract class AbstractHeapVector
extends AbstractColumnVector {
    protected boolean[] isNull;
    protected HeapIntVector dictionaryIds;

    public AbstractHeapVector(int len) {
        this.isNull = new boolean[len];
    }

    @Override
    public void reset() {
        if (!this.noNulls) {
            Arrays.fill(this.isNull, false);
        }
        this.noNulls = true;
    }

    public void setNullAt(int i) {
        this.isNull[i] = true;
        this.noNulls = false;
    }

    @Override
    public boolean isNullAt(int i) {
        return !this.noNulls && this.isNull[i];
    }

    @Override
    public HeapIntVector reserveDictionaryIds(int capacity) {
        if (this.dictionaryIds == null) {
            this.dictionaryIds = new HeapIntVector(capacity);
        } else {
            this.dictionaryIds.reset();
        }
        return this.dictionaryIds;
    }

    public HeapIntVector getDictionaryIds() {
        return this.dictionaryIds;
    }

    public static AbstractHeapVector[] allocateHeapVectors(LogicalType[] fieldTypes, int maxRows) {
        AbstractHeapVector[] columns = new AbstractHeapVector[fieldTypes.length];
        for (int i = 0; i < fieldTypes.length; ++i) {
            columns[i] = AbstractHeapVector.createHeapColumn(fieldTypes[i], maxRows);
        }
        return columns;
    }

    public static AbstractHeapVector createHeapColumn(LogicalType fieldType, int maxRows) {
        switch (fieldType.getTypeRoot()) {
            case BOOLEAN: {
                return new HeapBooleanVector(maxRows);
            }
            case TINYINT: {
                return new HeapByteVector(maxRows);
            }
            case DOUBLE: {
                return new HeapDoubleVector(maxRows);
            }
            case FLOAT: {
                return new HeapFloatVector(maxRows);
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                return new HeapIntVector(maxRows);
            }
            case BIGINT: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return new HeapLongVector(maxRows);
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)fieldType;
                if (Decimal.is32BitDecimal(decimalType.getPrecision())) {
                    return new HeapIntVector(maxRows);
                }
                if (Decimal.is64BitDecimal(decimalType.getPrecision())) {
                    return new HeapLongVector(maxRows);
                }
                return new HeapBytesVector(maxRows);
            }
            case SMALLINT: {
                return new HeapShortVector(maxRows);
            }
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return new HeapBytesVector(maxRows);
            }
        }
        throw new UnsupportedOperationException(fieldType + " is not supported now.");
    }
}

