/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.runtime.util.SegmentsUtil;

public abstract class BinaryFormat {
    static final int MAX_FIX_PART_DATA_SIZE = 7;
    private static final long HIGHEST_FIRST_BIT = Long.MIN_VALUE;
    private static final long HIGHEST_SECOND_TO_EIGHTH_BIT = 0x7F00000000000000L;
    protected MemorySegment[] segments;
    protected int offset;
    protected int sizeInBytes;

    public BinaryFormat() {
    }

    public BinaryFormat(MemorySegment[] segments, int offset, int sizeInBytes) {
        this.segments = segments;
        this.offset = offset;
        this.sizeInBytes = sizeInBytes;
    }

    public final void pointTo(MemorySegment segment, int offset, int sizeInBytes) {
        this.pointTo(new MemorySegment[]{segment}, offset, sizeInBytes);
    }

    public void pointTo(MemorySegment[] segments, int offset, int sizeInBytes) {
        this.segments = segments;
        this.offset = offset;
        this.sizeInBytes = sizeInBytes;
    }

    public MemorySegment[] getSegments() {
        return this.segments;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.binaryEquals((BinaryFormat)o);
    }

    protected boolean binaryEquals(BinaryFormat that) {
        return this.sizeInBytes == that.sizeInBytes && SegmentsUtil.equals(this.segments, this.offset, that.segments, that.offset, this.sizeInBytes);
    }

    public int hashCode() {
        return SegmentsUtil.hash(this.segments, this.offset, this.sizeInBytes);
    }

    static byte[] readBinaryFieldFromSegments(MemorySegment[] segments, int baseOffset, int fieldOffset, long variablePartOffsetAndLen) {
        long mark = variablePartOffsetAndLen & Long.MIN_VALUE;
        if (mark == 0L) {
            int subOffset = (int)(variablePartOffsetAndLen >> 32);
            int len = (int)variablePartOffsetAndLen;
            return SegmentsUtil.copyToBytes(segments, baseOffset + subOffset, len);
        }
        int len = (int)((variablePartOffsetAndLen & 0x7F00000000000000L) >>> 56);
        if (SegmentsUtil.LITTLE_ENDIAN) {
            return SegmentsUtil.copyToBytes(segments, fieldOffset, len);
        }
        return SegmentsUtil.copyToBytes(segments, fieldOffset + 1, len);
    }

    static BinaryString readBinaryStringFieldFromSegments(MemorySegment[] segments, int baseOffset, int fieldOffset, long variablePartOffsetAndLen) {
        long mark = variablePartOffsetAndLen & Long.MIN_VALUE;
        if (mark == 0L) {
            int subOffset = (int)(variablePartOffsetAndLen >> 32);
            int len = (int)variablePartOffsetAndLen;
            return BinaryString.fromAddress(segments, baseOffset + subOffset, len);
        }
        int len = (int)((variablePartOffsetAndLen & 0x7F00000000000000L) >>> 56);
        if (SegmentsUtil.LITTLE_ENDIAN) {
            return BinaryString.fromAddress(segments, fieldOffset, len);
        }
        return BinaryString.fromAddress(segments, fieldOffset + 1, len);
    }
}

