/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.materialize.LatticeChildNode;
import org.apache.calcite.materialize.LatticeSpace;
import org.apache.calcite.materialize.LatticeTable;
import org.apache.calcite.materialize.MutableNode;
import org.apache.calcite.materialize.Path;
import org.apache.calcite.materialize.Step;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public abstract class LatticeNode {
    public final LatticeTable table;
    final int startCol;
    final int endCol;
    public final String alias;
    private final ImmutableList<LatticeChildNode> children;
    public final String digest;

    LatticeNode(LatticeSpace space, LatticeNode parent, MutableNode mutableNode) {
        this.table = Objects.requireNonNull(mutableNode.table);
        this.startCol = mutableNode.startCol;
        this.endCol = mutableNode.endCol;
        this.alias = mutableNode.alias;
        Preconditions.checkArgument(this.startCol >= 0);
        Preconditions.checkArgument(this.endCol > this.startCol);
        StringBuilder sb = new StringBuilder().append(space.simpleName(this.table));
        if (parent != null) {
            sb.append(':');
            int i = 0;
            for (IntPair p : mutableNode.step.keys) {
                if (i++ > 0) {
                    sb.append(",");
                }
                sb.append(parent.table.field(p.source).getName());
            }
        }
        if (mutableNode.children.isEmpty()) {
            this.children = ImmutableList.of();
        } else {
            sb.append(" (");
            ImmutableList.Builder b = ImmutableList.builder();
            int i = 0;
            for (MutableNode mutableChild : mutableNode.children) {
                if (i++ > 0) {
                    sb.append(' ');
                }
                LatticeChildNode node = new LatticeChildNode(space, this, mutableChild);
                sb.append(node.digest);
                b.add(node);
            }
            this.children = b.build();
            sb.append(")");
        }
        this.digest = sb.toString();
    }

    public String toString() {
        return this.digest;
    }

    public RelOptTable relOptTable() {
        return this.table.t;
    }

    abstract void use(List<LatticeNode> var1);

    void flattenTo(ImmutableList.Builder<LatticeNode> builder) {
        builder.add((Object)this);
        for (LatticeChildNode child : this.children) {
            child.flattenTo(builder);
        }
    }

    void createPathsRecurse(LatticeSpace space, List<Step> steps, List<Path> paths) {
        paths.add(space.addPath(steps));
        for (LatticeChildNode child : this.children) {
            steps.add(space.addEdge(this.table, child.table, child.link));
            child.createPathsRecurse(space, steps, paths);
            steps.remove(steps.size() - 1);
        }
    }
}

