#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['build_harness',
 'build_harness.commands',
 'build_harness.commands.bdd',
 'build_harness.tools']

package_data = \
{'': ['*']}

install_requires = \
['behave == 1.2.6',
 'black == 20.8b1',
 'click == 7.1.2',
 'flake8 == 3.8.4',
 'flake8-annotations == 2.4.1',
 'isort == 5.5.4',
 'mypy == 0.782',
 'packaging == 20.4',
 'parver == 0.3.1',
 'pip == 20.2.4',
 'pydocstyle == 5.1.1',
 'pygments == 2.7.1',
 'toml == 0.10.1']

extras_require = \
{'dev': ['flit == 3.0.0', 'mutmut == 2.1.0', 'pre_commit == 2.7.1'],
 'doc': ['sphinx == 3.2.1', 'sphinx_rtd_theme == 0.5.0'],
 'test': ['pytest == 6.1.1', 'pytest-cov == 2.10.1', 'pytest-mock == 2.0.0']}

entry_points = \
{'console_scripts': ['build-harness = '
                     'build_harness.entrypoint:build_harness_entry',
                     'install-release = '
                     'build_harness.entrypoint:install_release_entry',
                     'release-flow = '
                     'build_harness.entrypoint:release_flow_entry']}

setup(name='build_harness',
      version='0.0.0',
      description='CI build harness embodying best practices for Python projects.',
      author='Russell Smiley',
      author_email='im.russell.smiley@gmail.com',
      url='https://gitlab.com/ci-cd-devops/build_harness',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.7',
     )
