"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.  # noqa: E501

    The version of the OpenAPI document: 2023-02-22
    Contact: developers@klaviyo.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from openapi_client.api_client import ApiClient, Endpoint as _Endpoint
from openapi_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from openapi_client.model.event_create_query import EventCreateQuery
from openapi_client.model.get_create_variants_jobs5_xx_response import GetCreateVariantsJobs5XXResponse


class EventsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_event_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/events/',
                'operation_id': 'create_event',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_create_query',
                ],
                'required': [
                    'event_create_query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_create_query':
                        (EventCreateQuery,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'event_create_query': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_event_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/events/{id}/',
                'operation_id': 'get_event',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'fields_event',
                    'fields_metric',
                    'fields_profile',
                    'include',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_event',
                    'fields_metric',
                    'fields_profile',
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_event',): {

                        "METRIC_ID": "metric_id",
                        "PROFILE_ID": "profile_id",
                        "TIMESTAMP": "timestamp",
                        "EVENT_PROPERTIES": "event_properties",
                        "DATETIME": "datetime",
                        "UUID": "uuid"
                    },
                    ('fields_metric',): {

                        "NAME": "name",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "INTEGRATION": "integration"
                    },
                    ('fields_profile',): {

                        "EMAIL": "email",
                        "PHONE_NUMBER": "phone_number",
                        "EXTERNAL_ID": "external_id",
                        "FIRST_NAME": "first_name",
                        "LAST_NAME": "last_name",
                        "ORGANIZATION": "organization",
                        "TITLE": "title",
                        "IMAGE": "image",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "LAST_EVENT_DATE": "last_event_date",
                        "LOCATION": "location",
                        "LOCATION.ADDRESS1": "location.address1",
                        "LOCATION.ADDRESS2": "location.address2",
                        "LOCATION.CITY": "location.city",
                        "LOCATION.COUNTRY": "location.country",
                        "LOCATION.LATITUDE": "location.latitude",
                        "LOCATION.LONGITUDE": "location.longitude",
                        "LOCATION.REGION": "location.region",
                        "LOCATION.ZIP": "location.zip",
                        "LOCATION.TIMEZONE": "location.timezone",
                        "PROPERTIES": "properties",
                        "SUBSCRIPTIONS": "subscriptions",
                        "SUBSCRIPTIONS.EMAIL": "subscriptions.email",
                        "SUBSCRIPTIONS.EMAIL.MARKETING": "subscriptions.email.marketing",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.CONSENT": "subscriptions.email.marketing.consent",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.TIMESTAMP": "subscriptions.email.marketing.timestamp",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.METHOD": "subscriptions.email.marketing.method",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.METHOD_DETAIL": "subscriptions.email.marketing.method_detail",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.CUSTOM_METHOD_DETAIL": "subscriptions.email.marketing.custom_method_detail",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.DOUBLE_OPTIN": "subscriptions.email.marketing.double_optin",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.SUPPRESSIONS": "subscriptions.email.marketing.suppressions",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.SUPPRESSIONS.REASON": "subscriptions.email.marketing.suppressions.reason",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.SUPPRESSIONS.TIMESTAMP": "subscriptions.email.marketing.suppressions.timestamp",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.LIST_SUPPRESSIONS": "subscriptions.email.marketing.list_suppressions",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.LIST_SUPPRESSIONS.LIST_ID": "subscriptions.email.marketing.list_suppressions.list_id",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.LIST_SUPPRESSIONS.REASON": "subscriptions.email.marketing.list_suppressions.reason",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.LIST_SUPPRESSIONS.TIMESTAMP": "subscriptions.email.marketing.list_suppressions.timestamp",
                        "SUBSCRIPTIONS.SMS": "subscriptions.sms",
                        "SUBSCRIPTIONS.SMS.MARKETING": "subscriptions.sms.marketing",
                        "SUBSCRIPTIONS.SMS.MARKETING.CONSENT": "subscriptions.sms.marketing.consent",
                        "SUBSCRIPTIONS.SMS.MARKETING.TIMESTAMP": "subscriptions.sms.marketing.timestamp",
                        "SUBSCRIPTIONS.SMS.MARKETING.METHOD": "subscriptions.sms.marketing.method",
                        "SUBSCRIPTIONS.SMS.MARKETING.METHOD_DETAIL": "subscriptions.sms.marketing.method_detail"
                    },
                    ('include',): {

                        "METRICS": "metrics",
                        "PROFILES": "profiles"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'fields_event':
                        ([str],),
                    'fields_metric':
                        ([str],),
                    'fields_profile':
                        ([str],),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'fields_event': 'fields[event]',
                    'fields_metric': 'fields[metric]',
                    'fields_profile': 'fields[profile]',
                    'include': 'include',
                },
                'location_map': {
                    'id': 'path',
                    'fields_event': 'query',
                    'fields_metric': 'query',
                    'fields_profile': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'fields_event': 'csv',
                    'fields_metric': 'csv',
                    'fields_profile': 'csv',
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_event_metrics_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/events/{id}/metrics/',
                'operation_id': 'get_event_metrics',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'fields_metric',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_metric',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_metric',): {

                        "NAME": "name",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "INTEGRATION": "integration"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'fields_metric':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'fields_metric': 'fields[metric]',
                },
                'location_map': {
                    'id': 'path',
                    'fields_metric': 'query',
                },
                'collection_format_map': {
                    'fields_metric': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_event_profiles_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/events/{id}/profiles/',
                'operation_id': 'get_event_profiles',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'additional_fields_profile',
                    'fields_profile',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'additional_fields_profile',
                    'fields_profile',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('additional_fields_profile',): {

                        "PREDICTIVE_ANALYTICS": "predictive_analytics"
                    },
                    ('fields_profile',): {

                        "EMAIL": "email",
                        "PHONE_NUMBER": "phone_number",
                        "EXTERNAL_ID": "external_id",
                        "FIRST_NAME": "first_name",
                        "LAST_NAME": "last_name",
                        "ORGANIZATION": "organization",
                        "TITLE": "title",
                        "IMAGE": "image",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "LAST_EVENT_DATE": "last_event_date",
                        "LOCATION": "location",
                        "LOCATION.ADDRESS1": "location.address1",
                        "LOCATION.ADDRESS2": "location.address2",
                        "LOCATION.CITY": "location.city",
                        "LOCATION.COUNTRY": "location.country",
                        "LOCATION.LATITUDE": "location.latitude",
                        "LOCATION.LONGITUDE": "location.longitude",
                        "LOCATION.REGION": "location.region",
                        "LOCATION.ZIP": "location.zip",
                        "LOCATION.TIMEZONE": "location.timezone",
                        "PROPERTIES": "properties",
                        "SUBSCRIPTIONS": "subscriptions",
                        "SUBSCRIPTIONS.EMAIL": "subscriptions.email",
                        "SUBSCRIPTIONS.EMAIL.MARKETING": "subscriptions.email.marketing",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.CONSENT": "subscriptions.email.marketing.consent",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.TIMESTAMP": "subscriptions.email.marketing.timestamp",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.METHOD": "subscriptions.email.marketing.method",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.METHOD_DETAIL": "subscriptions.email.marketing.method_detail",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.CUSTOM_METHOD_DETAIL": "subscriptions.email.marketing.custom_method_detail",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.DOUBLE_OPTIN": "subscriptions.email.marketing.double_optin",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.SUPPRESSIONS": "subscriptions.email.marketing.suppressions",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.SUPPRESSIONS.REASON": "subscriptions.email.marketing.suppressions.reason",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.SUPPRESSIONS.TIMESTAMP": "subscriptions.email.marketing.suppressions.timestamp",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.LIST_SUPPRESSIONS": "subscriptions.email.marketing.list_suppressions",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.LIST_SUPPRESSIONS.LIST_ID": "subscriptions.email.marketing.list_suppressions.list_id",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.LIST_SUPPRESSIONS.REASON": "subscriptions.email.marketing.list_suppressions.reason",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.LIST_SUPPRESSIONS.TIMESTAMP": "subscriptions.email.marketing.list_suppressions.timestamp",
                        "SUBSCRIPTIONS.SMS": "subscriptions.sms",
                        "SUBSCRIPTIONS.SMS.MARKETING": "subscriptions.sms.marketing",
                        "SUBSCRIPTIONS.SMS.MARKETING.CONSENT": "subscriptions.sms.marketing.consent",
                        "SUBSCRIPTIONS.SMS.MARKETING.TIMESTAMP": "subscriptions.sms.marketing.timestamp",
                        "SUBSCRIPTIONS.SMS.MARKETING.METHOD": "subscriptions.sms.marketing.method",
                        "SUBSCRIPTIONS.SMS.MARKETING.METHOD_DETAIL": "subscriptions.sms.marketing.method_detail",
                        "PREDICTIVE_ANALYTICS": "predictive_analytics",
                        "PREDICTIVE_ANALYTICS.HISTORIC_CLV": "predictive_analytics.historic_clv",
                        "PREDICTIVE_ANALYTICS.PREDICTED_CLV": "predictive_analytics.predicted_clv",
                        "PREDICTIVE_ANALYTICS.TOTAL_CLV": "predictive_analytics.total_clv",
                        "PREDICTIVE_ANALYTICS.HISTORIC_NUMBER_OF_ORDERS": "predictive_analytics.historic_number_of_orders",
                        "PREDICTIVE_ANALYTICS.PREDICTED_NUMBER_OF_ORDERS": "predictive_analytics.predicted_number_of_orders",
                        "PREDICTIVE_ANALYTICS.AVERAGE_DAYS_BETWEEN_ORDERS": "predictive_analytics.average_days_between_orders",
                        "PREDICTIVE_ANALYTICS.AVERAGE_ORDER_VALUE": "predictive_analytics.average_order_value",
                        "PREDICTIVE_ANALYTICS.CHURN_PROBABILITY": "predictive_analytics.churn_probability",
                        "PREDICTIVE_ANALYTICS.EXPECTED_DATE_OF_NEXT_ORDER": "predictive_analytics.expected_date_of_next_order"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'additional_fields_profile':
                        ([str],),
                    'fields_profile':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'additional_fields_profile': 'additional-fields[profile]',
                    'fields_profile': 'fields[profile]',
                },
                'location_map': {
                    'id': 'path',
                    'additional_fields_profile': 'query',
                    'fields_profile': 'query',
                },
                'collection_format_map': {
                    'additional_fields_profile': 'csv',
                    'fields_profile': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_event_relationships_metrics_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/events/{id}/relationships/metrics/',
                'operation_id': 'get_event_relationships_metrics',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_event_relationships_profiles_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/events/{id}/relationships/profiles/',
                'operation_id': 'get_event_relationships_profiles',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_events_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/events/',
                'operation_id': 'get_events',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'fields_event',
                    'fields_metric',
                    'fields_profile',
                    'filter',
                    'include',
                    'page_cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'fields_event',
                    'fields_metric',
                    'fields_profile',
                    'include',
                    'sort',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_event',): {

                        "METRIC_ID": "metric_id",
                        "PROFILE_ID": "profile_id",
                        "TIMESTAMP": "timestamp",
                        "EVENT_PROPERTIES": "event_properties",
                        "DATETIME": "datetime",
                        "UUID": "uuid"
                    },
                    ('fields_metric',): {

                        "NAME": "name",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "INTEGRATION": "integration"
                    },
                    ('fields_profile',): {

                        "EMAIL": "email",
                        "PHONE_NUMBER": "phone_number",
                        "EXTERNAL_ID": "external_id",
                        "FIRST_NAME": "first_name",
                        "LAST_NAME": "last_name",
                        "ORGANIZATION": "organization",
                        "TITLE": "title",
                        "IMAGE": "image",
                        "CREATED": "created",
                        "UPDATED": "updated",
                        "LAST_EVENT_DATE": "last_event_date",
                        "LOCATION": "location",
                        "LOCATION.ADDRESS1": "location.address1",
                        "LOCATION.ADDRESS2": "location.address2",
                        "LOCATION.CITY": "location.city",
                        "LOCATION.COUNTRY": "location.country",
                        "LOCATION.LATITUDE": "location.latitude",
                        "LOCATION.LONGITUDE": "location.longitude",
                        "LOCATION.REGION": "location.region",
                        "LOCATION.ZIP": "location.zip",
                        "LOCATION.TIMEZONE": "location.timezone",
                        "PROPERTIES": "properties",
                        "SUBSCRIPTIONS": "subscriptions",
                        "SUBSCRIPTIONS.EMAIL": "subscriptions.email",
                        "SUBSCRIPTIONS.EMAIL.MARKETING": "subscriptions.email.marketing",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.CONSENT": "subscriptions.email.marketing.consent",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.TIMESTAMP": "subscriptions.email.marketing.timestamp",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.METHOD": "subscriptions.email.marketing.method",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.METHOD_DETAIL": "subscriptions.email.marketing.method_detail",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.CUSTOM_METHOD_DETAIL": "subscriptions.email.marketing.custom_method_detail",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.DOUBLE_OPTIN": "subscriptions.email.marketing.double_optin",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.SUPPRESSIONS": "subscriptions.email.marketing.suppressions",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.SUPPRESSIONS.REASON": "subscriptions.email.marketing.suppressions.reason",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.SUPPRESSIONS.TIMESTAMP": "subscriptions.email.marketing.suppressions.timestamp",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.LIST_SUPPRESSIONS": "subscriptions.email.marketing.list_suppressions",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.LIST_SUPPRESSIONS.LIST_ID": "subscriptions.email.marketing.list_suppressions.list_id",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.LIST_SUPPRESSIONS.REASON": "subscriptions.email.marketing.list_suppressions.reason",
                        "SUBSCRIPTIONS.EMAIL.MARKETING.LIST_SUPPRESSIONS.TIMESTAMP": "subscriptions.email.marketing.list_suppressions.timestamp",
                        "SUBSCRIPTIONS.SMS": "subscriptions.sms",
                        "SUBSCRIPTIONS.SMS.MARKETING": "subscriptions.sms.marketing",
                        "SUBSCRIPTIONS.SMS.MARKETING.CONSENT": "subscriptions.sms.marketing.consent",
                        "SUBSCRIPTIONS.SMS.MARKETING.TIMESTAMP": "subscriptions.sms.marketing.timestamp",
                        "SUBSCRIPTIONS.SMS.MARKETING.METHOD": "subscriptions.sms.marketing.method",
                        "SUBSCRIPTIONS.SMS.MARKETING.METHOD_DETAIL": "subscriptions.sms.marketing.method_detail"
                    },
                    ('include',): {

                        "METRICS": "metrics",
                        "PROFILES": "profiles"
                    },
                    ('sort',): {

                        "DATETIME": "datetime",
                        "-DATETIME": "-datetime",
                        "TIMESTAMP": "timestamp",
                        "-TIMESTAMP": "-timestamp"
                    },
                },
                'openapi_types': {
                    'fields_event':
                        ([str],),
                    'fields_metric':
                        ([str],),
                    'fields_profile':
                        ([str],),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page_cursor':
                        (str,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'fields_event': 'fields[event]',
                    'fields_metric': 'fields[metric]',
                    'fields_profile': 'fields[profile]',
                    'filter': 'filter',
                    'include': 'include',
                    'page_cursor': 'page[cursor]',
                    'sort': 'sort',
                },
                'location_map': {
                    'fields_event': 'query',
                    'fields_metric': 'query',
                    'fields_profile': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page_cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'fields_event': 'csv',
                    'fields_metric': 'csv',
                    'fields_profile': 'csv',
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def create_event(
        self,
        event_create_query,
        **kwargs
    ):
        """Create Event  # noqa: E501

        Create an event. Events are created asynchronously. Successful response indicates that the event was validated and submitted for processing, but does not guarantee that processing is complete.<br><br>*Rate limits*:<br>Burst: `350/s`<br>Steady: `3500/m`  **Scopes:** `Events Write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_event(event_create_query, async_req=True)
        >>> result = thread.get()

        Args:
            event_create_query (EventCreateQuery): Event to create.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['event_create_query'] = \
            event_create_query
        return self.create_event_endpoint.call_with_http_info(**kwargs)

    def get_event(
        self,
        id,
        **kwargs
    ):
        """Get Event  # noqa: E501

        Get an event with the given event ID. Include parameters can be provided to get the following related resource data: `metrics`, `profiles`<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `Events Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_event(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the event

        Keyword Args:
            fields_event ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-02-22/reference/api-overview#sparse-fieldsets. [optional]
            fields_metric ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-02-22/reference/api-overview#sparse-fieldsets. [optional]
            fields_profile ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-02-22/reference/api-overview#sparse-fieldsets. [optional]
            include ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-02-22/reference/api-overview#relationships. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_event_endpoint.call_with_http_info(**kwargs)

    def get_event_metrics(
        self,
        id,
        **kwargs
    ):
        """Get Event Metrics  # noqa: E501

        Get the metric for an event with the given event ID.<br><br>*Rate limits*:<br>Burst: `350/s`<br>Steady: `3500/m`  **Scopes:** `Events Read` `Metrics Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_event_metrics(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the event

        Keyword Args:
            fields_metric ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-02-22/reference/api-overview#sparse-fieldsets. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_event_metrics_endpoint.call_with_http_info(**kwargs)

    def get_event_profiles(
        self,
        id,
        **kwargs
    ):
        """Get Event Profiles  # noqa: E501

        Get the profile associated with an event with the given event ID.<br><br>*Rate limits*:<br>Burst: `350/s`<br>Steady: `3500/m`  **Scopes:** `Events Read` `Profiles Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_event_profiles(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): ID of the event

        Keyword Args:
            additional_fields_profile ([str]): Request additional fields not included by default in the response. Supported values: 'predictive_analytics'. [optional]
            fields_profile ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-02-22/reference/api-overview#sparse-fieldsets. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_event_profiles_endpoint.call_with_http_info(**kwargs)

    def get_event_relationships_metrics(
        self,
        id,
        **kwargs
    ):
        """Get Event Relationships Metrics  # noqa: E501

        Get a list of related Metrics for an Event<br><br>*Rate limits*:<br>Burst: `350/s`<br>Steady: `3500/m`  **Scopes:** `Events Read` `Metrics Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_event_relationships_metrics(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): 

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_event_relationships_metrics_endpoint.call_with_http_info(**kwargs)

    def get_event_relationships_profiles(
        self,
        id,
        **kwargs
    ):
        """Get Event Relationships Profiles  # noqa: E501

        Get profile [relationships](https://developers.klaviyo.com/en/reference/api_overview#relationships) for an event with the given event ID.<br><br>*Rate limits*:<br>Burst: `350/s`<br>Steady: `3500/m`  **Scopes:** `Events Read` `Profiles Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_event_relationships_profiles(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): 

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_event_relationships_profiles_endpoint.call_with_http_info(**kwargs)

    def get_events(
        self,
        **kwargs
    ):
        """Get Events  # noqa: E501

        Get all events in an account Requests can be sorted by the following fields: `datetime`, `timestamp` Include parameters can be provided to get the following related resource data: `metrics`, `profiles` Returns a maximum of 200 events per page.<br><br>*Rate limits*:<br>Burst: `350/s`<br>Steady: `3500/m`  **Scopes:** `Events Read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_events(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            fields_event ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-02-22/reference/api-overview#sparse-fieldsets. [optional]
            fields_metric ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-02-22/reference/api-overview#sparse-fieldsets. [optional]
            fields_profile ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-02-22/reference/api-overview#sparse-fieldsets. [optional]
            filter (str): For more information please visit https://developers.klaviyo.com/en/v2023-02-22/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`metric_id`: `equals`<br>`profile_id`: `equals`<br>`datetime`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`timestamp`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`. [optional]
            include ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-02-22/reference/api-overview#relationships. [optional]
            page_cursor (str): For more information please visit https://developers.klaviyo.com/en/v2023-02-22/reference/api-overview#pagination. [optional]
            sort (str): For more information please visit https://developers.klaviyo.com/en/v2023-02-22/reference/api-overview#sorting. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_events_endpoint.call_with_http_info(**kwargs)

