"""add core api tables

Peek Plugin Database Migration Script

Revision ID: c31aaab9c30e
Revises: 
Create Date: 2021-05-11 16:42:09.211708

"""

# revision identifiers, used by Alembic.
revision = "c31aaab9c30e"
down_revision = None
branch_labels = None
depends_on = None

import sqlalchemy as sa
from alembic import op


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "PublishedApi",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("pluginName", sa.String(), nullable=False),
        sa.Column("apiKey", sa.String(), nullable=False),
        sa.Column("tupleName", sa.String(), nullable=False),
        sa.Column(
            "pluginApiTupleKey",
            sa.String(),
            sa.Computed(
                '"pluginName" || \':\' || "apiKey" || \':\' || "tupleName"',
                persisted=True,
            ),
            nullable=True,
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("pluginApiTupleKey"),
        schema="core_api",
    )
    op.create_table(
        "Webhook",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("comment", sa.String(), nullable=True),
        sa.Column("postUrl", sa.String(), nullable=False),
        sa.Column(
            "authToken",
            sa.String(),
            nullable=True,
            comment="authorisation token",
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="core_api",
    )
    op.create_table(
        "MessageQueue",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("webhookId", sa.Integer(), nullable=False),
        sa.Column("queuedDate", sa.DateTime(timezone=True), nullable=False),
        sa.Column(
            "lastDeliveryAttemptDate", sa.DateTime(timezone=True), nullable=True
        ),
        sa.Column("lastDeliveryResponseCode", sa.Integer(), nullable=True),
        sa.Column(
            "attemptCount",
            sa.Integer(),
            nullable=False,
            server_default="0",
        ),
        sa.Column("deliveredDate", sa.DateTime(timezone=True), nullable=True),
        sa.Column("lastPostResponseSeconds", sa.Float(), nullable=True),
        sa.Column("deliveryStatus", sa.Integer(), nullable=False),
        sa.Column(
            "messageBinary",
            sa.LargeBinary(),
            nullable=False,
            comment="in binary, gzip compressed",
        ),
        sa.Column("postPath", sa.String(), nullable=True),
        sa.Column("pluginApiTupleKey", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["pluginApiTupleKey"],
            ["core_api.PublishedApi.pluginApiTupleKey"],
        ),
        sa.ForeignKeyConstraint(
            ["webhookId"],
            ["core_api.Webhook.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="core_api",
    )
    op.create_table(
        "WebhookMap",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("webhookId", sa.Integer(), nullable=True),
        sa.Column("pluginApiTupleKey", sa.String(), nullable=True),
        sa.Column("postPath", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["pluginApiTupleKey"],
            ["core_api.PublishedApi.pluginApiTupleKey"],
        ),
        sa.ForeignKeyConstraint(
            ["webhookId"],
            ["core_api.Webhook.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="core_api",
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("WebhookMap", schema="core_api")
    op.drop_table("MessageQueue", schema="core_api")
    op.drop_table("Webhook", schema="core_api")
    op.drop_table("PublishedApi", schema="core_api")
    # ### end Alembic commands ###
