import { IAlarm } from './alarm-base';
import { ConcreteWidget } from './widget';
/**
 * Properties for an Alarm Status Widget.
 *
 * @stability stable
 */
export interface AlarmStatusWidgetProps {
    /**
     * CloudWatch Alarms to show in widget.
     *
     * @stability stable
     */
    readonly alarms: IAlarm[];
    /**
     * The title of the widget.
     *
     * @default 'Alarm Status'
     * @stability stable
     */
    readonly title?: string;
    /**
     * Width of the widget, in a grid of 24 units wide.
     *
     * @default 6
     * @stability stable
     */
    readonly width?: number;
    /**
     * Height of the widget.
     *
     * @default 3
     * @stability stable
     */
    readonly height?: number;
}
/**
 * A dashboard widget that displays alarms in a grid view.
 *
 * @stability stable
 */
export declare class AlarmStatusWidget extends ConcreteWidget {
    private readonly props;
    /**
     * @stability stable
     */
    constructor(props: AlarmStatusWidgetProps);
    /**
     * Place the widget at a given position.
     *
     * @stability stable
     */
    position(x: number, y: number): void;
    /**
     * Return the widget JSON for use in the dashboard.
     *
     * @stability stable
     */
    toJson(): any[];
}
