"""
Copyright (c) 2021-present duhby
MIT License, see LICENSE for more details.
"""

from dataclasses import dataclass, field
from datetime import datetime

from . import utils

__all__ = [
    'Friend',
]


@dataclass
class Friend:
    raw: dict = field(repr=False)
    id: str # _id
    uuid: str # uuidReceiver
    started: datetime # started

    def __post_init__(self):
        self.started = utils.convert_to_datetime(self.started)
