# coding: utf-8

"""
    Aspose.PDF Cloud API Reference


   Copyright (c) 2020 Aspose.PDF Cloud
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:
 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.



    OpenAPI spec version: 3.0
    
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class PdfApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient(None, None)
            self.api_client = config.api_client

    def copy_file(self, src_path, dest_path, **kwargs):
        """
        Copy file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.copy_file(src_path, dest_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Source file path e.g. '/folder/file.ext' (required)
        :param str dest_path: Destination file path (required)
        :param str src_storage_name: Source storage name
        :param str dest_storage_name: Destination storage name
        :param str version_id: File version ID to copy
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.copy_file_with_http_info(src_path, dest_path, **kwargs)
        else:
            (data) = self.copy_file_with_http_info(src_path, dest_path, **kwargs)
            return data

    def copy_file_with_http_info(self, src_path, dest_path, **kwargs):
        """
        Copy file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.copy_file_with_http_info(src_path, dest_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Source file path e.g. '/folder/file.ext' (required)
        :param str dest_path: Destination file path (required)
        :param str src_storage_name: Source storage name
        :param str dest_storage_name: Destination storage name
        :param str version_id: File version ID to copy
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'dest_path', 'src_storage_name', 'dest_storage_name', 'version_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `copy_file`")
        # verify the required parameter 'dest_path' is set
        if ('dest_path' not in params) or (params['dest_path'] is None):
            raise ValueError("Missing the required parameter `dest_path` when calling `copy_file`")


        collection_formats = {}

        path_params = {}
        if 'src_path' in params:
            path_params['srcPath'] = params['src_path']

        query_params = []
        if 'dest_path' in params:
            query_params.append(('destPath', params['dest_path']))
        if 'src_storage_name' in params:
            query_params.append(('srcStorageName', params['src_storage_name']))
        if 'dest_storage_name' in params:
            query_params.append(('destStorageName', params['dest_storage_name']))
        if 'version_id' in params:
            query_params.append(('versionId', params['version_id']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/storage/file/copy/{srcPath}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def copy_folder(self, src_path, dest_path, **kwargs):
        """
        Copy folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.copy_folder(src_path, dest_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Source folder path e.g. '/src' (required)
        :param str dest_path: Destination folder path e.g. '/dst' (required)
        :param str src_storage_name: Source storage name
        :param str dest_storage_name: Destination storage name
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.copy_folder_with_http_info(src_path, dest_path, **kwargs)
        else:
            (data) = self.copy_folder_with_http_info(src_path, dest_path, **kwargs)
            return data

    def copy_folder_with_http_info(self, src_path, dest_path, **kwargs):
        """
        Copy folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.copy_folder_with_http_info(src_path, dest_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Source folder path e.g. '/src' (required)
        :param str dest_path: Destination folder path e.g. '/dst' (required)
        :param str src_storage_name: Source storage name
        :param str dest_storage_name: Destination storage name
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'dest_path', 'src_storage_name', 'dest_storage_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `copy_folder`")
        # verify the required parameter 'dest_path' is set
        if ('dest_path' not in params) or (params['dest_path'] is None):
            raise ValueError("Missing the required parameter `dest_path` when calling `copy_folder`")


        collection_formats = {}

        path_params = {}
        if 'src_path' in params:
            path_params['srcPath'] = params['src_path']

        query_params = []
        if 'dest_path' in params:
            query_params.append(('destPath', params['dest_path']))
        if 'src_storage_name' in params:
            query_params.append(('srcStorageName', params['src_storage_name']))
        if 'dest_storage_name' in params:
            query_params.append(('destStorageName', params['dest_storage_name']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/storage/folder/copy/{srcPath}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_folder(self, path, **kwargs):
        """
        Create the folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_folder(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: Folder path to create e.g. 'folder_1/folder_2/' (required)
        :param str storage_name: Storage name
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_folder_with_http_info(path, **kwargs)
        else:
            (data) = self.create_folder_with_http_info(path, **kwargs)
            return data

    def create_folder_with_http_info(self, path, **kwargs):
        """
        Create the folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_folder_with_http_info(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: Folder path to create e.g. 'folder_1/folder_2/' (required)
        :param str storage_name: Storage name
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'storage_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params) or (params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `create_folder`")


        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = []
        if 'storage_name' in params:
            query_params.append(('storageName', params['storage_name']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/storage/folder/{path}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_annotation(self, name, annotation_id, **kwargs):
        """
        Delete document annotation by ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.delete_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def delete_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Delete document annotation by ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `delete_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/{annotationId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_bookmark(self, name, bookmark_path, **kwargs):
        """
        Delete document bookmark by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_bookmark(name, bookmark_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str bookmark_path: The bookmark path. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_bookmark_with_http_info(name, bookmark_path, **kwargs)
        else:
            (data) = self.delete_bookmark_with_http_info(name, bookmark_path, **kwargs)
            return data

    def delete_bookmark_with_http_info(self, name, bookmark_path, **kwargs):
        """
        Delete document bookmark by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_bookmark_with_http_info(name, bookmark_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str bookmark_path: The bookmark path. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'bookmark_path', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_bookmark" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_bookmark`")
        # verify the required parameter 'bookmark_path' is set
        if ('bookmark_path' not in params) or (params['bookmark_path'] is None):
            raise ValueError("Missing the required parameter `bookmark_path` when calling `delete_bookmark`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'bookmark_path' in params:
            path_params['bookmarkPath'] = params['bookmark_path']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/bookmarks/bookmark/{bookmarkPath}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_document_annotations(self, name, **kwargs):
        """
        Delete all annotations from the document
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_document_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.delete_document_annotations_with_http_info(name, **kwargs)
            return data

    def delete_document_annotations_with_http_info(self, name, **kwargs):
        """
        Delete all annotations from the document
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_document_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_document_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_document_bookmarks(self, name, **kwargs):
        """
        Delete all document bookmarks.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_bookmarks(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_document_bookmarks_with_http_info(name, **kwargs)
        else:
            (data) = self.delete_document_bookmarks_with_http_info(name, **kwargs)
            return data

    def delete_document_bookmarks_with_http_info(self, name, **kwargs):
        """
        Delete all document bookmarks.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_bookmarks_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_document_bookmarks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_document_bookmarks`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/bookmarks/tree', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_document_link_annotations(self, name, **kwargs):
        """
        Delete all link annotations from the document
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_link_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_document_link_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.delete_document_link_annotations_with_http_info(name, **kwargs)
            return data

    def delete_document_link_annotations_with_http_info(self, name, **kwargs):
        """
        Delete all link annotations from the document
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_link_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_document_link_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_document_link_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/links', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_document_stamps(self, name, **kwargs):
        """
        Delete all stamps from the document
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_stamps(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_document_stamps_with_http_info(name, **kwargs)
        else:
            (data) = self.delete_document_stamps_with_http_info(name, **kwargs)
            return data

    def delete_document_stamps_with_http_info(self, name, **kwargs):
        """
        Delete all stamps from the document
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_stamps_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_document_stamps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_document_stamps`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/stamps', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_document_tables(self, name, **kwargs):
        """
        Delete all tables from the document
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_tables(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_document_tables_with_http_info(name, **kwargs)
        else:
            (data) = self.delete_document_tables_with_http_info(name, **kwargs)
            return data

    def delete_document_tables_with_http_info(self, name, **kwargs):
        """
        Delete all tables from the document
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_document_tables_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_document_tables" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_document_tables`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/tables', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_field(self, name, field_name, **kwargs):
        """
        Delete document field by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_field(name, field_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str field_name: The field name/ (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_field_with_http_info(name, field_name, **kwargs)
        else:
            (data) = self.delete_field_with_http_info(name, field_name, **kwargs)
            return data

    def delete_field_with_http_info(self, name, field_name, **kwargs):
        """
        Delete document field by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_field_with_http_info(name, field_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str field_name: The field name/ (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'field_name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_field" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_field`")
        # verify the required parameter 'field_name' is set
        if ('field_name' not in params) or (params['field_name'] is None):
            raise ValueError("Missing the required parameter `field_name` when calling `delete_field`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'field_name' in params:
            path_params['fieldName'] = params['field_name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/fields/{fieldName}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_file(self, path, **kwargs):
        """
        Delete file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_file(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: File path e.g. '/folder/file.ext' (required)
        :param str storage_name: Storage name
        :param str version_id: File version ID to delete
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_file_with_http_info(path, **kwargs)
        else:
            (data) = self.delete_file_with_http_info(path, **kwargs)
            return data

    def delete_file_with_http_info(self, path, **kwargs):
        """
        Delete file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_file_with_http_info(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: File path e.g. '/folder/file.ext' (required)
        :param str storage_name: Storage name
        :param str version_id: File version ID to delete
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'storage_name', 'version_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params) or (params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `delete_file`")


        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = []
        if 'storage_name' in params:
            query_params.append(('storageName', params['storage_name']))
        if 'version_id' in params:
            query_params.append(('versionId', params['version_id']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/storage/file/{path}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_folder(self, path, **kwargs):
        """
        Delete folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_folder(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: Folder path e.g. '/folder' (required)
        :param str storage_name: Storage name
        :param bool recursive: Enable to delete folders, subfolders and files
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_folder_with_http_info(path, **kwargs)
        else:
            (data) = self.delete_folder_with_http_info(path, **kwargs)
            return data

    def delete_folder_with_http_info(self, path, **kwargs):
        """
        Delete folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_folder_with_http_info(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: Folder path e.g. '/folder' (required)
        :param str storage_name: Storage name
        :param bool recursive: Enable to delete folders, subfolders and files
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'storage_name', 'recursive']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params) or (params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `delete_folder`")


        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = []
        if 'storage_name' in params:
            query_params.append(('storageName', params['storage_name']))
        if 'recursive' in params:
            query_params.append(('recursive', params['recursive']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/storage/folder/{path}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_image(self, name, image_id, **kwargs):
        """
        Delete image from document page.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_image(name, image_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str image_id: Image ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_image_with_http_info(name, image_id, **kwargs)
        else:
            (data) = self.delete_image_with_http_info(name, image_id, **kwargs)
            return data

    def delete_image_with_http_info(self, name, image_id, **kwargs):
        """
        Delete image from document page.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_image_with_http_info(name, image_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str image_id: Image ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'image_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_image`")
        # verify the required parameter 'image_id' is set
        if ('image_id' not in params) or (params['image_id'] is None):
            raise ValueError("Missing the required parameter `image_id` when calling `delete_image`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'image_id' in params:
            path_params['imageId'] = params['image_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/images/{imageId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_link_annotation(self, name, link_id, **kwargs):
        """
        Delete document page link annotation by ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_link_annotation(name, link_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str link_id: The link ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_link_annotation_with_http_info(name, link_id, **kwargs)
        else:
            (data) = self.delete_link_annotation_with_http_info(name, link_id, **kwargs)
            return data

    def delete_link_annotation_with_http_info(self, name, link_id, **kwargs):
        """
        Delete document page link annotation by ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_link_annotation_with_http_info(name, link_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str link_id: The link ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'link_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_link_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_link_annotation`")
        # verify the required parameter 'link_id' is set
        if ('link_id' not in params) or (params['link_id'] is None):
            raise ValueError("Missing the required parameter `link_id` when calling `delete_link_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'link_id' in params:
            path_params['linkId'] = params['link_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/links/{linkId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_page(self, name, page_number, **kwargs):
        """
        Delete document page by its number.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_page(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_page_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.delete_page_with_http_info(name, page_number, **kwargs)
            return data

    def delete_page_with_http_info(self, name, page_number, **kwargs):
        """
        Delete document page by its number.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_page_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_page" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_page`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `delete_page`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_page_annotations(self, name, page_number, **kwargs):
        """
        Delete all annotations from the page
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_page_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_page_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.delete_page_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def delete_page_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Delete all annotations from the page
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_page_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_page_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_page_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `delete_page_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_page_link_annotations(self, name, page_number, **kwargs):
        """
        Delete all link annotations from the page
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_page_link_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_page_link_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.delete_page_link_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def delete_page_link_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Delete all link annotations from the page
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_page_link_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_page_link_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_page_link_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `delete_page_link_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/links', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_page_stamps(self, name, page_number, **kwargs):
        """
        Delete all stamps from the page
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_page_stamps(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_page_stamps_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.delete_page_stamps_with_http_info(name, page_number, **kwargs)
            return data

    def delete_page_stamps_with_http_info(self, name, page_number, **kwargs):
        """
        Delete all stamps from the page
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_page_stamps_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_page_stamps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_page_stamps`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `delete_page_stamps`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/stamps', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_page_tables(self, name, page_number, **kwargs):
        """
        Delete all tables from the page
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_page_tables(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_page_tables_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.delete_page_tables_with_http_info(name, page_number, **kwargs)
            return data

    def delete_page_tables_with_http_info(self, name, page_number, **kwargs):
        """
        Delete all tables from the page
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_page_tables_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_page_tables" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_page_tables`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `delete_page_tables`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/tables', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_properties(self, name, **kwargs):
        """
        Delete custom document properties.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_properties(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str storage:
        :param str folder:
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_properties_with_http_info(name, **kwargs)
        else:
            (data) = self.delete_properties_with_http_info(name, **kwargs)
            return data

    def delete_properties_with_http_info(self, name, **kwargs):
        """
        Delete custom document properties.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_properties_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str storage:
        :param str folder:
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_properties`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/documentproperties', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_property(self, name, property_name, **kwargs):
        """
        Delete document property.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_property(name, property_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str property_name: (required)
        :param str storage:
        :param str folder:
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_property_with_http_info(name, property_name, **kwargs)
        else:
            (data) = self.delete_property_with_http_info(name, property_name, **kwargs)
            return data

    def delete_property_with_http_info(self, name, property_name, **kwargs):
        """
        Delete document property.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_property_with_http_info(name, property_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str property_name: (required)
        :param str storage:
        :param str folder:
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'property_name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_property" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_property`")
        # verify the required parameter 'property_name' is set
        if ('property_name' not in params) or (params['property_name'] is None):
            raise ValueError("Missing the required parameter `property_name` when calling `delete_property`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'property_name' in params:
            path_params['propertyName'] = params['property_name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/documentproperties/{propertyName}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_stamp(self, name, stamp_id, **kwargs):
        """
        Delete document stamp by ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_stamp(name, stamp_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str stamp_id: The stamp ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_stamp_with_http_info(name, stamp_id, **kwargs)
        else:
            (data) = self.delete_stamp_with_http_info(name, stamp_id, **kwargs)
            return data

    def delete_stamp_with_http_info(self, name, stamp_id, **kwargs):
        """
        Delete document stamp by ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_stamp_with_http_info(name, stamp_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str stamp_id: The stamp ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'stamp_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_stamp" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_stamp`")
        # verify the required parameter 'stamp_id' is set
        if ('stamp_id' not in params) or (params['stamp_id'] is None):
            raise ValueError("Missing the required parameter `stamp_id` when calling `delete_stamp`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'stamp_id' in params:
            path_params['stampId'] = params['stamp_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/stamps/{stampId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_table(self, name, table_id, **kwargs):
        """
        Delete document table by ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_table(name, table_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str table_id: The table ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_table_with_http_info(name, table_id, **kwargs)
        else:
            (data) = self.delete_table_with_http_info(name, table_id, **kwargs)
            return data

    def delete_table_with_http_info(self, name, table_id, **kwargs):
        """
        Delete document table by ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_table_with_http_info(name, table_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str table_id: The table ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AsposeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'table_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_table`")
        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `delete_table`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/tables/{tableId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AsposeResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def download_file(self, path, **kwargs):
        """
        Download file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.download_file(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: File path e.g. '/folder/file.ext' (required)
        :param str storage_name: Storage name
        :param str version_id: File version ID to download
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.download_file_with_http_info(path, **kwargs)
        else:
            (data) = self.download_file_with_http_info(path, **kwargs)
            return data

    def download_file_with_http_info(self, path, **kwargs):
        """
        Download file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.download_file_with_http_info(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: File path e.g. '/folder/file.ext' (required)
        :param str storage_name: Storage name
        :param str version_id: File version ID to download
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'storage_name', 'version_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params) or (params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `download_file`")


        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = []
        if 'storage_name' in params:
            query_params.append(('storageName', params['storage_name']))
        if 'version_id' in params:
            query_params.append(('versionId', params['version_id']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/storage/file/{path}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_api_info(self, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_api_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_api_info_with_http_info(**kwargs)
        else:
            (data) = self.get_api_info_with_http_info(**kwargs)
            return data

    def get_api_info_with_http_info(self, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_api_info_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_api_info" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/info', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiInfo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_bookmark(self, name, bookmark_path, **kwargs):
        """
        Read document bookmark.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bookmark(name, bookmark_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str bookmark_path: The bookmark path. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: BookmarkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_bookmark_with_http_info(name, bookmark_path, **kwargs)
        else:
            (data) = self.get_bookmark_with_http_info(name, bookmark_path, **kwargs)
            return data

    def get_bookmark_with_http_info(self, name, bookmark_path, **kwargs):
        """
        Read document bookmark.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bookmark_with_http_info(name, bookmark_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str bookmark_path: The bookmark path. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: BookmarkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'bookmark_path', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bookmark" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_bookmark`")
        # verify the required parameter 'bookmark_path' is set
        if ('bookmark_path' not in params) or (params['bookmark_path'] is None):
            raise ValueError("Missing the required parameter `bookmark_path` when calling `get_bookmark`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'bookmark_path' in params:
            path_params['bookmarkPath'] = params['bookmark_path']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/bookmarks/bookmark/{bookmarkPath}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BookmarkResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_bookmarks(self, name, bookmark_path, **kwargs):
        """
        Read document bookmarks node list.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bookmarks(name, bookmark_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str bookmark_path: The bookmark path. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: BookmarksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_bookmarks_with_http_info(name, bookmark_path, **kwargs)
        else:
            (data) = self.get_bookmarks_with_http_info(name, bookmark_path, **kwargs)
            return data

    def get_bookmarks_with_http_info(self, name, bookmark_path, **kwargs):
        """
        Read document bookmarks node list.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_bookmarks_with_http_info(name, bookmark_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str bookmark_path: The bookmark path. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: BookmarksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'bookmark_path', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bookmarks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_bookmarks`")
        # verify the required parameter 'bookmark_path' is set
        if ('bookmark_path' not in params) or (params['bookmark_path'] is None):
            raise ValueError("Missing the required parameter `bookmark_path` when calling `get_bookmarks`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'bookmark_path' in params:
            path_params['bookmarkPath'] = params['bookmark_path']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/bookmarks/list/{bookmarkPath}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BookmarksResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_caret_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page caret annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_caret_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: CaretAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_caret_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_caret_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_caret_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page caret annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_caret_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: CaretAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_caret_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_caret_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_caret_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/caret/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CaretAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_check_box_field(self, name, field_name, **kwargs):
        """
        Read document checkbox field by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_check_box_field(name, field_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str field_name: The field name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: CheckBoxFieldResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_check_box_field_with_http_info(name, field_name, **kwargs)
        else:
            (data) = self.get_check_box_field_with_http_info(name, field_name, **kwargs)
            return data

    def get_check_box_field_with_http_info(self, name, field_name, **kwargs):
        """
        Read document checkbox field by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_check_box_field_with_http_info(name, field_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str field_name: The field name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: CheckBoxFieldResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'field_name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_check_box_field" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_check_box_field`")
        # verify the required parameter 'field_name' is set
        if ('field_name' not in params) or (params['field_name'] is None):
            raise ValueError("Missing the required parameter `field_name` when calling `get_check_box_field`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'field_name' in params:
            path_params['fieldName'] = params['field_name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/fields/checkbox/{fieldName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CheckBoxFieldResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_circle_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page circle annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_circle_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: CircleAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_circle_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_circle_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_circle_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page circle annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_circle_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: CircleAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_circle_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_circle_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_circle_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/circle/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CircleAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_combo_box_field(self, name, field_name, **kwargs):
        """
        Read document combobox field by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_combo_box_field(name, field_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str field_name: The field name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ComboBoxFieldResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_combo_box_field_with_http_info(name, field_name, **kwargs)
        else:
            (data) = self.get_combo_box_field_with_http_info(name, field_name, **kwargs)
            return data

    def get_combo_box_field_with_http_info(self, name, field_name, **kwargs):
        """
        Read document combobox field by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_combo_box_field_with_http_info(name, field_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str field_name: The field name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ComboBoxFieldResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'field_name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_combo_box_field" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_combo_box_field`")
        # verify the required parameter 'field_name' is set
        if ('field_name' not in params) or (params['field_name'] is None):
            raise ValueError("Missing the required parameter `field_name` when calling `get_combo_box_field`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'field_name' in params:
            path_params['fieldName'] = params['field_name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/fields/combobox/{fieldName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ComboBoxFieldResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_disc_usage(self, **kwargs):
        """
        Get disc usage
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_disc_usage(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str storage_name: Storage name
        :return: DiscUsage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_disc_usage_with_http_info(**kwargs)
        else:
            (data) = self.get_disc_usage_with_http_info(**kwargs)
            return data

    def get_disc_usage_with_http_info(self, **kwargs):
        """
        Get disc usage
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_disc_usage_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str storage_name: Storage name
        :return: DiscUsage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storage_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_disc_usage" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'storage_name' in params:
            query_params.append(('storageName', params['storage_name']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/storage/disc', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DiscUsage',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document(self, name, **kwargs):
        """
        Read common document info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: DocumentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_with_http_info(name, **kwargs)
            return data

    def get_document_with_http_info(self, name, **kwargs):
        """
        Read common document info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: DocumentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_annotations(self, name, **kwargs):
        """
        Read document page annotations. Returns only FreeTextAnnotations, TextAnnotations, other annotations will implemented next releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AnnotationsInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_annotations_with_http_info(self, name, **kwargs):
        """
        Read document page annotations. Returns only FreeTextAnnotations, TextAnnotations, other annotations will implemented next releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AnnotationsInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AnnotationsInfoResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_attachment_by_index(self, name, attachment_index, **kwargs):
        """
        Read document attachment info by its index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_attachment_by_index(name, attachment_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int attachment_index: The attachment index. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AttachmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_attachment_by_index_with_http_info(name, attachment_index, **kwargs)
        else:
            (data) = self.get_document_attachment_by_index_with_http_info(name, attachment_index, **kwargs)
            return data

    def get_document_attachment_by_index_with_http_info(self, name, attachment_index, **kwargs):
        """
        Read document attachment info by its index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_attachment_by_index_with_http_info(name, attachment_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int attachment_index: The attachment index. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AttachmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'attachment_index', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_attachment_by_index" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_attachment_by_index`")
        # verify the required parameter 'attachment_index' is set
        if ('attachment_index' not in params) or (params['attachment_index'] is None):
            raise ValueError("Missing the required parameter `attachment_index` when calling `get_document_attachment_by_index`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'attachment_index' in params:
            path_params['attachmentIndex'] = params['attachment_index']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/attachments/{attachmentIndex}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AttachmentResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_attachments(self, name, **kwargs):
        """
        Read document attachments info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_attachments(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AttachmentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_attachments_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_attachments_with_http_info(name, **kwargs)
            return data

    def get_document_attachments_with_http_info(self, name, **kwargs):
        """
        Read document attachments info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_attachments_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AttachmentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_attachments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_attachments`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/attachments', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AttachmentsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_bookmarks(self, name, **kwargs):
        """
        Read document bookmarks tree.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_bookmarks(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: BookmarksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_bookmarks_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_bookmarks_with_http_info(name, **kwargs)
            return data

    def get_document_bookmarks_with_http_info(self, name, **kwargs):
        """
        Read document bookmarks tree.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_bookmarks_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: BookmarksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_bookmarks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_bookmarks`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/bookmarks/tree', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BookmarksResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_caret_annotations(self, name, **kwargs):
        """
        Read document caret annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_caret_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: CaretAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_caret_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_caret_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_caret_annotations_with_http_info(self, name, **kwargs):
        """
        Read document caret annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_caret_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: CaretAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_caret_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_caret_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/caret', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CaretAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_check_box_fields(self, name, **kwargs):
        """
        Read document checkbox fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_check_box_fields(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: CheckBoxFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_check_box_fields_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_check_box_fields_with_http_info(name, **kwargs)
            return data

    def get_document_check_box_fields_with_http_info(self, name, **kwargs):
        """
        Read document checkbox fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_check_box_fields_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: CheckBoxFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_check_box_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_check_box_fields`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/fields/checkbox', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CheckBoxFieldsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_circle_annotations(self, name, **kwargs):
        """
        Read document circle annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_circle_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: CircleAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_circle_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_circle_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_circle_annotations_with_http_info(self, name, **kwargs):
        """
        Read document circle annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_circle_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: CircleAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_circle_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_circle_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/circle', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CircleAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_combo_box_fields(self, name, **kwargs):
        """
        Read document combobox fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_combo_box_fields(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ComboBoxFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_combo_box_fields_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_combo_box_fields_with_http_info(name, **kwargs)
            return data

    def get_document_combo_box_fields_with_http_info(self, name, **kwargs):
        """
        Read document combobox fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_combo_box_fields_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ComboBoxFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_combo_box_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_combo_box_fields`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/fields/combobox', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ComboBoxFieldsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_display_properties(self, name, **kwargs):
        """
        Read document display properties.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_display_properties(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str storage:
        :param str folder:
        :return: DisplayPropertiesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_display_properties_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_display_properties_with_http_info(name, **kwargs)
            return data

    def get_document_display_properties_with_http_info(self, name, **kwargs):
        """
        Read document display properties.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_display_properties_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str storage:
        :param str folder:
        :return: DisplayPropertiesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_display_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_display_properties`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/displayproperties', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DisplayPropertiesResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_file_attachment_annotations(self, name, **kwargs):
        """
        Read document FileAttachment annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_file_attachment_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: FileAttachmentAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_file_attachment_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_file_attachment_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_file_attachment_annotations_with_http_info(self, name, **kwargs):
        """
        Read document FileAttachment annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_file_attachment_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: FileAttachmentAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_file_attachment_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_file_attachment_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/fileattachment', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FileAttachmentAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_free_text_annotations(self, name, **kwargs):
        """
        Read document free text annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_free_text_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: FreeTextAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_free_text_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_free_text_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_free_text_annotations_with_http_info(self, name, **kwargs):
        """
        Read document free text annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_free_text_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: FreeTextAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_free_text_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_free_text_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/freetext', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FreeTextAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_highlight_annotations(self, name, **kwargs):
        """
        Read document highlight annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_highlight_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: HighlightAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_highlight_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_highlight_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_highlight_annotations_with_http_info(self, name, **kwargs):
        """
        Read document highlight annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_highlight_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: HighlightAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_highlight_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_highlight_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/highlight', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='HighlightAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_ink_annotations(self, name, **kwargs):
        """
        Read document ink annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_ink_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: InkAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_ink_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_ink_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_ink_annotations_with_http_info(self, name, **kwargs):
        """
        Read document ink annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_ink_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: InkAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_ink_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_ink_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/ink', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='InkAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_line_annotations(self, name, **kwargs):
        """
        Read document line annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_line_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: LineAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_line_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_line_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_line_annotations_with_http_info(self, name, **kwargs):
        """
        Read document line annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_line_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: LineAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_line_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_line_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/line', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LineAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_list_box_fields(self, name, **kwargs):
        """
        Read document listbox fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_list_box_fields(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ListBoxFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_list_box_fields_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_list_box_fields_with_http_info(name, **kwargs)
            return data

    def get_document_list_box_fields_with_http_info(self, name, **kwargs):
        """
        Read document listbox fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_list_box_fields_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ListBoxFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_list_box_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_list_box_fields`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/fields/listbox', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ListBoxFieldsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_movie_annotations(self, name, **kwargs):
        """
        Read document movie annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_movie_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: MovieAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_movie_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_movie_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_movie_annotations_with_http_info(self, name, **kwargs):
        """
        Read document movie annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_movie_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: MovieAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_movie_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_movie_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/movie', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MovieAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_poly_line_annotations(self, name, **kwargs):
        """
        Read document polyline annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_poly_line_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PolyLineAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_poly_line_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_poly_line_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_poly_line_annotations_with_http_info(self, name, **kwargs):
        """
        Read document polyline annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_poly_line_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PolyLineAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_poly_line_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_poly_line_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/polyline', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PolyLineAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_polygon_annotations(self, name, **kwargs):
        """
        Read document polygon annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_polygon_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PolygonAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_polygon_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_polygon_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_polygon_annotations_with_http_info(self, name, **kwargs):
        """
        Read document polygon annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_polygon_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PolygonAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_polygon_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_polygon_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/polygon', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PolygonAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_popup_annotations(self, name, **kwargs):
        """
        Read document popup annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_popup_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PopupAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_popup_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_popup_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_popup_annotations_with_http_info(self, name, **kwargs):
        """
        Read document popup annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_popup_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PopupAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_popup_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_popup_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/popup', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PopupAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_popup_annotations_by_parent(self, name, annotation_id, **kwargs):
        """
        Read document popup annotations by parent id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_popup_annotations_by_parent(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The parent annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PopupAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_popup_annotations_by_parent_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_document_popup_annotations_by_parent_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_document_popup_annotations_by_parent_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document popup annotations by parent id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_popup_annotations_by_parent_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The parent annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PopupAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_popup_annotations_by_parent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_popup_annotations_by_parent`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_document_popup_annotations_by_parent`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/{annotationId}/popup', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PopupAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_properties(self, name, **kwargs):
        """
        Read document properties.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_properties(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str storage:
        :param str folder:
        :return: DocumentPropertiesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_properties_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_properties_with_http_info(name, **kwargs)
            return data

    def get_document_properties_with_http_info(self, name, **kwargs):
        """
        Read document properties.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_properties_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str storage:
        :param str folder:
        :return: DocumentPropertiesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_properties`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/documentproperties', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentPropertiesResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_property(self, name, property_name, **kwargs):
        """
        Read document property by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_property(name, property_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str property_name: (required)
        :param str storage:
        :param str folder:
        :return: DocumentPropertyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_property_with_http_info(name, property_name, **kwargs)
        else:
            (data) = self.get_document_property_with_http_info(name, property_name, **kwargs)
            return data

    def get_document_property_with_http_info(self, name, property_name, **kwargs):
        """
        Read document property by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_property_with_http_info(name, property_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str property_name: (required)
        :param str storage:
        :param str folder:
        :return: DocumentPropertyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'property_name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_property" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_property`")
        # verify the required parameter 'property_name' is set
        if ('property_name' not in params) or (params['property_name'] is None):
            raise ValueError("Missing the required parameter `property_name` when calling `get_document_property`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'property_name' in params:
            path_params['propertyName'] = params['property_name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/documentproperties/{propertyName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentPropertyResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_radio_button_fields(self, name, **kwargs):
        """
        Read document radiobutton fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_radio_button_fields(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: RadioButtonFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_radio_button_fields_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_radio_button_fields_with_http_info(name, **kwargs)
            return data

    def get_document_radio_button_fields_with_http_info(self, name, **kwargs):
        """
        Read document radiobutton fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_radio_button_fields_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: RadioButtonFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_radio_button_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_radio_button_fields`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/fields/radiobutton', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RadioButtonFieldsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_redaction_annotations(self, name, **kwargs):
        """
        Read document redaction annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_redaction_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: RedactionAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_redaction_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_redaction_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_redaction_annotations_with_http_info(self, name, **kwargs):
        """
        Read document redaction annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_redaction_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: RedactionAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_redaction_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_redaction_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/redaction', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RedactionAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_screen_annotations(self, name, **kwargs):
        """
        Read document screen annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_screen_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ScreenAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_screen_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_screen_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_screen_annotations_with_http_info(self, name, **kwargs):
        """
        Read document screen annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_screen_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ScreenAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_screen_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_screen_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/screen', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ScreenAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_signature_fields(self, name, **kwargs):
        """
        Read document signature fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_signature_fields(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SignatureFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_signature_fields_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_signature_fields_with_http_info(name, **kwargs)
            return data

    def get_document_signature_fields_with_http_info(self, name, **kwargs):
        """
        Read document signature fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_signature_fields_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SignatureFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_signature_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_signature_fields`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/fields/signature', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SignatureFieldsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_sound_annotations(self, name, **kwargs):
        """
        Read document sound annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_sound_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SoundAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_sound_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_sound_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_sound_annotations_with_http_info(self, name, **kwargs):
        """
        Read document sound annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_sound_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SoundAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_sound_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_sound_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/sound', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SoundAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_square_annotations(self, name, **kwargs):
        """
        Read document square annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_square_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SquareAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_square_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_square_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_square_annotations_with_http_info(self, name, **kwargs):
        """
        Read document square annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_square_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SquareAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_square_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_square_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/square', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SquareAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_squiggly_annotations(self, name, **kwargs):
        """
        Read document squiggly annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_squiggly_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SquigglyAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_squiggly_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_squiggly_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_squiggly_annotations_with_http_info(self, name, **kwargs):
        """
        Read document squiggly annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_squiggly_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SquigglyAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_squiggly_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_squiggly_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/squiggly', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SquigglyAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_stamp_annotations(self, name, **kwargs):
        """
        Read document stamp annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_stamp_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: StampAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_stamp_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_stamp_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_stamp_annotations_with_http_info(self, name, **kwargs):
        """
        Read document stamp annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_stamp_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: StampAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_stamp_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_stamp_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/stamp', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='StampAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_stamps(self, name, **kwargs):
        """
        Read document stamps.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_stamps(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: StampsInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_stamps_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_stamps_with_http_info(name, **kwargs)
            return data

    def get_document_stamps_with_http_info(self, name, **kwargs):
        """
        Read document stamps.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_stamps_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: StampsInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_stamps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_stamps`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/stamps', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='StampsInfoResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_strike_out_annotations(self, name, **kwargs):
        """
        Read document StrikeOut annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_strike_out_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: StrikeOutAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_strike_out_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_strike_out_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_strike_out_annotations_with_http_info(self, name, **kwargs):
        """
        Read document StrikeOut annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_strike_out_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: StrikeOutAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_strike_out_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_strike_out_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/strikeout', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='StrikeOutAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_tables(self, name, **kwargs):
        """
        Read document tables.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_tables(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str storage:
        :param str folder:
        :return: TablesRecognizedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_tables_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_tables_with_http_info(name, **kwargs)
            return data

    def get_document_tables_with_http_info(self, name, **kwargs):
        """
        Read document tables.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_tables_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str storage:
        :param str folder:
        :return: TablesRecognizedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_tables" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_tables`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/tables', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TablesRecognizedResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_text_annotations(self, name, **kwargs):
        """
        Read document text annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_text_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: TextAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_text_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_text_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_text_annotations_with_http_info(self, name, **kwargs):
        """
        Read document text annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_text_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: TextAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_text_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_text_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/text', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TextAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_text_box_fields(self, name, **kwargs):
        """
        Read document text box fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_text_box_fields(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: TextBoxFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_text_box_fields_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_text_box_fields_with_http_info(name, **kwargs)
            return data

    def get_document_text_box_fields_with_http_info(self, name, **kwargs):
        """
        Read document text box fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_text_box_fields_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: TextBoxFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_text_box_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_text_box_fields`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/fields/textbox', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TextBoxFieldsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_document_underline_annotations(self, name, **kwargs):
        """
        Read document underline annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_underline_annotations(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: UnderlineAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_document_underline_annotations_with_http_info(name, **kwargs)
        else:
            (data) = self.get_document_underline_annotations_with_http_info(name, **kwargs)
            return data

    def get_document_underline_annotations_with_http_info(self, name, **kwargs):
        """
        Read document underline annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_document_underline_annotations_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: UnderlineAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_underline_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_document_underline_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/underline', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='UnderlineAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_download_document_attachment_by_index(self, name, attachment_index, **kwargs):
        """
        Download document attachment content by its index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_download_document_attachment_by_index(name, attachment_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int attachment_index: The attachment index. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_download_document_attachment_by_index_with_http_info(name, attachment_index, **kwargs)
        else:
            (data) = self.get_download_document_attachment_by_index_with_http_info(name, attachment_index, **kwargs)
            return data

    def get_download_document_attachment_by_index_with_http_info(self, name, attachment_index, **kwargs):
        """
        Download document attachment content by its index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_download_document_attachment_by_index_with_http_info(name, attachment_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int attachment_index: The attachment index. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'attachment_index', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_download_document_attachment_by_index" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_download_document_attachment_by_index`")
        # verify the required parameter 'attachment_index' is set
        if ('attachment_index' not in params) or (params['attachment_index'] is None):
            raise ValueError("Missing the required parameter `attachment_index` when calling `get_download_document_attachment_by_index`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'attachment_index' in params:
            path_params['attachmentIndex'] = params['attachment_index']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/attachments/{attachmentIndex}/download', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_epub_in_storage_to_pdf(self, src_path, **kwargs):
        """
        Convert EPUB file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_epub_in_storage_to_pdf(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.epub) (required)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_epub_in_storage_to_pdf_with_http_info(src_path, **kwargs)
        else:
            (data) = self.get_epub_in_storage_to_pdf_with_http_info(src_path, **kwargs)
            return data

    def get_epub_in_storage_to_pdf_with_http_info(self, src_path, **kwargs):
        """
        Convert EPUB file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_epub_in_storage_to_pdf_with_http_info(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.epub) (required)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_epub_in_storage_to_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `get_epub_in_storage_to_pdf`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'src_path' in params:
            query_params.append(('srcPath', params['src_path']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/create/epub', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_export_fields_from_pdf_to_fdf_in_storage(self, name, **kwargs):
        """
        Export fields from from PDF in storage to FDF file.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_export_fields_from_pdf_to_fdf_in_storage(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_export_fields_from_pdf_to_fdf_in_storage_with_http_info(name, **kwargs)
        else:
            (data) = self.get_export_fields_from_pdf_to_fdf_in_storage_with_http_info(name, **kwargs)
            return data

    def get_export_fields_from_pdf_to_fdf_in_storage_with_http_info(self, name, **kwargs):
        """
        Export fields from from PDF in storage to FDF file.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_export_fields_from_pdf_to_fdf_in_storage_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_export_fields_from_pdf_to_fdf_in_storage" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_export_fields_from_pdf_to_fdf_in_storage`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/export/fdf', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_export_fields_from_pdf_to_xfdf_in_storage(self, name, **kwargs):
        """
        Export fields from from PDF in storage to XFDF file.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_export_fields_from_pdf_to_xfdf_in_storage(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_export_fields_from_pdf_to_xfdf_in_storage_with_http_info(name, **kwargs)
        else:
            (data) = self.get_export_fields_from_pdf_to_xfdf_in_storage_with_http_info(name, **kwargs)
            return data

    def get_export_fields_from_pdf_to_xfdf_in_storage_with_http_info(self, name, **kwargs):
        """
        Export fields from from PDF in storage to XFDF file.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_export_fields_from_pdf_to_xfdf_in_storage_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_export_fields_from_pdf_to_xfdf_in_storage" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_export_fields_from_pdf_to_xfdf_in_storage`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/export/xfdf', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_export_fields_from_pdf_to_xml_in_storage(self, name, **kwargs):
        """
        Export fields from from PDF in storage to XML file.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_export_fields_from_pdf_to_xml_in_storage(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_export_fields_from_pdf_to_xml_in_storage_with_http_info(name, **kwargs)
        else:
            (data) = self.get_export_fields_from_pdf_to_xml_in_storage_with_http_info(name, **kwargs)
            return data

    def get_export_fields_from_pdf_to_xml_in_storage_with_http_info(self, name, **kwargs):
        """
        Export fields from from PDF in storage to XML file.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_export_fields_from_pdf_to_xml_in_storage_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_export_fields_from_pdf_to_xml_in_storage" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_export_fields_from_pdf_to_xml_in_storage`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/export/xml', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_field(self, name, field_name, **kwargs):
        """
        Get document field by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_field(name, field_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str field_name: The field name (name should be encoded). (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: FieldResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_field_with_http_info(name, field_name, **kwargs)
        else:
            (data) = self.get_field_with_http_info(name, field_name, **kwargs)
            return data

    def get_field_with_http_info(self, name, field_name, **kwargs):
        """
        Get document field by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_field_with_http_info(name, field_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str field_name: The field name (name should be encoded). (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: FieldResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'field_name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_field" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_field`")
        # verify the required parameter 'field_name' is set
        if ('field_name' not in params) or (params['field_name'] is None):
            raise ValueError("Missing the required parameter `field_name` when calling `get_field`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'field_name' in params:
            path_params['fieldName'] = params['field_name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/fields/{fieldName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FieldResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_fields(self, name, **kwargs):
        """
        Get document fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_fields(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: FieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_fields_with_http_info(name, **kwargs)
        else:
            (data) = self.get_fields_with_http_info(name, **kwargs)
            return data

    def get_fields_with_http_info(self, name, **kwargs):
        """
        Get document fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_fields_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: FieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_fields`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/fields', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FieldsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_file_attachment_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page FileAttachment annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_file_attachment_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: FileAttachmentAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_file_attachment_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_file_attachment_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_file_attachment_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page FileAttachment annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_file_attachment_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: FileAttachmentAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_attachment_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_file_attachment_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_file_attachment_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/fileattachment/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FileAttachmentAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_file_attachment_annotation_data(self, name, annotation_id, **kwargs):
        """
        Read document page FileAttachment annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_file_attachment_annotation_data(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_file_attachment_annotation_data_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_file_attachment_annotation_data_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_file_attachment_annotation_data_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page FileAttachment annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_file_attachment_annotation_data_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_attachment_annotation_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_file_attachment_annotation_data`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_file_attachment_annotation_data`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/fileattachment/{annotationId}/data', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_file_versions(self, path, **kwargs):
        """
        Get file versions
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_file_versions(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: File path e.g. '/file.ext' (required)
        :param str storage_name: Storage name
        :return: FileVersions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_file_versions_with_http_info(path, **kwargs)
        else:
            (data) = self.get_file_versions_with_http_info(path, **kwargs)
            return data

    def get_file_versions_with_http_info(self, path, **kwargs):
        """
        Get file versions
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_file_versions_with_http_info(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: File path e.g. '/file.ext' (required)
        :param str storage_name: Storage name
        :return: FileVersions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'storage_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_versions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params) or (params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `get_file_versions`")


        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = []
        if 'storage_name' in params:
            query_params.append(('storageName', params['storage_name']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/storage/version/{path}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FileVersions',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_files_list(self, path, **kwargs):
        """
        Get all files and folders within a folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_files_list(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: Folder path e.g. '/folder' (required)
        :param str storage_name: Storage name
        :return: FilesList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_files_list_with_http_info(path, **kwargs)
        else:
            (data) = self.get_files_list_with_http_info(path, **kwargs)
            return data

    def get_files_list_with_http_info(self, path, **kwargs):
        """
        Get all files and folders within a folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_files_list_with_http_info(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: Folder path e.g. '/folder' (required)
        :param str storage_name: Storage name
        :return: FilesList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'storage_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_files_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params) or (params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `get_files_list`")


        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = []
        if 'storage_name' in params:
            query_params.append(('storageName', params['storage_name']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/storage/folder/{path}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FilesList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_free_text_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page free text annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_free_text_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: FreeTextAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_free_text_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_free_text_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_free_text_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page free text annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_free_text_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: FreeTextAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_free_text_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_free_text_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_free_text_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/freetext/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FreeTextAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_highlight_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page highlight annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_highlight_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: HighlightAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_highlight_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_highlight_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_highlight_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page highlight annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_highlight_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: HighlightAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_highlight_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_highlight_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_highlight_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/highlight/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='HighlightAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_html_in_storage_to_pdf(self, src_path, **kwargs):
        """
        Convert HTML file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_html_in_storage_to_pdf(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.zip) (required)
        :param str html_file_name: Name of HTML file in ZIP.
        :param float height: Page height
        :param float width: Page width
        :param bool is_landscape: Is page landscaped
        :param float margin_left: Page margin left
        :param float margin_bottom: Page margin bottom
        :param float margin_right: Page margin right
        :param float margin_top: Page margin top
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_html_in_storage_to_pdf_with_http_info(src_path, **kwargs)
        else:
            (data) = self.get_html_in_storage_to_pdf_with_http_info(src_path, **kwargs)
            return data

    def get_html_in_storage_to_pdf_with_http_info(self, src_path, **kwargs):
        """
        Convert HTML file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_html_in_storage_to_pdf_with_http_info(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.zip) (required)
        :param str html_file_name: Name of HTML file in ZIP.
        :param float height: Page height
        :param float width: Page width
        :param bool is_landscape: Is page landscaped
        :param float margin_left: Page margin left
        :param float margin_bottom: Page margin bottom
        :param float margin_right: Page margin right
        :param float margin_top: Page margin top
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'html_file_name', 'height', 'width', 'is_landscape', 'margin_left', 'margin_bottom', 'margin_right', 'margin_top', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_html_in_storage_to_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `get_html_in_storage_to_pdf`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'src_path' in params:
            query_params.append(('srcPath', params['src_path']))
        if 'html_file_name' in params:
            query_params.append(('htmlFileName', params['html_file_name']))
        if 'height' in params:
            query_params.append(('height', params['height']))
        if 'width' in params:
            query_params.append(('width', params['width']))
        if 'is_landscape' in params:
            query_params.append(('isLandscape', params['is_landscape']))
        if 'margin_left' in params:
            query_params.append(('marginLeft', params['margin_left']))
        if 'margin_bottom' in params:
            query_params.append(('marginBottom', params['margin_bottom']))
        if 'margin_right' in params:
            query_params.append(('marginRight', params['margin_right']))
        if 'margin_top' in params:
            query_params.append(('marginTop', params['margin_top']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/create/html', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_image(self, name, image_id, **kwargs):
        """
        Read document image by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_image(name, image_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str image_id: Image ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ImageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_image_with_http_info(name, image_id, **kwargs)
        else:
            (data) = self.get_image_with_http_info(name, image_id, **kwargs)
            return data

    def get_image_with_http_info(self, name, image_id, **kwargs):
        """
        Read document image by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_image_with_http_info(name, image_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str image_id: Image ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ImageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'image_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_image`")
        # verify the required parameter 'image_id' is set
        if ('image_id' not in params) or (params['image_id'] is None):
            raise ValueError("Missing the required parameter `image_id` when calling `get_image`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'image_id' in params:
            path_params['imageId'] = params['image_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/images/{imageId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ImageResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_image_extract_as_gif(self, name, image_id, **kwargs):
        """
        Extract document image in GIF format
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_image_extract_as_gif(name, image_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str image_id: Image ID. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_image_extract_as_gif_with_http_info(name, image_id, **kwargs)
        else:
            (data) = self.get_image_extract_as_gif_with_http_info(name, image_id, **kwargs)
            return data

    def get_image_extract_as_gif_with_http_info(self, name, image_id, **kwargs):
        """
        Extract document image in GIF format
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_image_extract_as_gif_with_http_info(name, image_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str image_id: Image ID. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'image_id', 'width', 'height', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_image_extract_as_gif" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_image_extract_as_gif`")
        # verify the required parameter 'image_id' is set
        if ('image_id' not in params) or (params['image_id'] is None):
            raise ValueError("Missing the required parameter `image_id` when calling `get_image_extract_as_gif`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'image_id' in params:
            path_params['imageId'] = params['image_id']

        query_params = []
        if 'width' in params:
            query_params.append(('width', params['width']))
        if 'height' in params:
            query_params.append(('height', params['height']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/images/{imageId}/extract/gif', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_image_extract_as_jpeg(self, name, image_id, **kwargs):
        """
        Extract document image in JPEG format
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_image_extract_as_jpeg(name, image_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str image_id: Image ID. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_image_extract_as_jpeg_with_http_info(name, image_id, **kwargs)
        else:
            (data) = self.get_image_extract_as_jpeg_with_http_info(name, image_id, **kwargs)
            return data

    def get_image_extract_as_jpeg_with_http_info(self, name, image_id, **kwargs):
        """
        Extract document image in JPEG format
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_image_extract_as_jpeg_with_http_info(name, image_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str image_id: Image ID. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'image_id', 'width', 'height', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_image_extract_as_jpeg" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_image_extract_as_jpeg`")
        # verify the required parameter 'image_id' is set
        if ('image_id' not in params) or (params['image_id'] is None):
            raise ValueError("Missing the required parameter `image_id` when calling `get_image_extract_as_jpeg`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'image_id' in params:
            path_params['imageId'] = params['image_id']

        query_params = []
        if 'width' in params:
            query_params.append(('width', params['width']))
        if 'height' in params:
            query_params.append(('height', params['height']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/images/{imageId}/extract/jpeg', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_image_extract_as_png(self, name, image_id, **kwargs):
        """
        Extract document image in PNG format
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_image_extract_as_png(name, image_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str image_id: Image ID. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_image_extract_as_png_with_http_info(name, image_id, **kwargs)
        else:
            (data) = self.get_image_extract_as_png_with_http_info(name, image_id, **kwargs)
            return data

    def get_image_extract_as_png_with_http_info(self, name, image_id, **kwargs):
        """
        Extract document image in PNG format
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_image_extract_as_png_with_http_info(name, image_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str image_id: Image ID. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'image_id', 'width', 'height', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_image_extract_as_png" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_image_extract_as_png`")
        # verify the required parameter 'image_id' is set
        if ('image_id' not in params) or (params['image_id'] is None):
            raise ValueError("Missing the required parameter `image_id` when calling `get_image_extract_as_png`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'image_id' in params:
            path_params['imageId'] = params['image_id']

        query_params = []
        if 'width' in params:
            query_params.append(('width', params['width']))
        if 'height' in params:
            query_params.append(('height', params['height']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/images/{imageId}/extract/png', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_image_extract_as_tiff(self, name, image_id, **kwargs):
        """
        Extract document image in TIFF format
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_image_extract_as_tiff(name, image_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str image_id: Image ID. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_image_extract_as_tiff_with_http_info(name, image_id, **kwargs)
        else:
            (data) = self.get_image_extract_as_tiff_with_http_info(name, image_id, **kwargs)
            return data

    def get_image_extract_as_tiff_with_http_info(self, name, image_id, **kwargs):
        """
        Extract document image in TIFF format
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_image_extract_as_tiff_with_http_info(name, image_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str image_id: Image ID. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'image_id', 'width', 'height', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_image_extract_as_tiff" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_image_extract_as_tiff`")
        # verify the required parameter 'image_id' is set
        if ('image_id' not in params) or (params['image_id'] is None):
            raise ValueError("Missing the required parameter `image_id` when calling `get_image_extract_as_tiff`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'image_id' in params:
            path_params['imageId'] = params['image_id']

        query_params = []
        if 'width' in params:
            query_params.append(('width', params['width']))
        if 'height' in params:
            query_params.append(('height', params['height']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/images/{imageId}/extract/tiff', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_images(self, name, page_number, **kwargs):
        """
        Read document images.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_images(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ImagesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_images_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_images_with_http_info(name, page_number, **kwargs)
            return data

    def get_images_with_http_info(self, name, page_number, **kwargs):
        """
        Read document images.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_images_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ImagesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_images" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_images`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_images`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/images', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ImagesResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_import_fields_from_fdf_in_storage(self, name, fdf_file_path, **kwargs):
        """
        Update fields from FDF file in storage.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_import_fields_from_fdf_in_storage(name, fdf_file_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str fdf_file_path: The Fdf file path. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_import_fields_from_fdf_in_storage_with_http_info(name, fdf_file_path, **kwargs)
        else:
            (data) = self.get_import_fields_from_fdf_in_storage_with_http_info(name, fdf_file_path, **kwargs)
            return data

    def get_import_fields_from_fdf_in_storage_with_http_info(self, name, fdf_file_path, **kwargs):
        """
        Update fields from FDF file in storage.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_import_fields_from_fdf_in_storage_with_http_info(name, fdf_file_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str fdf_file_path: The Fdf file path. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'fdf_file_path', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_import_fields_from_fdf_in_storage" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_import_fields_from_fdf_in_storage`")
        # verify the required parameter 'fdf_file_path' is set
        if ('fdf_file_path' not in params) or (params['fdf_file_path'] is None):
            raise ValueError("Missing the required parameter `fdf_file_path` when calling `get_import_fields_from_fdf_in_storage`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'fdf_file_path' in params:
            query_params.append(('fdfFilePath', params['fdf_file_path']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/import/fdf', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_import_fields_from_xfdf_in_storage(self, name, xfdf_file_path, **kwargs):
        """
        Update fields from XFDF file in storage.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_import_fields_from_xfdf_in_storage(name, xfdf_file_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str xfdf_file_path: The XFDF file path. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_import_fields_from_xfdf_in_storage_with_http_info(name, xfdf_file_path, **kwargs)
        else:
            (data) = self.get_import_fields_from_xfdf_in_storage_with_http_info(name, xfdf_file_path, **kwargs)
            return data

    def get_import_fields_from_xfdf_in_storage_with_http_info(self, name, xfdf_file_path, **kwargs):
        """
        Update fields from XFDF file in storage.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_import_fields_from_xfdf_in_storage_with_http_info(name, xfdf_file_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str xfdf_file_path: The XFDF file path. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'xfdf_file_path', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_import_fields_from_xfdf_in_storage" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_import_fields_from_xfdf_in_storage`")
        # verify the required parameter 'xfdf_file_path' is set
        if ('xfdf_file_path' not in params) or (params['xfdf_file_path'] is None):
            raise ValueError("Missing the required parameter `xfdf_file_path` when calling `get_import_fields_from_xfdf_in_storage`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'xfdf_file_path' in params:
            query_params.append(('xfdfFilePath', params['xfdf_file_path']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/import/xfdf', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_import_fields_from_xml_in_storage(self, name, xml_file_path, **kwargs):
        """
        Import from XML file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_import_fields_from_xml_in_storage(name, xml_file_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str xml_file_path: Full source filename (ex. /folder1/folder2/template.xml) (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_import_fields_from_xml_in_storage_with_http_info(name, xml_file_path, **kwargs)
        else:
            (data) = self.get_import_fields_from_xml_in_storage_with_http_info(name, xml_file_path, **kwargs)
            return data

    def get_import_fields_from_xml_in_storage_with_http_info(self, name, xml_file_path, **kwargs):
        """
        Import from XML file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_import_fields_from_xml_in_storage_with_http_info(name, xml_file_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str xml_file_path: Full source filename (ex. /folder1/folder2/template.xml) (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'xml_file_path', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_import_fields_from_xml_in_storage" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_import_fields_from_xml_in_storage`")
        # verify the required parameter 'xml_file_path' is set
        if ('xml_file_path' not in params) or (params['xml_file_path'] is None):
            raise ValueError("Missing the required parameter `xml_file_path` when calling `get_import_fields_from_xml_in_storage`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'xml_file_path' in params:
            query_params.append(('xmlFilePath', params['xml_file_path']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/import/xml', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_ink_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page ink annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_ink_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: InkAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_ink_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_ink_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_ink_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page ink annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_ink_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: InkAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ink_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_ink_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_ink_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/ink/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='InkAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_la_te_x_in_storage_to_pdf(self, src_path, **kwargs):
        """
        Convert TeX file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_la_te_x_in_storage_to_pdf(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.tex) (required)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_la_te_x_in_storage_to_pdf_with_http_info(src_path, **kwargs)
        else:
            (data) = self.get_la_te_x_in_storage_to_pdf_with_http_info(src_path, **kwargs)
            return data

    def get_la_te_x_in_storage_to_pdf_with_http_info(self, src_path, **kwargs):
        """
        Convert TeX file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_la_te_x_in_storage_to_pdf_with_http_info(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.tex) (required)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_la_te_x_in_storage_to_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `get_la_te_x_in_storage_to_pdf`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'src_path' in params:
            query_params.append(('srcPath', params['src_path']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/create/latex', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_line_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page line annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_line_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: LineAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_line_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_line_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_line_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page line annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_line_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: LineAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_line_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_line_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_line_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/line/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LineAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_link_annotation(self, name, link_id, **kwargs):
        """
        Read document link annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_link_annotation(name, link_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str link_id: The link ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: LinkAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_link_annotation_with_http_info(name, link_id, **kwargs)
        else:
            (data) = self.get_link_annotation_with_http_info(name, link_id, **kwargs)
            return data

    def get_link_annotation_with_http_info(self, name, link_id, **kwargs):
        """
        Read document link annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_link_annotation_with_http_info(name, link_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str link_id: The link ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: LinkAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'link_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_link_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_link_annotation`")
        # verify the required parameter 'link_id' is set
        if ('link_id' not in params) or (params['link_id'] is None):
            raise ValueError("Missing the required parameter `link_id` when calling `get_link_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'link_id' in params:
            path_params['linkId'] = params['link_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/links/{linkId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LinkAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_list_box_field(self, name, field_name, **kwargs):
        """
        Read document listbox field by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_list_box_field(name, field_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str field_name: The field name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ListBoxFieldResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_list_box_field_with_http_info(name, field_name, **kwargs)
        else:
            (data) = self.get_list_box_field_with_http_info(name, field_name, **kwargs)
            return data

    def get_list_box_field_with_http_info(self, name, field_name, **kwargs):
        """
        Read document listbox field by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_list_box_field_with_http_info(name, field_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str field_name: The field name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ListBoxFieldResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'field_name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_box_field" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_list_box_field`")
        # verify the required parameter 'field_name' is set
        if ('field_name' not in params) or (params['field_name'] is None):
            raise ValueError("Missing the required parameter `field_name` when calling `get_list_box_field`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'field_name' in params:
            path_params['fieldName'] = params['field_name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/fields/listbox/{fieldName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ListBoxFieldResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_markdown_in_storage_to_pdf(self, src_path, **kwargs):
        """
        Convert MD file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_markdown_in_storage_to_pdf(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.md) (required)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_markdown_in_storage_to_pdf_with_http_info(src_path, **kwargs)
        else:
            (data) = self.get_markdown_in_storage_to_pdf_with_http_info(src_path, **kwargs)
            return data

    def get_markdown_in_storage_to_pdf_with_http_info(self, src_path, **kwargs):
        """
        Convert MD file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_markdown_in_storage_to_pdf_with_http_info(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.md) (required)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_markdown_in_storage_to_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `get_markdown_in_storage_to_pdf`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'src_path' in params:
            query_params.append(('srcPath', params['src_path']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/create/markdown', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_mht_in_storage_to_pdf(self, src_path, **kwargs):
        """
        Convert MHT file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_mht_in_storage_to_pdf(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.mht) (required)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_mht_in_storage_to_pdf_with_http_info(src_path, **kwargs)
        else:
            (data) = self.get_mht_in_storage_to_pdf_with_http_info(src_path, **kwargs)
            return data

    def get_mht_in_storage_to_pdf_with_http_info(self, src_path, **kwargs):
        """
        Convert MHT file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_mht_in_storage_to_pdf_with_http_info(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.mht) (required)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mht_in_storage_to_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `get_mht_in_storage_to_pdf`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'src_path' in params:
            query_params.append(('srcPath', params['src_path']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/create/mht', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_movie_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page movie annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_movie_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: MovieAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_movie_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_movie_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_movie_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page movie annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_movie_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: MovieAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_movie_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_movie_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_movie_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/movie/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MovieAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page(self, name, page_number, **kwargs):
        """
        Read document page info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: DocumentPageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: DocumentPageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentPageResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_annotations(self, name, page_number, **kwargs):
        """
        Read document page annotations. Returns only FreeTextAnnotations, TextAnnotations, other annotations will implemented next releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AnnotationsInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page annotations. Returns only FreeTextAnnotations, TextAnnotations, other annotations will implemented next releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: AnnotationsInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AnnotationsInfoResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_caret_annotations(self, name, page_number, **kwargs):
        """
        Read document page caret annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_caret_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: CaretAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_caret_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_caret_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_caret_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page caret annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_caret_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: CaretAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_caret_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_caret_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_caret_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/caret', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CaretAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_check_box_fields(self, name, page_number, **kwargs):
        """
        Read document page checkbox fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_check_box_fields(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: CheckBoxFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_check_box_fields_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_check_box_fields_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_check_box_fields_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page checkbox fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_check_box_fields_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: CheckBoxFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_check_box_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_check_box_fields`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_check_box_fields`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/page/{pageNumber}/fields/checkbox', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CheckBoxFieldsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_circle_annotations(self, name, page_number, **kwargs):
        """
        Read document page circle annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_circle_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: CircleAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_circle_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_circle_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_circle_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page circle annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_circle_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: CircleAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_circle_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_circle_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_circle_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/circle', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CircleAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_combo_box_fields(self, name, page_number, **kwargs):
        """
        Read document page combobox fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_combo_box_fields(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ComboBoxFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_combo_box_fields_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_combo_box_fields_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_combo_box_fields_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page combobox fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_combo_box_fields_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ComboBoxFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_combo_box_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_combo_box_fields`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_combo_box_fields`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/page/{pageNumber}/fields/combobox', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ComboBoxFieldsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_convert_to_bmp(self, name, page_number, **kwargs):
        """
        Convert document page to Bmp image and return resulting file in response.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_convert_to_bmp(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_convert_to_bmp_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_convert_to_bmp_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_convert_to_bmp_with_http_info(self, name, page_number, **kwargs):
        """
        Convert document page to Bmp image and return resulting file in response.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_convert_to_bmp_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'width', 'height', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_convert_to_bmp" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_convert_to_bmp`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_convert_to_bmp`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'width' in params:
            query_params.append(('width', params['width']))
        if 'height' in params:
            query_params.append(('height', params['height']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/convert/bmp', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_convert_to_emf(self, name, page_number, **kwargs):
        """
        Convert document page to Emf image and return resulting file in response.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_convert_to_emf(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_convert_to_emf_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_convert_to_emf_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_convert_to_emf_with_http_info(self, name, page_number, **kwargs):
        """
        Convert document page to Emf image and return resulting file in response.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_convert_to_emf_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'width', 'height', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_convert_to_emf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_convert_to_emf`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_convert_to_emf`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'width' in params:
            query_params.append(('width', params['width']))
        if 'height' in params:
            query_params.append(('height', params['height']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/convert/emf', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_convert_to_gif(self, name, page_number, **kwargs):
        """
        Convert document page to Gif image and return resulting file in response.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_convert_to_gif(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_convert_to_gif_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_convert_to_gif_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_convert_to_gif_with_http_info(self, name, page_number, **kwargs):
        """
        Convert document page to Gif image and return resulting file in response.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_convert_to_gif_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'width', 'height', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_convert_to_gif" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_convert_to_gif`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_convert_to_gif`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'width' in params:
            query_params.append(('width', params['width']))
        if 'height' in params:
            query_params.append(('height', params['height']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/convert/gif', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_convert_to_jpeg(self, name, page_number, **kwargs):
        """
        Convert document page to Jpeg image and return resulting file in response.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_convert_to_jpeg(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_convert_to_jpeg_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_convert_to_jpeg_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_convert_to_jpeg_with_http_info(self, name, page_number, **kwargs):
        """
        Convert document page to Jpeg image and return resulting file in response.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_convert_to_jpeg_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'width', 'height', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_convert_to_jpeg" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_convert_to_jpeg`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_convert_to_jpeg`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'width' in params:
            query_params.append(('width', params['width']))
        if 'height' in params:
            query_params.append(('height', params['height']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/convert/jpeg', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_convert_to_png(self, name, page_number, **kwargs):
        """
        Convert document page to Png image and return resulting file in response.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_convert_to_png(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_convert_to_png_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_convert_to_png_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_convert_to_png_with_http_info(self, name, page_number, **kwargs):
        """
        Convert document page to Png image and return resulting file in response.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_convert_to_png_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'width', 'height', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_convert_to_png" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_convert_to_png`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_convert_to_png`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'width' in params:
            query_params.append(('width', params['width']))
        if 'height' in params:
            query_params.append(('height', params['height']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/convert/png', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_convert_to_tiff(self, name, page_number, **kwargs):
        """
        Convert document page to Tiff image  and return resulting file in response.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_convert_to_tiff(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_convert_to_tiff_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_convert_to_tiff_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_convert_to_tiff_with_http_info(self, name, page_number, **kwargs):
        """
        Convert document page to Tiff image  and return resulting file in response.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_convert_to_tiff_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param int width: The converted image width.
        :param int height: The converted image height.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'width', 'height', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_convert_to_tiff" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_convert_to_tiff`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_convert_to_tiff`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'width' in params:
            query_params.append(('width', params['width']))
        if 'height' in params:
            query_params.append(('height', params['height']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/convert/tiff', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_file_attachment_annotations(self, name, page_number, **kwargs):
        """
        Read document page FileAttachment annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_file_attachment_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: FileAttachmentAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_file_attachment_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_file_attachment_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_file_attachment_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page FileAttachment annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_file_attachment_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: FileAttachmentAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_file_attachment_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_file_attachment_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_file_attachment_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/fileattachment', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FileAttachmentAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_free_text_annotations(self, name, page_number, **kwargs):
        """
        Read document page free text annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_free_text_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: FreeTextAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_free_text_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_free_text_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_free_text_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page free text annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_free_text_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: FreeTextAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_free_text_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_free_text_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_free_text_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/freetext', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FreeTextAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_highlight_annotations(self, name, page_number, **kwargs):
        """
        Read document page highlight annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_highlight_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: HighlightAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_highlight_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_highlight_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_highlight_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page highlight annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_highlight_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: HighlightAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_highlight_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_highlight_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_highlight_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/highlight', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='HighlightAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_ink_annotations(self, name, page_number, **kwargs):
        """
        Read document page ink annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_ink_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: InkAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_ink_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_ink_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_ink_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page ink annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_ink_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: InkAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_ink_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_ink_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_ink_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/ink', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='InkAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_line_annotations(self, name, page_number, **kwargs):
        """
        Read document page line annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_line_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: LineAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_line_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_line_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_line_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page line annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_line_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: LineAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_line_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_line_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_line_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/line', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LineAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_link_annotation(self, name, page_number, link_id, **kwargs):
        """
        Read document page link annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_link_annotation(name, page_number, link_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str link_id: The link ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: LinkAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_link_annotation_with_http_info(name, page_number, link_id, **kwargs)
        else:
            (data) = self.get_page_link_annotation_with_http_info(name, page_number, link_id, **kwargs)
            return data

    def get_page_link_annotation_with_http_info(self, name, page_number, link_id, **kwargs):
        """
        Read document page link annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_link_annotation_with_http_info(name, page_number, link_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str link_id: The link ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: LinkAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'link_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_link_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_link_annotation`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_link_annotation`")
        # verify the required parameter 'link_id' is set
        if ('link_id' not in params) or (params['link_id'] is None):
            raise ValueError("Missing the required parameter `link_id` when calling `get_page_link_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']
        if 'link_id' in params:
            path_params['linkId'] = params['link_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/links/{linkId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LinkAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_link_annotations(self, name, page_number, **kwargs):
        """
        Read document page link annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_link_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: LinkAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_link_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_link_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_link_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page link annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_link_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: LinkAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_link_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_link_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_link_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/links', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LinkAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_list_box_fields(self, name, page_number, **kwargs):
        """
        Read document page listbox fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_list_box_fields(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ListBoxFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_list_box_fields_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_list_box_fields_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_list_box_fields_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page listbox fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_list_box_fields_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ListBoxFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_list_box_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_list_box_fields`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_list_box_fields`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/page/{pageNumber}/fields/listbox', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ListBoxFieldsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_movie_annotations(self, name, page_number, **kwargs):
        """
        Read document page movie annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_movie_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: MovieAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_movie_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_movie_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_movie_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page movie annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_movie_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: MovieAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_movie_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_movie_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_movie_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/movie', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MovieAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_poly_line_annotations(self, name, page_number, **kwargs):
        """
        Read document page polyline annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_poly_line_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PolyLineAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_poly_line_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_poly_line_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_poly_line_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page polyline annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_poly_line_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PolyLineAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_poly_line_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_poly_line_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_poly_line_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/polyline', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PolyLineAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_polygon_annotations(self, name, page_number, **kwargs):
        """
        Read document page polygon annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_polygon_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PolygonAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_polygon_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_polygon_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_polygon_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page polygon annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_polygon_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PolygonAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_polygon_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_polygon_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_polygon_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/polygon', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PolygonAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_popup_annotations(self, name, page_number, **kwargs):
        """
        Read document page popup annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_popup_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PopupAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_popup_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_popup_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_popup_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page popup annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_popup_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PopupAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_popup_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_popup_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_popup_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/popup', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PopupAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_radio_button_fields(self, name, page_number, **kwargs):
        """
        Read document page radiobutton fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_radio_button_fields(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: RadioButtonFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_radio_button_fields_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_radio_button_fields_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_radio_button_fields_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page radiobutton fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_radio_button_fields_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: RadioButtonFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_radio_button_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_radio_button_fields`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_radio_button_fields`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/page/{pageNumber}/fields/radiobutton', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RadioButtonFieldsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_redaction_annotations(self, name, page_number, **kwargs):
        """
        Read document page redaction annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_redaction_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: RedactionAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_redaction_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_redaction_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_redaction_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page redaction annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_redaction_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: RedactionAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_redaction_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_redaction_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_redaction_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/redaction', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RedactionAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_screen_annotations(self, name, page_number, **kwargs):
        """
        Read document page screen annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_screen_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ScreenAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_screen_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_screen_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_screen_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page screen annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_screen_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ScreenAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_screen_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_screen_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_screen_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/screen', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ScreenAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_signature_fields(self, name, page_number, **kwargs):
        """
        Read document page signature fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_signature_fields(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SignatureFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_signature_fields_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_signature_fields_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_signature_fields_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page signature fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_signature_fields_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SignatureFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_signature_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_signature_fields`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_signature_fields`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/page/{pageNumber}/fields/signature', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SignatureFieldsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_sound_annotations(self, name, page_number, **kwargs):
        """
        Read document page sound annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_sound_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SoundAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_sound_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_sound_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_sound_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page sound annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_sound_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SoundAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_sound_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_sound_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_sound_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/sound', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SoundAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_square_annotations(self, name, page_number, **kwargs):
        """
        Read document page square annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_square_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SquareAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_square_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_square_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_square_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page square annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_square_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SquareAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_square_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_square_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_square_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/square', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SquareAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_squiggly_annotations(self, name, page_number, **kwargs):
        """
        Read document page squiggly annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_squiggly_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SquigglyAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_squiggly_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_squiggly_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_squiggly_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page squiggly annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_squiggly_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SquigglyAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_squiggly_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_squiggly_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_squiggly_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/squiggly', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SquigglyAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_stamp_annotations(self, name, page_number, **kwargs):
        """
        Read document page stamp annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_stamp_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: StampAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_stamp_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_stamp_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_stamp_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page stamp annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_stamp_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: StampAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_stamp_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_stamp_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_stamp_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/stamp', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='StampAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_stamps(self, name, page_number, **kwargs):
        """
        Read page document stamps.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_stamps(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: StampsInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_stamps_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_stamps_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_stamps_with_http_info(self, name, page_number, **kwargs):
        """
        Read page document stamps.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_stamps_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: StampsInfoResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_stamps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_stamps`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_stamps`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/stamps', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='StampsInfoResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_strike_out_annotations(self, name, page_number, **kwargs):
        """
        Read document page StrikeOut annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_strike_out_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: StrikeOutAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_strike_out_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_strike_out_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_strike_out_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page StrikeOut annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_strike_out_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: StrikeOutAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_strike_out_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_strike_out_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_strike_out_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/strikeout', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='StrikeOutAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_tables(self, name, page_number, **kwargs):
        """
        Read document page tables.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_tables(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param int page_number: (required)
        :param str storage:
        :param str folder:
        :return: TablesRecognizedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_tables_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_tables_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_tables_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page tables.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_tables_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param int page_number: (required)
        :param str storage:
        :param str folder:
        :return: TablesRecognizedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_tables" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_tables`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_tables`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/tables', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TablesRecognizedResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_text(self, name, page_number, llx, lly, urx, ury, **kwargs):
        """
        Read page text items.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_text(name, page_number, llx, lly, urx, ury, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: Number of page (starting from 1). (required)
        :param float llx: X-coordinate of lower - left corner. (required)
        :param float lly: Y - coordinate of lower-left corner. (required)
        :param float urx: X - coordinate of upper-right corner. (required)
        :param float ury: Y - coordinate of upper-right corner. (required)
        :param list[str] format: List of formats for search.
        :param str regex: Formats are specified as a regular expression.
        :param bool split_rects: Split result fragments (default is true).
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: TextRectsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_text_with_http_info(name, page_number, llx, lly, urx, ury, **kwargs)
        else:
            (data) = self.get_page_text_with_http_info(name, page_number, llx, lly, urx, ury, **kwargs)
            return data

    def get_page_text_with_http_info(self, name, page_number, llx, lly, urx, ury, **kwargs):
        """
        Read page text items.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_text_with_http_info(name, page_number, llx, lly, urx, ury, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: Number of page (starting from 1). (required)
        :param float llx: X-coordinate of lower - left corner. (required)
        :param float lly: Y - coordinate of lower-left corner. (required)
        :param float urx: X - coordinate of upper-right corner. (required)
        :param float ury: Y - coordinate of upper-right corner. (required)
        :param list[str] format: List of formats for search.
        :param str regex: Formats are specified as a regular expression.
        :param bool split_rects: Split result fragments (default is true).
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: TextRectsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'llx', 'lly', 'urx', 'ury', 'format', 'regex', 'split_rects', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_text" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_text`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_text`")
        # verify the required parameter 'llx' is set
        if ('llx' not in params) or (params['llx'] is None):
            raise ValueError("Missing the required parameter `llx` when calling `get_page_text`")
        # verify the required parameter 'lly' is set
        if ('lly' not in params) or (params['lly'] is None):
            raise ValueError("Missing the required parameter `lly` when calling `get_page_text`")
        # verify the required parameter 'urx' is set
        if ('urx' not in params) or (params['urx'] is None):
            raise ValueError("Missing the required parameter `urx` when calling `get_page_text`")
        # verify the required parameter 'ury' is set
        if ('ury' not in params) or (params['ury'] is None):
            raise ValueError("Missing the required parameter `ury` when calling `get_page_text`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))
            collection_formats['format'] = 'csv'
        if 'regex' in params:
            query_params.append(('regex', params['regex']))
        if 'split_rects' in params:
            query_params.append(('splitRects', params['split_rects']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'llx' in params:
            query_params.append(('LLX', params['llx']))
        if 'lly' in params:
            query_params.append(('LLY', params['lly']))
        if 'urx' in params:
            query_params.append(('URX', params['urx']))
        if 'ury' in params:
            query_params.append(('URY', params['ury']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/text', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TextRectsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_text_annotations(self, name, page_number, **kwargs):
        """
        Read document page text annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_text_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: TextAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_text_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_text_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_text_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page text annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_text_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: TextAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_text_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_text_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_text_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/text', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TextAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_text_box_fields(self, name, page_number, **kwargs):
        """
        Read document page text box fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_text_box_fields(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: TextBoxFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_text_box_fields_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_text_box_fields_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_text_box_fields_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page text box fields.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_text_box_fields_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: TextBoxFieldsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_text_box_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_text_box_fields`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_text_box_fields`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/page/{pageNumber}/fields/textbox', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TextBoxFieldsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_page_underline_annotations(self, name, page_number, **kwargs):
        """
        Read document page underline annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_underline_annotations(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: UnderlineAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_page_underline_annotations_with_http_info(name, page_number, **kwargs)
        else:
            (data) = self.get_page_underline_annotations_with_http_info(name, page_number, **kwargs)
            return data

    def get_page_underline_annotations_with_http_info(self, name, page_number, **kwargs):
        """
        Read document page underline annotations.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_page_underline_annotations_with_http_info(name, page_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int page_number: The page number. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: UnderlineAnnotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_page_underline_annotations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_page_underline_annotations`")
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params) or (params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_page_underline_annotations`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'page_number' in params:
            path_params['pageNumber'] = params['page_number']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/{pageNumber}/annotations/underline', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='UnderlineAnnotationsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pages(self, name, **kwargs):
        """
        Read document pages info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pages(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: DocumentPagesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pages_with_http_info(name, **kwargs)
        else:
            (data) = self.get_pages_with_http_info(name, **kwargs)
            return data

    def get_pages_with_http_info(self, name, **kwargs):
        """
        Read document pages info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pages_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: DocumentPagesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_pages`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DocumentPagesResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pcl_in_storage_to_pdf(self, src_path, **kwargs):
        """
        Convert PCL file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pcl_in_storage_to_pdf(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.pcl) (required)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pcl_in_storage_to_pdf_with_http_info(src_path, **kwargs)
        else:
            (data) = self.get_pcl_in_storage_to_pdf_with_http_info(src_path, **kwargs)
            return data

    def get_pcl_in_storage_to_pdf_with_http_info(self, src_path, **kwargs):
        """
        Convert PCL file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pcl_in_storage_to_pdf_with_http_info(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.pcl) (required)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pcl_in_storage_to_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `get_pcl_in_storage_to_pdf`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'src_path' in params:
            query_params.append(('srcPath', params['src_path']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/create/pcl', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pdf_a_in_storage_to_pdf(self, src_path, **kwargs):
        """
        Convert PDFA file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_a_in_storage_to_pdf(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.pdf) (required)
        :param bool dont_optimize: If set, document resources will not be optimized.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pdf_a_in_storage_to_pdf_with_http_info(src_path, **kwargs)
        else:
            (data) = self.get_pdf_a_in_storage_to_pdf_with_http_info(src_path, **kwargs)
            return data

    def get_pdf_a_in_storage_to_pdf_with_http_info(self, src_path, **kwargs):
        """
        Convert PDFA file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_a_in_storage_to_pdf_with_http_info(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.pdf) (required)
        :param bool dont_optimize: If set, document resources will not be optimized.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'dont_optimize', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pdf_a_in_storage_to_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `get_pdf_a_in_storage_to_pdf`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'src_path' in params:
            query_params.append(('srcPath', params['src_path']))
        if 'dont_optimize' in params:
            query_params.append(('dontOptimize', params['dont_optimize']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/create/pdfa', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pdf_in_storage_to_doc(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to DOC format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_doc(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param bool add_return_to_line_end: Add return to line end.
        :param str format: Allows to specify .doc or .docx file format.
        :param int image_resolution_x: Image resolution X.
        :param int image_resolution_y: Image resolution Y.
        :param float max_distance_between_text_lines: Max distance between text lines.
        :param str mode: Allows to control how a PDF document is converted into a word processing document.
        :param bool recognize_bullets: Recognize bullets.
        :param float relative_horizontal_proximity: Relative horizontal proximity.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pdf_in_storage_to_doc_with_http_info(name, **kwargs)
        else:
            (data) = self.get_pdf_in_storage_to_doc_with_http_info(name, **kwargs)
            return data

    def get_pdf_in_storage_to_doc_with_http_info(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to DOC format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_doc_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param bool add_return_to_line_end: Add return to line end.
        :param str format: Allows to specify .doc or .docx file format.
        :param int image_resolution_x: Image resolution X.
        :param int image_resolution_y: Image resolution Y.
        :param float max_distance_between_text_lines: Max distance between text lines.
        :param str mode: Allows to control how a PDF document is converted into a word processing document.
        :param bool recognize_bullets: Recognize bullets.
        :param float relative_horizontal_proximity: Relative horizontal proximity.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'add_return_to_line_end', 'format', 'image_resolution_x', 'image_resolution_y', 'max_distance_between_text_lines', 'mode', 'recognize_bullets', 'relative_horizontal_proximity', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pdf_in_storage_to_doc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_pdf_in_storage_to_doc`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'add_return_to_line_end' in params:
            query_params.append(('addReturnToLineEnd', params['add_return_to_line_end']))
        if 'format' in params:
            query_params.append(('format', params['format']))
        if 'image_resolution_x' in params:
            query_params.append(('imageResolutionX', params['image_resolution_x']))
        if 'image_resolution_y' in params:
            query_params.append(('imageResolutionY', params['image_resolution_y']))
        if 'max_distance_between_text_lines' in params:
            query_params.append(('maxDistanceBetweenTextLines', params['max_distance_between_text_lines']))
        if 'mode' in params:
            query_params.append(('mode', params['mode']))
        if 'recognize_bullets' in params:
            query_params.append(('recognizeBullets', params['recognize_bullets']))
        if 'relative_horizontal_proximity' in params:
            query_params.append(('relativeHorizontalProximity', params['relative_horizontal_proximity']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/convert/doc', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pdf_in_storage_to_epub(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to EPUB format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_epub(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str content_recognition_mode: Property tunes conversion for this or that desirable method of recognition of content.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pdf_in_storage_to_epub_with_http_info(name, **kwargs)
        else:
            (data) = self.get_pdf_in_storage_to_epub_with_http_info(name, **kwargs)
            return data

    def get_pdf_in_storage_to_epub_with_http_info(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to EPUB format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_epub_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str content_recognition_mode: Property tunes conversion for this or that desirable method of recognition of content.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'content_recognition_mode', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pdf_in_storage_to_epub" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_pdf_in_storage_to_epub`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'content_recognition_mode' in params:
            query_params.append(('contentRecognitionMode', params['content_recognition_mode']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/convert/epub', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pdf_in_storage_to_html(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to Html format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_html(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int additional_margin_width_in_points: Defines width of margin that will be forcibly left around that output HTML-areas.
        :param bool compress_svg_graphics_if_any: The flag that indicates whether found SVG graphics(if any) will be compressed(zipped) into SVGZ format during saving.
        :param bool convert_marked_content_to_layers: If attribute ConvertMarkedContentToLayers set to true then an all elements inside a PDF marked content (layer) will be put into an HTML div with \"data-pdflayer\" attribute specifying a layer name. This layer name will be extracted from optional properties of PDF marked content. If this attribute is false (by default) then no any layers will be created from PDF marked content.
        :param str default_font_name: Specifies the name of an installed font which is used to substitute any document font that is not embedded and not installed in the system. If null then default substitution font is used.
        :param str document_type: Result document type.
        :param bool fixed_layout: The value indicating whether that HTML is created as fixed layout.
        :param int image_resolution: Resolution for image rendering.
        :param int minimal_line_width: This attribute sets minimal width of graphic path line. If thickness of line is less than 1px Adobe Acrobat rounds it to this value. So this attribute can be used to emulate this behavior for HTML browsers.
        :param bool prevent_glyphs_grouping: This attribute switch on the mode when text glyphs will not be grouped into words and strings This mode allows to keep maximum precision during positioning of glyphs on the page and it can be used for conversion documents with music notes or glyphs that should be placed separately each other. This parameter will be applied to document only when the value of FixedLayout attribute is true.
        :param bool split_css_into_pages: When multipage-mode selected(i.e 'SplitIntoPages' is 'true'), then this attribute defines whether should be created separate CSS-file for each result HTML page.
        :param bool split_into_pages: The flag that indicates whether each page of source document will be converted into it's own target HTML document, i.e whether result HTML will be splitted into several HTML-pages.
        :param bool use_z_order: If attribute UseZORder set to true, graphics and text are added to resultant HTML document accordingly Z-order in original PDF document. If this attribute is false all graphics is put as single layer which may cause some unnecessary effects for overlapped objects.
        :param str antialiasing_processing: The parameter defines required antialiasing measures during conversion of compound background images from PDF to HTML.
        :param str css_class_names_prefix: When PDFtoHTML converter generates result CSSs, CSS class names (something like \".stl_01 {}\" ... \".stl_NN {}) are generated and used in result CSS. This property allows forcibly set class name prefix.
        :param list[int] explicit_list_of_saved_pages: With this property You can explicitely define what pages of document should be converted. Pages in this list must have 1-based numbers. I.e. valid numbers of pages must be taken from range (1...[NumberOfPagesInConvertedDocument]) Order of appearing of pages in this list does not affect their order in result HTML page(s) - in result pages allways will go in order in which they are present in source PDF.
        :param str font_encoding_strategy: Defines encoding special rule to tune PDF decoding for current document.
        :param str font_saving_mode: Defines font saving mode that will be used during saving of PDF to desirable format.
        :param str html_markup_generation_mode: Sometimes specific reqirments to generation of HTML markup are present. This parameter defines HTML preparing modes that can be used during conversion of PDF to HTML to match such specific requirments.
        :param str letters_positioning_method: The mode of positioning of letters in words in result HTML.
        :param bool pages_flow_type_depends_on_viewers_screen_size: If attribute 'SplitOnPages=false', than whole HTML representing all input PDF pages will be put into one big result HTML file. This flag defines whether result HTML will be generated in such way that flow of areas that represent PDF pages in result HTML will depend on screen resolution of viewer.
        :param str parts_embedding_mode: It defines whether referenced files (HTML, Fonts,Images, CSSes) will be embedded into main HTML file or will be generated as apart binary entities.
        :param str raster_images_saving_mode: Converted PDF can contain raster images This parameter defines how they should be handled during conversion of PDF to HTML.
        :param bool remove_empty_areas_on_top_and_bottom: Defines whether in created HTML will be removed top and bottom empty area without any content (if any).
        :param bool save_shadowed_texts_as_transparent_texts: Pdf can contain texts that are shadowed by another elements (f.e. by images) but can be selected to clipboard in Acrobat Reader (usually it happen when document contains images and OCRed texts extracted from it). This settings tells to converter whether we need save such texts as transparent selectable texts in result HTML to mimic behaviour of Acrobat Reader (othervise such texts are usually saved as hidden, not available for copying to clipboard).
        :param bool save_transparent_texts: Pdf can contain transparent texts that can be selected to clipboard (usually it happen when document contains images and OCRed texts extracted from it). This settings tells to converter whether we need save such texts as transparent selectable texts in result HTML.
        :param str special_folder_for_all_images: The path to directory to which must be saved any images if they are encountered during saving of document as HTML. If parameter is empty or null then image files(if any) wil be saved together with other files linked to HTML It does not affect anything if CustomImageSavingStrategy property was successfully used to process relevant image file.
        :param str special_folder_for_svg_images: The path to directory to which must be saved only SVG-images if they are encountered during saving of document as HTML. If parameter is empty or null then SVG files(if any) wil be saved together with other image-files (near to output file) or in special folder for images (if it specified in SpecialImagesFolderIfAny option). It does not affect anything if CustomImageSavingStrategy property was successfully used to process relevant image file.
        :param bool try_save_text_underlining_and_strikeouting_in_css: PDF itself does not contain underlining markers for texts. It emulated with line situated under text. This option allows converter try guess that this or that line is a text's underlining and put this info into CSS instead of drawing of underlining graphically.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :param bool flow_layout_paragraph_full_width: This attribute specifies full width paragraph text for Flow mode, FixedLayout = false.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pdf_in_storage_to_html_with_http_info(name, **kwargs)
        else:
            (data) = self.get_pdf_in_storage_to_html_with_http_info(name, **kwargs)
            return data

    def get_pdf_in_storage_to_html_with_http_info(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to Html format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_html_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param int additional_margin_width_in_points: Defines width of margin that will be forcibly left around that output HTML-areas.
        :param bool compress_svg_graphics_if_any: The flag that indicates whether found SVG graphics(if any) will be compressed(zipped) into SVGZ format during saving.
        :param bool convert_marked_content_to_layers: If attribute ConvertMarkedContentToLayers set to true then an all elements inside a PDF marked content (layer) will be put into an HTML div with \"data-pdflayer\" attribute specifying a layer name. This layer name will be extracted from optional properties of PDF marked content. If this attribute is false (by default) then no any layers will be created from PDF marked content.
        :param str default_font_name: Specifies the name of an installed font which is used to substitute any document font that is not embedded and not installed in the system. If null then default substitution font is used.
        :param str document_type: Result document type.
        :param bool fixed_layout: The value indicating whether that HTML is created as fixed layout.
        :param int image_resolution: Resolution for image rendering.
        :param int minimal_line_width: This attribute sets minimal width of graphic path line. If thickness of line is less than 1px Adobe Acrobat rounds it to this value. So this attribute can be used to emulate this behavior for HTML browsers.
        :param bool prevent_glyphs_grouping: This attribute switch on the mode when text glyphs will not be grouped into words and strings This mode allows to keep maximum precision during positioning of glyphs on the page and it can be used for conversion documents with music notes or glyphs that should be placed separately each other. This parameter will be applied to document only when the value of FixedLayout attribute is true.
        :param bool split_css_into_pages: When multipage-mode selected(i.e 'SplitIntoPages' is 'true'), then this attribute defines whether should be created separate CSS-file for each result HTML page.
        :param bool split_into_pages: The flag that indicates whether each page of source document will be converted into it's own target HTML document, i.e whether result HTML will be splitted into several HTML-pages.
        :param bool use_z_order: If attribute UseZORder set to true, graphics and text are added to resultant HTML document accordingly Z-order in original PDF document. If this attribute is false all graphics is put as single layer which may cause some unnecessary effects for overlapped objects.
        :param str antialiasing_processing: The parameter defines required antialiasing measures during conversion of compound background images from PDF to HTML.
        :param str css_class_names_prefix: When PDFtoHTML converter generates result CSSs, CSS class names (something like \".stl_01 {}\" ... \".stl_NN {}) are generated and used in result CSS. This property allows forcibly set class name prefix.
        :param list[int] explicit_list_of_saved_pages: With this property You can explicitely define what pages of document should be converted. Pages in this list must have 1-based numbers. I.e. valid numbers of pages must be taken from range (1...[NumberOfPagesInConvertedDocument]) Order of appearing of pages in this list does not affect their order in result HTML page(s) - in result pages allways will go in order in which they are present in source PDF.
        :param str font_encoding_strategy: Defines encoding special rule to tune PDF decoding for current document.
        :param str font_saving_mode: Defines font saving mode that will be used during saving of PDF to desirable format.
        :param str html_markup_generation_mode: Sometimes specific reqirments to generation of HTML markup are present. This parameter defines HTML preparing modes that can be used during conversion of PDF to HTML to match such specific requirments.
        :param str letters_positioning_method: The mode of positioning of letters in words in result HTML.
        :param bool pages_flow_type_depends_on_viewers_screen_size: If attribute 'SplitOnPages=false', than whole HTML representing all input PDF pages will be put into one big result HTML file. This flag defines whether result HTML will be generated in such way that flow of areas that represent PDF pages in result HTML will depend on screen resolution of viewer.
        :param str parts_embedding_mode: It defines whether referenced files (HTML, Fonts,Images, CSSes) will be embedded into main HTML file or will be generated as apart binary entities.
        :param str raster_images_saving_mode: Converted PDF can contain raster images This parameter defines how they should be handled during conversion of PDF to HTML.
        :param bool remove_empty_areas_on_top_and_bottom: Defines whether in created HTML will be removed top and bottom empty area without any content (if any).
        :param bool save_shadowed_texts_as_transparent_texts: Pdf can contain texts that are shadowed by another elements (f.e. by images) but can be selected to clipboard in Acrobat Reader (usually it happen when document contains images and OCRed texts extracted from it). This settings tells to converter whether we need save such texts as transparent selectable texts in result HTML to mimic behaviour of Acrobat Reader (othervise such texts are usually saved as hidden, not available for copying to clipboard).
        :param bool save_transparent_texts: Pdf can contain transparent texts that can be selected to clipboard (usually it happen when document contains images and OCRed texts extracted from it). This settings tells to converter whether we need save such texts as transparent selectable texts in result HTML.
        :param str special_folder_for_all_images: The path to directory to which must be saved any images if they are encountered during saving of document as HTML. If parameter is empty or null then image files(if any) wil be saved together with other files linked to HTML It does not affect anything if CustomImageSavingStrategy property was successfully used to process relevant image file.
        :param str special_folder_for_svg_images: The path to directory to which must be saved only SVG-images if they are encountered during saving of document as HTML. If parameter is empty or null then SVG files(if any) wil be saved together with other image-files (near to output file) or in special folder for images (if it specified in SpecialImagesFolderIfAny option). It does not affect anything if CustomImageSavingStrategy property was successfully used to process relevant image file.
        :param bool try_save_text_underlining_and_strikeouting_in_css: PDF itself does not contain underlining markers for texts. It emulated with line situated under text. This option allows converter try guess that this or that line is a text's underlining and put this info into CSS instead of drawing of underlining graphically.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :param bool flow_layout_paragraph_full_width: This attribute specifies full width paragraph text for Flow mode, FixedLayout = false.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'additional_margin_width_in_points', 'compress_svg_graphics_if_any', 'convert_marked_content_to_layers', 'default_font_name', 'document_type', 'fixed_layout', 'image_resolution', 'minimal_line_width', 'prevent_glyphs_grouping', 'split_css_into_pages', 'split_into_pages', 'use_z_order', 'antialiasing_processing', 'css_class_names_prefix', 'explicit_list_of_saved_pages', 'font_encoding_strategy', 'font_saving_mode', 'html_markup_generation_mode', 'letters_positioning_method', 'pages_flow_type_depends_on_viewers_screen_size', 'parts_embedding_mode', 'raster_images_saving_mode', 'remove_empty_areas_on_top_and_bottom', 'save_shadowed_texts_as_transparent_texts', 'save_transparent_texts', 'special_folder_for_all_images', 'special_folder_for_svg_images', 'try_save_text_underlining_and_strikeouting_in_css', 'folder', 'storage', 'flow_layout_paragraph_full_width']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pdf_in_storage_to_html" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_pdf_in_storage_to_html`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'additional_margin_width_in_points' in params:
            query_params.append(('additionalMarginWidthInPoints', params['additional_margin_width_in_points']))
        if 'compress_svg_graphics_if_any' in params:
            query_params.append(('compressSvgGraphicsIfAny', params['compress_svg_graphics_if_any']))
        if 'convert_marked_content_to_layers' in params:
            query_params.append(('convertMarkedContentToLayers', params['convert_marked_content_to_layers']))
        if 'default_font_name' in params:
            query_params.append(('defaultFontName', params['default_font_name']))
        if 'document_type' in params:
            query_params.append(('documentType', params['document_type']))
        if 'fixed_layout' in params:
            query_params.append(('fixedLayout', params['fixed_layout']))
        if 'image_resolution' in params:
            query_params.append(('imageResolution', params['image_resolution']))
        if 'minimal_line_width' in params:
            query_params.append(('minimalLineWidth', params['minimal_line_width']))
        if 'prevent_glyphs_grouping' in params:
            query_params.append(('preventGlyphsGrouping', params['prevent_glyphs_grouping']))
        if 'split_css_into_pages' in params:
            query_params.append(('splitCssIntoPages', params['split_css_into_pages']))
        if 'split_into_pages' in params:
            query_params.append(('splitIntoPages', params['split_into_pages']))
        if 'use_z_order' in params:
            query_params.append(('useZOrder', params['use_z_order']))
        if 'antialiasing_processing' in params:
            query_params.append(('antialiasingProcessing', params['antialiasing_processing']))
        if 'css_class_names_prefix' in params:
            query_params.append(('cssClassNamesPrefix', params['css_class_names_prefix']))
        if 'explicit_list_of_saved_pages' in params:
            query_params.append(('explicitListOfSavedPages', params['explicit_list_of_saved_pages']))
            collection_formats['explicitListOfSavedPages'] = 'csv'
        if 'font_encoding_strategy' in params:
            query_params.append(('fontEncodingStrategy', params['font_encoding_strategy']))
        if 'font_saving_mode' in params:
            query_params.append(('fontSavingMode', params['font_saving_mode']))
        if 'html_markup_generation_mode' in params:
            query_params.append(('htmlMarkupGenerationMode', params['html_markup_generation_mode']))
        if 'letters_positioning_method' in params:
            query_params.append(('lettersPositioningMethod', params['letters_positioning_method']))
        if 'pages_flow_type_depends_on_viewers_screen_size' in params:
            query_params.append(('pagesFlowTypeDependsOnViewersScreenSize', params['pages_flow_type_depends_on_viewers_screen_size']))
        if 'parts_embedding_mode' in params:
            query_params.append(('partsEmbeddingMode', params['parts_embedding_mode']))
        if 'raster_images_saving_mode' in params:
            query_params.append(('rasterImagesSavingMode', params['raster_images_saving_mode']))
        if 'remove_empty_areas_on_top_and_bottom' in params:
            query_params.append(('removeEmptyAreasOnTopAndBottom', params['remove_empty_areas_on_top_and_bottom']))
        if 'save_shadowed_texts_as_transparent_texts' in params:
            query_params.append(('saveShadowedTextsAsTransparentTexts', params['save_shadowed_texts_as_transparent_texts']))
        if 'save_transparent_texts' in params:
            query_params.append(('saveTransparentTexts', params['save_transparent_texts']))
        if 'special_folder_for_all_images' in params:
            query_params.append(('specialFolderForAllImages', params['special_folder_for_all_images']))
        if 'special_folder_for_svg_images' in params:
            query_params.append(('specialFolderForSvgImages', params['special_folder_for_svg_images']))
        if 'try_save_text_underlining_and_strikeouting_in_css' in params:
            query_params.append(('trySaveTextUnderliningAndStrikeoutingInCss', params['try_save_text_underlining_and_strikeouting_in_css']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'flow_layout_paragraph_full_width' in params:
            query_params.append(('flowLayoutParagraphFullWidth', params['flow_layout_paragraph_full_width']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/convert/html', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pdf_in_storage_to_la_te_x(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to TeX format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_la_te_x(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pdf_in_storage_to_la_te_x_with_http_info(name, **kwargs)
        else:
            (data) = self.get_pdf_in_storage_to_la_te_x_with_http_info(name, **kwargs)
            return data

    def get_pdf_in_storage_to_la_te_x_with_http_info(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to TeX format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_la_te_x_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pdf_in_storage_to_la_te_x" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_pdf_in_storage_to_la_te_x`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/convert/latex', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pdf_in_storage_to_mobi_xml(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to MOBIXML format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_mobi_xml(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pdf_in_storage_to_mobi_xml_with_http_info(name, **kwargs)
        else:
            (data) = self.get_pdf_in_storage_to_mobi_xml_with_http_info(name, **kwargs)
            return data

    def get_pdf_in_storage_to_mobi_xml_with_http_info(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to MOBIXML format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_mobi_xml_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pdf_in_storage_to_mobi_xml" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_pdf_in_storage_to_mobi_xml`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/convert/mobixml', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pdf_in_storage_to_pdf_a(self, name, type, **kwargs):
        """
        Converts PDF document (located on storage) to PdfA format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_pdf_a(name, type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str type: Type of PdfA format. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pdf_in_storage_to_pdf_a_with_http_info(name, type, **kwargs)
        else:
            (data) = self.get_pdf_in_storage_to_pdf_a_with_http_info(name, type, **kwargs)
            return data

    def get_pdf_in_storage_to_pdf_a_with_http_info(self, name, type, **kwargs):
        """
        Converts PDF document (located on storage) to PdfA format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_pdf_a_with_http_info(name, type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str type: Type of PdfA format. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'type', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pdf_in_storage_to_pdf_a" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_pdf_in_storage_to_pdf_a`")
        # verify the required parameter 'type' is set
        if ('type' not in params) or (params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `get_pdf_in_storage_to_pdf_a`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/convert/pdfa', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pdf_in_storage_to_pptx(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to PPTX format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_pptx(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param bool separate_images: Separate images.
        :param bool slides_as_images: Slides as images.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pdf_in_storage_to_pptx_with_http_info(name, **kwargs)
        else:
            (data) = self.get_pdf_in_storage_to_pptx_with_http_info(name, **kwargs)
            return data

    def get_pdf_in_storage_to_pptx_with_http_info(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to PPTX format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_pptx_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param bool separate_images: Separate images.
        :param bool slides_as_images: Slides as images.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'separate_images', 'slides_as_images', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pdf_in_storage_to_pptx" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_pdf_in_storage_to_pptx`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'separate_images' in params:
            query_params.append(('separateImages', params['separate_images']))
        if 'slides_as_images' in params:
            query_params.append(('slidesAsImages', params['slides_as_images']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/convert/pptx', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pdf_in_storage_to_svg(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to SVG format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_svg(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param bool compress_output_to_zip_archive: Specifies whether output will be created as one zip-archive.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pdf_in_storage_to_svg_with_http_info(name, **kwargs)
        else:
            (data) = self.get_pdf_in_storage_to_svg_with_http_info(name, **kwargs)
            return data

    def get_pdf_in_storage_to_svg_with_http_info(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to SVG format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_svg_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param bool compress_output_to_zip_archive: Specifies whether output will be created as one zip-archive.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'compress_output_to_zip_archive', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pdf_in_storage_to_svg" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_pdf_in_storage_to_svg`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'compress_output_to_zip_archive' in params:
            query_params.append(('compressOutputToZipArchive', params['compress_output_to_zip_archive']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/convert/svg', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pdf_in_storage_to_te_x(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to TeX format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_te_x(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pdf_in_storage_to_te_x_with_http_info(name, **kwargs)
        else:
            (data) = self.get_pdf_in_storage_to_te_x_with_http_info(name, **kwargs)
            return data

    def get_pdf_in_storage_to_te_x_with_http_info(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to TeX format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_te_x_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pdf_in_storage_to_te_x" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_pdf_in_storage_to_te_x`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/convert/tex', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pdf_in_storage_to_tiff(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to TIFF format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_tiff(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param float brightness: Image brightness.
        :param str compression: Tiff compression. Possible values are: LZW, CCITT4, CCITT3, RLE, None.
        :param str color_depth: Image color depth. Possible valuse are: Default, Format8bpp, Format4bpp, Format1bpp.
        :param int left_margin: Left image margin.
        :param int right_margin: Right image margin.
        :param int top_margin: Top image margin.
        :param int bottom_margin: Bottom image margin.
        :param str orientation: Image orientation. Possible values are: None, Landscape, Portait.
        :param bool skip_blank_pages: Skip blank pages flag.
        :param int width: Image width.
        :param int height: Image height.
        :param int x_resolution: Horizontal resolution.
        :param int y_resolution: Vertical resolution.
        :param int page_index: Start page to export.
        :param int page_count: Number of pages to export.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pdf_in_storage_to_tiff_with_http_info(name, **kwargs)
        else:
            (data) = self.get_pdf_in_storage_to_tiff_with_http_info(name, **kwargs)
            return data

    def get_pdf_in_storage_to_tiff_with_http_info(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to TIFF format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_tiff_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param float brightness: Image brightness.
        :param str compression: Tiff compression. Possible values are: LZW, CCITT4, CCITT3, RLE, None.
        :param str color_depth: Image color depth. Possible valuse are: Default, Format8bpp, Format4bpp, Format1bpp.
        :param int left_margin: Left image margin.
        :param int right_margin: Right image margin.
        :param int top_margin: Top image margin.
        :param int bottom_margin: Bottom image margin.
        :param str orientation: Image orientation. Possible values are: None, Landscape, Portait.
        :param bool skip_blank_pages: Skip blank pages flag.
        :param int width: Image width.
        :param int height: Image height.
        :param int x_resolution: Horizontal resolution.
        :param int y_resolution: Vertical resolution.
        :param int page_index: Start page to export.
        :param int page_count: Number of pages to export.
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'brightness', 'compression', 'color_depth', 'left_margin', 'right_margin', 'top_margin', 'bottom_margin', 'orientation', 'skip_blank_pages', 'width', 'height', 'x_resolution', 'y_resolution', 'page_index', 'page_count', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pdf_in_storage_to_tiff" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_pdf_in_storage_to_tiff`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'brightness' in params:
            query_params.append(('brightness', params['brightness']))
        if 'compression' in params:
            query_params.append(('compression', params['compression']))
        if 'color_depth' in params:
            query_params.append(('colorDepth', params['color_depth']))
        if 'left_margin' in params:
            query_params.append(('leftMargin', params['left_margin']))
        if 'right_margin' in params:
            query_params.append(('rightMargin', params['right_margin']))
        if 'top_margin' in params:
            query_params.append(('topMargin', params['top_margin']))
        if 'bottom_margin' in params:
            query_params.append(('bottomMargin', params['bottom_margin']))
        if 'orientation' in params:
            query_params.append(('orientation', params['orientation']))
        if 'skip_blank_pages' in params:
            query_params.append(('skipBlankPages', params['skip_blank_pages']))
        if 'width' in params:
            query_params.append(('width', params['width']))
        if 'height' in params:
            query_params.append(('height', params['height']))
        if 'x_resolution' in params:
            query_params.append(('xResolution', params['x_resolution']))
        if 'y_resolution' in params:
            query_params.append(('yResolution', params['y_resolution']))
        if 'page_index' in params:
            query_params.append(('pageIndex', params['page_index']))
        if 'page_count' in params:
            query_params.append(('pageCount', params['page_count']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/convert/tiff', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pdf_in_storage_to_xls(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to XLS format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_xls(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param bool insert_blank_column_at_first: Insert blank column at first
        :param bool minimize_the_number_of_worksheets: Minimize the number of worksheets
        :param float scale_factor: Scale factor
        :param bool uniform_worksheets: Uniform worksheets
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pdf_in_storage_to_xls_with_http_info(name, **kwargs)
        else:
            (data) = self.get_pdf_in_storage_to_xls_with_http_info(name, **kwargs)
            return data

    def get_pdf_in_storage_to_xls_with_http_info(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to XLS format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_xls_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param bool insert_blank_column_at_first: Insert blank column at first
        :param bool minimize_the_number_of_worksheets: Minimize the number of worksheets
        :param float scale_factor: Scale factor
        :param bool uniform_worksheets: Uniform worksheets
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'insert_blank_column_at_first', 'minimize_the_number_of_worksheets', 'scale_factor', 'uniform_worksheets', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pdf_in_storage_to_xls" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_pdf_in_storage_to_xls`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'insert_blank_column_at_first' in params:
            query_params.append(('insertBlankColumnAtFirst', params['insert_blank_column_at_first']))
        if 'minimize_the_number_of_worksheets' in params:
            query_params.append(('minimizeTheNumberOfWorksheets', params['minimize_the_number_of_worksheets']))
        if 'scale_factor' in params:
            query_params.append(('scaleFactor', params['scale_factor']))
        if 'uniform_worksheets' in params:
            query_params.append(('uniformWorksheets', params['uniform_worksheets']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/convert/xls', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pdf_in_storage_to_xlsx(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to XLSX format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_xlsx(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param bool insert_blank_column_at_first: Insert blank column at first
        :param bool minimize_the_number_of_worksheets: Minimize the number of worksheets
        :param float scale_factor: Scale factor
        :param bool uniform_worksheets: Uniform worksheets
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pdf_in_storage_to_xlsx_with_http_info(name, **kwargs)
        else:
            (data) = self.get_pdf_in_storage_to_xlsx_with_http_info(name, **kwargs)
            return data

    def get_pdf_in_storage_to_xlsx_with_http_info(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to XLSX format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_xlsx_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param bool insert_blank_column_at_first: Insert blank column at first
        :param bool minimize_the_number_of_worksheets: Minimize the number of worksheets
        :param float scale_factor: Scale factor
        :param bool uniform_worksheets: Uniform worksheets
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'insert_blank_column_at_first', 'minimize_the_number_of_worksheets', 'scale_factor', 'uniform_worksheets', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pdf_in_storage_to_xlsx" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_pdf_in_storage_to_xlsx`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'insert_blank_column_at_first' in params:
            query_params.append(('insertBlankColumnAtFirst', params['insert_blank_column_at_first']))
        if 'minimize_the_number_of_worksheets' in params:
            query_params.append(('minimizeTheNumberOfWorksheets', params['minimize_the_number_of_worksheets']))
        if 'scale_factor' in params:
            query_params.append(('scaleFactor', params['scale_factor']))
        if 'uniform_worksheets' in params:
            query_params.append(('uniformWorksheets', params['uniform_worksheets']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/convert/xlsx', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pdf_in_storage_to_xml(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to XML format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_xml(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pdf_in_storage_to_xml_with_http_info(name, **kwargs)
        else:
            (data) = self.get_pdf_in_storage_to_xml_with_http_info(name, **kwargs)
            return data

    def get_pdf_in_storage_to_xml_with_http_info(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to XML format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_xml_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pdf_in_storage_to_xml" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_pdf_in_storage_to_xml`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/convert/xml', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_pdf_in_storage_to_xps(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to XPS format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_xps(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_pdf_in_storage_to_xps_with_http_info(name, **kwargs)
        else:
            (data) = self.get_pdf_in_storage_to_xps_with_http_info(name, **kwargs)
            return data

    def get_pdf_in_storage_to_xps_with_http_info(self, name, **kwargs):
        """
        Converts PDF document (located on storage) to XPS format and returns resulting file in response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_pdf_in_storage_to_xps_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pdf_in_storage_to_xps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_pdf_in_storage_to_xps`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/convert/xps', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_poly_line_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page polyline annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_poly_line_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PolyLineAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_poly_line_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_poly_line_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_poly_line_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page polyline annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_poly_line_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PolyLineAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_poly_line_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_poly_line_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_poly_line_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/polyline/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PolyLineAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_polygon_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page polygon annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_polygon_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PolygonAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_polygon_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_polygon_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_polygon_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page polygon annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_polygon_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PolygonAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_polygon_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_polygon_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_polygon_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/polygon/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PolygonAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_popup_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page popup annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_popup_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PopupAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_popup_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_popup_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_popup_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page popup annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_popup_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: PopupAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_popup_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_popup_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_popup_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/popup/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PopupAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_ps_in_storage_to_pdf(self, src_path, **kwargs):
        """
        Convert PS file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_ps_in_storage_to_pdf(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.ps) (required)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_ps_in_storage_to_pdf_with_http_info(src_path, **kwargs)
        else:
            (data) = self.get_ps_in_storage_to_pdf_with_http_info(src_path, **kwargs)
            return data

    def get_ps_in_storage_to_pdf_with_http_info(self, src_path, **kwargs):
        """
        Convert PS file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_ps_in_storage_to_pdf_with_http_info(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.ps) (required)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ps_in_storage_to_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `get_ps_in_storage_to_pdf`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'src_path' in params:
            query_params.append(('srcPath', params['src_path']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/create/ps', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_radio_button_field(self, name, field_name, **kwargs):
        """
        Read document RadioButton field by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_radio_button_field(name, field_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str field_name: The field name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: RadioButtonFieldResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_radio_button_field_with_http_info(name, field_name, **kwargs)
        else:
            (data) = self.get_radio_button_field_with_http_info(name, field_name, **kwargs)
            return data

    def get_radio_button_field_with_http_info(self, name, field_name, **kwargs):
        """
        Read document RadioButton field by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_radio_button_field_with_http_info(name, field_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str field_name: The field name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: RadioButtonFieldResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'field_name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_radio_button_field" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_radio_button_field`")
        # verify the required parameter 'field_name' is set
        if ('field_name' not in params) or (params['field_name'] is None):
            raise ValueError("Missing the required parameter `field_name` when calling `get_radio_button_field`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'field_name' in params:
            path_params['fieldName'] = params['field_name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/fields/radiobutton/{fieldName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RadioButtonFieldResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_redaction_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page redaction annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_redaction_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: RedactionAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_redaction_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_redaction_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_redaction_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page redaction annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_redaction_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: RedactionAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_redaction_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_redaction_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_redaction_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/redaction/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RedactionAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_screen_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page screen annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_screen_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ScreenAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_screen_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_screen_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_screen_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page screen annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_screen_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: ScreenAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_screen_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_screen_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_screen_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/screen/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ScreenAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_screen_annotation_data(self, name, annotation_id, **kwargs):
        """
        Read document page screen annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_screen_annotation_data(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_screen_annotation_data_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_screen_annotation_data_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_screen_annotation_data_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page screen annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_screen_annotation_data_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_screen_annotation_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_screen_annotation_data`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_screen_annotation_data`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/screen/{annotationId}/data', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_signature_field(self, name, field_name, **kwargs):
        """
        Read document signature field by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_signature_field(name, field_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str field_name: The field name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SignatureFieldResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_signature_field_with_http_info(name, field_name, **kwargs)
        else:
            (data) = self.get_signature_field_with_http_info(name, field_name, **kwargs)
            return data

    def get_signature_field_with_http_info(self, name, field_name, **kwargs):
        """
        Read document signature field by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_signature_field_with_http_info(name, field_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str field_name: The field name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SignatureFieldResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'field_name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_signature_field" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_signature_field`")
        # verify the required parameter 'field_name' is set
        if ('field_name' not in params) or (params['field_name'] is None):
            raise ValueError("Missing the required parameter `field_name` when calling `get_signature_field`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'field_name' in params:
            path_params['fieldName'] = params['field_name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/fields/signature/{fieldName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SignatureFieldResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_sound_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page sound annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_sound_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SoundAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_sound_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_sound_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_sound_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page sound annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_sound_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SoundAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sound_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_sound_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_sound_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/sound/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SoundAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_sound_annotation_data(self, name, annotation_id, **kwargs):
        """
        Read document page sound annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_sound_annotation_data(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_sound_annotation_data_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_sound_annotation_data_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_sound_annotation_data_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page sound annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_sound_annotation_data_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sound_annotation_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_sound_annotation_data`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_sound_annotation_data`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/sound/{annotationId}/data', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_square_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page square annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_square_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SquareAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_square_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_square_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_square_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page square annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_square_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SquareAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_square_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_square_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_square_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/square/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SquareAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_squiggly_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page squiggly annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_squiggly_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SquigglyAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_squiggly_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_squiggly_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_squiggly_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page squiggly annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_squiggly_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SquigglyAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_squiggly_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_squiggly_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_squiggly_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/squiggly/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SquigglyAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_stamp_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page stamp annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_stamp_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: StampAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_stamp_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_stamp_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_stamp_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page stamp annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_stamp_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: StampAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stamp_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_stamp_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_stamp_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/stamp/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='StampAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_stamp_annotation_data(self, name, annotation_id, **kwargs):
        """
        Read document page stamp annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_stamp_annotation_data(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_stamp_annotation_data_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_stamp_annotation_data_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_stamp_annotation_data_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page stamp annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_stamp_annotation_data_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stamp_annotation_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_stamp_annotation_data`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_stamp_annotation_data`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/stamp/{annotationId}/data', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_strike_out_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page StrikeOut annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_strike_out_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: StrikeOutAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_strike_out_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_strike_out_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_strike_out_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page StrikeOut annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_strike_out_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: StrikeOutAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_strike_out_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_strike_out_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_strike_out_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/strikeout/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='StrikeOutAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_svg_in_storage_to_pdf(self, src_path, **kwargs):
        """
        Convert SVG file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_svg_in_storage_to_pdf(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.svg) (required)
        :param bool adjust_page_size: Adjust page size
        :param float height: Page height
        :param float width: Page width
        :param bool is_landscape: Is page landscaped
        :param float margin_left: Page margin left
        :param float margin_bottom: Page margin bottom
        :param float margin_right: Page margin right
        :param float margin_top: Page margin top
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_svg_in_storage_to_pdf_with_http_info(src_path, **kwargs)
        else:
            (data) = self.get_svg_in_storage_to_pdf_with_http_info(src_path, **kwargs)
            return data

    def get_svg_in_storage_to_pdf_with_http_info(self, src_path, **kwargs):
        """
        Convert SVG file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_svg_in_storage_to_pdf_with_http_info(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.svg) (required)
        :param bool adjust_page_size: Adjust page size
        :param float height: Page height
        :param float width: Page width
        :param bool is_landscape: Is page landscaped
        :param float margin_left: Page margin left
        :param float margin_bottom: Page margin bottom
        :param float margin_right: Page margin right
        :param float margin_top: Page margin top
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'adjust_page_size', 'height', 'width', 'is_landscape', 'margin_left', 'margin_bottom', 'margin_right', 'margin_top', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_svg_in_storage_to_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `get_svg_in_storage_to_pdf`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'src_path' in params:
            query_params.append(('srcPath', params['src_path']))
        if 'adjust_page_size' in params:
            query_params.append(('adjustPageSize', params['adjust_page_size']))
        if 'height' in params:
            query_params.append(('height', params['height']))
        if 'width' in params:
            query_params.append(('width', params['width']))
        if 'is_landscape' in params:
            query_params.append(('isLandscape', params['is_landscape']))
        if 'margin_left' in params:
            query_params.append(('marginLeft', params['margin_left']))
        if 'margin_bottom' in params:
            query_params.append(('marginBottom', params['margin_bottom']))
        if 'margin_right' in params:
            query_params.append(('marginRight', params['margin_right']))
        if 'margin_top' in params:
            query_params.append(('marginTop', params['margin_top']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/create/svg', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_table(self, name, table_id, **kwargs):
        """
        Read document page table by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_table(name, table_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str table_id: The table ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: TableRecognizedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_table_with_http_info(name, table_id, **kwargs)
        else:
            (data) = self.get_table_with_http_info(name, table_id, **kwargs)
            return data

    def get_table_with_http_info(self, name, table_id, **kwargs):
        """
        Read document page table by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_table_with_http_info(name, table_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str table_id: The table ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: TableRecognizedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'table_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_table`")
        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `get_table`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/tables/{tableId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TableRecognizedResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_te_x_in_storage_to_pdf(self, src_path, **kwargs):
        """
        Convert TeX file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_te_x_in_storage_to_pdf(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.tex) (required)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_te_x_in_storage_to_pdf_with_http_info(src_path, **kwargs)
        else:
            (data) = self.get_te_x_in_storage_to_pdf_with_http_info(src_path, **kwargs)
            return data

    def get_te_x_in_storage_to_pdf_with_http_info(self, src_path, **kwargs):
        """
        Convert TeX file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_te_x_in_storage_to_pdf_with_http_info(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.tex) (required)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_te_x_in_storage_to_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `get_te_x_in_storage_to_pdf`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'src_path' in params:
            query_params.append(('srcPath', params['src_path']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/create/tex', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_text(self, name, llx, lly, urx, ury, **kwargs):
        """
        Read document text.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_text(name, llx, lly, urx, ury, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param float llx: X-coordinate of lower - left corner. (required)
        :param float lly: Y - coordinate of lower-left corner. (required)
        :param float urx: X - coordinate of upper-right corner. (required)
        :param float ury: Y - coordinate of upper-right corner. (required)
        :param list[str] format: List of formats for search.
        :param str regex: Formats are specified as a regular expression.
        :param bool split_rects: Split result fragments (default is true).
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: TextRectsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_text_with_http_info(name, llx, lly, urx, ury, **kwargs)
        else:
            (data) = self.get_text_with_http_info(name, llx, lly, urx, ury, **kwargs)
            return data

    def get_text_with_http_info(self, name, llx, lly, urx, ury, **kwargs):
        """
        Read document text.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_text_with_http_info(name, llx, lly, urx, ury, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param float llx: X-coordinate of lower - left corner. (required)
        :param float lly: Y - coordinate of lower-left corner. (required)
        :param float urx: X - coordinate of upper-right corner. (required)
        :param float ury: Y - coordinate of upper-right corner. (required)
        :param list[str] format: List of formats for search.
        :param str regex: Formats are specified as a regular expression.
        :param bool split_rects: Split result fragments (default is true).
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: TextRectsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'llx', 'lly', 'urx', 'ury', 'format', 'regex', 'split_rects', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_text" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_text`")
        # verify the required parameter 'llx' is set
        if ('llx' not in params) or (params['llx'] is None):
            raise ValueError("Missing the required parameter `llx` when calling `get_text`")
        # verify the required parameter 'lly' is set
        if ('lly' not in params) or (params['lly'] is None):
            raise ValueError("Missing the required parameter `lly` when calling `get_text`")
        # verify the required parameter 'urx' is set
        if ('urx' not in params) or (params['urx'] is None):
            raise ValueError("Missing the required parameter `urx` when calling `get_text`")
        # verify the required parameter 'ury' is set
        if ('ury' not in params) or (params['ury'] is None):
            raise ValueError("Missing the required parameter `ury` when calling `get_text`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))
            collection_formats['format'] = 'csv'
        if 'regex' in params:
            query_params.append(('regex', params['regex']))
        if 'split_rects' in params:
            query_params.append(('splitRects', params['split_rects']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'llx' in params:
            query_params.append(('LLX', params['llx']))
        if 'lly' in params:
            query_params.append(('LLY', params['lly']))
        if 'urx' in params:
            query_params.append(('URX', params['urx']))
        if 'ury' in params:
            query_params.append(('URY', params['ury']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/text', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TextRectsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_text_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page text annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_text_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: TextAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_text_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_text_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_text_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page text annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_text_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: TextAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_text_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_text_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_text_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/text/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TextAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_text_box_field(self, name, field_name, **kwargs):
        """
        Read document text box field by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_text_box_field(name, field_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str field_name: The field name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: TextBoxFieldResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_text_box_field_with_http_info(name, field_name, **kwargs)
        else:
            (data) = self.get_text_box_field_with_http_info(name, field_name, **kwargs)
            return data

    def get_text_box_field_with_http_info(self, name, field_name, **kwargs):
        """
        Read document text box field by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_text_box_field_with_http_info(name, field_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str field_name: The field name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: TextBoxFieldResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'field_name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_text_box_field" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_text_box_field`")
        # verify the required parameter 'field_name' is set
        if ('field_name' not in params) or (params['field_name'] is None):
            raise ValueError("Missing the required parameter `field_name` when calling `get_text_box_field`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'field_name' in params:
            path_params['fieldName'] = params['field_name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/fields/textbox/{fieldName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TextBoxFieldResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_underline_annotation(self, name, annotation_id, **kwargs):
        """
        Read document page underline annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_underline_annotation(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: UnderlineAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_underline_annotation_with_http_info(name, annotation_id, **kwargs)
        else:
            (data) = self.get_underline_annotation_with_http_info(name, annotation_id, **kwargs)
            return data

    def get_underline_annotation_with_http_info(self, name, annotation_id, **kwargs):
        """
        Read document page underline annotation by ID.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_underline_annotation_with_http_info(name, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str annotation_id: The annotation ID. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: UnderlineAnnotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'annotation_id', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_underline_annotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_underline_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_underline_annotation`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/annotations/underline/{annotationId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='UnderlineAnnotationResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_verify_signature(self, name, sign_name, **kwargs):
        """
        Verify signature document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_verify_signature(name, sign_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str sign_name: Sign name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SignatureVerifyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_verify_signature_with_http_info(name, sign_name, **kwargs)
        else:
            (data) = self.get_verify_signature_with_http_info(name, sign_name, **kwargs)
            return data

    def get_verify_signature_with_http_info(self, name, sign_name, **kwargs):
        """
        Verify signature document.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_verify_signature_with_http_info(name, sign_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str sign_name: Sign name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: SignatureVerifyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sign_name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_verify_signature" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_verify_signature`")
        # verify the required parameter 'sign_name' is set
        if ('sign_name' not in params) or (params['sign_name'] is None):
            raise ValueError("Missing the required parameter `sign_name` when calling `get_verify_signature`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'sign_name' in params:
            query_params.append(('signName', params['sign_name']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/verifySignature', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SignatureVerifyResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_web_in_storage_to_pdf(self, url, **kwargs):
        """
        Convert web page to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_web_in_storage_to_pdf(url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str url: Source url (required)
        :param float height: Page height
        :param float width: Page width
        :param bool is_landscape: Is page landscaped
        :param float margin_left: Page margin left
        :param float margin_bottom: Page margin bottom
        :param float margin_right: Page margin right
        :param float margin_top: Page margin top
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_web_in_storage_to_pdf_with_http_info(url, **kwargs)
        else:
            (data) = self.get_web_in_storage_to_pdf_with_http_info(url, **kwargs)
            return data

    def get_web_in_storage_to_pdf_with_http_info(self, url, **kwargs):
        """
        Convert web page to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_web_in_storage_to_pdf_with_http_info(url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str url: Source url (required)
        :param float height: Page height
        :param float width: Page width
        :param bool is_landscape: Is page landscaped
        :param float margin_left: Page margin left
        :param float margin_bottom: Page margin bottom
        :param float margin_right: Page margin right
        :param float margin_top: Page margin top
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['url', 'height', 'width', 'is_landscape', 'margin_left', 'margin_bottom', 'margin_right', 'margin_top', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_web_in_storage_to_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'url' is set
        if ('url' not in params) or (params['url'] is None):
            raise ValueError("Missing the required parameter `url` when calling `get_web_in_storage_to_pdf`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'url' in params:
            query_params.append(('url', params['url']))
        if 'height' in params:
            query_params.append(('height', params['height']))
        if 'width' in params:
            query_params.append(('width', params['width']))
        if 'is_landscape' in params:
            query_params.append(('isLandscape', params['is_landscape']))
        if 'margin_left' in params:
            query_params.append(('marginLeft', params['margin_left']))
        if 'margin_bottom' in params:
            query_params.append(('marginBottom', params['margin_bottom']))
        if 'margin_right' in params:
            query_params.append(('marginRight', params['margin_right']))
        if 'margin_top' in params:
            query_params.append(('marginTop', params['margin_top']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/create/web', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_words_per_page(self, name, **kwargs):
        """
        Get number of words per document page.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_words_per_page(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: WordCountResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_words_per_page_with_http_info(name, **kwargs)
        else:
            (data) = self.get_words_per_page_with_http_info(name, **kwargs)
            return data

    def get_words_per_page_with_http_info(self, name, **kwargs):
        """
        Get number of words per document page.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_words_per_page_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str storage: The document storage.
        :param str folder: The document folder.
        :return: WordCountResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'storage', 'folder']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_words_per_page" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_words_per_page`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/pages/wordCount', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='WordCountResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_xfa_pdf_in_storage_to_acro_form(self, name, **kwargs):
        """
        Converts PDF document which contains XFA form (located on storage) to PDF with AcroForm and returns resulting file response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_xfa_pdf_in_storage_to_acro_form(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_xfa_pdf_in_storage_to_acro_form_with_http_info(name, **kwargs)
        else:
            (data) = self.get_xfa_pdf_in_storage_to_acro_form_with_http_info(name, **kwargs)
            return data

    def get_xfa_pdf_in_storage_to_acro_form_with_http_info(self, name, **kwargs):
        """
        Converts PDF document which contains XFA form (located on storage) to PDF with AcroForm and returns resulting file response content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_xfa_pdf_in_storage_to_acro_form_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_xfa_pdf_in_storage_to_acro_form" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_xfa_pdf_in_storage_to_acro_form`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/{name}/convert/xfatoacroform', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_xml_in_storage_to_pdf(self, src_path, **kwargs):
        """
        Convert XML file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_xml_in_storage_to_pdf(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.xml) (required)
        :param str xsl_file_path: Full XSL source filename (ex. /folder1/folder2/template.xsl)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_xml_in_storage_to_pdf_with_http_info(src_path, **kwargs)
        else:
            (data) = self.get_xml_in_storage_to_pdf_with_http_info(src_path, **kwargs)
            return data

    def get_xml_in_storage_to_pdf_with_http_info(self, src_path, **kwargs):
        """
        Convert XML file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_xml_in_storage_to_pdf_with_http_info(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.xml) (required)
        :param str xsl_file_path: Full XSL source filename (ex. /folder1/folder2/template.xsl)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'xsl_file_path', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_xml_in_storage_to_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `get_xml_in_storage_to_pdf`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'src_path' in params:
            query_params.append(('srcPath', params['src_path']))
        if 'xsl_file_path' in params:
            query_params.append(('xslFilePath', params['xsl_file_path']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/create/xml', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_xps_in_storage_to_pdf(self, src_path, **kwargs):
        """
        Convert XPS file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_xps_in_storage_to_pdf(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.xps) (required)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_xps_in_storage_to_pdf_with_http_info(src_path, **kwargs)
        else:
            (data) = self.get_xps_in_storage_to_pdf_with_http_info(src_path, **kwargs)
            return data

    def get_xps_in_storage_to_pdf_with_http_info(self, src_path, **kwargs):
        """
        Convert XPS file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_xps_in_storage_to_pdf_with_http_info(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.xps) (required)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_xps_in_storage_to_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `get_xps_in_storage_to_pdf`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'src_path' in params:
            query_params.append(('srcPath', params['src_path']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/create/xps', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_xsl_fo_in_storage_to_pdf(self, src_path, **kwargs):
        """
        Convert XslFo file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_xsl_fo_in_storage_to_pdf(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.xslfo) (required)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_xsl_fo_in_storage_to_pdf_with_http_info(src_path, **kwargs)
        else:
            (data) = self.get_xsl_fo_in_storage_to_pdf_with_http_info(src_path, **kwargs)
            return data

    def get_xsl_fo_in_storage_to_pdf_with_http_info(self, src_path, **kwargs):
        """
        Convert XslFo file (located on storage) to PDF format and return resulting file in response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_xsl_fo_in_storage_to_pdf_with_http_info(src_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Full source filename (ex. /folder1/folder2/template.xslfo) (required)
        :param str storage: The document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_xsl_fo_in_storage_to_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `get_xsl_fo_in_storage_to_pdf`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'src_path' in params:
            query_params.append(('srcPath', params['src_path']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/pdf/create/xslfo', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def move_file(self, src_path, dest_path, **kwargs):
        """
        Move file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.move_file(src_path, dest_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Source file path e.g. '/src.ext' (required)
        :param str dest_path: Destination file path e.g. '/dest.ext' (required)
        :param str src_storage_name: Source storage name
        :param str dest_storage_name: Destination storage name
        :param str version_id: File version ID to move
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.move_file_with_http_info(src_path, dest_path, **kwargs)
        else:
            (data) = self.move_file_with_http_info(src_path, dest_path, **kwargs)
            return data

    def move_file_with_http_info(self, src_path, dest_path, **kwargs):
        """
        Move file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.move_file_with_http_info(src_path, dest_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Source file path e.g. '/src.ext' (required)
        :param str dest_path: Destination file path e.g. '/dest.ext' (required)
        :param str src_storage_name: Source storage name
        :param str dest_storage_name: Destination storage name
        :param str version_id: File version ID to move
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'dest_path', 'src_storage_name', 'dest_storage_name', 'version_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is