SolutionSpaceScanner
==============================
[//]: # (Badges)
[![Build Status](https://travis-ci.org/holehouse-lab/solutionspacescanner.svg?branch=master)](https://travis-ci.org/holehouse-lab/solutionspacescanner)
[![Documentation Status](https://readthedocs.org/projects/solutionspacescanner/badge/?version=latest)](https://solutionspacescanner.readthedocs.io/en/latest/?badge=latest)
[![codecov](https://codecov.io/gh/holehouse-lab/solutionspacescanner/branch/master/graph/badge.svg)](https://codecov.io/gh/holehouse-lab/solutionspacescanner)
[![PyPI version](https://badge.fury.io/py/solutionspacescanner.svg)](https://badge.fury.io/py/solutionspacescanner)



**SolutionSpaceScanner** is a Python package implemented to generate ABSINTH parameter files that can be used for running solution space
scanning simulations.

**SolutionSpaceScanner** accompanies the paper [Controlling Structural Bias in Intrinsically Disordered Proteins Using Solution Space Scanning](https://pubs.acs.org/doi/pdf/10.1021/acs.jctc.9b00604) (Holehouse & Sukenik JCTC). 

**SolutionSpaceScanner** was developed by the [Holehouse](http://holehouselab.com) and [Sukenik](http://sukeniklab.com) labs.

### Installation

	pip install solutionspacescanner

### Documentation
Documentation (installation and usage) can [be found here](https://solutionspacescanner.readthedocs.io/en/latest/index.html).


### References
Holehouse, A. S. & Sukenik, S. Controlling Structural Bias in Intrinsically Disordered Proteins Using Solution Space Scanning. J. Chem. Theory Comput. 16, 1794–1805 (2020).

### Copyright

Copyright (c) 2017-2020, Alex S. Holehouse & Shahar Sukenik


#### Acknowledgements
 
Project based on the 
[Computational Molecular Science Python Cookiecutter](https://github.com/molssi/cookiecutter-cms) version 1.0. The development of **SolutionSpaceScanner** was supported by the [Molecular Sciences Software Insitute (MOLSSI)](https://molssi.org).
