import sys
from pathlib import Path

if sys.version_info < (3, 9):
    import importlib_resources
else:
    import importlib.resources as importlib_resources

from asdf.resource import DirectoryResourceMapping

import asdf_standard


def get_resource_mappings():
    resources_root = importlib_resources.files(asdf_standard) / "resources"
    if not resources_root.is_dir():
        # In an editable install, the resources directory will exist off the
        # repository root:
        resources_root = Path(__file__).absolute().parent.parent.parent / "resources"
        if not resources_root.is_dir():
            raise RuntimeError("Missing resources directory")

    return [
        DirectoryResourceMapping(resources_root / "schemas" / "stsci.edu", "http://stsci.edu/schemas/", recursive=True),
        DirectoryResourceMapping(
            resources_root / "schemas" / "asdf-format.org" / "core", "asdf://asdf-format.org/core/schemas/"
        ),
        DirectoryResourceMapping(
            resources_root / "manifests" / "asdf-format.org" / "core",
            "asdf://asdf-format.org/core/manifests/",
        ),
    ]
