# Distributed under the MIT software license, see the accompanying
# file LICENSE or http://www.opensource.org/licenses/mit-license.php.
from unittest import TestCase

from pyqrandomx.pyqrandomx import ThreadedQRandomX


class TestQRandomX(TestCase):
    def __init__(self, *args, **kwargs):
        super(TestQRandomX, self).__init__(*args, **kwargs)

    def test_init(self):
        qrx = ThreadedQRandomX()

    def test_hash(self):
        qrx = ThreadedQRandomX()

        main_height = 10
        seed_height = qrx.getSeedHeight(main_height)
        seed_hash = [
            0x2a, 0x1c, 0x4a, 0x94, 0x33, 0xf1, 0xde, 0x36,
            0xf8, 0xb9, 0x9c, 0x7c, 0x5a, 0xce, 0xb7, 0xbd,
            0x2e, 0xb3, 0x9e, 0x1e, 0xad, 0x64, 0x8e, 0xa5,
            0x82, 0x27, 0xd3, 0x99, 0xad, 0x84, 0xc7, 0x24
        ]

        input = [
            0x00, 0x9d, 0x6b, 0x07, 0x38, 0x20, 0xb0, 0x0a,
            0x5b, 0x60, 0xc7, 0x64, 0x6f, 0x3d, 0x30, 0x46,
            0xa3, 0x49, 0x49, 0xcd, 0x93, 0x9b, 0x2b, 0x52,
            0xb9, 0x9f, 0x1b, 0xb2, 0xde, 0x1f, 0x4c, 0x92,
            0x12, 0x7a, 0xe9, 0xe4, 0xc3, 0xe3, 0x9e, 0xe0,
            0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x58,
            0x22, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x54, 0xdb, 0x8c, 0x8e, 0xa6, 0x6f, 0xc0, 0x5b,
            0x1d, 0x12, 0x24, 0x25, 0x5a, 0x24, 0x70, 0x8e,
            0x5d, 0x67, 0x33, 0xdc
        ]
        output = qrx.hash(main_height, seed_height, seed_hash, input, 0)

        output_expected = (
            0x36, 0x15, 0x33, 0x94, 0xa3, 0xd9, 0x01, 0x0d,
            0xef, 0xae, 0x86, 0x31, 0xb9, 0xa6, 0xbb, 0x1f,
            0x9d, 0x62, 0x9d, 0x54, 0x8b, 0xc7, 0x3f, 0xbe,
            0x61, 0x2c, 0xfe, 0x6b, 0x08, 0xd7, 0xa2, 0x16
        )

        for i in output:
            print("0x{:02x}, ".format(i), sep='', end='')

        self.assertEqual(output_expected, output)
