# BALRoGO

[![pipeline status](https://gitlab.com/eduardo-vitral/balrogo/badges/master/pipeline.svg)](https://gitlab.com/eduardo-vitral/balrogo/-/commits/master)
[![coverage report](https://gitlab.com/eduardo-vitral/balrogo/badges/master/coverage.svg)](https://gitlab.com/eduardo-vitral/balrogo/-/commits/master)
[![pypi](https://img.shields.io/pypi/v/balrogo.svg)](https://pypi.python.org/pypi/balrogo/)
[![python](https://img.shields.io/pypi/pyversions/balrogo.svg)](https://pypi.python.org/pypi/balrogo)
[![license](http://img.shields.io/badge/license-MIT-blue.svg)](LICENSE)

<!-- markdownlint-disable-next-line no-inline-html -->
<img alt="logo" align="right" src="logo.png" width="20%" />

BALRoGO: Bayesian Astrometric Likelihood Recover of Galactic Objects.

- Specially developed to handle data from the Gaia space mission.
- Extracts galactic objects such as globular clusters and dwarf galaxies.
- Uses a combination of Bayesian and non-Bayesian approaches.
- Provides:
  - Fits of proper motion space.
  - Fits of surface density.
  - Fits of object center.
  - Confidence regions for the color-magnitude diagram and parallaxes.

If something does not work, please [file an issue](https://gitlab.com/eduardo-vitral/balrogo/-/issues).

## Attribution

Please cite [us](https://arxiv.org/abs/2010.05532) if you find this code useful in your research and add your paper to the testimonials list. The BibTeX entry for the paper is:

```bibtex
@ARTICLE{Vitral&Mamon20b,
       author = {{Vitral}, Eduardo and {Mamon}, Gary A.},
        title = "{Does NGC 6397 contain an intermediate-mass black hole or a more diffuse inner sub-cluster?}",
      journal = {arXiv e-prints},
     keywords = {Astrophysics - Astrophysics of Galaxies},
         year = 2020,
        month = oct,
          eid = {arXiv:2010.05532},
        pages = {arXiv:2010.05532},
archivePrefix = {arXiv},
       eprint = {2010.05532},
 primaryClass = {astro-ph.GA},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2020arXiv201005532V},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}
}
```

## Quick overview

To be written.

### Using BALRoGO on [*Gaia*](https://www.cosmos.esa.int/web/gaia/data-access) data

To be written.

## License

Copyright (c) 2020 Eduardo Vitral & Alexandre Macedo.

BALRoGO is free software made available under the [MIT License](LICENSE).
