# -*- coding: utf-8 -*-
#
# Copyright (C) 2008-2021 EDF R&D
#
# This file is part of SALOME ADAO module
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
#
# Author: Jean-Philippe Argaud, jean-philippe.argaud@edf.fr, EDF R&D

# --------------------------------------------------------
# Generated by AdaoCatalogGenerator on 2021-12-01 18:11:46
# --------------------------------------------------------

import os, re
import Accas
from Accas import *

JdC = JDC_CATA (
    code = 'ADAO',
    execmodul = None,
    regles = ( AU_MOINS_UN ('ASSIMILATION_STUDY','OPTIMIZATION_STUDY','REDUCTION_STUDY','CHECKING_STUDY'), AU_PLUS_UN ('ASSIMILATION_STUDY','OPTIMIZATION_STUDY','REDUCTION_STUDY','CHECKING_STUDY')),
    )
VERSION_CATALOGUE='V9_8_0'

def NoCheckInNS(filename):
    return 1
NoCheckInNS.info = u""
def DirectOperatorInNS(filename):
    if os.path.isfile(filename):
        fc = open(filename, 'r').readlines()
        cr = re.compile("^def[\s]*DirectOperator[\s]*\(")
        for ln in fc:
            if cr.match(ln): return 1
        cr = re.compile("^DirectOperator[\s]*=")
        for ln in fc:
            if cr.match(ln): return 1
    return 0
DirectOperatorInNS.info = u"The Python file has to contain explicitly a \"DirectOperator\" function definition with only one vector as argument."
def TangentOperatorInNS(filename):
    if os.path.isfile(filename):
        fc = open(filename, 'r').readlines()
        cr = re.compile("^def[\s]*TangentOperator[\s]*\(")
        for ln in fc:
            if cr.match(ln): return 1
        cr = re.compile("^TangentOperator[\s]*=")
        for ln in fc:
            if cr.match(ln): return 1
    return 0
TangentOperatorInNS.info = u"The Python file has to contain explicitly a \"TangentOperator\" function definition with only one pair of vectors as argument."
def AdjointOperatorInNS(filename):
    if os.path.isfile(filename):
        fc = open(filename, 'r').readlines()
        cr = re.compile("^def[\s]*AdjointOperator[\s]*\(")
        for ln in fc:
            if cr.match(ln): return 1
        cr = re.compile("^AdjointOperator[\s]*=")
        for ln in fc:
            if cr.match(ln): return 1
    return 0
AdjointOperatorInNS.info = u"The Python file has to contain explicitly an \"AdjointOperator\" function definition with only one pair of vectors as argument."
def ColDataFileExtVal(filename):
    __readable = (".csv", ".tsv", ".txt", ".npy", ".npz")
    if os.path.isfile(filename) and os.path.splitext(filename)[1] in __readable:
        return 1
    return 0
ColDataFileExtVal.info = u"The data file has to contain explicitly one or more number columns with separator, or one variable, that can fit in a unique continuous vector."

def F_Vector(statut, fv=NoCheckInNS) : return FACT(
    statut = statut,
    FROM = SIMP(statut = "o", typ = "TXM", into=("String", "Script", "DataFile", ), defaut="Script"),
    SCRIPT_DATA = BLOC ( condition = " FROM in ( 'Script', ) ",
        SCRIPT_FILE = SIMP(statut = "o", typ = ("FichierNoAbs",'Python Files (*.py)',), validators=[OnlyStr(), FileExtVal('py'), FunctionVal(fv)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant si nécessaire la définition d'une variable interne de même nom que le concept parent", ang="Waiting for a script file name, with or without the full path to find it, containing if necessary the definition of an internal variable of the same name as the parent concept"),
        ),
    DATA_DATA = BLOC ( condition = " FROM in ( 'DataFile', ) ",
        DATA_FILE = SIMP(statut = "o", typ = ("FichierNoAbs",'CSV Text Files (*.csv);;TSV Text Files (*.tsv);;TXT Text Files (*.txt);;NPY Binary Numpy Files (*.npy);;NPZ Binary Numpy Files (*.npz);;All Files (*)", ',), validators=[OnlyStr(), FunctionVal(ColDataFileExtVal)], fr="En attente d'un nom de fichier de données, avec ou sans le chemin complet pour le trouver, contenant ou plusieurs colonnes pour définir un unique vecteur continu", ang="Waiting for a data file name, with or without the full path to find it, containing one or more columns to define a unique continuous vector"),
        ColMajor = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Variables en colonnes acquises ligne par ligne (0) ou colonne par colonne (1)", ang="Variables in columns acquired line by line (0) or column by column (1)"),
        ),
    STRING_DATA = BLOC ( condition = " FROM in ( 'String', ) ",
        STRING = SIMP(statut = "o", typ = "TXM", fr="En attente d'une chaîne de caractères entre guillemets. Pour construire un vecteur ou une matrice, ce doit être une suite de nombres, utilisant un espace ou une virgule pour séparer deux éléments et un point-virgule pour séparer deux lignes", ang="Waiting for a string in quotes. To build a vector or a matrix, it has to be a float serie, using a space or comma to separate two elements in a line, a semi-colon to separate rows"),
        ),
    SCRIPTWITHFUNCTIONS_DATA = BLOC ( condition = " FROM in ( 'ScriptWithFunctions', ) ",
        SCRIPTWITHFUNCTIONS_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py'), FunctionVal(DirectOperatorInNS), FunctionVal(TangentOperatorInNS), FunctionVal(AdjointOperatorInNS)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant en variables internes trois fonctions de calcul nommées DirectOperator, TangentOperator et AdjointOperator", ang="Waiting for a script file name, with or without the full path to find it, containing as internal variables three computation functions named DirectOperator, TangentOperator and AdjointOperator"),
        ),
    SCRIPTWITHONEFUNCTION_DATA = BLOC ( condition = " FROM in ( 'ScriptWithOneFunction', ) ",
        SCRIPTWITHONEFUNCTION_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py'), FunctionVal(DirectOperatorInNS)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant en variable interne une seule fonction de calcul nommée DirectOperator", ang="Waiting for a script file name, with or without the full path to find it, containing as internal variable only one function named DirectOperator"),
        DifferentialIncrement = SIMP(statut="o", typ = "R", val_min=0, val_max=1, defaut=0.01, fr="Incrément de la perturbation dX pour calculer la dérivée, construite en multipliant X par l'incrément en évitant les valeurs nulles", ang="Increment of dX perturbation to calculate the derivative, build multiplying X by the increment avoiding null values"),
        CenteredFiniteDifference = SIMP(statut="o", typ = "I", into=(0, 1), defaut=0, fr="Formulation centrée (1) ou décentrée (0) pour la méthode des différences finies", ang="Centered (1) or uncentered (0) formulation for the finite differences method"),
        EnableMultiProcessing = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Calculs élémentaires effectués en séquentiel (0) ou en parallèle (1) dans la méthode des différences finies", ang="Elementary calculations done sequentially (0) or in parallel (1) in the finite differences method"),
        NumberOfProcesses = SIMP(statut="f", typ = "I", val_min=0, defaut=0, fr="Nombre de processus parallèles, 0 pour un contrôle automatique", ang="Number of parallel processes, 0 for automatic control"),
        ),
    SCRIPTWITHSWITCH_DATA = BLOC ( condition = " FROM in ( 'ScriptWithSwitch', ) ",
        SCRIPTWITHSWITCH_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant un switch pour les calculs direct, tangent et adjoint", ang="Waiting for a script file name, with or without the full path to find it, containing a switch for direct, tangent and adjoint computations"),
        ),
    TEMPLATE_DATA =  BLOC (condition = " FROM in ( 'Template', ) ",
        Template = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "AnalysisPrinter", into=("AnalysisPrinter", "AnalysisSaver", "AnalysisPrinterAndSaver", "AnalysisSeriePrinter", "AnalysisSerieSaver", "AnalysisSeriePrinterAndSaver")),
        AnalysisPrinter = BLOC (condition = " Template == 'AnalysisPrinter' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nprint('Analysis',xa)", fr="Imprime sur la sortie standard la valeur optimale", ang="Print on standard output the optimal value" ),
            ),
        AnalysisSaver = BLOC (condition = " Template == 'AnalysisSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Enregistre la valeur optimale dans un fichier du répertoire '/tmp' nommé 'analysis.txt'", ang="Save the optimal value in a file of the '/tmp' directory named 'analysis.txt'" ),
            ),
        AnalysisPrinterAndSaver = BLOC (condition = " Template == 'AnalysisPrinterAndSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nprint('Analysis',xa)\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Imprime sur la sortie standard et, en même temps enregistre dans un fichier du répertoire '/tmp', la valeur optimale", ang="Print on standard output and, in the same time save in a file of the '/tmp' directory, the optimal value" ),
            ),
        AnalysisSeriePrinter = BLOC (condition = " Template == 'AnalysisSeriePrinter' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nprint('Analysis',xa)", fr="Imprime sur la sortie standard la série des valeurs optimales", ang="Print on standard output the optimal value series" ),
            ),
        AnalysisSerieSaver = BLOC (condition = " Template == 'AnalysisSerieSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Enregistre la série des valeurs optimales dans un fichier du répertoire '/tmp' nommé 'analysis.txt'", ang="Save the optimal value series in a file of the '/tmp' directory named 'analysis.txt'" ),
            ),
        AnalysisSeriePrinterAndSaver = BLOC (condition = " Template == 'AnalysisSeriePrinterAndSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nprint('Analysis',xa)\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Imprime sur la sortie standard et, en même temps enregistre dans un fichier du répertoire '/tmp', la série des valeurs optimales", ang="Print on standard output and, in the same time save in a file of the '/tmp' directory, the optimal value series" ),
            ),
        ),
    )

def F_VectorSerie(statut, fv=NoCheckInNS) : return FACT(
    statut = statut,
    FROM = SIMP(statut = "o", typ = "TXM", into=("String", "Script", "DataFile", ), defaut="Script"),
    SCRIPT_DATA = BLOC ( condition = " FROM in ( 'Script', ) ",
        SCRIPT_FILE = SIMP(statut = "o", typ = ("FichierNoAbs",'Python Files (*.py)',), validators=[OnlyStr(), FileExtVal('py'), FunctionVal(fv)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant si nécessaire la définition d'une variable interne de même nom que le concept parent", ang="Waiting for a script file name, with or without the full path to find it, containing if necessary the definition of an internal variable of the same name as the parent concept"),
        ),
    DATA_DATA = BLOC ( condition = " FROM in ( 'DataFile', ) ",
        DATA_FILE = SIMP(statut = "o", typ = ("FichierNoAbs",'CSV Text Files (*.csv);;TSV Text Files (*.tsv);;TXT Text Files (*.txt);;NPY Binary Numpy Files (*.npy);;NPZ Binary Numpy Files (*.npz);;All Files (*)", ',), validators=[OnlyStr(), FunctionVal(ColDataFileExtVal)], fr="En attente d'un nom de fichier de données, avec ou sans le chemin complet pour le trouver, contenant ou plusieurs colonnes pour définir un unique vecteur continu", ang="Waiting for a data file name, with or without the full path to find it, containing one or more columns to define a unique continuous vector"),
        ColMajor = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Variables en colonnes acquises ligne par ligne (0) ou colonne par colonne (1)", ang="Variables in columns acquired line by line (0) or column by column (1)"),
        ),
    STRING_DATA = BLOC ( condition = " FROM in ( 'String', ) ",
        STRING = SIMP(statut = "o", typ = "TXM", fr="En attente d'une chaîne de caractères entre guillemets. Pour construire un vecteur ou une matrice, ce doit être une suite de nombres, utilisant un espace ou une virgule pour séparer deux éléments et un point-virgule pour séparer deux lignes", ang="Waiting for a string in quotes. To build a vector or a matrix, it has to be a float serie, using a space or comma to separate two elements in a line, a semi-colon to separate rows"),
        ),
    SCRIPTWITHFUNCTIONS_DATA = BLOC ( condition = " FROM in ( 'ScriptWithFunctions', ) ",
        SCRIPTWITHFUNCTIONS_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py'), FunctionVal(DirectOperatorInNS), FunctionVal(TangentOperatorInNS), FunctionVal(AdjointOperatorInNS)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant en variables internes trois fonctions de calcul nommées DirectOperator, TangentOperator et AdjointOperator", ang="Waiting for a script file name, with or without the full path to find it, containing as internal variables three computation functions named DirectOperator, TangentOperator and AdjointOperator"),
        ),
    SCRIPTWITHONEFUNCTION_DATA = BLOC ( condition = " FROM in ( 'ScriptWithOneFunction', ) ",
        SCRIPTWITHONEFUNCTION_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py'), FunctionVal(DirectOperatorInNS)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant en variable interne une seule fonction de calcul nommée DirectOperator", ang="Waiting for a script file name, with or without the full path to find it, containing as internal variable only one function named DirectOperator"),
        DifferentialIncrement = SIMP(statut="o", typ = "R", val_min=0, val_max=1, defaut=0.01, fr="Incrément de la perturbation dX pour calculer la dérivée, construite en multipliant X par l'incrément en évitant les valeurs nulles", ang="Increment of dX perturbation to calculate the derivative, build multiplying X by the increment avoiding null values"),
        CenteredFiniteDifference = SIMP(statut="o", typ = "I", into=(0, 1), defaut=0, fr="Formulation centrée (1) ou décentrée (0) pour la méthode des différences finies", ang="Centered (1) or uncentered (0) formulation for the finite differences method"),
        EnableMultiProcessing = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Calculs élémentaires effectués en séquentiel (0) ou en parallèle (1) dans la méthode des différences finies", ang="Elementary calculations done sequentially (0) or in parallel (1) in the finite differences method"),
        NumberOfProcesses = SIMP(statut="f", typ = "I", val_min=0, defaut=0, fr="Nombre de processus parallèles, 0 pour un contrôle automatique", ang="Number of parallel processes, 0 for automatic control"),
        ),
    SCRIPTWITHSWITCH_DATA = BLOC ( condition = " FROM in ( 'ScriptWithSwitch', ) ",
        SCRIPTWITHSWITCH_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant un switch pour les calculs direct, tangent et adjoint", ang="Waiting for a script file name, with or without the full path to find it, containing a switch for direct, tangent and adjoint computations"),
        ),
    TEMPLATE_DATA =  BLOC (condition = " FROM in ( 'Template', ) ",
        Template = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "AnalysisPrinter", into=("AnalysisPrinter", "AnalysisSaver", "AnalysisPrinterAndSaver", "AnalysisSeriePrinter", "AnalysisSerieSaver", "AnalysisSeriePrinterAndSaver")),
        AnalysisPrinter = BLOC (condition = " Template == 'AnalysisPrinter' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nprint('Analysis',xa)", fr="Imprime sur la sortie standard la valeur optimale", ang="Print on standard output the optimal value" ),
            ),
        AnalysisSaver = BLOC (condition = " Template == 'AnalysisSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Enregistre la valeur optimale dans un fichier du répertoire '/tmp' nommé 'analysis.txt'", ang="Save the optimal value in a file of the '/tmp' directory named 'analysis.txt'" ),
            ),
        AnalysisPrinterAndSaver = BLOC (condition = " Template == 'AnalysisPrinterAndSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nprint('Analysis',xa)\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Imprime sur la sortie standard et, en même temps enregistre dans un fichier du répertoire '/tmp', la valeur optimale", ang="Print on standard output and, in the same time save in a file of the '/tmp' directory, the optimal value" ),
            ),
        AnalysisSeriePrinter = BLOC (condition = " Template == 'AnalysisSeriePrinter' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nprint('Analysis',xa)", fr="Imprime sur la sortie standard la série des valeurs optimales", ang="Print on standard output the optimal value series" ),
            ),
        AnalysisSerieSaver = BLOC (condition = " Template == 'AnalysisSerieSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Enregistre la série des valeurs optimales dans un fichier du répertoire '/tmp' nommé 'analysis.txt'", ang="Save the optimal value series in a file of the '/tmp' directory named 'analysis.txt'" ),
            ),
        AnalysisSeriePrinterAndSaver = BLOC (condition = " Template == 'AnalysisSeriePrinterAndSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nprint('Analysis',xa)\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Imprime sur la sortie standard et, en même temps enregistre dans un fichier du répertoire '/tmp', la série des valeurs optimales", ang="Print on standard output and, in the same time save in a file of the '/tmp' directory, the optimal value series" ),
            ),
        ),
    )

def F_Matrix(statut, fv=NoCheckInNS) : return FACT(
    statut = statut,
    FROM = SIMP(statut = "o", typ = "TXM", into=("String", "Script", ), defaut="Script"),
    SCRIPT_DATA = BLOC ( condition = " FROM in ( 'Script', ) ",
        SCRIPT_FILE = SIMP(statut = "o", typ = ("FichierNoAbs",'Python Files (*.py)',), validators=[OnlyStr(), FileExtVal('py'), FunctionVal(fv)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant si nécessaire la définition d'une variable interne de même nom que le concept parent", ang="Waiting for a script file name, with or without the full path to find it, containing if necessary the definition of an internal variable of the same name as the parent concept"),
        ),
    DATA_DATA = BLOC ( condition = " FROM in ( 'DataFile', ) ",
        DATA_FILE = SIMP(statut = "o", typ = ("FichierNoAbs",'CSV Text Files (*.csv);;TSV Text Files (*.tsv);;TXT Text Files (*.txt);;NPY Binary Numpy Files (*.npy);;NPZ Binary Numpy Files (*.npz);;All Files (*)", ',), validators=[OnlyStr(), FunctionVal(ColDataFileExtVal)], fr="En attente d'un nom de fichier de données, avec ou sans le chemin complet pour le trouver, contenant ou plusieurs colonnes pour définir un unique vecteur continu", ang="Waiting for a data file name, with or without the full path to find it, containing one or more columns to define a unique continuous vector"),
        ColMajor = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Variables en colonnes acquises ligne par ligne (0) ou colonne par colonne (1)", ang="Variables in columns acquired line by line (0) or column by column (1)"),
        ),
    STRING_DATA = BLOC ( condition = " FROM in ( 'String', ) ",
        STRING = SIMP(statut = "o", typ = "TXM", fr="En attente d'une chaîne de caractères entre guillemets. Pour construire un vecteur ou une matrice, ce doit être une suite de nombres, utilisant un espace ou une virgule pour séparer deux éléments et un point-virgule pour séparer deux lignes", ang="Waiting for a string in quotes. To build a vector or a matrix, it has to be a float serie, using a space or comma to separate two elements in a line, a semi-colon to separate rows"),
        ),
    SCRIPTWITHFUNCTIONS_DATA = BLOC ( condition = " FROM in ( 'ScriptWithFunctions', ) ",
        SCRIPTWITHFUNCTIONS_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py'), FunctionVal(DirectOperatorInNS), FunctionVal(TangentOperatorInNS), FunctionVal(AdjointOperatorInNS)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant en variables internes trois fonctions de calcul nommées DirectOperator, TangentOperator et AdjointOperator", ang="Waiting for a script file name, with or without the full path to find it, containing as internal variables three computation functions named DirectOperator, TangentOperator and AdjointOperator"),
        ),
    SCRIPTWITHONEFUNCTION_DATA = BLOC ( condition = " FROM in ( 'ScriptWithOneFunction', ) ",
        SCRIPTWITHONEFUNCTION_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py'), FunctionVal(DirectOperatorInNS)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant en variable interne une seule fonction de calcul nommée DirectOperator", ang="Waiting for a script file name, with or without the full path to find it, containing as internal variable only one function named DirectOperator"),
        DifferentialIncrement = SIMP(statut="o", typ = "R", val_min=0, val_max=1, defaut=0.01, fr="Incrément de la perturbation dX pour calculer la dérivée, construite en multipliant X par l'incrément en évitant les valeurs nulles", ang="Increment of dX perturbation to calculate the derivative, build multiplying X by the increment avoiding null values"),
        CenteredFiniteDifference = SIMP(statut="o", typ = "I", into=(0, 1), defaut=0, fr="Formulation centrée (1) ou décentrée (0) pour la méthode des différences finies", ang="Centered (1) or uncentered (0) formulation for the finite differences method"),
        EnableMultiProcessing = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Calculs élémentaires effectués en séquentiel (0) ou en parallèle (1) dans la méthode des différences finies", ang="Elementary calculations done sequentially (0) or in parallel (1) in the finite differences method"),
        NumberOfProcesses = SIMP(statut="f", typ = "I", val_min=0, defaut=0, fr="Nombre de processus parallèles, 0 pour un contrôle automatique", ang="Number of parallel processes, 0 for automatic control"),
        ),
    SCRIPTWITHSWITCH_DATA = BLOC ( condition = " FROM in ( 'ScriptWithSwitch', ) ",
        SCRIPTWITHSWITCH_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant un switch pour les calculs direct, tangent et adjoint", ang="Waiting for a script file name, with or without the full path to find it, containing a switch for direct, tangent and adjoint computations"),
        ),
    TEMPLATE_DATA =  BLOC (condition = " FROM in ( 'Template', ) ",
        Template = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "AnalysisPrinter", into=("AnalysisPrinter", "AnalysisSaver", "AnalysisPrinterAndSaver", "AnalysisSeriePrinter", "AnalysisSerieSaver", "AnalysisSeriePrinterAndSaver")),
        AnalysisPrinter = BLOC (condition = " Template == 'AnalysisPrinter' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nprint('Analysis',xa)", fr="Imprime sur la sortie standard la valeur optimale", ang="Print on standard output the optimal value" ),
            ),
        AnalysisSaver = BLOC (condition = " Template == 'AnalysisSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Enregistre la valeur optimale dans un fichier du répertoire '/tmp' nommé 'analysis.txt'", ang="Save the optimal value in a file of the '/tmp' directory named 'analysis.txt'" ),
            ),
        AnalysisPrinterAndSaver = BLOC (condition = " Template == 'AnalysisPrinterAndSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nprint('Analysis',xa)\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Imprime sur la sortie standard et, en même temps enregistre dans un fichier du répertoire '/tmp', la valeur optimale", ang="Print on standard output and, in the same time save in a file of the '/tmp' directory, the optimal value" ),
            ),
        AnalysisSeriePrinter = BLOC (condition = " Template == 'AnalysisSeriePrinter' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nprint('Analysis',xa)", fr="Imprime sur la sortie standard la série des valeurs optimales", ang="Print on standard output the optimal value series" ),
            ),
        AnalysisSerieSaver = BLOC (condition = " Template == 'AnalysisSerieSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Enregistre la série des valeurs optimales dans un fichier du répertoire '/tmp' nommé 'analysis.txt'", ang="Save the optimal value series in a file of the '/tmp' directory named 'analysis.txt'" ),
            ),
        AnalysisSeriePrinterAndSaver = BLOC (condition = " Template == 'AnalysisSeriePrinterAndSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nprint('Analysis',xa)\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Imprime sur la sortie standard et, en même temps enregistre dans un fichier du répertoire '/tmp', la série des valeurs optimales", ang="Print on standard output and, in the same time save in a file of the '/tmp' directory, the optimal value series" ),
            ),
        ),
    )

def F_ScalarSparseMatrix(statut, fv=NoCheckInNS) : return FACT(
    statut = statut,
    FROM = SIMP(statut = "o", typ = "TXM", into=("String", "Script", ), defaut="String"),
    SCRIPT_DATA = BLOC ( condition = " FROM in ( 'Script', ) ",
        SCRIPT_FILE = SIMP(statut = "o", typ = ("FichierNoAbs",'Python Files (*.py)',), validators=[OnlyStr(), FileExtVal('py'), FunctionVal(fv)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant si nécessaire la définition d'une variable interne de même nom que le concept parent", ang="Waiting for a script file name, with or without the full path to find it, containing if necessary the definition of an internal variable of the same name as the parent concept"),
        ),
    DATA_DATA = BLOC ( condition = " FROM in ( 'DataFile', ) ",
        DATA_FILE = SIMP(statut = "o", typ = ("FichierNoAbs",'CSV Text Files (*.csv);;TSV Text Files (*.tsv);;TXT Text Files (*.txt);;NPY Binary Numpy Files (*.npy);;NPZ Binary Numpy Files (*.npz);;All Files (*)", ',), validators=[OnlyStr(), FunctionVal(ColDataFileExtVal)], fr="En attente d'un nom de fichier de données, avec ou sans le chemin complet pour le trouver, contenant ou plusieurs colonnes pour définir un unique vecteur continu", ang="Waiting for a data file name, with or without the full path to find it, containing one or more columns to define a unique continuous vector"),
        ColMajor = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Variables en colonnes acquises ligne par ligne (0) ou colonne par colonne (1)", ang="Variables in columns acquired line by line (0) or column by column (1)"),
        ),
    STRING_DATA = BLOC ( condition = " FROM in ( 'String', ) ",
        STRING = SIMP(statut = "o", typ = "TXM", defaut="1.", fr="En attente d'une chaîne de caractères entre guillemets. Pour construire un vecteur ou une matrice, ce doit être une suite de nombres, utilisant un espace ou une virgule pour séparer deux éléments et un point-virgule pour séparer deux lignes", ang="Waiting for a string in quotes. To build a vector or a matrix, it has to be a float serie, using a space or comma to separate two elements in a line, a semi-colon to separate rows"),
        ),
    SCRIPTWITHFUNCTIONS_DATA = BLOC ( condition = " FROM in ( 'ScriptWithFunctions', ) ",
        SCRIPTWITHFUNCTIONS_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py'), FunctionVal(DirectOperatorInNS), FunctionVal(TangentOperatorInNS), FunctionVal(AdjointOperatorInNS)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant en variables internes trois fonctions de calcul nommées DirectOperator, TangentOperator et AdjointOperator", ang="Waiting for a script file name, with or without the full path to find it, containing as internal variables three computation functions named DirectOperator, TangentOperator and AdjointOperator"),
        ),
    SCRIPTWITHONEFUNCTION_DATA = BLOC ( condition = " FROM in ( 'ScriptWithOneFunction', ) ",
        SCRIPTWITHONEFUNCTION_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py'), FunctionVal(DirectOperatorInNS)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant en variable interne une seule fonction de calcul nommée DirectOperator", ang="Waiting for a script file name, with or without the full path to find it, containing as internal variable only one function named DirectOperator"),
        DifferentialIncrement = SIMP(statut="o", typ = "R", val_min=0, val_max=1, defaut=0.01, fr="Incrément de la perturbation dX pour calculer la dérivée, construite en multipliant X par l'incrément en évitant les valeurs nulles", ang="Increment of dX perturbation to calculate the derivative, build multiplying X by the increment avoiding null values"),
        CenteredFiniteDifference = SIMP(statut="o", typ = "I", into=(0, 1), defaut=0, fr="Formulation centrée (1) ou décentrée (0) pour la méthode des différences finies", ang="Centered (1) or uncentered (0) formulation for the finite differences method"),
        EnableMultiProcessing = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Calculs élémentaires effectués en séquentiel (0) ou en parallèle (1) dans la méthode des différences finies", ang="Elementary calculations done sequentially (0) or in parallel (1) in the finite differences method"),
        NumberOfProcesses = SIMP(statut="f", typ = "I", val_min=0, defaut=0, fr="Nombre de processus parallèles, 0 pour un contrôle automatique", ang="Number of parallel processes, 0 for automatic control"),
        ),
    SCRIPTWITHSWITCH_DATA = BLOC ( condition = " FROM in ( 'ScriptWithSwitch', ) ",
        SCRIPTWITHSWITCH_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant un switch pour les calculs direct, tangent et adjoint", ang="Waiting for a script file name, with or without the full path to find it, containing a switch for direct, tangent and adjoint computations"),
        ),
    TEMPLATE_DATA =  BLOC (condition = " FROM in ( 'Template', ) ",
        Template = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "AnalysisPrinter", into=("AnalysisPrinter", "AnalysisSaver", "AnalysisPrinterAndSaver", "AnalysisSeriePrinter", "AnalysisSerieSaver", "AnalysisSeriePrinterAndSaver")),
        AnalysisPrinter = BLOC (condition = " Template == 'AnalysisPrinter' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nprint('Analysis',xa)", fr="Imprime sur la sortie standard la valeur optimale", ang="Print on standard output the optimal value" ),
            ),
        AnalysisSaver = BLOC (condition = " Template == 'AnalysisSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Enregistre la valeur optimale dans un fichier du répertoire '/tmp' nommé 'analysis.txt'", ang="Save the optimal value in a file of the '/tmp' directory named 'analysis.txt'" ),
            ),
        AnalysisPrinterAndSaver = BLOC (condition = " Template == 'AnalysisPrinterAndSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nprint('Analysis',xa)\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Imprime sur la sortie standard et, en même temps enregistre dans un fichier du répertoire '/tmp', la valeur optimale", ang="Print on standard output and, in the same time save in a file of the '/tmp' directory, the optimal value" ),
            ),
        AnalysisSeriePrinter = BLOC (condition = " Template == 'AnalysisSeriePrinter' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nprint('Analysis',xa)", fr="Imprime sur la sortie standard la série des valeurs optimales", ang="Print on standard output the optimal value series" ),
            ),
        AnalysisSerieSaver = BLOC (condition = " Template == 'AnalysisSerieSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Enregistre la série des valeurs optimales dans un fichier du répertoire '/tmp' nommé 'analysis.txt'", ang="Save the optimal value series in a file of the '/tmp' directory named 'analysis.txt'" ),
            ),
        AnalysisSeriePrinterAndSaver = BLOC (condition = " Template == 'AnalysisSeriePrinterAndSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nprint('Analysis',xa)\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Imprime sur la sortie standard et, en même temps enregistre dans un fichier du répertoire '/tmp', la série des valeurs optimales", ang="Print on standard output and, in the same time save in a file of the '/tmp' directory, the optimal value series" ),
            ),
        ),
    )

def F_DiagonalSparseMatrix(statut, fv=NoCheckInNS) : return FACT(
    statut = statut,
    FROM = SIMP(statut = "o", typ = "TXM", into=("String", "Script", ), defaut="String"),
    SCRIPT_DATA = BLOC ( condition = " FROM in ( 'Script', ) ",
        SCRIPT_FILE = SIMP(statut = "o", typ = ("FichierNoAbs",'Python Files (*.py)',), validators=[OnlyStr(), FileExtVal('py'), FunctionVal(fv)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant si nécessaire la définition d'une variable interne de même nom que le concept parent", ang="Waiting for a script file name, with or without the full path to find it, containing if necessary the definition of an internal variable of the same name as the parent concept"),
        ),
    DATA_DATA = BLOC ( condition = " FROM in ( 'DataFile', ) ",
        DATA_FILE = SIMP(statut = "o", typ = ("FichierNoAbs",'CSV Text Files (*.csv);;TSV Text Files (*.tsv);;TXT Text Files (*.txt);;NPY Binary Numpy Files (*.npy);;NPZ Binary Numpy Files (*.npz);;All Files (*)", ',), validators=[OnlyStr(), FunctionVal(ColDataFileExtVal)], fr="En attente d'un nom de fichier de données, avec ou sans le chemin complet pour le trouver, contenant ou plusieurs colonnes pour définir un unique vecteur continu", ang="Waiting for a data file name, with or without the full path to find it, containing one or more columns to define a unique continuous vector"),
        ColMajor = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Variables en colonnes acquises ligne par ligne (0) ou colonne par colonne (1)", ang="Variables in columns acquired line by line (0) or column by column (1)"),
        ),
    STRING_DATA = BLOC ( condition = " FROM in ( 'String', ) ",
        STRING = SIMP(statut = "o", typ = "TXM", fr="En attente d'une chaîne de caractères entre guillemets. Pour construire un vecteur ou une matrice, ce doit être une suite de nombres, utilisant un espace ou une virgule pour séparer deux éléments et un point-virgule pour séparer deux lignes", ang="Waiting for a string in quotes. To build a vector or a matrix, it has to be a float serie, using a space or comma to separate two elements in a line, a semi-colon to separate rows"),
        ),
    SCRIPTWITHFUNCTIONS_DATA = BLOC ( condition = " FROM in ( 'ScriptWithFunctions', ) ",
        SCRIPTWITHFUNCTIONS_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py'), FunctionVal(DirectOperatorInNS), FunctionVal(TangentOperatorInNS), FunctionVal(AdjointOperatorInNS)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant en variables internes trois fonctions de calcul nommées DirectOperator, TangentOperator et AdjointOperator", ang="Waiting for a script file name, with or without the full path to find it, containing as internal variables three computation functions named DirectOperator, TangentOperator and AdjointOperator"),
        ),
    SCRIPTWITHONEFUNCTION_DATA = BLOC ( condition = " FROM in ( 'ScriptWithOneFunction', ) ",
        SCRIPTWITHONEFUNCTION_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py'), FunctionVal(DirectOperatorInNS)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant en variable interne une seule fonction de calcul nommée DirectOperator", ang="Waiting for a script file name, with or without the full path to find it, containing as internal variable only one function named DirectOperator"),
        DifferentialIncrement = SIMP(statut="o", typ = "R", val_min=0, val_max=1, defaut=0.01, fr="Incrément de la perturbation dX pour calculer la dérivée, construite en multipliant X par l'incrément en évitant les valeurs nulles", ang="Increment of dX perturbation to calculate the derivative, build multiplying X by the increment avoiding null values"),
        CenteredFiniteDifference = SIMP(statut="o", typ = "I", into=(0, 1), defaut=0, fr="Formulation centrée (1) ou décentrée (0) pour la méthode des différences finies", ang="Centered (1) or uncentered (0) formulation for the finite differences method"),
        EnableMultiProcessing = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Calculs élémentaires effectués en séquentiel (0) ou en parallèle (1) dans la méthode des différences finies", ang="Elementary calculations done sequentially (0) or in parallel (1) in the finite differences method"),
        NumberOfProcesses = SIMP(statut="f", typ = "I", val_min=0, defaut=0, fr="Nombre de processus parallèles, 0 pour un contrôle automatique", ang="Number of parallel processes, 0 for automatic control"),
        ),
    SCRIPTWITHSWITCH_DATA = BLOC ( condition = " FROM in ( 'ScriptWithSwitch', ) ",
        SCRIPTWITHSWITCH_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant un switch pour les calculs direct, tangent et adjoint", ang="Waiting for a script file name, with or without the full path to find it, containing a switch for direct, tangent and adjoint computations"),
        ),
    TEMPLATE_DATA =  BLOC (condition = " FROM in ( 'Template', ) ",
        Template = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "AnalysisPrinter", into=("AnalysisPrinter", "AnalysisSaver", "AnalysisPrinterAndSaver", "AnalysisSeriePrinter", "AnalysisSerieSaver", "AnalysisSeriePrinterAndSaver")),
        AnalysisPrinter = BLOC (condition = " Template == 'AnalysisPrinter' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nprint('Analysis',xa)", fr="Imprime sur la sortie standard la valeur optimale", ang="Print on standard output the optimal value" ),
            ),
        AnalysisSaver = BLOC (condition = " Template == 'AnalysisSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Enregistre la valeur optimale dans un fichier du répertoire '/tmp' nommé 'analysis.txt'", ang="Save the optimal value in a file of the '/tmp' directory named 'analysis.txt'" ),
            ),
        AnalysisPrinterAndSaver = BLOC (condition = " Template == 'AnalysisPrinterAndSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nprint('Analysis',xa)\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Imprime sur la sortie standard et, en même temps enregistre dans un fichier du répertoire '/tmp', la valeur optimale", ang="Print on standard output and, in the same time save in a file of the '/tmp' directory, the optimal value" ),
            ),
        AnalysisSeriePrinter = BLOC (condition = " Template == 'AnalysisSeriePrinter' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nprint('Analysis',xa)", fr="Imprime sur la sortie standard la série des valeurs optimales", ang="Print on standard output the optimal value series" ),
            ),
        AnalysisSerieSaver = BLOC (condition = " Template == 'AnalysisSerieSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Enregistre la série des valeurs optimales dans un fichier du répertoire '/tmp' nommé 'analysis.txt'", ang="Save the optimal value series in a file of the '/tmp' directory named 'analysis.txt'" ),
            ),
        AnalysisSeriePrinterAndSaver = BLOC (condition = " Template == 'AnalysisSeriePrinterAndSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nprint('Analysis',xa)\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Imprime sur la sortie standard et, en même temps enregistre dans un fichier du répertoire '/tmp', la série des valeurs optimales", ang="Print on standard output and, in the same time save in a file of the '/tmp' directory, the optimal value series" ),
            ),
        ),
    )

def F_Function(statut, fv=NoCheckInNS) : return FACT(
    statut = statut,
    FROM = SIMP(statut = "o", typ = "TXM", into=("ScriptWithOneFunction", "ScriptWithFunctions", "ScriptWithSwitch", "FunctionDict", ), defaut="ScriptWithOneFunction"),
    SCRIPT_DATA = BLOC ( condition = " FROM in ( 'Script', ) ",
        SCRIPT_FILE = SIMP(statut = "o", typ = ("FichierNoAbs",'Python Files (*.py)',), validators=[OnlyStr(), FileExtVal('py'), FunctionVal(fv)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant si nécessaire la définition d'une variable interne de même nom que le concept parent", ang="Waiting for a script file name, with or without the full path to find it, containing if necessary the definition of an internal variable of the same name as the parent concept"),
        ),
    DATA_DATA = BLOC ( condition = " FROM in ( 'DataFile', ) ",
        DATA_FILE = SIMP(statut = "o", typ = ("FichierNoAbs",'CSV Text Files (*.csv);;TSV Text Files (*.tsv);;TXT Text Files (*.txt);;NPY Binary Numpy Files (*.npy);;NPZ Binary Numpy Files (*.npz);;All Files (*)", ',), validators=[OnlyStr(), FunctionVal(ColDataFileExtVal)], fr="En attente d'un nom de fichier de données, avec ou sans le chemin complet pour le trouver, contenant ou plusieurs colonnes pour définir un unique vecteur continu", ang="Waiting for a data file name, with or without the full path to find it, containing one or more columns to define a unique continuous vector"),
        ColMajor = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Variables en colonnes acquises ligne par ligne (0) ou colonne par colonne (1)", ang="Variables in columns acquired line by line (0) or column by column (1)"),
        ),
    STRING_DATA = BLOC ( condition = " FROM in ( 'String', ) ",
        STRING = SIMP(statut = "o", typ = "TXM", fr="En attente d'une chaîne de caractères entre guillemets. Pour construire un vecteur ou une matrice, ce doit être une suite de nombres, utilisant un espace ou une virgule pour séparer deux éléments et un point-virgule pour séparer deux lignes", ang="Waiting for a string in quotes. To build a vector or a matrix, it has to be a float serie, using a space or comma to separate two elements in a line, a semi-colon to separate rows"),
        ),
    SCRIPTWITHFUNCTIONS_DATA = BLOC ( condition = " FROM in ( 'ScriptWithFunctions', ) ",
        SCRIPTWITHFUNCTIONS_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py'), FunctionVal(DirectOperatorInNS), FunctionVal(TangentOperatorInNS), FunctionVal(AdjointOperatorInNS)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant en variables internes trois fonctions de calcul nommées DirectOperator, TangentOperator et AdjointOperator", ang="Waiting for a script file name, with or without the full path to find it, containing as internal variables three computation functions named DirectOperator, TangentOperator and AdjointOperator"),
        ),
    SCRIPTWITHONEFUNCTION_DATA = BLOC ( condition = " FROM in ( 'ScriptWithOneFunction', ) ",
        SCRIPTWITHONEFUNCTION_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py'), FunctionVal(DirectOperatorInNS)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant en variable interne une seule fonction de calcul nommée DirectOperator", ang="Waiting for a script file name, with or without the full path to find it, containing as internal variable only one function named DirectOperator"),
        DifferentialIncrement = SIMP(statut="o", typ = "R", val_min=0, val_max=1, defaut=0.01, fr="Incrément de la perturbation dX pour calculer la dérivée, construite en multipliant X par l'incrément en évitant les valeurs nulles", ang="Increment of dX perturbation to calculate the derivative, build multiplying X by the increment avoiding null values"),
        CenteredFiniteDifference = SIMP(statut="o", typ = "I", into=(0, 1), defaut=0, fr="Formulation centrée (1) ou décentrée (0) pour la méthode des différences finies", ang="Centered (1) or uncentered (0) formulation for the finite differences method"),
        EnableMultiProcessing = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Calculs élémentaires effectués en séquentiel (0) ou en parallèle (1) dans la méthode des différences finies", ang="Elementary calculations done sequentially (0) or in parallel (1) in the finite differences method"),
        NumberOfProcesses = SIMP(statut="f", typ = "I", val_min=0, defaut=0, fr="Nombre de processus parallèles, 0 pour un contrôle automatique", ang="Number of parallel processes, 0 for automatic control"),
        ),
    SCRIPTWITHSWITCH_DATA = BLOC ( condition = " FROM in ( 'ScriptWithSwitch', ) ",
        SCRIPTWITHSWITCH_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant un switch pour les calculs direct, tangent et adjoint", ang="Waiting for a script file name, with or without the full path to find it, containing a switch for direct, tangent and adjoint computations"),
        ),
    TEMPLATE_DATA =  BLOC (condition = " FROM in ( 'Template', ) ",
        Template = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "AnalysisPrinter", into=("AnalysisPrinter", "AnalysisSaver", "AnalysisPrinterAndSaver", "AnalysisSeriePrinter", "AnalysisSerieSaver", "AnalysisSeriePrinterAndSaver")),
        AnalysisPrinter = BLOC (condition = " Template == 'AnalysisPrinter' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nprint('Analysis',xa)", fr="Imprime sur la sortie standard la valeur optimale", ang="Print on standard output the optimal value" ),
            ),
        AnalysisSaver = BLOC (condition = " Template == 'AnalysisSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Enregistre la valeur optimale dans un fichier du répertoire '/tmp' nommé 'analysis.txt'", ang="Save the optimal value in a file of the '/tmp' directory named 'analysis.txt'" ),
            ),
        AnalysisPrinterAndSaver = BLOC (condition = " Template == 'AnalysisPrinterAndSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nprint('Analysis',xa)\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Imprime sur la sortie standard et, en même temps enregistre dans un fichier du répertoire '/tmp', la valeur optimale", ang="Print on standard output and, in the same time save in a file of the '/tmp' directory, the optimal value" ),
            ),
        AnalysisSeriePrinter = BLOC (condition = " Template == 'AnalysisSeriePrinter' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nprint('Analysis',xa)", fr="Imprime sur la sortie standard la série des valeurs optimales", ang="Print on standard output the optimal value series" ),
            ),
        AnalysisSerieSaver = BLOC (condition = " Template == 'AnalysisSerieSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Enregistre la série des valeurs optimales dans un fichier du répertoire '/tmp' nommé 'analysis.txt'", ang="Save the optimal value series in a file of the '/tmp' directory named 'analysis.txt'" ),
            ),
        AnalysisSeriePrinterAndSaver = BLOC (condition = " Template == 'AnalysisSeriePrinterAndSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nprint('Analysis',xa)\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Imprime sur la sortie standard et, en même temps enregistre dans un fichier du répertoire '/tmp', la série des valeurs optimales", ang="Print on standard output and, in the same time save in a file of the '/tmp' directory, the optimal value series" ),
            ),
        ),
    )

def F_Dict(statut, fv=NoCheckInNS) : return FACT(
    statut = statut,
    FROM = SIMP(statut = "o", typ = "TXM", into=("String", "Script", ), defaut="Script"),
    SCRIPT_DATA = BLOC ( condition = " FROM in ( 'Script', ) ",
        SCRIPT_FILE = SIMP(statut = "o", typ = ("FichierNoAbs",'Python Files (*.py)',), validators=[OnlyStr(), FileExtVal('py'), FunctionVal(fv)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant si nécessaire la définition d'une variable interne de même nom que le concept parent", ang="Waiting for a script file name, with or without the full path to find it, containing if necessary the definition of an internal variable of the same name as the parent concept"),
        ),
    DATA_DATA = BLOC ( condition = " FROM in ( 'DataFile', ) ",
        DATA_FILE = SIMP(statut = "o", typ = ("FichierNoAbs",'CSV Text Files (*.csv);;TSV Text Files (*.tsv);;TXT Text Files (*.txt);;NPY Binary Numpy Files (*.npy);;NPZ Binary Numpy Files (*.npz);;All Files (*)", ',), validators=[OnlyStr(), FunctionVal(ColDataFileExtVal)], fr="En attente d'un nom de fichier de données, avec ou sans le chemin complet pour le trouver, contenant ou plusieurs colonnes pour définir un unique vecteur continu", ang="Waiting for a data file name, with or without the full path to find it, containing one or more columns to define a unique continuous vector"),
        ColMajor = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Variables en colonnes acquises ligne par ligne (0) ou colonne par colonne (1)", ang="Variables in columns acquired line by line (0) or column by column (1)"),
        ),
    STRING_DATA = BLOC ( condition = " FROM in ( 'String', ) ",
        STRING = SIMP(statut = "o", typ = "TXM", fr="En attente d'une chaîne de caractères entre guillemets. Pour construire un vecteur ou une matrice, ce doit être une suite de nombres, utilisant un espace ou une virgule pour séparer deux éléments et un point-virgule pour séparer deux lignes", ang="Waiting for a string in quotes. To build a vector or a matrix, it has to be a float serie, using a space or comma to separate two elements in a line, a semi-colon to separate rows"),
        ),
    SCRIPTWITHFUNCTIONS_DATA = BLOC ( condition = " FROM in ( 'ScriptWithFunctions', ) ",
        SCRIPTWITHFUNCTIONS_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py'), FunctionVal(DirectOperatorInNS), FunctionVal(TangentOperatorInNS), FunctionVal(AdjointOperatorInNS)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant en variables internes trois fonctions de calcul nommées DirectOperator, TangentOperator et AdjointOperator", ang="Waiting for a script file name, with or without the full path to find it, containing as internal variables three computation functions named DirectOperator, TangentOperator and AdjointOperator"),
        ),
    SCRIPTWITHONEFUNCTION_DATA = BLOC ( condition = " FROM in ( 'ScriptWithOneFunction', ) ",
        SCRIPTWITHONEFUNCTION_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py'), FunctionVal(DirectOperatorInNS)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant en variable interne une seule fonction de calcul nommée DirectOperator", ang="Waiting for a script file name, with or without the full path to find it, containing as internal variable only one function named DirectOperator"),
        DifferentialIncrement = SIMP(statut="o", typ = "R", val_min=0, val_max=1, defaut=0.01, fr="Incrément de la perturbation dX pour calculer la dérivée, construite en multipliant X par l'incrément en évitant les valeurs nulles", ang="Increment of dX perturbation to calculate the derivative, build multiplying X by the increment avoiding null values"),
        CenteredFiniteDifference = SIMP(statut="o", typ = "I", into=(0, 1), defaut=0, fr="Formulation centrée (1) ou décentrée (0) pour la méthode des différences finies", ang="Centered (1) or uncentered (0) formulation for the finite differences method"),
        EnableMultiProcessing = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Calculs élémentaires effectués en séquentiel (0) ou en parallèle (1) dans la méthode des différences finies", ang="Elementary calculations done sequentially (0) or in parallel (1) in the finite differences method"),
        NumberOfProcesses = SIMP(statut="f", typ = "I", val_min=0, defaut=0, fr="Nombre de processus parallèles, 0 pour un contrôle automatique", ang="Number of parallel processes, 0 for automatic control"),
        ),
    SCRIPTWITHSWITCH_DATA = BLOC ( condition = " FROM in ( 'ScriptWithSwitch', ) ",
        SCRIPTWITHSWITCH_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant un switch pour les calculs direct, tangent et adjoint", ang="Waiting for a script file name, with or without the full path to find it, containing a switch for direct, tangent and adjoint computations"),
        ),
    TEMPLATE_DATA =  BLOC (condition = " FROM in ( 'Template', ) ",
        Template = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "AnalysisPrinter", into=("AnalysisPrinter", "AnalysisSaver", "AnalysisPrinterAndSaver", "AnalysisSeriePrinter", "AnalysisSerieSaver", "AnalysisSeriePrinterAndSaver")),
        AnalysisPrinter = BLOC (condition = " Template == 'AnalysisPrinter' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nprint('Analysis',xa)", fr="Imprime sur la sortie standard la valeur optimale", ang="Print on standard output the optimal value" ),
            ),
        AnalysisSaver = BLOC (condition = " Template == 'AnalysisSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Enregistre la valeur optimale dans un fichier du répertoire '/tmp' nommé 'analysis.txt'", ang="Save the optimal value in a file of the '/tmp' directory named 'analysis.txt'" ),
            ),
        AnalysisPrinterAndSaver = BLOC (condition = " Template == 'AnalysisPrinterAndSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nprint('Analysis',xa)\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Imprime sur la sortie standard et, en même temps enregistre dans un fichier du répertoire '/tmp', la valeur optimale", ang="Print on standard output and, in the same time save in a file of the '/tmp' directory, the optimal value" ),
            ),
        AnalysisSeriePrinter = BLOC (condition = " Template == 'AnalysisSeriePrinter' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nprint('Analysis',xa)", fr="Imprime sur la sortie standard la série des valeurs optimales", ang="Print on standard output the optimal value series" ),
            ),
        AnalysisSerieSaver = BLOC (condition = " Template == 'AnalysisSerieSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Enregistre la série des valeurs optimales dans un fichier du répertoire '/tmp' nommé 'analysis.txt'", ang="Save the optimal value series in a file of the '/tmp' directory named 'analysis.txt'" ),
            ),
        AnalysisSeriePrinterAndSaver = BLOC (condition = " Template == 'AnalysisSeriePrinterAndSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nprint('Analysis',xa)\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Imprime sur la sortie standard et, en même temps enregistre dans un fichier du répertoire '/tmp', la série des valeurs optimales", ang="Print on standard output and, in the same time save in a file of the '/tmp' directory, the optimal value series" ),
            ),
        ),
    )

def BackgroundInNS(filename):
    if os.path.isfile(filename):
        fc = open(filename, 'r').readlines()
        cr = re.compile("^Background[\s]*=")
        for ln in fc:
            if cr.match(ln): return 1
    return 0
BackgroundInNS.info = u"The Python file has to contain explicitly a \"Background\" variable."
def F_Background(statut, fv=NoCheckInNS) : return FACT(
    statut=statut,
    Stored = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Choix de stockage interne ou non du concept parent", ang="Choice of the storage or not of the parent concept"),
    INPUT_TYPE = SIMP(statut="o", typ = "TXM", into=("Vector", "VectorSerie", ), defaut="Vector"),
    Vector = BLOC ( condition = " INPUT_TYPE in ( 'Vector', ) ",
        data = F_Vector("o", fv),
        ),
    VectorSerie = BLOC ( condition = " INPUT_TYPE in ( 'VectorSerie', ) ",
        data = F_VectorSerie("o", fv),
        ),
    )

def BackgroundErrorInNS(filename):
    if os.path.isfile(filename):
        fc = open(filename, 'r').readlines()
        cr = re.compile("^BackgroundError[\s]*=")
        for ln in fc:
            if cr.match(ln): return 1
    return 0
BackgroundErrorInNS.info = u"The Python file has to contain explicitly a \"BackgroundError\" variable."
def F_BackgroundError(statut, fv=NoCheckInNS) : return FACT(
    statut=statut,
    Stored = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Choix de stockage interne ou non du concept parent", ang="Choice of the storage or not of the parent concept"),
    INPUT_TYPE = SIMP(statut="o", typ = "TXM", into=("Matrix", "ScalarSparseMatrix", "DiagonalSparseMatrix", ), defaut="ScalarSparseMatrix"),
    Matrix = BLOC ( condition = " INPUT_TYPE in ( 'Matrix', ) ",
        data = F_Matrix("o", fv),
        ),
    ScalarSparseMatrix = BLOC ( condition = " INPUT_TYPE in ( 'ScalarSparseMatrix', ) ",
        data = F_ScalarSparseMatrix("o", fv),
        ),
    DiagonalSparseMatrix = BLOC ( condition = " INPUT_TYPE in ( 'DiagonalSparseMatrix', ) ",
        data = F_DiagonalSparseMatrix("o", fv),
        ),
    )

def ObservationInNS(filename):
    if os.path.isfile(filename):
        fc = open(filename, 'r').readlines()
        cr = re.compile("^Observation[\s]*=")
        for ln in fc:
            if cr.match(ln): return 1
    return 0
ObservationInNS.info = u"The Python file has to contain explicitly a \"Observation\" variable."
def F_Observation(statut, fv=NoCheckInNS) : return FACT(
    statut=statut,
    Stored = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Choix de stockage interne ou non du concept parent", ang="Choice of the storage or not of the parent concept"),
    INPUT_TYPE = SIMP(statut="o", typ = "TXM", into=("Vector", "VectorSerie", ), defaut="Vector"),
    Vector = BLOC ( condition = " INPUT_TYPE in ( 'Vector', ) ",
        data = F_Vector("o", fv),
        ),
    VectorSerie = BLOC ( condition = " INPUT_TYPE in ( 'VectorSerie', ) ",
        data = F_VectorSerie("o", fv),
        ),
    )

def ObservationErrorInNS(filename):
    if os.path.isfile(filename):
        fc = open(filename, 'r').readlines()
        cr = re.compile("^ObservationError[\s]*=")
        for ln in fc:
            if cr.match(ln): return 1
    return 0
ObservationErrorInNS.info = u"The Python file has to contain explicitly a \"ObservationError\" variable."
def F_ObservationError(statut, fv=NoCheckInNS) : return FACT(
    statut=statut,
    Stored = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Choix de stockage interne ou non du concept parent", ang="Choice of the storage or not of the parent concept"),
    INPUT_TYPE = SIMP(statut="o", typ = "TXM", into=("Matrix", "ScalarSparseMatrix", "DiagonalSparseMatrix", ), defaut="ScalarSparseMatrix"),
    Matrix = BLOC ( condition = " INPUT_TYPE in ( 'Matrix', ) ",
        data = F_Matrix("o", fv),
        ),
    ScalarSparseMatrix = BLOC ( condition = " INPUT_TYPE in ( 'ScalarSparseMatrix', ) ",
        data = F_ScalarSparseMatrix("o", fv),
        ),
    DiagonalSparseMatrix = BLOC ( condition = " INPUT_TYPE in ( 'DiagonalSparseMatrix', ) ",
        data = F_DiagonalSparseMatrix("o", fv),
        ),
    )

def ObservationOperatorInNS(filename):
    if os.path.isfile(filename):
        fc = open(filename, 'r').readlines()
        cr = re.compile("^ObservationOperator[\s]*=")
        for ln in fc:
            if cr.match(ln): return 1
    return 0
ObservationOperatorInNS.info = u"The Python file has to contain explicitly a \"ObservationOperator\" variable."
def F_ObservationOperator(statut, fv=NoCheckInNS) : return FACT(
    statut=statut,
    Stored = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Choix de stockage interne ou non du concept parent", ang="Choice of the storage or not of the parent concept"),
    INPUT_TYPE = SIMP(statut="o", typ = "TXM", into=("Matrix", "Function", ), defaut="Function"),
    Matrix = BLOC ( condition = " INPUT_TYPE in ( 'Matrix', ) ",
        data = F_Matrix("o", fv),
        ),
    Function = BLOC ( condition = " INPUT_TYPE in ( 'Function', ) ",
        data = F_Function("o", fv),
        ),
    )

def EvolutionModelInNS(filename):
    if os.path.isfile(filename):
        fc = open(filename, 'r').readlines()
        cr = re.compile("^EvolutionModel[\s]*=")
        for ln in fc:
            if cr.match(ln): return 1
    return 0
EvolutionModelInNS.info = u"The Python file has to contain explicitly a \"EvolutionModel\" variable."
def F_EvolutionModel(statut, fv=NoCheckInNS) : return FACT(
    statut=statut,
    Stored = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Choix de stockage interne ou non du concept parent", ang="Choice of the storage or not of the parent concept"),
    INPUT_TYPE = SIMP(statut="o", typ = "TXM", into=("Matrix", "Function", ), defaut="Function"),
    Matrix = BLOC ( condition = " INPUT_TYPE in ( 'Matrix', ) ",
        data = F_Matrix("o", fv),
        ),
    Function = BLOC ( condition = " INPUT_TYPE in ( 'Function', ) ",
        data = F_Function("o", fv),
        ),
    )

def EvolutionErrorInNS(filename):
    if os.path.isfile(filename):
        fc = open(filename, 'r').readlines()
        cr = re.compile("^EvolutionError[\s]*=")
        for ln in fc:
            if cr.match(ln): return 1
    return 0
EvolutionErrorInNS.info = u"The Python file has to contain explicitly a \"EvolutionError\" variable."
def F_EvolutionError(statut, fv=NoCheckInNS) : return FACT(
    statut=statut,
    Stored = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Choix de stockage interne ou non du concept parent", ang="Choice of the storage or not of the parent concept"),
    INPUT_TYPE = SIMP(statut="o", typ = "TXM", into=("Matrix", "ScalarSparseMatrix", "DiagonalSparseMatrix", ), defaut="ScalarSparseMatrix"),
    Matrix = BLOC ( condition = " INPUT_TYPE in ( 'Matrix', ) ",
        data = F_Matrix("o", fv),
        ),
    ScalarSparseMatrix = BLOC ( condition = " INPUT_TYPE in ( 'ScalarSparseMatrix', ) ",
        data = F_ScalarSparseMatrix("o", fv),
        ),
    DiagonalSparseMatrix = BLOC ( condition = " INPUT_TYPE in ( 'DiagonalSparseMatrix', ) ",
        data = F_DiagonalSparseMatrix("o", fv),
        ),
    )

def AlgorithmParametersInNS(filename):
    if os.path.isfile(filename):
        fc = open(filename, 'r').readlines()
        cr = re.compile("^AlgorithmParameters[\s]*=")
        for ln in fc:
            if cr.match(ln): return 1
    return 0
AlgorithmParametersInNS.info = u"The Python file has to contain explicitly a \"AlgorithmParameters\" variable."
def F_AlgorithmParameters(statut, fv=NoCheckInNS) : return FACT(
    statut=statut,

    INPUT_TYPE = SIMP(statut="o", typ = "TXM", into=("Dict", ), defaut="Dict"),
    Dict = BLOC ( condition = " INPUT_TYPE in ( 'Dict', ) ",
        data = F_Dict("o", fv),
        ),
    )

def UserDataInitInNS(filename):
    if os.path.isfile(filename):
        fc = open(filename, 'r').readlines()
        cr = re.compile("^UserDataInit[\s]*=")
        for ln in fc:
            if cr.match(ln): return 1
    return 0
UserDataInitInNS.info = u"The Python file has to contain explicitly a \"UserDataInit\" variable."
def F_UserDataInit(statut, fv=NoCheckInNS) : return FACT(
    statut=statut,

    INPUT_TYPE = SIMP(statut="o", typ = "TXM", into=("Dict", ), defaut="Dict"),
    Dict = BLOC ( condition = " INPUT_TYPE in ( 'Dict', ) ",
        data = F_Dict("o", fv),
        ),
    )

def CheckingPointInNS(filename):
    if os.path.isfile(filename):
        fc = open(filename, 'r').readlines()
        cr = re.compile("^CheckingPoint[\s]*=")
        for ln in fc:
            if cr.match(ln): return 1
    return 0
CheckingPointInNS.info = u"The Python file has to contain explicitly a \"CheckingPoint\" variable."
def F_CheckingPoint(statut, fv=NoCheckInNS) : return FACT(
    statut=statut,
    Stored = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Choix de stockage interne ou non du concept parent", ang="Choice of the storage or not of the parent concept"),
    INPUT_TYPE = SIMP(statut="o", typ = "TXM", into=("Vector", ), defaut="Vector"),
    Vector = BLOC ( condition = " INPUT_TYPE in ( 'Vector', ) ",
        data = F_Vector("o", fv),
        ),
    )

def ControlInputInNS(filename):
    if os.path.isfile(filename):
        fc = open(filename, 'r').readlines()
        cr = re.compile("^ControlInput[\s]*=")
        for ln in fc:
            if cr.match(ln): return 1
    return 0
ControlInputInNS.info = u"The Python file has to contain explicitly a \"ControlInput\" variable."
def F_ControlInput(statut, fv=NoCheckInNS) : return FACT(
    statut=statut,
    Stored = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Choix de stockage interne ou non du concept parent", ang="Choice of the storage or not of the parent concept"),
    INPUT_TYPE = SIMP(statut="o", typ = "TXM", into=("Vector", "VectorSerie", ), defaut="Vector"),
    Vector = BLOC ( condition = " INPUT_TYPE in ( 'Vector', ) ",
        data = F_Vector("o", fv),
        ),
    VectorSerie = BLOC ( condition = " INPUT_TYPE in ( 'VectorSerie', ) ",
        data = F_VectorSerie("o", fv),
        ),
    )

def F_UserPostAnalysis(statut, fv=NoCheckInNS) : return FACT(
    statut = statut,
    FROM = SIMP(statut = "o", typ = "TXM", into=("String", "Script", "Template", ), defaut="Template"),
    SCRIPT_DATA = BLOC ( condition = " FROM in ( 'Script', ) ",
        SCRIPT_FILE = SIMP(statut = "o", typ = ("FichierNoAbs",'Python Files (*.py)',), validators=[OnlyStr(), FileExtVal('py'), FunctionVal(fv)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant si nécessaire la définition d'une variable interne de même nom que le concept parent", ang="Waiting for a script file name, with or without the full path to find it, containing if necessary the definition of an internal variable of the same name as the parent concept"),
        ),
    DATA_DATA = BLOC ( condition = " FROM in ( 'DataFile', ) ",
        DATA_FILE = SIMP(statut = "o", typ = ("FichierNoAbs",'CSV Text Files (*.csv);;TSV Text Files (*.tsv);;TXT Text Files (*.txt);;NPY Binary Numpy Files (*.npy);;NPZ Binary Numpy Files (*.npz);;All Files (*)", ',), validators=[OnlyStr(), FunctionVal(ColDataFileExtVal)], fr="En attente d'un nom de fichier de données, avec ou sans le chemin complet pour le trouver, contenant ou plusieurs colonnes pour définir un unique vecteur continu", ang="Waiting for a data file name, with or without the full path to find it, containing one or more columns to define a unique continuous vector"),
        ColMajor = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Variables en colonnes acquises ligne par ligne (0) ou colonne par colonne (1)", ang="Variables in columns acquired line by line (0) or column by column (1)"),
        ),
    STRING_DATA = BLOC ( condition = " FROM in ( 'String', ) ",
        STRING = SIMP(statut = "o", typ = "TXM", fr="En attente d'une chaîne de caractères entre guillemets. Pour construire un vecteur ou une matrice, ce doit être une suite de nombres, utilisant un espace ou une virgule pour séparer deux éléments et un point-virgule pour séparer deux lignes", ang="Waiting for a string in quotes. To build a vector or a matrix, it has to be a float serie, using a space or comma to separate two elements in a line, a semi-colon to separate rows"),
        ),
    SCRIPTWITHFUNCTIONS_DATA = BLOC ( condition = " FROM in ( 'ScriptWithFunctions', ) ",
        SCRIPTWITHFUNCTIONS_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py'), FunctionVal(DirectOperatorInNS), FunctionVal(TangentOperatorInNS), FunctionVal(AdjointOperatorInNS)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant en variables internes trois fonctions de calcul nommées DirectOperator, TangentOperator et AdjointOperator", ang="Waiting for a script file name, with or without the full path to find it, containing as internal variables three computation functions named DirectOperator, TangentOperator and AdjointOperator"),
        ),
    SCRIPTWITHONEFUNCTION_DATA = BLOC ( condition = " FROM in ( 'ScriptWithOneFunction', ) ",
        SCRIPTWITHONEFUNCTION_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py'), FunctionVal(DirectOperatorInNS)], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant en variable interne une seule fonction de calcul nommée DirectOperator", ang="Waiting for a script file name, with or without the full path to find it, containing as internal variable only one function named DirectOperator"),
        DifferentialIncrement = SIMP(statut="o", typ = "R", val_min=0, val_max=1, defaut=0.01, fr="Incrément de la perturbation dX pour calculer la dérivée, construite en multipliant X par l'incrément en évitant les valeurs nulles", ang="Increment of dX perturbation to calculate the derivative, build multiplying X by the increment avoiding null values"),
        CenteredFiniteDifference = SIMP(statut="o", typ = "I", into=(0, 1), defaut=0, fr="Formulation centrée (1) ou décentrée (0) pour la méthode des différences finies", ang="Centered (1) or uncentered (0) formulation for the finite differences method"),
        EnableMultiProcessing = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0, fr="Calculs élémentaires effectués en séquentiel (0) ou en parallèle (1) dans la méthode des différences finies", ang="Elementary calculations done sequentially (0) or in parallel (1) in the finite differences method"),
        NumberOfProcesses = SIMP(statut="f", typ = "I", val_min=0, defaut=0, fr="Nombre de processus parallèles, 0 pour un contrôle automatique", ang="Number of parallel processes, 0 for automatic control"),
        ),
    SCRIPTWITHSWITCH_DATA = BLOC ( condition = " FROM in ( 'ScriptWithSwitch', ) ",
        SCRIPTWITHSWITCH_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')], fr="En attente d'un nom de fichier script, avec ou sans le chemin complet pour le trouver, contenant un switch pour les calculs direct, tangent et adjoint", ang="Waiting for a script file name, with or without the full path to find it, containing a switch for direct, tangent and adjoint computations"),
        ),
    TEMPLATE_DATA =  BLOC (condition = " FROM in ( 'Template', ) ",
        Template = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "AnalysisPrinter", into=("AnalysisPrinter", "AnalysisSaver", "AnalysisPrinterAndSaver", "AnalysisSeriePrinter", "AnalysisSerieSaver", "AnalysisSeriePrinterAndSaver")),
        AnalysisPrinter = BLOC (condition = " Template == 'AnalysisPrinter' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nprint('Analysis',xa)", fr="Imprime sur la sortie standard la valeur optimale", ang="Print on standard output the optimal value" ),
            ),
        AnalysisSaver = BLOC (condition = " Template == 'AnalysisSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Enregistre la valeur optimale dans un fichier du répertoire '/tmp' nommé 'analysis.txt'", ang="Save the optimal value in a file of the '/tmp' directory named 'analysis.txt'" ),
            ),
        AnalysisPrinterAndSaver = BLOC (condition = " Template == 'AnalysisPrinterAndSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')[-1]\nprint('Analysis',xa)\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Imprime sur la sortie standard et, en même temps enregistre dans un fichier du répertoire '/tmp', la valeur optimale", ang="Print on standard output and, in the same time save in a file of the '/tmp' directory, the optimal value" ),
            ),
        AnalysisSeriePrinter = BLOC (condition = " Template == 'AnalysisSeriePrinter' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nprint('Analysis',xa)", fr="Imprime sur la sortie standard la série des valeurs optimales", ang="Print on standard output the optimal value series" ),
            ),
        AnalysisSerieSaver = BLOC (condition = " Template == 'AnalysisSerieSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Enregistre la série des valeurs optimales dans un fichier du répertoire '/tmp' nommé 'analysis.txt'", ang="Save the optimal value series in a file of the '/tmp' directory named 'analysis.txt'" ),
            ),
        AnalysisSeriePrinterAndSaver = BLOC (condition = " Template == 'AnalysisSeriePrinterAndSaver' ",
            ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print('# Post-analysis')\nimport numpy\nxa=ADD.get('Analysis')\nprint('Analysis',xa)\nf='/tmp/analysis.txt'\nprint('Analysis saved in \"%s\"'%f)\nnumpy.savetxt(f,xa)", fr="Imprime sur la sortie standard et, en même temps enregistre dans un fichier du répertoire '/tmp', la série des valeurs optimales", ang="Print on standard output and, in the same time save in a file of the '/tmp' directory, the optimal value series" ),
            ),
        ),
    )

def F_InitChoice() : return  ("Background",
                              "BackgroundError",
                              "Observation",
                              "ObservationError",
                              "ObservationOperator",
                              "EvolutionModel",
                              "EvolutionError",
                              "AlgorithmParameters",
                              "UserPostAnalysis",
                             )

def F_Init(statut) : return FACT(statut = statut,
    INIT_FILE = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')]),
    TARGET_LIST = SIMP(statut = "o", typ = "TXM", min=1, max="**", into=F_InitChoice(),  validators=(VerifExiste(2))),
    )

def F_ObserverTemplate() : return BLOC(condition = " NodeType == 'Template' ",
                Template = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "ValuePrinter", into=("ValuePrinter", "ValueAndIndexPrinter", "ValueSeriePrinter", "ValueSaver", "ValueSerieSaver", "ValuePrinterAndSaver", "ValueIndexPrinterAndSaver", "ValueSeriePrinterAndSaver", "ValueGnuPlotter", "ValueSerieGnuPlotter", "ValuePrinterAndGnuPlotter", "ValueSeriePrinterAndGnuPlotter", "ValuePrinterSaverAndGnuPlotter", "ValueSeriePrinterSaverAndGnuPlotter", "ValueMean", "ValueStandardError", "ValueVariance", "ValueL2Norm", "ValueRMS")),
                ValuePrinter = BLOC (condition = " Template == 'ValuePrinter' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print(str(info)+\" \"+str(var[-1]))", fr="Imprime sur la sortie standard la valeur courante de la variable", ang="Print on standard output the current value of the variable" ),
                    ),
                ValueAndIndexPrinter = BLOC (condition = " Template == 'ValueAndIndexPrinter' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print(str(info)+(\" index %i:\"%(len(var)-1))+\" \"+str(var[-1]))", fr="Imprime sur la sortie standard la valeur courante de la variable, en ajoutant son index", ang="Print on standard output the current value of the variable, adding its index" ),
                    ),
                ValueSeriePrinter = BLOC (condition = " Template == 'ValueSeriePrinter' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print(str(info)+\" \"+str(var[:]))", fr="Imprime sur la sortie standard la série des valeurs de la variable", ang="Print on standard output the value series of the variable" ),
                    ),
                ValueSaver = BLOC (condition = " Template == 'ValueSaver' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "import numpy, re\nv=numpy.array(var[-1], ndmin=1)\nglobal istep\ntry:\n    istep += 1\nexcept:\n    istep = 0\nf='/tmp/value_%s_%05i.txt'%(info,istep)\nf=re.sub('\s','_',f)\nprint('Value saved in \"%s\"'%f)\nnumpy.savetxt(f,v)", fr="Enregistre la valeur courante de la variable dans un fichier du répertoire '/tmp' nommé 'value...txt' selon le nom de la variable et l'étape d'enregistrement", ang="Save the current value of the variable in a file of the '/tmp' directory named 'value...txt' from the variable name and the saving step" ),
                    ),
                ValueSerieSaver = BLOC (condition = " Template == 'ValueSerieSaver' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "import numpy, re\nv=numpy.array(var[:],  ndmin=1)\nglobal istep\ntry:\n    istep += 1\nexcept:\n    istep = 0\nf='/tmp/value_%s_%05i.txt'%(info,istep)\nf=re.sub('\s','_',f)\nprint('Value saved in \"%s\"'%f)\nnumpy.savetxt(f,v)", fr="Enregistre la série des valeurs de la variable dans un fichier du répertoire '/tmp' nommé 'value...txt' selon le nom de la variable et l'étape", ang="Save the value series of the variable in a file of the '/tmp' directory named 'value...txt' from the variable name and the saving step" ),
                    ),
                ValuePrinterAndSaver = BLOC (condition = " Template == 'ValuePrinterAndSaver' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "import numpy, re\nv=numpy.array(var[-1], ndmin=1)\nprint(str(info)+\" \"+str(v))\nglobal istep\ntry:\n    istep += 1\nexcept:\n    istep = 0\nf='/tmp/value_%s_%05i.txt'%(info,istep)\nf=re.sub('\s','_',f)\nprint('Value saved in \"%s\"'%f)\nnumpy.savetxt(f,v)", fr="Imprime sur la sortie standard et, en même temps enregistre dans un fichier du répertoire '/tmp', la valeur courante de la variable", ang="Print on standard output and, in the same time save in a file of the '/tmp' directory, the current value of the variable" ),
                    ),
                ValueIndexPrinterAndSaver = BLOC (condition = " Template == 'ValueIndexPrinterAndSaver' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "import numpy, re\nv=numpy.array(var[-1], ndmin=1)\nprint(str(info)+(\" index %i:\"%(len(var)-1))+\" \"+str(v))\nglobal istep\ntry:\n    istep += 1\nexcept:\n    istep = 0\nf='/tmp/value_%s_%05i.txt'%(info,istep)\nf=re.sub('\s','_',f)\nprint('Value saved in \"%s\"'%f)\nnumpy.savetxt(f,v)", fr="Imprime sur la sortie standard et, en même temps enregistre dans un fichier du répertoire '/tmp', la valeur courante de la variable, en ajoutant son index", ang="Print on standard output and, in the same time save in a file of the '/tmp' directory, the current value of the variable, adding its index" ),
                    ),
                ValueSeriePrinterAndSaver = BLOC (condition = " Template == 'ValueSeriePrinterAndSaver' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "import numpy, re\nv=numpy.array(var[:],  ndmin=1)\nprint(str(info)+\" \"+str(v))\nglobal istep\ntry:\n    istep += 1\nexcept:\n    istep = 0\nf='/tmp/value_%s_%05i.txt'%(info,istep)\nf=re.sub('\s','_',f)\nprint('Value saved in \"%s\"'%f)\nnumpy.savetxt(f,v)", fr="Imprime sur la sortie standard et, en même temps, enregistre dans un fichier du répertoire '/tmp', la série des valeurs de la variable", ang="Print on standard output and, in the same time, save in a file of the '/tmp' directory, the value series of the variable" ),
                    ),
                ValueGnuPlotter = BLOC (condition = " Template == 'ValueGnuPlotter' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "import numpy, Gnuplot\nv=numpy.array(var[-1], ndmin=1)\nglobal ifig, gp\ntry:\n    ifig += 1\n    gp(' set style data lines')\nexcept:\n    ifig = 0\n    gp = Gnuplot.Gnuplot(persist=1)\n    gp(' set style data lines')\ngp('set title  \"%s (Figure %i)\"'%(info,ifig))\ngp.plot( Gnuplot.Data( v, with_='lines lw 2' ) )", fr="Affiche graphiquement avec Gnuplot la valeur courante de la variable", ang="Graphically plot with Gnuplot the current value of the variable" ),
                    ),
                ValueSerieGnuPlotter = BLOC (condition = " Template == 'ValueSerieGnuPlotter' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "import numpy, Gnuplot\nv=numpy.array(var[:],  ndmin=1)\nglobal ifig, gp\ntry:\n    ifig += 1\n    gp(' set style data lines')\nexcept:\n    ifig = 0\n    gp = Gnuplot.Gnuplot(persist=1)\n    gp(' set style data lines')\ngp('set title  \"%s (Figure %i)\"'%(info,ifig))\ngp.plot( Gnuplot.Data( v, with_='lines lw 2' ) )", fr="Affiche graphiquement avec Gnuplot la série des valeurs de la variable", ang="Graphically plot with Gnuplot the value series of the variable" ),
                    ),
                ValuePrinterAndGnuPlotter = BLOC (condition = " Template == 'ValuePrinterAndGnuPlotter' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print(str(info)+\" \"+str(var[-1]))\nimport numpy, Gnuplot\nv=numpy.array(var[-1], ndmin=1)\nglobal ifig,gp\ntry:\n    ifig += 1\n    gp(' set style data lines')\nexcept:\n    ifig = 0\n    gp = Gnuplot.Gnuplot(persist=1)\n    gp(' set style data lines')\ngp('set title  \"%s (Figure %i)\"'%(info,ifig))\ngp.plot( Gnuplot.Data( v, with_='lines lw 2' ) )", fr="Imprime sur la sortie standard et, en même temps, affiche graphiquement avec Gnuplot la valeur courante de la variable", ang="Print on standard output and, in the same time, graphically plot with Gnuplot the current value of the variable" ),
                    ),
                ValueSeriePrinterAndGnuPlotter = BLOC (condition = " Template == 'ValueSeriePrinterAndGnuPlotter' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print(str(info)+\" \"+str(var[:]))\nimport numpy, Gnuplot\nv=numpy.array(var[:],  ndmin=1)\nglobal ifig,gp\ntry:\n    ifig += 1\n    gp(' set style data lines')\nexcept:\n    ifig = 0\n    gp = Gnuplot.Gnuplot(persist=1)\n    gp(' set style data lines')\ngp('set title  \"%s (Figure %i)\"'%(info,ifig))\ngp.plot( Gnuplot.Data( v, with_='lines lw 2' ) )", fr="Imprime sur la sortie standard et, en même temps, affiche graphiquement avec Gnuplot la série des valeurs de la variable", ang="Print on standard output and, in the same time, graphically plot with Gnuplot the value series of the variable" ),
                    ),
                ValuePrinterSaverAndGnuPlotter = BLOC (condition = " Template == 'ValuePrinterSaverAndGnuPlotter' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print(str(info)+\" \"+str(var[-1]))\nimport numpy, re\nv=numpy.array(var[-1], ndmin=1)\nglobal istep\ntry:\n    istep += 1\nexcept:\n    istep = 0\nf='/tmp/value_%s_%05i.txt'%(info,istep)\nf=re.sub('\s','_',f)\nprint('Value saved in \"%s\"'%f)\nnumpy.savetxt(f,v)\nimport Gnuplot\nglobal ifig,gp\ntry:\n    ifig += 1\n    gp(' set style data lines')\nexcept:\n    ifig = 0\n    gp = Gnuplot.Gnuplot(persist=1)\n    gp(' set style data lines')\ngp('set title  \"%s (Figure %i)\"'%(info,ifig))\ngp.plot( Gnuplot.Data( v, with_='lines lw 2' ) )", fr="Imprime sur la sortie standard et, en même temps, enregistre dans un fichier du répertoire '/tmp' et affiche graphiquement la valeur courante de la variable", ang="Print on standard output and, in the same, time save in a file of the '/tmp' directory and graphically plot the current value of the variable" ),
                    ),
                ValueSeriePrinterSaverAndGnuPlotter = BLOC (condition = " Template == 'ValueSeriePrinterSaverAndGnuPlotter' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "print(str(info)+\" \"+str(var[:]))\nimport numpy, re\nv=numpy.array(var[:],  ndmin=1)\nglobal istep\ntry:\n    istep += 1\nexcept:\n    istep = 0\nf='/tmp/value_%s_%05i.txt'%(info,istep)\nf=re.sub('\s','_',f)\nprint('Value saved in \"%s\"'%f)\nnumpy.savetxt(f,v)\nimport Gnuplot\nglobal ifig,gp\ntry:\n    ifig += 1\n    gp(' set style data lines')\nexcept:\n    ifig = 0\n    gp = Gnuplot.Gnuplot(persist=1)\n    gp(' set style data lines')\ngp('set title  \"%s (Figure %i)\"'%(info,ifig))\ngp.plot( Gnuplot.Data( v, with_='lines lw 2' ) )", fr="Imprime sur la sortie standard et, en même temps, enregistre dans un fichier du répertoire '/tmp' et affiche graphiquement la série des valeurs de la variable", ang="Print on standard output and, in the same, time save in a file of the '/tmp' directory and graphically plot the value series of the variable" ),
                    ),
                ValueMean = BLOC (condition = " Template == 'ValueMean' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "import numpy\nprint(str(info)+\" \"+str(numpy.nanmean(var[-1])))", fr="Imprime sur la sortie standard la moyenne de la valeur courante de la variable", ang="Print on standard output the mean of the current value of the variable" ),
                    ),
                ValueStandardError = BLOC (condition = " Template == 'ValueStandardError' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "import numpy\nprint(str(info)+\" \"+str(numpy.nanstd(var[-1])))", fr="Imprime sur la sortie standard l'écart-type de la valeur courante de la variable", ang="Print on standard output the standard error of the current value of the variable" ),
                    ),
                ValueVariance = BLOC (condition = " Template == 'ValueVariance' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "import numpy\nprint(str(info)+\" \"+str(numpy.nanvar(var[-1])))", fr="Imprime sur la sortie standard la variance de la valeur courante de la variable", ang="Print on standard output the variance of the current value of the variable" ),
                    ),
                ValueL2Norm = BLOC (condition = " Template == 'ValueL2Norm' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "import numpy\nv = numpy.ravel( var[-1] )\nprint(str(info)+\" \"+str(float( numpy.linalg.norm(v) )))", fr="Imprime sur la sortie standard la norme L2 de la valeur courante de la variable", ang="Print on standard output the L2 norm of the current value of the variable" ),
                    ),
                ValueRMS = BLOC (condition = " Template == 'ValueRMS' ",
                    ValueTemplate = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "import numpy\nv = numpy.ravel( var[-1] )\nprint(str(info)+\" \"+str(float( numpy.sqrt((1./v.size)*numpy.dot(v,v)) )))", fr="Imprime sur la sortie standard la racine de la moyenne des carrés (RMS), ou moyenne quadratique, de la valeur courante de la variable", ang="Print on standard output the root mean square (RMS), or quadratic mean, of the current value of the variable" ),
                    ),
                )

def F_Observers(statut) : return FACT(
    statut=statut,
    SELECTION = SIMP(statut="o", defaut=[], typ="TXM", min=0, max="**", homo="SansOrdreNiDoublon", validators=NoRepeat(), into=(['Analysis', 'Innovation', 'InnovationAtCurrentState', 'CurrentState', 'CurrentOptimum', 'IndexOfOptimum', 'SimulatedObservationAtBackground', 'SimulatedObservationAtCurrentState', 'SimulatedObservationAtOptimum', 'SimulatedObservationAtCurrentOptimum', 'BMA', 'OMA', 'OMB', 'CostFunctionJ', 'CostFunctionJb', 'CostFunctionJo', 'GradientOfCostFunctionJ', 'GradientOfCostFunctionJb', 'GradientOfCostFunctionJo', 'SigmaObs2', 'SigmaBck2', 'APosterioriCorrelations', 'APosterioriCovariance', 'APosterioriStandardDeviations', 'APosterioriVariances', 'Residu'])),
    Analysis = BLOC (condition=" 'Analysis' in set(SELECTION) ",
        Analysis_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "Analysis"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    Innovation = BLOC (condition=" 'Innovation' in set(SELECTION) ",
        Innovation_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "Innovation"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    InnovationAtCurrentState = BLOC (condition=" 'InnovationAtCurrentState' in set(SELECTION) ",
        InnovationAtCurrentState_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "InnovationAtCurrentState"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    CurrentState = BLOC (condition=" 'CurrentState' in set(SELECTION) ",
        CurrentState_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "CurrentState"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    CurrentOptimum = BLOC (condition=" 'CurrentOptimum' in set(SELECTION) ",
        CurrentOptimum_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "CurrentOptimum"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    IndexOfOptimum = BLOC (condition=" 'IndexOfOptimum' in set(SELECTION) ",
        IndexOfOptimum_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "IndexOfOptimum"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    SimulatedObservationAtBackground = BLOC (condition=" 'SimulatedObservationAtBackground' in set(SELECTION) ",
        SimulatedObservationAtBackground_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "SimulatedObservationAtBackground"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    SimulatedObservationAtCurrentState = BLOC (condition=" 'SimulatedObservationAtCurrentState' in set(SELECTION) ",
        SimulatedObservationAtCurrentState_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "SimulatedObservationAtCurrentState"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    SimulatedObservationAtOptimum = BLOC (condition=" 'SimulatedObservationAtOptimum' in set(SELECTION) ",
        SimulatedObservationAtOptimum_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "SimulatedObservationAtOptimum"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    SimulatedObservationAtCurrentOptimum = BLOC (condition=" 'SimulatedObservationAtCurrentOptimum' in set(SELECTION) ",
        SimulatedObservationAtCurrentOptimum_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "SimulatedObservationAtCurrentOptimum"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    BMA = BLOC (condition=" 'BMA' in set(SELECTION) ",
        BMA_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "BMA"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    OMA = BLOC (condition=" 'OMA' in set(SELECTION) ",
        OMA_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "OMA"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    OMB = BLOC (condition=" 'OMB' in set(SELECTION) ",
        OMB_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "OMB"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    CostFunctionJ = BLOC (condition=" 'CostFunctionJ' in set(SELECTION) ",
        CostFunctionJ_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "CostFunctionJ"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    CostFunctionJb = BLOC (condition=" 'CostFunctionJb' in set(SELECTION) ",
        CostFunctionJb_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "CostFunctionJb"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    CostFunctionJo = BLOC (condition=" 'CostFunctionJo' in set(SELECTION) ",
        CostFunctionJo_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "CostFunctionJo"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    GradientOfCostFunctionJ = BLOC (condition=" 'GradientOfCostFunctionJ' in set(SELECTION) ",
        GradientOfCostFunctionJ_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "GradientOfCostFunctionJ"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    GradientOfCostFunctionJb = BLOC (condition=" 'GradientOfCostFunctionJb' in set(SELECTION) ",
        GradientOfCostFunctionJb_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "GradientOfCostFunctionJb"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    GradientOfCostFunctionJo = BLOC (condition=" 'GradientOfCostFunctionJo' in set(SELECTION) ",
        GradientOfCostFunctionJo_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "GradientOfCostFunctionJo"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    SigmaObs2 = BLOC (condition=" 'SigmaObs2' in set(SELECTION) ",
        SigmaObs2_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "SigmaObs2"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    SigmaBck2 = BLOC (condition=" 'SigmaBck2' in set(SELECTION) ",
        SigmaBck2_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "SigmaBck2"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    APosterioriCorrelations = BLOC (condition=" 'APosterioriCorrelations' in set(SELECTION) ",
        APosterioriCorrelations_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "APosterioriCorrelations"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    APosterioriCovariance = BLOC (condition=" 'APosterioriCovariance' in set(SELECTION) ",
        APosterioriCovariance_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "APosterioriCovariance"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    APosterioriStandardDeviations = BLOC (condition=" 'APosterioriStandardDeviations' in set(SELECTION) ",
        APosterioriStandardDeviations_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "APosterioriStandardDeviations"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    APosterioriVariances = BLOC (condition=" 'APosterioriVariances' in set(SELECTION) ",
        APosterioriVariances_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "APosterioriVariances"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    Residu = BLOC (condition=" 'Residu' in set(SELECTION) ",
        Residu_data = FACT(statut = "o",
            Scheduler    = SIMP(statut = "f", typ = "TXM"),
            Info         = SIMP(statut = "o", typ = "TXM", defaut = "Residu"),
            NodeType     = SIMP(statut = "o", typ = "TXM", min=1, max=1, defaut = "Template", into=("String", "Script", "Template")),
            PythonScript = BLOC (condition = " NodeType == 'String' ",
                Value = SIMP(statut = "o", typ = "TXM")
                ),
            UserFile = BLOC (condition = " NodeType == 'Script' ",
                Value = SIMP(statut = "o", typ = "FichierNoAbs", validators=[OnlyStr(), FileExtVal('py')])
                ),
            ObserverTemplate = F_ObserverTemplate(),
            ),
        ),
    )

def AlgorithmParametersInNS(filename):
    if os.path.isfile(filename):
        fc = open(filename, 'r').readlines()
        cr = re.compile("^AlgorithmParameters[\s]*=")
        for ln in fc:
            if cr.match(ln): return 1
    return 0
AlgorithmParametersInNS.info = u"The Python file has to contain explicitly an \"AlgorithmParameters\" variable."
def F_AlgorithmParameters(statut, algos_names, fv=NoCheckInNS) : return FACT(
    statut = statut,
    Algorithm = SIMP(statut="o", typ = "TXM", into = algos_names ),
    Parameters = SIMP(statut="f", typ = "TXM", into=("Defaults", "Dict"), defaut="Defaults"),
    Dict = BLOC ( condition = " Parameters == 'Dict' ",
        statut="f",
        data = F_Dict("o", fv),
        ),
    Parameters3DVAR = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == '3DVAR') ",
        statut="f",
        Bounds = SIMP(statut="f", typ="TXM", fr="Liste des paires de bornes"),
        CostDecrementTolerance = SIMP(statut="f", typ="R", val_min=0.0, min=1, max=1, defaut=1e-07, fr="Diminution relative minimale du coût lors de l'arrêt"),
        EstimationOf = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="Parameters", into=['State', 'Parameters'], fr="Estimation d'état ou de paramètres"),
        GradientNormTolerance = SIMP(statut="f", typ="R", val_min=0.0, min=1, max=1, defaut=1e-05, fr="Maximum des composantes du gradient lors de l'arrêt"),
        InitializationPoint = SIMP(statut="f", typ="TXM", fr="État initial imposé (par défaut, c'est l'ébauche si None)"),
        MaximumNumberOfSteps = SIMP(statut="f", typ="I", val_min=-1, min=1, max=1, defaut=15000, fr="Nombre maximal de pas d'optimisation"),
        Minimizer = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="LBFGSB", into=['LBFGSB', 'TNC', 'CG', 'NCG', 'BFGS'], fr="Minimiseur utilisé"),
        NumberOfSamplesForQuantiles = SIMP(statut="f", typ="I", val_min=1, min=1, max=1, defaut=100, fr="Nombre d'échantillons simulés pour le calcul des quantiles"),
        ProjectedGradientTolerance = SIMP(statut="f", typ="R", val_min=-1, min=1, max=1, defaut=-1.0, fr="Maximum des composantes du gradient projeté lors de l'arrêt"),
        Quantiles = SIMP(statut="f", typ="TXM", max="**", into=None, fr="Liste des valeurs de quantiles"),
        SetSeed = SIMP(statut="f", typ="TXM", fr="Graine fixée pour le générateur aléatoire"),
        SimulationForQuantiles = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="Linear", into=['Linear', 'NonLinear'], fr="Type de simulation en estimation des quantiles"),
        StateBoundsForQuantiles = SIMP(statut="f", typ="TXM", fr="Liste des paires de bornes pour les états utilisés en estimation des quantiles"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['Analysis', 'APosterioriCorrelations', 'APosterioriCovariance', 'APosterioriStandardDeviations', 'APosterioriVariances', 'BMA', 'CostFunctionJ', 'CostFunctionJAtCurrentOptimum', 'CostFunctionJb', 'CostFunctionJbAtCurrentOptimum', 'CostFunctionJo', 'CostFunctionJoAtCurrentOptimum', 'CurrentIterationNumber', 'CurrentOptimum', 'CurrentState', 'ForecastState', 'IndexOfOptimum', 'Innovation', 'InnovationAtCurrentState', 'JacobianMatrixAtBackground', 'JacobianMatrixAtOptimum', 'KalmanGainAtOptimum', 'MahalanobisConsistency', 'OMA', 'OMB', 'SampledStateForQuantiles', 'SigmaObs2', 'SimulatedObservationAtBackground', 'SimulatedObservationAtCurrentOptimum', 'SimulatedObservationAtCurrentState', 'SimulatedObservationAtOptimum', 'SimulationQuantiles'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        Variant = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="3DVAR", into=['3DVAR', '3DVAR-VAN', '3DVAR-Incr', '3DVAR-PSAS'], fr="Variant ou formulation de la méthode"),
        ),
    Parameters4DVAR = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == '4DVAR') ",
        statut="f",
        Bounds = SIMP(statut="f", typ="TXM", fr="Liste des valeurs de bornes"),
        ConstrainedBy = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="EstimateProjection", into=['EstimateProjection'], fr="Prise en compte des contraintes"),
        CostDecrementTolerance = SIMP(statut="f", typ="R", val_min=0.0, min=1, max=1, defaut=1e-07, fr="Diminution relative minimale du coût lors de l'arrêt"),
        EstimationOf = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="State", into=['State', 'Parameters'], fr="Estimation d'état ou de paramètres"),
        GradientNormTolerance = SIMP(statut="f", typ="R", val_min=0.0, min=1, max=1, defaut=1e-05, fr="Maximum des composantes du gradient lors de l'arrêt"),
        InitializationPoint = SIMP(statut="f", typ="TXM", fr="État initial imposé (par défaut, c'est l'ébauche si None)"),
        MaximumNumberOfSteps = SIMP(statut="f", typ="I", val_min=-1, min=1, max=1, defaut=15000, fr="Nombre maximal de pas d'optimisation"),
        Minimizer = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="LBFGSB", into=['LBFGSB', 'TNC', 'CG', 'NCG', 'BFGS'], fr="Minimiseur utilisé"),
        ProjectedGradientTolerance = SIMP(statut="f", typ="R", val_min=-1, min=1, max=1, defaut=-1.0, fr="Maximum des composantes du gradient projeté lors de l'arrêt"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['Analysis', 'BMA', 'CostFunctionJ', 'CostFunctionJAtCurrentOptimum', 'CostFunctionJb', 'CostFunctionJbAtCurrentOptimum', 'CostFunctionJo', 'CostFunctionJoAtCurrentOptimum', 'CurrentIterationNumber', 'CurrentOptimum', 'CurrentState', 'IndexOfOptimum'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        Variant = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="4DVAR", into=['4DVAR'], fr="Variant ou formulation de la méthode"),
        ),
    ParametersAdjointTest = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'AdjointTest') ",
        statut="f",
        AmplitudeOfInitialDirection = SIMP(statut="f", typ="R", min=1, max=1, defaut=1.0, fr="Amplitude de la direction initiale de la dérivée directionnelle autour du point nominal"),
        EpsilonMinimumExponent = SIMP(statut="f", typ="I", val_min=-20, val_max=0, min=1, max=1, defaut=-8, fr="Exposant minimal en puissance de 10 pour le multiplicateur d'incrément"),
        InitialDirection = SIMP(statut="f", typ="TXM", fr="Direction initiale de la dérivée directionnelle autour du point nominal"),
        ResiduFormula = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="ScalarProduct", into=['ScalarProduct'], fr="Formule de résidu utilisée"),
        SetSeed = SIMP(statut="f", typ="TXM", fr="Graine fixée pour le générateur aléatoire"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['CurrentState', 'Residu', 'SimulatedObservationAtCurrentState'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        ),
    ParametersBlue = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'Blue') ",
        statut="f",
        NumberOfSamplesForQuantiles = SIMP(statut="f", typ="I", val_min=1, min=1, max=1, defaut=100, fr="Nombre d'échantillons simulés pour le calcul des quantiles"),
        Quantiles = SIMP(statut="f", typ="TXM", max="**", into=None, fr="Liste des valeurs de quantiles"),
        SetSeed = SIMP(statut="f", typ="TXM", fr="Graine fixée pour le générateur aléatoire"),
        SimulationForQuantiles = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="Linear", into=['Linear', 'NonLinear'], fr="Type de simulation en estimation des quantiles"),
        StateBoundsForQuantiles = SIMP(statut="f", typ="TXM", fr="Liste des paires de bornes pour les états utilisés en estimation des quantiles"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['Analysis', 'APosterioriCorrelations', 'APosterioriCovariance', 'APosterioriStandardDeviations', 'APosterioriVariances', 'BMA', 'CostFunctionJ', 'CostFunctionJAtCurrentOptimum', 'CostFunctionJb', 'CostFunctionJbAtCurrentOptimum', 'CostFunctionJo', 'CostFunctionJoAtCurrentOptimum', 'CurrentOptimum', 'CurrentState', 'Innovation', 'MahalanobisConsistency', 'OMA', 'OMB', 'SampledStateForQuantiles', 'SigmaBck2', 'SigmaObs2', 'SimulatedObservationAtBackground', 'SimulatedObservationAtCurrentOptimum', 'SimulatedObservationAtCurrentState', 'SimulatedObservationAtOptimum', 'SimulationQuantiles'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        ),
    ParametersDerivativeFreeOptimization = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'DerivativeFreeOptimization') ",
        statut="f",
        Bounds = SIMP(statut="f", typ="TXM", fr="Liste des valeurs de bornes"),
        CostDecrementTolerance = SIMP(statut="f", typ="R", min=1, max=1, defaut=1e-07, fr="Diminution relative minimale du cout lors de l'arrêt"),
        MaximumNumberOfFunctionEvaluations = SIMP(statut="f", typ="I", val_min=-1, min=1, max=1, defaut=15000, fr="Nombre maximal d'évaluations de la fonction"),
        MaximumNumberOfSteps = SIMP(statut="f", typ="I", val_min=-1, min=1, max=1, defaut=15000, fr="Nombre maximal de pas d'optimisation"),
        Minimizer = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="BOBYQA", into=['BOBYQA', 'COBYLA', 'NEWUOA', 'POWELL', 'SIMPLEX', 'SUBPLEX'], fr="Minimiseur utilisé"),
        QualityCriterion = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="AugmentedWeightedLeastSquares", into=['AugmentedWeightedLeastSquares', 'AWLS', 'DA', 'WeightedLeastSquares', 'WLS', 'LeastSquares', 'LS', 'L2', 'AbsoluteValue', 'L1', 'MaximumError', 'ME'], fr="Critère de qualité utilisé"),
        StateVariationTolerance = SIMP(statut="f", typ="R", min=1, max=1, defaut=0.0001, fr="Variation relative maximale de l'état lors de l'arrêt"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['Analysis', 'BMA', 'CostFunctionJ', 'CostFunctionJb', 'CostFunctionJo', 'CostFunctionJAtCurrentOptimum', 'CostFunctionJbAtCurrentOptimum', 'CostFunctionJoAtCurrentOptimum', 'CurrentIterationNumber', 'CurrentOptimum', 'CurrentState', 'IndexOfOptimum', 'Innovation', 'InnovationAtCurrentState', 'OMA', 'OMB', 'SimulatedObservationAtBackground', 'SimulatedObservationAtCurrentOptimum', 'SimulatedObservationAtCurrentState', 'SimulatedObservationAtOptimum'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        ),
    ParametersDifferentialEvolution = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'DifferentialEvolution') ",
        statut="f",
        Bounds = SIMP(statut="f", typ="TXM", fr="Liste des valeurs de bornes"),
        CrossOverProbability_CR = SIMP(statut="f", typ="R", val_min=0.0, val_max=1.0, min=1, max=1, defaut=0.7, fr="Probabilité de recombinaison ou de croisement, notée CR"),
        MaximumNumberOfFunctionEvaluations = SIMP(statut="f", typ="I", val_min=-1, min=1, max=1, defaut=15000, fr="Nombre maximal d'évaluations de la fonction"),
        MaximumNumberOfSteps = SIMP(statut="f", typ="I", val_min=0, min=1, max=1, defaut=15000, fr="Nombre maximal de générations"),
        Minimizer = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="BEST1BIN", into=['BEST1BIN', 'BEST1EXP', 'BEST2BIN', 'BEST2EXP', 'RAND1BIN', 'RAND1EXP', 'RAND2BIN', 'RAND2EXP', 'RANDTOBEST1BIN', 'RANDTOBEST1EXP'], fr="Stratégie de minimisation utilisée"),
        MutationDifferentialWeight_F = SIMP(statut="f", typ="TXM", max="**", into=None, fr="Poids différentiel de mutation, constant ou aléatoire dans l'intervalle, noté F"),
        PopulationSize = SIMP(statut="f", typ="I", val_min=1, min=1, max=1, defaut=100, fr="Taille approximative de la population à chaque génération"),
        QualityCriterion = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="AugmentedWeightedLeastSquares", into=['AugmentedWeightedLeastSquares', 'AWLS', 'DA', 'WeightedLeastSquares', 'WLS', 'LeastSquares', 'LS', 'L2', 'AbsoluteValue', 'L1', 'MaximumError', 'ME'], fr="Critère de qualité utilisé"),
        SetSeed = SIMP(statut="f", typ="TXM", fr="Graine fixée pour le générateur aléatoire"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['Analysis', 'BMA', 'CostFunctionJ', 'CostFunctionJb', 'CostFunctionJo', 'CostFunctionJAtCurrentOptimum', 'CostFunctionJbAtCurrentOptimum', 'CostFunctionJoAtCurrentOptimum', 'CurrentIterationNumber', 'CurrentOptimum', 'CurrentState', 'IndexOfOptimum', 'Innovation', 'InnovationAtCurrentState', 'OMA', 'OMB', 'SimulatedObservationAtBackground', 'SimulatedObservationAtCurrentOptimum', 'SimulatedObservationAtCurrentState', 'SimulatedObservationAtOptimum'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        ),
    ParametersEnsembleBlue = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'EnsembleBlue') ",
        statut="f",
        SetSeed = SIMP(statut="f", typ="TXM", fr="Graine fixée pour le générateur aléatoire"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['Analysis', 'CurrentOptimum', 'CurrentState', 'Innovation', 'SimulatedObservationAtBackground', 'SimulatedObservationAtCurrentState', 'SimulatedObservationAtOptimum'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        ),
    ParametersEnsembleKalmanFilter = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'EnsembleKalmanFilter') ",
        statut="f",
        EstimationOf = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="State", into=['State', 'Parameters'], fr="Estimation d'etat ou de parametres"),
        HybridCovarianceEquilibrium = SIMP(statut="f", typ="R", val_min=0.0, val_max=1.0, min=1, max=1, defaut=0.5, fr="Facteur d'équilibre entre la covariance statique et la covariance d'ensemble"),
        InflationFactor = SIMP(statut="f", typ="R", val_min=0.0, min=1, max=1, defaut=1.0, fr="Facteur d'inflation"),
        InflationType = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="MultiplicativeOnAnalysisAnomalies", into=['MultiplicativeOnAnalysisAnomalies', 'MultiplicativeOnBackgroundAnomalies'], fr="Méthode d'inflation d'ensemble"),
        NumberOfMembers = SIMP(statut="f", typ="I", val_min=2, min=1, max=1, defaut=100, fr="Nombre de membres dans l'ensemble"),
        SetSeed = SIMP(statut="f", typ="TXM", fr="Graine fixée pour le générateur aléatoire"),
        SmootherLagL = SIMP(statut="f", typ="I", val_min=0, min=1, max=1, defaut=0, fr="Nombre d'intervalles de temps de lissage dans le passé"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['Analysis', 'APosterioriCorrelations', 'APosterioriCovariance', 'APosterioriStandardDeviations', 'APosterioriVariances', 'BMA', 'CostFunctionJ', 'CostFunctionJAtCurrentOptimum', 'CostFunctionJb', 'CostFunctionJbAtCurrentOptimum', 'CostFunctionJo', 'CostFunctionJoAtCurrentOptimum', 'CurrentIterationNumber', 'CurrentOptimum', 'CurrentState', 'ForecastCovariance', 'ForecastState', 'IndexOfOptimum', 'InnovationAtCurrentAnalysis', 'InnovationAtCurrentState', 'SimulatedObservationAtCurrentAnalysis', 'SimulatedObservationAtCurrentOptimum', 'SimulatedObservationAtCurrentState'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        Variant = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="EnKF", into=['EnKF', 'ETKF', 'ETKF-N', 'MLEF', 'IEnKF', 'EnKS'], fr="Variant ou formulation de la méthode"),
        ),
    ParametersExtendedBlue = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'ExtendedBlue') ",
        statut="f",
        NumberOfSamplesForQuantiles = SIMP(statut="f", typ="I", val_min=1, min=1, max=1, defaut=100, fr="Nombre d'échantillons simulés pour le calcul des quantiles"),
        Quantiles = SIMP(statut="f", typ="TXM", max="**", into=None, fr="Liste des valeurs de quantiles"),
        SetSeed = SIMP(statut="f", typ="TXM", fr="Graine fixée pour le générateur aléatoire"),
        SimulationForQuantiles = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="Linear", into=['Linear', 'NonLinear'], fr="Type de simulation en estimation des quantiles"),
        StateBoundsForQuantiles = SIMP(statut="f", typ="TXM", fr="Liste des paires de bornes pour les états utilisés en estimation des quantiles"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['Analysis', 'APosterioriCorrelations', 'APosterioriCovariance', 'APosterioriStandardDeviations', 'APosterioriVariances', 'BMA', 'CostFunctionJ', 'CostFunctionJAtCurrentOptimum', 'CostFunctionJb', 'CostFunctionJbAtCurrentOptimum', 'CostFunctionJo', 'CostFunctionJoAtCurrentOptimum', 'CurrentOptimum', 'CurrentState', 'Innovation', 'MahalanobisConsistency', 'OMA', 'OMB', 'SampledStateForQuantiles', 'SigmaBck2', 'SigmaObs2', 'SimulatedObservationAtBackground', 'SimulatedObservationAtCurrentOptimum', 'SimulatedObservationAtCurrentState', 'SimulatedObservationAtOptimum', 'SimulationQuantiles'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        ),
    ParametersExtendedKalmanFilter = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'ExtendedKalmanFilter') ",
        statut="f",
        Bounds = SIMP(statut="f", typ="TXM", fr="Liste des valeurs de bornes"),
        ConstrainedBy = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="EstimateProjection", into=['EstimateProjection'], fr="Prise en compte des contraintes"),
        EstimationOf = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="State", into=['State', 'Parameters'], fr="Estimation d'etat ou de parametres"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['Analysis', 'APosterioriCorrelations', 'APosterioriCovariance', 'APosterioriStandardDeviations', 'APosterioriVariances', 'BMA', 'CostFunctionJ', 'CostFunctionJAtCurrentOptimum', 'CostFunctionJb', 'CostFunctionJbAtCurrentOptimum', 'CostFunctionJo', 'CostFunctionJoAtCurrentOptimum', 'CurrentIterationNumber', 'CurrentOptimum', 'CurrentState', 'ForecastCovariance', 'ForecastState', 'IndexOfOptimum', 'InnovationAtCurrentAnalysis', 'InnovationAtCurrentState', 'SimulatedObservationAtCurrentAnalysis', 'SimulatedObservationAtCurrentOptimum', 'SimulatedObservationAtCurrentState'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        Variant = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="CEKF", into=['EKF', 'CEKF'], fr="Variant ou formulation de la méthode"),
        ),
    ParametersFunctionTest = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'FunctionTest') ",
        statut="f",
        NumberOfPrintedDigits = SIMP(statut="f", typ="I", val_min=0, min=1, max=1, defaut=5, fr="Nombre de chiffres affichés pour les impressions de réels"),
        NumberOfRepetition = SIMP(statut="f", typ="I", val_min=1, min=1, max=1, defaut=1, fr="Nombre de fois où l'exécution de la fonction est répétée"),
        SetDebug = SIMP(statut="f", typ="I", into=(0, 1), min=1, max=1, defaut=0, fr="Activation du mode debug lors de l'exécution"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['CurrentState', 'SimulatedObservationAtCurrentState'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        ),
    ParametersGradientTest = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'GradientTest') ",
        statut="f",
        AmplitudeOfInitialDirection = SIMP(statut="f", typ="R", min=1, max=1, defaut=1.0, fr="Amplitude de la direction initiale de la dérivée directionnelle autour du point nominal"),
        AmplitudeOfTangentPerturbation = SIMP(statut="f", typ="R", val_min=1e-10, val_max=1.0, min=1, max=1, defaut=0.01, fr="Amplitude de la perturbation pour le calcul de la forme tangente"),
        EpsilonMinimumExponent = SIMP(statut="f", typ="I", val_min=-20, val_max=0, min=1, max=1, defaut=-8, fr="Exposant minimal en puissance de 10 pour le multiplicateur d'incrément"),
        InitialDirection = SIMP(statut="f", typ="TXM", fr="Direction initiale de la dérivée directionnelle autour du point nominal"),
        ResiduFormula = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="Taylor", into=['Norm', 'TaylorOnNorm', 'Taylor'], fr="Formule de résidu utilisée"),
        SetSeed = SIMP(statut="f", typ="TXM", fr="Graine fixée pour le générateur aléatoire"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['CurrentState', 'Residu', 'SimulatedObservationAtCurrentState'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        ),
    ParametersInputValuesTest = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'InputValuesTest') ",
        statut="f",
        NumberOfPrintedDigits = SIMP(statut="f", typ="I", val_min=0, min=1, max=1, defaut=5, fr="Nombre de chiffres affichés pour les impressions de réels"),
        PrintAllValuesFor = SIMP(statut="f", typ="TXM", max="**", into=['Background', 'CheckingPoint', 'Observation'], fr="Liste de noms de vecteurs dont les valeurs détaillées sont à imprimer"),
        SetDebug = SIMP(statut="f", typ="I", into=(0, 1), min=1, max=1, defaut=0, fr="Activation du mode debug lors de l'exécution"),
        ShowInformationOnlyFor = SIMP(statut="f", typ="TXM", max="**", into=['Background', 'CheckingPoint', 'Observation'], fr="Liste de noms de vecteurs dont les informations synthétiques sont à imprimer"),
        ),
    ParametersKalmanFilter = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'KalmanFilter') ",
        statut="f",
        EstimationOf = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="State", into=['State', 'Parameters'], fr="Estimation d'etat ou de parametres"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['Analysis', 'APosterioriCorrelations', 'APosterioriCovariance', 'APosterioriStandardDeviations', 'APosterioriVariances', 'BMA', 'CostFunctionJ', 'CostFunctionJAtCurrentOptimum', 'CostFunctionJb', 'CostFunctionJbAtCurrentOptimum', 'CostFunctionJo', 'CostFunctionJoAtCurrentOptimum', 'CurrentIterationNumber', 'CurrentOptimum', 'CurrentState', 'ForecastCovariance', 'ForecastState', 'IndexOfOptimum', 'InnovationAtCurrentAnalysis', 'InnovationAtCurrentState', 'SimulatedObservationAtCurrentAnalysis', 'SimulatedObservationAtCurrentOptimum', 'SimulatedObservationAtCurrentState'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        ),
    ParametersLinearLeastSquares = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'LinearLeastSquares') ",
        statut="f",
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['Analysis', 'CostFunctionJ', 'CostFunctionJAtCurrentOptimum', 'CostFunctionJb', 'CostFunctionJbAtCurrentOptimum', 'CostFunctionJo', 'CostFunctionJoAtCurrentOptimum', 'CurrentOptimum', 'CurrentState', 'OMA', 'SimulatedObservationAtCurrentOptimum', 'SimulatedObservationAtCurrentState', 'SimulatedObservationAtOptimum'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        ),
    ParametersLinearityTest = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'LinearityTest') ",
        statut="f",
        AmplitudeOfInitialDirection = SIMP(statut="f", typ="R", min=1, max=1, defaut=1.0, fr="Amplitude de la direction initiale de la dérivée directionnelle autour du point nominal"),
        AmplitudeOfTangentPerturbation = SIMP(statut="f", typ="R", val_min=1e-10, val_max=1.0, min=1, max=1, defaut=0.01, fr="Amplitude de la perturbation pour le calcul de la forme tangente"),
        EpsilonMinimumExponent = SIMP(statut="f", typ="I", val_min=-20, val_max=0, min=1, max=1, defaut=-8, fr="Exposant minimal en puissance de 10 pour le multiplicateur d'incrément"),
        InitialDirection = SIMP(statut="f", typ="TXM", fr="Direction initiale de la dérivée directionnelle autour du point nominal"),
        ResiduFormula = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="CenteredDL", into=['CenteredDL', 'Taylor', 'NominalTaylor', 'NominalTaylorRMS'], fr="Formule de résidu utilisée"),
        SetSeed = SIMP(statut="f", typ="TXM", fr="Graine fixée pour le générateur aléatoire"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['CurrentState', 'Residu', 'SimulatedObservationAtCurrentState'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        ),
    ParametersLocalSensitivityTest = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'LocalSensitivityTest') ",
        statut="f",
        SetDebug = SIMP(statut="f", typ="I", into=(0, 1), min=1, max=1, defaut=0, fr="Activation du mode debug lors de l'exécution"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['CurrentState', 'JacobianMatrixAtCurrentState', 'SimulatedObservationAtCurrentState'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        ),
    ParametersNonLinearLeastSquares = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'NonLinearLeastSquares') ",
        statut="f",
        Bounds = SIMP(statut="f", typ="TXM", fr="Liste des paires de bornes"),
        CostDecrementTolerance = SIMP(statut="f", typ="R", val_min=0.0, min=1, max=1, defaut=1e-07, fr="Diminution relative minimale du coût lors de l'arrêt"),
        GradientNormTolerance = SIMP(statut="f", typ="R", val_min=0.0, min=1, max=1, defaut=1e-05, fr="Maximum des composantes du gradient lors de l'arrêt"),
        InitializationPoint = SIMP(statut="f", typ="TXM", fr="État initial imposé (par défaut, c'est l'ébauche si None)"),
        MaximumNumberOfSteps = SIMP(statut="f", typ="I", val_min=-1, min=1, max=1, defaut=15000, fr="Nombre maximal de pas d'optimisation"),
        Minimizer = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="LBFGSB", into=['LBFGSB', 'TNC', 'CG', 'NCG', 'BFGS', 'LM'], fr="Minimiseur utilisé"),
        ProjectedGradientTolerance = SIMP(statut="f", typ="R", val_min=-1, min=1, max=1, defaut=-1.0, fr="Maximum des composantes du gradient projeté lors de l'arrêt"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['Analysis', 'BMA', 'CostFunctionJ', 'CostFunctionJAtCurrentOptimum', 'CostFunctionJb', 'CostFunctionJbAtCurrentOptimum', 'CostFunctionJo', 'CostFunctionJoAtCurrentOptimum', 'CurrentIterationNumber', 'CurrentOptimum', 'CurrentState', 'IndexOfOptimum', 'Innovation', 'InnovationAtCurrentState', 'OMA', 'OMB', 'SimulatedObservationAtBackground', 'SimulatedObservationAtCurrentOptimum', 'SimulatedObservationAtCurrentState', 'SimulatedObservationAtOptimum'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        ),
    ParametersParallelFunctionTest = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'ParallelFunctionTest') ",
        statut="f",
        NumberOfPrintedDigits = SIMP(statut="f", typ="I", val_min=0, min=1, max=1, defaut=5, fr="Nombre de chiffres affichés pour les impressions de réels"),
        NumberOfRepetition = SIMP(statut="f", typ="I", val_min=1, min=1, max=1, defaut=1, fr="Nombre de fois où l'exécution de la fonction est répétée"),
        SetDebug = SIMP(statut="f", typ="I", into=(0, 1), min=1, max=1, defaut=0, fr="Activation du mode debug lors de l'exécution"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['CurrentState', 'SimulatedObservationAtCurrentState'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        ),
    ParametersParticleSwarmOptimization = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'ParticleSwarmOptimization') ",
        statut="f",
        BoxBounds = SIMP(statut="f", typ="TXM", fr="Liste des valeurs de bornes d'incréments de paramètres"),
        GroupRecallRate = SIMP(statut="f", typ="R", val_min=0.0, val_max=1.0, min=1, max=1, defaut=0.5, fr="Taux de rappel au meilleur insecte du groupe (entre 0 et 1)"),
        MaximumNumberOfFunctionEvaluations = SIMP(statut="f", typ="I", val_min=-1, min=1, max=1, defaut=15000, fr="Nombre maximal d'évaluations de la fonction"),
        MaximumNumberOfSteps = SIMP(statut="f", typ="I", val_min=0, min=1, max=1, defaut=50, fr="Nombre maximal de pas d'optimisation"),
        NumberOfInsects = SIMP(statut="f", typ="I", val_min=-1, min=1, max=1, defaut=100, fr="Nombre d'insectes dans l'essaim"),
        QualityCriterion = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="AugmentedWeightedLeastSquares", into=['DA', 'AugmentedWeightedLeastSquares', 'AWLS', 'WeightedLeastSquares', 'WLS', 'LeastSquares', 'LS', 'L2', 'AbsoluteValue', 'L1', 'MaximumError', 'ME'], fr="Critère de qualité utilisé"),
        SetSeed = SIMP(statut="f", typ="TXM", fr="Graine fixée pour le générateur aléatoire"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['Analysis', 'BMA', 'CostFunctionJ', 'CostFunctionJb', 'CostFunctionJo', 'CurrentIterationNumber', 'CurrentState', 'Innovation', 'OMA', 'OMB', 'SimulatedObservationAtBackground', 'SimulatedObservationAtCurrentState', 'SimulatedObservationAtOptimum'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        SwarmVelocity = SIMP(statut="f", typ="R", val_min=0.0, min=1, max=1, defaut=1.0, fr="Vitesse de groupe imposée par l'essaim"),
        ),
    ParametersQuantileRegression = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'QuantileRegression') ",
        statut="f",
        Bounds = SIMP(statut="f", typ="TXM", fr="Liste des valeurs de bornes"),
        CostDecrementTolerance = SIMP(statut="f", typ="R", min=1, max=1, defaut=1e-06, fr="Maximum de variation de la fonction d'estimation lors de l'arrêt"),
        InitializationPoint = SIMP(statut="f", typ="TXM", fr="État initial imposé (par défaut, c'est l'ébauche si None)"),
        MaximumNumberOfSteps = SIMP(statut="f", typ="I", val_min=1, min=1, max=1, defaut=15000, fr="Nombre maximal de pas d'optimisation"),
        Minimizer = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="MMQR", into=['MMQR'], fr="Minimiseur utilisé"),
        Quantile = SIMP(statut="f", typ="R", val_min=0.0, val_max=1.0, min=1, max=1, defaut=0.5, fr="Quantile pour la regression de quantile"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['Analysis', 'BMA', 'CostFunctionJ', 'CostFunctionJb', 'CostFunctionJo', 'CurrentIterationNumber', 'CurrentState', 'Innovation', 'OMA', 'OMB', 'SimulatedObservationAtBackground', 'SimulatedObservationAtCurrentState', 'SimulatedObservationAtOptimum'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        ),
    ParametersSamplingTest = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'SamplingTest') ",
        statut="f",
        QualityCriterion = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="AugmentedWeightedLeastSquares", into=['DA', 'AugmentedWeightedLeastSquares', 'AWLS', 'WeightedLeastSquares', 'WLS', 'LeastSquares', 'LS', 'L2', 'AbsoluteValue', 'L1', 'MaximumError', 'ME'], fr="Critère de qualité utilisé"),
        SampleAsExplicitHyperCube = SIMP(statut="f", typ="TXM", max="**", into=None, fr="Points de calcul définis par un hyper-cube dont on donne la liste des échantillonages de chaque variable comme une liste"),
        SampleAsIndependantRandomVariables = SIMP(statut="f", typ="TXM", max="**", into=None, fr="Points de calcul définis par un hyper-cube dont les points sur chaque axe proviennent de l'échantillonage indépendant de la variable selon la spécification ['distribution',[parametres],nombre]"),
        SampleAsMinMaxStepHyperCube = SIMP(statut="f", typ="TXM", max="**", into=None, fr="Points de calcul définis par un hyper-cube dont on donne la liste des échantillonages de chaque variable par un triplet [min,max,step]"),
        SampleAsnUplet = SIMP(statut="f", typ="TXM", max="**", into=None, fr="Points de calcul définis par une liste de n-uplet"),
        SetDebug = SIMP(statut="f", typ="I", into=(0, 1), min=1, max=1, defaut=0, fr="Activation du mode debug lors de l'exécution"),
        SetSeed = SIMP(statut="f", typ="TXM", fr="Graine fixée pour le générateur aléatoire"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['CostFunctionJ', 'CostFunctionJb', 'CostFunctionJo', 'CurrentState', 'InnovationAtCurrentState', 'SimulatedObservationAtCurrentState'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        ),
    ParametersTabuSearch = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'TabuSearch') ",
        statut="f",
        Bounds = SIMP(statut="f", typ="TXM", fr="Liste des valeurs de bornes"),
        LengthOfTabuList = SIMP(statut="f", typ="I", val_min=1, min=1, max=1, defaut=50, fr="Longueur de la liste tabou"),
        MaximumNumberOfSteps = SIMP(statut="f", typ="I", val_min=1, min=1, max=1, defaut=50, fr="Nombre maximal de pas d'optimisation"),
        NoiseAddingProbability = SIMP(statut="f", typ="R", val_min=0.0, val_max=1.0, min=1, max=1, defaut=1.0, fr="Probabilité de perturbation d'une composante de l'état"),
        NoiseDistribution = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="Uniform", into=['Gaussian', 'Uniform'], fr="Distribution pour générer les perturbations d'état"),
        NoiseHalfRange = SIMP(statut="f", typ="TXM", fr="Demi-amplitude des perturbations uniformes centrées d'état pour chaque composante de l'état"),
        NumberOfElementaryPerturbations = SIMP(statut="f", typ="I", val_min=1, min=1, max=1, defaut=1, fr="Nombre de perturbations élémentaires pour choisir une perturbation d'état"),
        QualityCriterion = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="AugmentedWeightedLeastSquares", into=['AugmentedWeightedLeastSquares', 'AWLS', 'DA', 'WeightedLeastSquares', 'WLS', 'LeastSquares', 'LS', 'L2', 'AbsoluteValue', 'L1', 'MaximumError', 'ME'], fr="Critère de qualité utilisé"),
        SetSeed = SIMP(statut="f", typ="TXM", fr="Graine fixée pour le générateur aléatoire"),
        StandardDeviation = SIMP(statut="f", typ="TXM", fr="Ecart-type des perturbations gaussiennes d'état pour chaque composante de l'état"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['Analysis', 'BMA', 'CostFunctionJ', 'CostFunctionJb', 'CostFunctionJo', 'CurrentIterationNumber', 'CurrentState', 'Innovation', 'OMA', 'OMB', 'SimulatedObservationAtBackground', 'SimulatedObservationAtCurrentState', 'SimulatedObservationAtOptimum'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        ),
    ParametersTangentTest = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'TangentTest') ",
        statut="f",
        AmplitudeOfInitialDirection = SIMP(statut="f", typ="R", min=1, max=1, defaut=1.0, fr="Amplitude de la direction initiale de la dérivée directionnelle autour du point nominal"),
        AmplitudeOfTangentPerturbation = SIMP(statut="f", typ="R", val_min=1e-10, val_max=1.0, min=1, max=1, defaut=0.01, fr="Amplitude de la perturbation pour le calcul de la forme tangente"),
        EpsilonMinimumExponent = SIMP(statut="f", typ="I", val_min=-20, val_max=0, min=1, max=1, defaut=-8, fr="Exposant minimal en puissance de 10 pour le multiplicateur d'incrément"),
        InitialDirection = SIMP(statut="f", typ="TXM", fr="Direction initiale de la dérivée directionnelle autour du point nominal"),
        ResiduFormula = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="Taylor", into=['Taylor'], fr="Formule de résidu utilisée"),
        SetSeed = SIMP(statut="f", typ="TXM", fr="Graine fixée pour le générateur aléatoire"),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['CurrentState', 'Residu', 'SimulatedObservationAtCurrentState'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        ),
    ParametersUnscentedKalmanFilter = BLOC (condition = " (Parameters == 'Defaults') and (Algorithm == 'UnscentedKalmanFilter') ",
        statut="f",
        Alpha = SIMP(statut="f", typ="R", val_min=0.0001, val_max=1.0, min=1, max=1, defaut=1.0, fr=""),
        Beta = SIMP(statut="f", typ="R", min=1, max=1, defaut=2.0, fr=""),
        Bounds = SIMP(statut="f", typ="TXM", fr="Liste des valeurs de bornes"),
        ConstrainedBy = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="EstimateProjection", into=['EstimateProjection'], fr="Prise en compte des contraintes"),
        EstimationOf = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="State", into=['State', 'Parameters'], fr="Estimation d'etat ou de parametres"),
        Kappa = SIMP(statut="f", typ="I", val_max=2, min=1, max=1, defaut=0, fr=""),
        Reconditioner = SIMP(statut="f", typ="R", val_min=0.001, val_max=10.0, min=1, max=1, defaut=1.0, fr=""),
        StoreSupplementaryCalculations = SIMP(statut="f", typ="TXM", max="**", into=['Analysis', 'APosterioriCorrelations', 'APosterioriCovariance', 'APosterioriStandardDeviations', 'APosterioriVariances', 'BMA', 'CostFunctionJ', 'CostFunctionJAtCurrentOptimum', 'CostFunctionJb', 'CostFunctionJbAtCurrentOptimum', 'CostFunctionJo', 'CostFunctionJoAtCurrentOptimum', 'CurrentIterationNumber', 'CurrentOptimum', 'CurrentState', 'ForecastCovariance', 'ForecastState', 'IndexOfOptimum', 'InnovationAtCurrentAnalysis', 'InnovationAtCurrentState', 'SimulatedObservationAtCurrentAnalysis', 'SimulatedObservationAtCurrentOptimum', 'SimulatedObservationAtCurrentState'], fr="Liste de calculs supplémentaires à stocker et/ou effectuer"),
        Variant = SIMP(statut="f", typ="TXM", min=1, max=1, defaut="2UKF", into=['UKF', '2UKF'], fr="Variant ou formulation de la méthode"),
        ),
    )

def F_variables(statut) : return FACT(
    statut=statut,
    regles = ( MEME_NOMBRE ('NAMES', 'SIZES')),
    NAMES = SIMP(statut="o", typ="TXM", max="**", validators=NoRepeat()),
    SIZES = SIMP(statut="o", typ="I", val_min=1, max="**")
    )
def ChDir(dirname):
    os.chdir(os.path.abspath(dirname))
    return 1
ChDir.info = u"This has to be a regular directory path."

ASSIMILATION_STUDY = PROC(nom="ASSIMILATION_STUDY",
    op=None,
    repetable           = "n",
    StudyName           = SIMP(statut="o", typ = "TXM", defaut="ADAO Calculation Case"),
    StudyRepertory      = SIMP(statut="f", typ = "Repertoire", validators=FunctionVal(ChDir), min=1, max=1),
    Debug               = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0),
    ExecuteInContainer  = SIMP(statut="f", typ = "TXM", min=1, max=1, defaut = "No", into=("No", "Mono", "Multi")),
    AlgorithmParameters = F_AlgorithmParameters("o",("3DVAR", "4DVAR", "Blue", "DerivativeFreeOptimization", "DifferentialEvolution", "EnsembleBlue", "EnsembleKalmanFilter", "ExtendedBlue", "ExtendedKalmanFilter", "KalmanFilter", "LinearLeastSquares", "NonLinearLeastSquares", "ParticleSwarmOptimization", "QuantileRegression", "TabuSearch", "UnscentedKalmanFilter", ), AlgorithmParametersInNS),
    Background          = F_Background("o", BackgroundInNS),
    BackgroundError     = F_BackgroundError("o", BackgroundErrorInNS),
    Observation         = F_Observation("o", ObservationInNS),
    ObservationError    = F_ObservationError("o", ObservationErrorInNS),
    ObservationOperator = F_ObservationOperator("o", ObservationOperatorInNS),
    EvolutionModel      = F_EvolutionModel("f", EvolutionModelInNS),
    EvolutionError      = F_EvolutionError("f", EvolutionErrorInNS),
    ControlInput        = F_ControlInput("f"),
    UserDataInit        = F_Init("f"),
    UserPostAnalysis    = F_UserPostAnalysis("o"),
    InputVariables      = F_variables("f"),
    OutputVariables     = F_variables("f"),
    Observers           = F_Observers("f")
    )

OPTIMIZATION_STUDY = PROC(nom="OPTIMIZATION_STUDY",
    op=None,
    repetable           = "n",
    StudyName           = SIMP(statut="o", typ = "TXM", defaut="ADAO Calculation Case"),
    StudyRepertory      = SIMP(statut="f", typ = "Repertoire", validators=FunctionVal(ChDir), min=1, max=1),
    Debug               = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0),
    ExecuteInContainer  = SIMP(statut="f", typ = "TXM", min=1, max=1, defaut = "No", into=("No", "Mono", "Multi")),
    AlgorithmParameters = F_AlgorithmParameters("o",("3DVAR", "Blue", "DerivativeFreeOptimization", "DifferentialEvolution", "KalmanFilter", "LinearLeastSquares", "NonLinearLeastSquares", "ParticleSwarmOptimization", "TabuSearch", ), AlgorithmParametersInNS),
    Background          = F_Background("o", BackgroundInNS),
    BackgroundError     = F_BackgroundError("f", BackgroundErrorInNS),
    Observation         = F_Observation("o", ObservationInNS),
    ObservationError    = F_ObservationError("f", ObservationErrorInNS),
    ObservationOperator = F_ObservationOperator("o", ObservationOperatorInNS),
    EvolutionModel      = F_EvolutionModel("f", EvolutionModelInNS),
    EvolutionError      = F_EvolutionError("f", EvolutionErrorInNS),
    ControlInput        = F_ControlInput("f"),
    UserDataInit        = F_Init("f"),
    UserPostAnalysis    = F_UserPostAnalysis("o"),
    InputVariables      = F_variables("f"),
    OutputVariables     = F_variables("f"),
    Observers           = F_Observers("f")
    )

REDUCTION_STUDY = PROC(nom="REDUCTION_STUDY",
    op=None,
    repetable           = "n",
    StudyName           = SIMP(statut="o", typ = "TXM", defaut="ADAO Calculation Case"),
    StudyRepertory      = SIMP(statut="f", typ = "Repertoire", validators=FunctionVal(ChDir), min=1, max=1),
    Debug               = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0),
    ExecuteInContainer  = SIMP(statut="f", typ = "TXM", min=1, max=1, defaut = "No", into=("No", "Mono", "Multi")),
    AlgorithmParameters = F_AlgorithmParameters("o",("EnsembleBlue", "EnsembleKalmanFilter", "UnscentedKalmanFilter", ), AlgorithmParametersInNS),
    Background          = F_Background("o", BackgroundInNS),
    BackgroundError     = F_BackgroundError("o", BackgroundErrorInNS),
    Observation         = F_Observation("o", ObservationInNS),
    ObservationError    = F_ObservationError("o", ObservationErrorInNS),
    ObservationOperator = F_ObservationOperator("o", ObservationOperatorInNS),
    EvolutionModel      = F_EvolutionModel("f", EvolutionModelInNS),
    EvolutionError      = F_EvolutionError("f", EvolutionErrorInNS),
    ControlInput        = F_ControlInput("f"),
    UserDataInit        = F_Init("f"),
    UserPostAnalysis    = F_UserPostAnalysis("o"),
    InputVariables      = F_variables("f"),
    OutputVariables     = F_variables("f"),
    Observers           = F_Observers("f")
    )

CHECKING_STUDY = PROC(nom="CHECKING_STUDY",
    op=None,
    repetable           = "n",
    StudyName           = SIMP(statut="o", typ = "TXM", defaut="ADAO Checking Case"),
    StudyRepertory      = SIMP(statut="f", typ = "Repertoire", validators=FunctionVal(ChDir), min=1, max=1),
    Debug               = SIMP(statut="f", typ = "I", into=(0, 1), defaut=0),
    ExecuteInContainer  = SIMP(statut="f", typ = "TXM", min=1, max=1, defaut = "No", into=("No", "Mono", "Multi")),
    AlgorithmParameters = F_AlgorithmParameters("o", ("AdjointTest", "FunctionTest", "GradientTest", "InputValuesTest", "LinearityTest", "LocalSensitivityTest", "ObserverTest", "ParallelFunctionTest", "SamplingTest", "TangentTest", ), AlgorithmParametersInNS),
    CheckingPoint       = F_CheckingPoint("o", CheckingPointInNS),
    Background          = F_Background("f", BackgroundInNS),
    BackgroundError     = F_BackgroundError("f", BackgroundErrorInNS),
    Observation         = F_Observation("f", ObservationInNS),
    ObservationError    = F_ObservationError("f", ObservationErrorInNS),
    ObservationOperator = F_ObservationOperator("o", ObservationOperatorInNS),
    UserDataInit        = F_Init("f"),
    Observers           = F_Observers("f")
    )
