# Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# pylint: disable=R0801

from __future__ import absolute_import

from pcluster.api import util
from pcluster.api.models.base_model_ import Model


class Ec2AmiInfoSummary(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, ami_id=None):  # noqa: E501
        """Ec2AmiInfoSummary - a model defined in OpenAPI

        :param ami_id: The ami_id of this Ec2AmiInfoSummary.  # noqa: E501
        :type ami_id: str
        """
        self.openapi_types = {"ami_id": str}

        self.attribute_map = {"ami_id": "amiId"}

        self._ami_id = ami_id

    @classmethod
    def from_dict(cls, dikt) -> "Ec2AmiInfoSummary":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Ec2AmiInfoSummary of this Ec2AmiInfoSummary.  # noqa: E501
        :rtype: Ec2AmiInfoSummary
        """
        return util.deserialize_model(dikt, cls)

    @property
    def ami_id(self):
        """Gets the ami_id of this Ec2AmiInfoSummary.

        EC2 AMI id  # noqa: E501

        :return: The ami_id of this Ec2AmiInfoSummary.
        :rtype: str
        """
        return self._ami_id

    @ami_id.setter
    def ami_id(self, ami_id):
        """Sets the ami_id of this Ec2AmiInfoSummary.

        EC2 AMI id  # noqa: E501

        :param ami_id: The ami_id of this Ec2AmiInfoSummary.
        :type ami_id: str
        """
        if ami_id is None:
            raise ValueError("Invalid value for `ami_id`, must not be `None`")  # noqa: E501

        self._ami_id = ami_id
