"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolResourceServer = exports.ResourceServerScope = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const cognito_generated_1 = require("./cognito.generated");
/**
 * A scope for ResourceServer
 */
class ResourceServerScope {
    constructor(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cognito_ResourceServerScopeProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.scopeName = props.scopeName;
        this.scopeDescription = props.scopeDescription;
    }
}
exports.ResourceServerScope = ResourceServerScope;
_a = JSII_RTTI_SYMBOL_1;
ResourceServerScope[_a] = { fqn: "@aws-cdk/aws-cognito.ResourceServerScope", version: "1.159.0" };
/**
 * Defines a User Pool OAuth2.0 Resource Server
 */
class UserPoolResourceServer extends core_1.Resource {
    constructor(scope, id, props) {
        var _c;
        super(scope, id, {
            physicalName: props.identifier,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cognito_UserPoolResourceServerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const resource = new cognito_generated_1.CfnUserPoolResourceServer(this, 'Resource', {
            identifier: this.physicalName,
            name: (_c = props.userPoolResourceServerName) !== null && _c !== void 0 ? _c : this.physicalName,
            scopes: props.scopes,
            userPoolId: props.userPool.userPoolId,
        });
        this.userPoolResourceServerId = resource.ref;
    }
    /**
     * Import a user pool resource client given its id.
     */
    static fromUserPoolResourceServerId(scope, id, userPoolResourceServerId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.userPoolResourceServerId = userPoolResourceServerId;
            }
        }
        return new Import(scope, id);
    }
}
exports.UserPoolResourceServer = UserPoolResourceServer;
_b = JSII_RTTI_SYMBOL_1;
UserPoolResourceServer[_b] = { fqn: "@aws-cdk/aws-cognito.UserPoolResourceServer", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,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