"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolIdentityProviderOidc = exports.OidcAttributeRequestMethod = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const cognito_generated_1 = require("../cognito.generated");
const user_pool_idp_base_1 = require("./private/user-pool-idp-base");
/**
 * The method to use to request attributes
 */
var OidcAttributeRequestMethod;
(function (OidcAttributeRequestMethod) {
    /** GET */
    OidcAttributeRequestMethod["GET"] = "GET";
    /** POST */
    OidcAttributeRequestMethod["POST"] = "POST";
})(OidcAttributeRequestMethod = exports.OidcAttributeRequestMethod || (exports.OidcAttributeRequestMethod = {}));
/**
 * Represents a identity provider that integrates with OpenID Connect
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
class UserPoolIdentityProviderOidc extends user_pool_idp_base_1.UserPoolIdentityProviderBase {
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f, _g;
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cognito_UserPoolIdentityProviderOidcProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (props.name && !core_1.Token.isUnresolved(props.name) && (props.name.length < 3 || props.name.length > 32)) {
            throw new Error(`Expected provider name to be between 3 and 32 characters, received ${props.name} (${props.name.length} characters)`);
        }
        const scopes = (_b = props.scopes) !== null && _b !== void 0 ? _b : ['openid'];
        const resource = new cognito_generated_1.CfnUserPoolIdentityProvider(this, 'Resource', {
            userPoolId: props.userPool.userPoolId,
            providerName: this.getProviderName(props.name),
            providerType: 'OIDC',
            providerDetails: {
                client_id: props.clientId,
                client_secret: props.clientSecret,
                authorize_scopes: scopes.join(' '),
                attributes_request_method: (_c = props.attributeRequestMethod) !== null && _c !== void 0 ? _c : OidcAttributeRequestMethod.GET,
                oidc_issuer: props.issuerUrl,
                authorize_url: (_d = props.endpoints) === null || _d === void 0 ? void 0 : _d.authorization,
                token_url: (_e = props.endpoints) === null || _e === void 0 ? void 0 : _e.token,
                attributes_url: (_f = props.endpoints) === null || _f === void 0 ? void 0 : _f.userInfo,
                jwks_uri: (_g = props.endpoints) === null || _g === void 0 ? void 0 : _g.jwksUri,
            },
            idpIdentifiers: props.identifiers,
            attributeMapping: super.configureAttributeMapping(),
        });
        this.providerName = super.getResourceNameAttribute(resource.ref);
    }
    getProviderName(name) {
        if (name) {
            if (!core_1.Token.isUnresolved(name) && (name.length < 3 || name.length > 32)) {
                throw new Error(`Expected provider name to be between 3 and 32 characters, received ${name} (${name.length} characters)`);
            }
            return name;
        }
        const uniqueId = core_1.Names.uniqueId(this);
        if (uniqueId.length < 3) {
            return `${uniqueId}oidc`;
        }
        if (uniqueId.length > 32) {
            return uniqueId.substring(0, 16) + uniqueId.substring(uniqueId.length - 16);
        }
        return uniqueId;
    }
}
exports.UserPoolIdentityProviderOidc = UserPoolIdentityProviderOidc;
_a = JSII_RTTI_SYMBOL_1;
UserPoolIdentityProviderOidc[_a] = { fqn: "@aws-cdk/aws-cognito.UserPoolIdentityProviderOidc", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,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