from dataclasses import dataclass

import marshmallow_dataclass
from pygitguardian.models import Base, BaseSchema


@dataclass
class IaCVulnerability(Base):
    policy: str
    policy_id: str
    line_end: int
    line_start: int
    description: str
    documentation_url: str
    component: str = ""
    severity: str = ""


IaCVulnerabilitySchema = marshmallow_dataclass.class_schema(
    IaCVulnerability, BaseSchema
)
