/* *********************************************************************
 * This Original Work is copyright of 51 Degrees Mobile Experts Limited.
 * Copyright 2019 51 Degrees Mobile Experts Limited, 5 Charlotte Close,
 * Caversham, Reading, Berkshire, United Kingdom RG4 7BY.
 *
 * This Original Work is licensed under the European Union Public Licence (EUPL) 
 * v.1.2 and is subject to its terms as set out below.
 *
 * If a copy of the EUPL was not distributed with this file, You can obtain
 * one at https://opensource.org/licenses/EUPL-1.2.
 *
 * The 'Compatible Licences' set out in the Appendix to the EUPL (as may be
 * amended by the European Commission) shall be deemed incompatible for
 * the purposes of the Work and the provisions of the compatibility
 * clause in Article 5 of the EUPL shall not apply.
 * 
 * If using the Work as, or as part of, a network application, by 
 * including the attribution notice(s) required under Article 5 of the EUPL
 * in the end user terms of the application under an appropriate heading, 
 * such notice(s) shall fulfill the requirements of that article.
 * ********************************************************************* */

#ifndef FIFTYONE_DEGREES_DATE_H_INCLUDED
#define FIFTYONE_DEGREES_DATE_H_INCLUDED

/**
 * @ingroup FiftyOneDegreesCommon
 * @defgroup FiftyOneDegreesDate Date
 *
 * Represents a date in a data set.
 *
 * ## Introduction
 *
 * The Date structure is used to represent dates in data sets. This is a memory
 * efficient way to store a date, and means that the memory from a data file
 * can be read directly into a structure.
 *
 * @{
 */

#include <stdint.h>
#ifdef _MSC_VER
#pragma warning (push)
#pragma warning (disable: 5105) 
#include <windows.h>
#pragma warning (default: 5105) 
#pragma warning (pop)
#endif

#include "data.h"

/**
 * Used to store the date when the dataset was produced and next date 51Degrees
 * expect to provide a new data file. Has to be packed at one byte because the 
 * date occurs in the data files in this form.
 */
#pragma pack(push, 1)
typedef struct fiftyone_degrees_date_t {
	int16_t year; /**< Year */
	byte month; /**< Month */
	byte day; /**< Day of the Month */
} fiftyoneDegreesDate;
#pragma pack(pop)

/**
 * @}
 */

#endif