# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.model_utils import (
    ModelNormal,
    cached_property,
    none_type,
)


class IncidentFieldAttributesSingleValue(ModelNormal):
    @cached_property
    def openapi_types(_):
        from datadog_api_client.v2.model.incident_field_attributes_single_value_type import (
            IncidentFieldAttributesSingleValueType,
        )

        return {
            "type": (IncidentFieldAttributesSingleValueType,),
            "value": (str, none_type),
        }

    attribute_map = {
        "type": "type",
        "value": "value",
    }

    def __init__(self_, *args, **kwargs):
        """
        A field with a single value selected.

        :param type: Type of the single value field definitions.
        :type type: IncidentFieldAttributesSingleValueType, optional

        :param value: The single value selected for this field.
        :type value: str, none_type, optional
        """
        super().__init__(kwargs)

        self_._check_pos_args(args)
